# The IMPORTED targets available when this package is found:
# OCCA::libocca Target to link to for using occa
# OCCA::occa The occa executable, e.g. can be called to get information on supported backends


# For support of redistributability, already have PACKAGE_INIT:

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was OCCAConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

####################################################################################

# Find Dependencies
# Dependencies that need to be found will depend on the build settings used
include(CMakeFindDependencyMacro)
# For some dependencies, we provide custom Find modules, that have been installed next to this file.
#   Temporarily add this directory to the CMAKE_MODULE_PATH
#   Use a variable with an OCCA prefix to store the old value, to prevent the variable being
#   overwritten by code in the dependencies, executed before the reset
set(_OCCA_STORE_CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH})
list(INSERT CMAKE_MODULE_PATH 0 "${CMAKE_CURRENT_LIST_DIR}")
find_dependency(Threads)
find_dependency(OpenMP)
find_dependency(OpenCLWrapper)

# Reset CMAKE_MODULE_PATH
# Do not use list(REMOVE CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}"), because that would remove all instances, even if they were not added here
set(CMAKE_MODULE_PATH ${_OCCA_STORE_CMAKE_MODULE_PATH})
unset(_OCCA_STORE_CMAKE_MODULE_PATH)

# The exported targets are defined in an auto-generated file:
include( "${CMAKE_CURRENT_LIST_DIR}/OCCATargets.cmake" )
