#ifndef XDKWRL_MFVEC2F_H
#define XDKWRL_MFVEC2F_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes/sfvec2f.h>
#include <deque>
#include <algorithm>
#include <iterator>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  MFVec2f
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   * 
   * A MFVec2f is a container of SFVec2f. It is implemented using a STL's
   * deque so you can benefit from its interface. Most common
   * functionnalities you would use are:
   \code
   MFVec2f mf;
   mf.push_back(SFVec2f(0.0f,0.0f));  
   mf.push_front(SFVec2f(1.0f,0.0f));
   mf[0].setX(1.0f);
   \endcode
   * but since it uses STL principles, you have all useful concepts such as
   * iterator, algorithms, etc...
   *
   * Below is included the documentation for this field type from the ISO
   * standard.
   * \htmlinclude sfvec2f.html
   */
  class XDKWRL_API MFVec2f : public std::deque<SFVec2f>
  {
  public:
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const MFVec2f& f);
  };
  //************************************************************
  // Implementation of MFVec2f
  //************************************************************
  inline const char*
  MFVec2f::typeName()
  {
    return "MFVec2f";
  }
  inline FieldTypeId
  MFVec2f::typeId()
  {
    return mfVec2f;
  }  
}

#endif // XDKWRL_MFVEC2F_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/fieldtypes")
// End:
