#ifndef XDKWRL_SFCOLOR_H
#define XDKWRL_SFCOLOR_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes.h>
#include <iostream>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  SFColor
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   *
   * Represents a RGB color value. Below is included the documentation for
   * this field type from the ISO standard.
   * \htmlinclude sfcolor.html
   */
  class XDKWRL_API SFColor 
  {
  public:
    inline SFColor();
    inline SFColor(const float* c);
    inline SFColor(const float r,const float g,const float b);
    inline SFColor& operator=(const SFColor& c);
    inline operator const float*() const;
    inline float red() const;
    inline float green() const;
    inline float blue() const;
    inline void setRGB(const float r,const float g,const float b);
    inline void setRed(const float);
    inline void setGreen(const float);
    inline void setBlue(const float);
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    inline bool operator==(const SFColor& c) const;
    friend std::ostream& operator<<(std::ostream& s,const SFColor& f);
  protected:
  private:
    float red_;
    float green_;
    float blue_;
  };
  //************************************************************
  // Implementation of SFColor
  //************************************************************
  inline
  SFColor::SFColor()
    : red_(0.0f),green_(0.0f),blue_(0.0f)
  {
  }
  inline
  SFColor::SFColor(const float* c)
    : red_(c[0]),green_(c[1]),blue_(c[2])    
  {    
  }
  inline
  SFColor::SFColor(const float r,const float g,const float b)
    : red_(r),green_(g),blue_(b)    
  {    
  }    
  inline SFColor&
  SFColor::operator=(const SFColor& c)
  {
    red_ = c.red_;
    green_ = c.green_;
    blue_ = c.blue_;
    return *this;
  }
  inline
  SFColor::operator const float*() const
  {
    return &red_;
  }
  inline float
  SFColor::red() const
  {
    return red_;
  }
  inline float
  SFColor::green() const
  {
    return green_;
  }
  inline float
  SFColor::blue() const
  {
    return blue_;
  }
  inline void
  SFColor::setRed(const float f)
  {
    red_ = f;
  }
  inline void
  SFColor::setGreen(const float f)
  {
    green_ = f;
  }
  inline void
  SFColor::setBlue(const float f)
  {
    blue_ = f;
  }  
  inline void
  SFColor::setRGB(const float r,const float g,const float b)
  {
    red_ = r;
    green_ = g;
    blue_ = b;
  }  
  inline bool
  SFColor::operator==(const SFColor& c) const
  {
    return red_ == c.red_ && green_ == c.green_ && blue_ == c.blue_;
  }
  inline const char*
  SFColor::typeName()
  {
    return "SFColor";
  }
  inline FieldTypeId
  SFColor::typeId()
  {
    return sfColor;
  }  
};

#endif // XDKWRL_SFCOLOR_H
