#ifndef XDKWRL_SFIMAGE_H
#define XDKWRL_SFIMAGE_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes.h>
#include <iostream>
#include <iomanip>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  SFImage
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   *
   * Represents an image. Below is included the documentation for this field
   * type from the ISO standard.   
   * \htmlinclude sfimage.html
   */
  class XDKWRL_API SFImage 
  {
  public:
    inline SFImage();
    inline SFImage(unsigned int w,
		   unsigned int h,
		   unsigned int n);
    SFImage(const SFImage& i);
    SFImage& operator=(const SFImage&);
    inline ~SFImage();
    inline void setDimensions(unsigned int w,
			      unsigned int h,
			      unsigned int n);
    inline unsigned int width() const;
    inline unsigned int height() const;
    inline unsigned int numComponents() const;
    inline unsigned char* pixels() const;
    inline unsigned char* pixels();
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    inline bool operator==(const SFImage& i) const;
    friend std::ostream& operator<<(std::ostream& s,const SFImage& f);
  protected:
  public:
    unsigned int   width_;
    unsigned int   height_;
    unsigned int   numComponents_;
    unsigned char* pixels_;
  };
  //************************************************************
  // Implementation of 
  //************************************************************
  // TODO: implement reference counting
  inline
  SFImage::SFImage()
    : width_(0),height_(0),numComponents_(0),pixels_(NULL)
  {
  }
  inline void
  SFImage::setDimensions(unsigned int w,
			 unsigned int h,
			 unsigned int n)
  {
    if (pixels_ != NULL)
    {
      delete [] pixels_;
    }    
    width_ = w;
    height_ = h;
    numComponents_ = n;
    pixels_ = new unsigned char[w*h*n];
  }
  inline
  SFImage::SFImage(unsigned int w,
		   unsigned int h,
		   unsigned int n)
    : width_(w),height_(h),numComponents_(n)
  {
    pixels_ = new unsigned char[w*h*n];
  }
  inline
  SFImage::~SFImage()
  {
    if (pixels_ != NULL)
    {
      delete [] pixels_;
    }
  }
  inline unsigned int
  SFImage::width() const
  {
    return width_;
  }
  inline unsigned int
  SFImage::height() const
  {
    return height_;
  }
  inline unsigned int
  SFImage::numComponents() const
  {
    return numComponents_;
  }
  inline unsigned char*
  SFImage::pixels() const
  {
    return pixels_;
  }
  inline unsigned char*
  SFImage::pixels() 
  {
    return pixels_;
  }
  inline const char*
  SFImage::typeName()
  {
    return "SFImage";
  }
  inline FieldTypeId
  SFImage::typeId()
  {
    return sfImage;
  }  
  inline bool
  SFImage::operator==(const SFImage&) const
  {
    return false; // TODO:
  }
}

#endif // XDKWRL_SFIMAGE_H
