#ifndef XDKWRL_BACKGROUND_H
#define XDKWRL_BACKGROUND_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfcolor.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/sfbool.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Background
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Background : public Node
  {
   public:
     Background(const char* name="");
     virtual ~Background();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    groundAngle;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFColor default value
       */
       MFColor    groundColor;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFString default value
       */
       MFString   backUrl;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFString default value
       */
       MFString   bottomUrl;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFString default value
       */
       MFString   frontUrl;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFString default value
       */
       MFString   leftUrl;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFString default value
       */
       MFString   rightUrl;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFString default value
       */
       MFString   topUrl;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    skyAngle;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
           skyColor.push_back(SFColor(0.0f,0.0f,0.0f));
       \endcode
       */
       MFColor    skyColor;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<SFBool>     set_bind;
      /*!
       * Set event associated to exposedField groundAngle
       */
       EventIn<MFFloat>    set_groundAngle;
      /*!
       * Set event associated to exposedField groundColor
       */
       EventIn<MFColor>    set_groundColor;
      /*!
       * Set event associated to exposedField backUrl
       */
       EventIn<MFString>   set_backUrl;
      /*!
       * Set event associated to exposedField bottomUrl
       */
       EventIn<MFString>   set_bottomUrl;
      /*!
       * Set event associated to exposedField frontUrl
       */
       EventIn<MFString>   set_frontUrl;
      /*!
       * Set event associated to exposedField leftUrl
       */
       EventIn<MFString>   set_leftUrl;
      /*!
       * Set event associated to exposedField rightUrl
       */
       EventIn<MFString>   set_rightUrl;
      /*!
       * Set event associated to exposedField topUrl
       */
       EventIn<MFString>   set_topUrl;
      /*!
       * Set event associated to exposedField skyAngle
       */
       EventIn<MFFloat>    set_skyAngle;
      /*!
       * Set event associated to exposedField skyColor
       */
       EventIn<MFColor>    set_skyColor;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFBool>     isBound;
      /*!
       * Changed event associated to exposedField groundAngle
       */
       EventOut<MFFloat>    groundAngle_changed;
      /*!
       * Changed event associated to exposedField groundColor
       */
       EventOut<MFColor>    groundColor_changed;
      /*!
       * Changed event associated to exposedField backUrl
       */
       EventOut<MFString>   backUrl_changed;
      /*!
       * Changed event associated to exposedField bottomUrl
       */
       EventOut<MFString>   bottomUrl_changed;
      /*!
       * Changed event associated to exposedField frontUrl
       */
       EventOut<MFString>   frontUrl_changed;
      /*!
       * Changed event associated to exposedField leftUrl
       */
       EventOut<MFString>   leftUrl_changed;
      /*!
       * Changed event associated to exposedField rightUrl
       */
       EventOut<MFString>   rightUrl_changed;
      /*!
       * Changed event associated to exposedField topUrl
       */
       EventOut<MFString>   topUrl_changed;
      /*!
       * Changed event associated to exposedField skyAngle
       */
       EventOut<MFFloat>    skyAngle_changed;
      /*!
       * Changed event associated to exposedField skyColor
       */
       EventOut<MFColor>    skyColor_changed;
  //!@}
  };
};
//************************************************************
// Implementation of Background
//************************************************************
/*!
 * Returns <code>"Background"</code>. Useful for printing.
 */
inline const char*
wrl::Background::typeName() const
{
  return "Background";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::Background::nbFields() const
{
   return 10;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::Background::nbEventsIn() const
{
   return 1;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::Background::nbEventsOut() const
{
   return 1;
}
#endif // XDKWRL_BACKGROUND_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
