#ifndef XDKWRL_DIRECTIONALLIGHT_H
#define XDKWRL_DIRECTIONALLIGHT_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sfcolor.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of DirectionalLight
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API DirectionalLight : public Node
  {
   public:
     DirectionalLight(const char* name="");
     virtual ~DirectionalLight();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       ambientIntensity = 0.0f;
       \endcode
       */
       SFFloat    ambientIntensity;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       color.setRGB(1.0f,1.0f,1.0f);
       \endcode
       */
       SFColor    color;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       direction.setXYZ(0.0f,0.0f,-1.0f);
       \endcode
       */
       SFVec3f    direction;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       intensity = 1.0f;
       \endcode
       */
       SFFloat    intensity;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       on = true;
       \endcode
       */
       SFBool     on;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField ambientIntensity
       */
       EventIn<SFFloat>    set_ambientIntensity;
      /*!
       * Set event associated to exposedField color
       */
       EventIn<SFColor>    set_color;
      /*!
       * Set event associated to exposedField direction
       */
       EventIn<SFVec3f>    set_direction;
      /*!
       * Set event associated to exposedField intensity
       */
       EventIn<SFFloat>    set_intensity;
      /*!
       * Set event associated to exposedField on
       */
       EventIn<SFBool>     set_on;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField ambientIntensity
       */
       EventOut<SFFloat>    ambientIntensity_changed;
      /*!
       * Changed event associated to exposedField color
       */
       EventOut<SFColor>    color_changed;
      /*!
       * Changed event associated to exposedField direction
       */
       EventOut<SFVec3f>    direction_changed;
      /*!
       * Changed event associated to exposedField intensity
       */
       EventOut<SFFloat>    intensity_changed;
      /*!
       * Changed event associated to exposedField on
       */
       EventOut<SFBool>     on_changed;
  //!@}
  };
};
//************************************************************
// Implementation of DirectionalLight
//************************************************************
/*!
 * Returns <code>"DirectionalLight"</code>. Useful for printing.
 */
inline const char*
wrl::DirectionalLight::typeName() const
{
  return "DirectionalLight";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::DirectionalLight::nbFields() const
{
   return 5;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::DirectionalLight::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::DirectionalLight::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_DIRECTIONALLIGHT_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
