#ifndef XDKWRL_NURBSCURVE2D_H
#define XDKWRL_NURBSCURVE2D_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfvec2f.h>
#include <xdkwrl/fieldtypes/sfint32.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of NurbsCurve2D
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API NurbsCurve2D : public Node
  {
   public:
     NurbsCurve2D(const char* name="");
     virtual ~NurbsCurve2D();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFVec2f default value
       */
       MFVec2f    controlPoint;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       tessellation = 0;
       \endcode
       */
       SFInt32    tessellation;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    weight;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    knot;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       order = 3;
        \endcode
       */
       SFInt32    order;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField controlPoint
       */
       EventIn<MFVec2f>    set_controlPoint;
      /*!
       * Set event associated to exposedField tessellation
       */
       EventIn<SFInt32>    set_tessellation;
      /*!
       * Set event associated to exposedField weight
       */
       EventIn<MFFloat>    set_weight;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField controlPoint
       */
       EventOut<MFVec2f>    controlPoint_changed;
      /*!
       * Changed event associated to exposedField tessellation
       */
       EventOut<SFInt32>    tessellation_changed;
      /*!
       * Changed event associated to exposedField weight
       */
       EventOut<MFFloat>    weight_changed;
  //!@}
  };
};
//************************************************************
// Implementation of NurbsCurve2D
//************************************************************
/*!
 * Returns <code>"NurbsCurve2D"</code>. Useful for printing.
 */
inline const char*
wrl::NurbsCurve2D::typeName() const
{
  return "NurbsCurve2D";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::NurbsCurve2D::nbFields() const
{
   return 5;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::NurbsCurve2D::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::NurbsCurve2D::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_NURBSCURVE2D_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
