#ifndef XDKWRL_ORIENTATIONINTERPOLATOR_H
#define XDKWRL_ORIENTATIONINTERPOLATOR_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfrotation.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfrotation.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of OrientationInterpolator
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API OrientationInterpolator : public Node
  {
   public:
     OrientationInterpolator(const char* name="");
     virtual ~OrientationInterpolator();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    key;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFRotation default value
       */
       MFRotation keyValue;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<SFFloat>    set_fraction;
      /*!
       * Set event associated to exposedField key
       */
       EventIn<MFFloat>    set_key;
      /*!
       * Set event associated to exposedField keyValue
       */
       EventIn<MFRotation> set_keyValue;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFRotation> value_changed;
      /*!
       * Changed event associated to exposedField key
       */
       EventOut<MFFloat>    key_changed;
      /*!
       * Changed event associated to exposedField keyValue
       */
       EventOut<MFRotation> keyValue_changed;
  //!@}
  };
};
//************************************************************
// Implementation of OrientationInterpolator
//************************************************************
/*!
 * Returns <code>"OrientationInterpolator"</code>. Useful for printing.
 */
inline const char*
wrl::OrientationInterpolator::typeName() const
{
  return "OrientationInterpolator";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::OrientationInterpolator::nbFields() const
{
   return 2;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::OrientationInterpolator::nbEventsIn() const
{
   return 1;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::OrientationInterpolator::nbEventsOut() const
{
   return 1;
}
#endif // XDKWRL_ORIENTATIONINTERPOLATOR_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
