#ifndef XDKWRL_POINTLIGHT_H
#define XDKWRL_POINTLIGHT_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sfcolor.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of PointLight
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API PointLight : public Node
  {
   public:
     PointLight(const char* name="");
     virtual ~PointLight();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       ambientIntensity = 0.0f;
       \endcode
       */
       SFFloat    ambientIntensity;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       attenuation.setXYZ(1.0f,0.0f,0.0f);
       \endcode
       */
       SFVec3f    attenuation;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       color.setRGB(1.0f,1.0f,1.0f);
       \endcode
       */
       SFColor    color;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       intensity = 1.0f;
       \endcode
       */
       SFFloat    intensity;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       location.setXYZ(0.0f,0.0f,0.0f);
       \endcode
       */
       SFVec3f    location;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       on = true;
       \endcode
       */
       SFBool     on;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       radius = 100.0f;
       \endcode
       */
       SFFloat    radius;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField ambientIntensity
       */
       EventIn<SFFloat>    set_ambientIntensity;
      /*!
       * Set event associated to exposedField attenuation
       */
       EventIn<SFVec3f>    set_attenuation;
      /*!
       * Set event associated to exposedField color
       */
       EventIn<SFColor>    set_color;
      /*!
       * Set event associated to exposedField intensity
       */
       EventIn<SFFloat>    set_intensity;
      /*!
       * Set event associated to exposedField location
       */
       EventIn<SFVec3f>    set_location;
      /*!
       * Set event associated to exposedField on
       */
       EventIn<SFBool>     set_on;
      /*!
       * Set event associated to exposedField radius
       */
       EventIn<SFFloat>    set_radius;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField ambientIntensity
       */
       EventOut<SFFloat>    ambientIntensity_changed;
      /*!
       * Changed event associated to exposedField attenuation
       */
       EventOut<SFVec3f>    attenuation_changed;
      /*!
       * Changed event associated to exposedField color
       */
       EventOut<SFColor>    color_changed;
      /*!
       * Changed event associated to exposedField intensity
       */
       EventOut<SFFloat>    intensity_changed;
      /*!
       * Changed event associated to exposedField location
       */
       EventOut<SFVec3f>    location_changed;
      /*!
       * Changed event associated to exposedField on
       */
       EventOut<SFBool>     on_changed;
      /*!
       * Changed event associated to exposedField radius
       */
       EventOut<SFFloat>    radius_changed;
  //!@}
  };
};
//************************************************************
// Implementation of PointLight
//************************************************************
/*!
 * Returns <code>"PointLight"</code>. Useful for printing.
 */
inline const char*
wrl::PointLight::typeName() const
{
  return "PointLight";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::PointLight::nbFields() const
{
   return 7;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::PointLight::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::PointLight::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_POINTLIGHT_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
