#ifndef XDKWRL_TIMESENSOR_H
#define XDKWRL_TIMESENSOR_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sftime.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of TimeSensor
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API TimeSensor : public Node
  {
   public:
     TimeSensor(const char* name="");
     virtual ~TimeSensor();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       cycleInterval.setNbSeconds(1);
       \endcode
       */
       SFTime     cycleInterval;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       enabled = true;
       \endcode
       */
       SFBool     enabled;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       loop = false;
       \endcode
       */
       SFBool     loop;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       startTime.setNbSeconds(0);
       \endcode
       */
       SFTime     startTime;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       stopTime.setNbSeconds(0);
       \endcode
       */
       SFTime     stopTime;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField cycleInterval
       */
       EventIn<SFTime>     set_cycleInterval;
      /*!
       * Set event associated to exposedField enabled
       */
       EventIn<SFBool>     set_enabled;
      /*!
       * Set event associated to exposedField loop
       */
       EventIn<SFBool>     set_loop;
      /*!
       * Set event associated to exposedField startTime
       */
       EventIn<SFTime>     set_startTime;
      /*!
       * Set event associated to exposedField stopTime
       */
       EventIn<SFTime>     set_stopTime;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFTime>     cycleTime;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFFloat>    fraction_changed;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFBool>     isActive;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFTime>     time;
      /*!
       * Changed event associated to exposedField cycleInterval
       */
       EventOut<SFTime>     cycleInterval_changed;
      /*!
       * Changed event associated to exposedField enabled
       */
       EventOut<SFBool>     enabled_changed;
      /*!
       * Changed event associated to exposedField loop
       */
       EventOut<SFBool>     loop_changed;
      /*!
       * Changed event associated to exposedField startTime
       */
       EventOut<SFTime>     startTime_changed;
      /*!
       * Changed event associated to exposedField stopTime
       */
       EventOut<SFTime>     stopTime_changed;
  //!@}
  };
};
//************************************************************
// Implementation of TimeSensor
//************************************************************
/*!
 * Returns <code>"TimeSensor"</code>. Useful for printing.
 */
inline const char*
wrl::TimeSensor::typeName() const
{
  return "TimeSensor";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::TimeSensor::nbFields() const
{
   return 5;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::TimeSensor::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::TimeSensor::nbEventsOut() const
{
   return 4;
}
#endif // XDKWRL_TIMESENSOR_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
