#ifndef XDKWRL_VISIBILITYSENSOR_H
#define XDKWRL_VISIBILITYSENSOR_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sftime.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of VisibilitySensor
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API VisibilitySensor : public Node
  {
   public:
     VisibilitySensor(const char* name="");
     virtual ~VisibilitySensor();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       center.setXYZ(0.0f,0.0f,0.0f);
       \endcode
       */
       SFVec3f    center;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       enabled = true;
       \endcode
       */
       SFBool     enabled;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       size.setXYZ(0.0f,0.0f,0.0f);
       \endcode
       */
       SFVec3f    size;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField center
       */
       EventIn<SFVec3f>    set_center;
      /*!
       * Set event associated to exposedField enabled
       */
       EventIn<SFBool>     set_enabled;
      /*!
       * Set event associated to exposedField size
       */
       EventIn<SFVec3f>    set_size;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFTime>     enterTime;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFTime>     exitTime;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFBool>     isActive;
      /*!
       * Changed event associated to exposedField center
       */
       EventOut<SFVec3f>    center_changed;
      /*!
       * Changed event associated to exposedField enabled
       */
       EventOut<SFBool>     enabled_changed;
      /*!
       * Changed event associated to exposedField size
       */
       EventOut<SFVec3f>    size_changed;
  //!@}
  };
};
//************************************************************
// Implementation of VisibilitySensor
//************************************************************
/*!
 * Returns <code>"VisibilitySensor"</code>. Useful for printing.
 */
inline const char*
wrl::VisibilitySensor::typeName() const
{
  return "VisibilitySensor";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::VisibilitySensor::nbFields() const
{
   return 3;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::VisibilitySensor::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::VisibilitySensor::nbEventsOut() const
{
   return 3;
}
#endif // XDKWRL_VISIBILITYSENSOR_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
