#ifndef XDKWRL_VRML97FASTLEXER_H
#define XDKWRL_VRML97FASTLEXER_H

#include "./vrml97lexer.hpp"

class vrml97parser;

class vrml97fastlexer : public vrml97lexer
{
public:
  vrml97fastlexer(std::istream& );
  virtual ANTLR_USE_NAMESPACE(antlr)RefToken nextToken();
  virtual int getLine() const;
  virtual int getColumn() const;
  inline void setParserPointer(vrml97parser* parser);
protected:
  void swallowOneChar();
  void spitOneChar();
private:
  std::istream& istm_;
  char          prevChar_;
  char          c_;
  int           col_;
  int           line_;
  bool          cWasSpit_;
  vrml97parser* parser_;
};
inline void
vrml97fastlexer::setParserPointer(vrml97parser* parser)
{
  parser_ = parser;
}

#endif // XDKWRL_VRML97FASTLEXER_H
