#ifndef XDKWRL_SCENE_H
#define XDKWRL_SCENE_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfnode.h>
#include <string>

namespace wrl
{
  class ProtoDeclaration;
  class ExternProtoDeclaration;
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Scene
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Scene
  {
  public:
    Scene();
    virtual ~Scene() {};
    void load(const char* fileName,bool verbose=false,bool fast=true);
    void load(const std::string& fileName,bool verbose=false,bool fast=true);
    MFNode nodes;
    std::deque<ProtoDeclaration*> protos;
    std::deque<ExternProtoDeclaration*> externProtos;
  private:
  };
};

#endif // XDKWRL_SCENE_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("." "../../src/xdkwrl/")
// End:
