#ifndef XDKWRL_TRAVERSER_H
#define XDKWRL_TRAVERSER_H

#include <xdkwrl/config.h>
#include <xdkwrl/tools/transformator.h>

namespace wrl
{
  class Node;
  
  class Anchor;
  class Appearance;
  class AudioClip;
  class Background;
  class Billboard;
  class Box;
  class Collision;
  class Color;
  class ColorInterpolator;
  class Cone;
  class Contour2D;
  class Coordinate;
  class CoordinateDeformer;
  class CoordinateInterpolator;
  class Cylinder;
  class CylinderSensor;
  class DirectionalLight;
  class ElevationGrid;
  class Extrusion;
  class Fog;
  class FontStyle;
  class GeoCoordinate;
  class GeoElevationGrid;
  class GeoLOD;
  class GeoLocation;
  class GeoMetadata;
  class GeoOrigin;
  class GeoPositionInterpolator;
  class GeoTouchSensor;
  class GeoViewpoint;
  class Group;
  class ImageTexture;
  class IndexedFaceSet;
  class IndexedLineSet;
  class Inline;
  class InlineLoadControl;
  class LOD;
  class Material;
  class MovieTexture;
  class NavigationInfo;
  class Normal;
  class NormalInterpolator;
  class NurbsCurve;
  class NurbsCurve2D;
  class NurbsGroup;
  class NurbsPositionInterpolator;
  class NurbsSurface;
  class NurbsTextureSurface;
  class OrientationInterpolator;
  class PixelTexture;
  class PlaneSensor;
  class PointLight;
  class PointSet;
  class Polyline2D;
  class PositionInterpolator;
  class ProximitySensor;
  class ScalarInterpolator;
  class Shape;
  class Sound;
  class Sphere;
  class SphereSensor;
  class SpotLight;
  class Switch;
  class Text;
  class TextureCoordinate;
  class TextureTransform;
  class TimeSensor;
  class TouchSensor;
  class Transform;
  class TrimmedSurface;
  class Viewpoint;
  class VisibilitySensor;
  class WorldInfo;  
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Traverser
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Traverser
  {
  public:
    void operator()(wrl::Node* node);
    virtual ~Traverser() {}
  protected:
    virtual void treat(Anchor*);
    virtual void treat(Appearance*);
    virtual void treat(AudioClip*);
    virtual void treat(Background*);
    virtual void treat(Billboard*);
    virtual void treat(Box*);
    virtual void treat(Collision*);
    virtual void treat(Color*);
    virtual void treat(ColorInterpolator*);
    virtual void treat(Cone*);
    virtual void treat(Contour2D*);
    virtual void treat(Coordinate*);
    virtual void treat(CoordinateDeformer*);
    virtual void treat(CoordinateInterpolator*);
    virtual void treat(Cylinder*);
    virtual void treat(CylinderSensor*);
    virtual void treat(DirectionalLight*);
    virtual void treat(ElevationGrid*);
    virtual void treat(Extrusion*);
    virtual void treat(Fog*);
    virtual void treat(FontStyle*);
    virtual void treat(GeoCoordinate*);
    virtual void treat(GeoElevationGrid*);
    virtual void treat(GeoLOD*);
    virtual void treat(GeoLocation*);
    virtual void treat(GeoMetadata*);
    virtual void treat(GeoOrigin*);
    virtual void treat(GeoPositionInterpolator*);
    virtual void treat(GeoTouchSensor*);
    virtual void treat(GeoViewpoint*);
    virtual void treat(Group*);
    virtual void treat(ImageTexture*);
    virtual void treat(IndexedFaceSet*);
    virtual void treat(IndexedLineSet*);
    virtual void treat(Inline*);
    virtual void treat(InlineLoadControl*);
    virtual void treat(LOD*);
    virtual void treat(Material*);
    virtual void treat(MovieTexture*);
    virtual void treat(NavigationInfo*);
    virtual void treat(Normal*);
    virtual void treat(NormalInterpolator*);
    virtual void treat(NurbsCurve*);
    virtual void treat(NurbsCurve2D*);
    virtual void treat(NurbsGroup*);
    virtual void treat(NurbsPositionInterpolator*);
    virtual void treat(NurbsSurface*);
    virtual void treat(NurbsTextureSurface*);
    virtual void treat(OrientationInterpolator*);
    virtual void treat(PixelTexture*);
    virtual void treat(PlaneSensor*);
    virtual void treat(PointLight*);
    virtual void treat(PointSet*);
    virtual void treat(Polyline2D*);
    virtual void treat(PositionInterpolator*);
    virtual void treat(ProximitySensor*);
    virtual void treat(ScalarInterpolator*);
    virtual void treat(Shape*);
    virtual void treat(Sound*);
    virtual void treat(Sphere*);
    virtual void treat(SphereSensor*);
    virtual void treat(SpotLight*);
    virtual void treat(Switch*);
    virtual void treat(Text*);
    virtual void treat(TextureCoordinate*);
    virtual void treat(TextureTransform*);
    virtual void treat(TimeSensor*);
    virtual void treat(TouchSensor*);
    virtual void treat(Transform*);
    virtual void treat(TrimmedSurface*);
    virtual void treat(Viewpoint*);
    virtual void treat(VisibilitySensor*);
    virtual void treat(WorldInfo*);
  protected:
    inline const TransformatorHierarchy& transformHierarchy() const;
    inline TransformatorHierarchy& transformHierarchy();
  private:
    TransformatorHierarchy transformHierarchy_;    
  };
  //************************************************************
  // Implementation of TransformatorHierarchy
  //************************************************************
  inline const TransformatorHierarchy&
  Traverser::transformHierarchy() const
  {
    return transformHierarchy_;
  }    
  inline TransformatorHierarchy&
  Traverser::transformHierarchy()
  {
    return transformHierarchy_;
  }
}

#endif // XDKWRL_TRAVERSER_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("." "../../../src/xdkwrl/tools/")
// End:
