/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker;

import com.bric.colorpicker.ColorPicker;
import com.bric.colorpicker.parts.DialogFooter;
import com.bric.colorpicker.parts.EscapeKeyBehavior;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JDialog;

public class ColorPickerDialog
extends JDialog {
    private static final ResourceBundle STRINGS = ResourceBundle.getBundle("com.bric.colorpicker.resources.ColorPickerDialog");
    public static final JComponent[] LEFT_COMPONENTS = new JComponent[0];
    private ColorPicker colorPicker;
    private Color returnValue;
    private final ActionListener okListener = new OkListener();

    public ColorPickerDialog() {
        this((Frame)null, Color.BLUE, false);
    }

    public ColorPickerDialog(Frame owner, Color color, boolean includeOpacity) {
        super(owner);
        this.initialize(owner, color, includeOpacity);
    }

    public ColorPickerDialog(Dialog owner, Color color, boolean includeOpacity) {
        super(owner);
        this.initialize(owner, color, includeOpacity);
    }

    public static Color showDialog(Window owner, String title, Color originalColor, boolean includeOpacity) {
        ColorPickerDialog dialog;
        if (owner instanceof Frame || owner == null) {
            dialog = new ColorPickerDialog((Frame)owner, originalColor, includeOpacity);
        } else if (owner instanceof Dialog) {
            dialog = new ColorPickerDialog((Dialog)owner, originalColor, includeOpacity);
        } else {
            throw new IllegalArgumentException("the owner (" + owner.getClass().getName() + ") must be a java.awt.Frame or a java.awt.Dialog");
        }
        if (title == null) {
            dialog.setTitle(STRINGS.getObject("ColorPickerDialogTitle").toString());
        } else {
            dialog.setTitle(title);
        }
        dialog.pack();
        dialog.setVisible(true);
        return dialog.returnValue;
    }

    public static Color showDialog(Window owner, Color originalColor, boolean includeOpacity) {
        return ColorPickerDialog.showDialog(owner, null, originalColor, includeOpacity);
    }

    public static Color showDialog(Window owner, Color originalColor) {
        return ColorPickerDialog.showDialog(owner, null, originalColor, false);
    }

    private void initialize(Component owner, Color color, boolean includeOpacity) {
        this.colorPicker = new ColorPicker(true, includeOpacity);
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.colorPicker, constraints);
        ++constraints.gridy;
        DialogFooter footer = DialogFooter.createDialogFooter(LEFT_COMPONENTS, DialogFooter.OK_CANCEL_OPTION, DialogFooter.OK_OPTION, EscapeKeyBehavior.TRIGGERS_CANCEL);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        this.getContentPane().add((Component)footer, constraints);
        this.colorPicker.setColor(color);
        this.pack();
        this.setLocationRelativeTo(owner);
        footer.addOkButtonActionListener(this.okListener);
    }

    public Color getColor() {
        return this.returnValue;
    }

    private class OkListener
    implements ActionListener {
        OkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorPickerDialog.this.returnValue = ColorPickerDialog.this.colorPicker.getColor();
        }
    }
}

