/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker.colorslider;

import com.bric.colorpicker.ColorPicker;
import com.bric.colorpicker.ColorPickerMode;
import com.bric.colorpicker.ColorPickerPanel;
import com.bric.colorpicker.colorslider.Painter;
import com.bric.colorpicker.colorslider.SliderMouseListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.JSlider;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicSliderUI;
import lombok.NonNull;

public class ColorSliderUI
extends BasicSliderUI {
    private final ColorPicker colorPicker;
    private static final int ARROW_HALF = 8;
    private final int[] intArray;
    private final BufferedImage image;
    private MouseInputAdapter mouseInputAdapter;

    public ColorSliderUI(@NonNull JSlider slider, @NonNull ColorPicker colorPicker) {
        super(slider);
        this.intArray = new int[Toolkit.getDefaultToolkit().getScreenSize().height];
        this.image = new BufferedImage(1, this.intArray.length, 1);
        if (slider == null) {
            throw new NullPointerException("slider is marked non-null but is null");
        }
        if (colorPicker == null) {
            throw new NullPointerException("colorPicker is marked non-null but is null");
        }
        this.colorPicker = colorPicker;
        ColorPickerPanel colorPanel = colorPicker.getColorPanel();
        colorPanel.addComponentListener(new ResizeListener());
    }

    @Override
    public void paintThumb(Graphics g) {
        int y = this.thumbRect.y + this.thumbRect.height / 2;
        Polygon polygon = new Polygon();
        polygon.addPoint(0, y - 8);
        polygon.addPoint(8, y);
        polygon.addPoint(0, y + 8);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        g2.fill(polygon);
        g2.setColor(Color.white);
        g2.setStroke(new BasicStroke(1.0f));
        g2.draw(polygon);
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.thumbRect.height += 4;
        this.thumbRect.y -= 2;
    }

    @Override
    protected void calculateTrackRect() {
        super.calculateTrackRect();
        ColorPickerPanel cp = this.colorPicker.getColorPanel();
        int size = Math.min(325, Math.min(cp.getWidth(), cp.getHeight()));
        int max = this.slider.getHeight() - 16 - 2;
        if (size > max) {
            size = max;
        }
        this.trackRect.y = this.slider.getHeight() / 2 - size / 2;
        this.trackRect.height = size;
    }

    @Override
    public synchronized void paintTrack(Graphics g) {
        int y;
        ColorPickerMode mode = this.colorPicker.getMode();
        if (mode == ColorPickerMode.HUE || mode == ColorPickerMode.BRIGHTNESS || mode == ColorPickerMode.SATURATION) {
            float[] hsb = this.colorPicker.getHSB();
            if (mode == ColorPickerMode.HUE) {
                for (y = 0; y < this.trackRect.height; ++y) {
                    float hue = (float)y / (float)this.trackRect.height;
                    this.intArray[y] = Color.HSBtoRGB(hue, 1.0f, 1.0f);
                }
            } else if (mode == ColorPickerMode.SATURATION) {
                for (y = 0; y < this.trackRect.height; ++y) {
                    float sat = 1.0f - (float)y / (float)this.trackRect.height;
                    this.intArray[y] = Color.HSBtoRGB(hsb[0], sat, hsb[2]);
                }
            } else {
                for (y = 0; y < this.trackRect.height; ++y) {
                    float bri = 1.0f - (float)y / (float)this.trackRect.height;
                    this.intArray[y] = Color.HSBtoRGB(hsb[0], hsb[1], bri);
                }
            }
        } else {
            int[] rgb = this.colorPicker.getRGB();
            if (mode == ColorPickerMode.RED) {
                for (y = 0; y < this.trackRect.height; ++y) {
                    int red = 255 - (int)((double)(y * 255 / this.trackRect.height) + 0.49);
                    this.intArray[y] = (red << 16) + (rgb[1] << 8) + rgb[2];
                }
            } else if (mode == ColorPickerMode.GREEN) {
                for (y = 0; y < this.trackRect.height; ++y) {
                    int green = 255 - (int)((double)(y * 255 / this.trackRect.height) + 0.49);
                    this.intArray[y] = (rgb[0] << 16) + (green << 8) + rgb[2];
                }
            } else if (mode == ColorPickerMode.BLUE) {
                for (y = 0; y < this.trackRect.height; ++y) {
                    int blue = 255 - (int)((double)(y * 255 / this.trackRect.height) + 0.49);
                    this.intArray[y] = (rgb[0] << 16) + (rgb[1] << 8) + blue;
                }
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        Rectangle r = new Rectangle(6, this.trackRect.y, 14, this.trackRect.height);
        Painter painter = new Painter();
        painter.setGraphics2D(g2);
        if (this.slider.hasFocus()) {
            painter.paintFocus(r, 3);
        }
        WritableRaster raster = this.image.getRaster();
        raster.setDataElements(0, 0, 1, this.trackRect.height, this.intArray);
        TexturePaint p = new TexturePaint(this.image, new Rectangle(0, this.trackRect.y, 1, this.image.getHeight()));
        g2.setPaint(p);
        g2.fillRect(r.x, r.y, r.width, r.height);
        painter.drawBevel(r);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        slider.removeMouseListener(this.trackListener);
        slider.removeMouseMotionListener(this.trackListener);
        if (this.mouseInputAdapter == null) {
            this.mouseInputAdapter = new SliderMouseListener(this, slider);
            slider.addMouseListener(this.mouseInputAdapter);
            slider.addMouseMotionListener(this.mouseInputAdapter);
        }
        slider.setOpaque(false);
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        if (this.mouseInputAdapter != null) {
            slider.removeMouseListener(this.mouseInputAdapter);
            slider.removeMouseMotionListener(this.mouseInputAdapter);
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            ColorSliderUI.this.calculateGeometry();
            ColorSliderUI.this.slider.repaint();
        }
    }
}

