/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker.options;

import com.bric.colorpicker.ColorPickerMode;
import com.bric.colorpicker.listeners.ColorListener;
import com.bric.colorpicker.listeners.ColorListenerWrapper;
import com.bric.colorpicker.listeners.ModeListener;
import com.bric.colorpicker.listeners.ModeListenerWrapper;
import com.bric.colorpicker.models.ColorModel;
import com.bric.colorpicker.models.ModeModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

public abstract class Option
implements ColorListener,
ModeListener {
    protected static final ResourceBundle STRINGS = ResourceBundle.getBundle("com.bric.colorpicker.resources.ColorPicker");
    private final ColorListenerWrapper colorListenerWrapper;
    private final ModeListenerWrapper modeListenerWrapper;
    private final JRadioButton radioButton = new JRadioButton();
    private final JSpinner spinner;
    private final JLabel label;
    private final ColorPickerMode mode;

    protected Option(String text, ColorPickerMode mode) {
        this.mode = mode;
        this.spinner = new JSpinner(new SpinnerNumberModel(0, 0, mode.getMax(), 5));
        this.label = new JLabel(text);
        this.colorListenerWrapper = ColorListenerWrapper.withListener(this::doColorChanged);
        this.modeListenerWrapper = ModeListenerWrapper.withListener(modeModel -> this.setSelected(modeModel.getMode() == mode));
    }

    protected abstract void doColorChanged(ColorModel var1);

    @Override
    public void colorChanged(ColorModel colorModel) {
        this.colorListenerWrapper.colorChanged(colorModel);
    }

    public void aboutToChangeColor() {
        this.colorListenerWrapper.aboutToChangeValue();
    }

    protected JSpinner getSpinner() {
        return this.spinner;
    }

    protected JLabel getLabel() {
        return this.label;
    }

    public void addRadioActionListener(ActionListener listener) {
        this.radioButton.addActionListener(listener);
    }

    public void addSpinnerChangeListener(ChangeListener listener) {
        this.spinner.addChangeListener(listener);
    }

    public void setSelected(boolean b) {
        this.radioButton.setSelected(b);
    }

    public void setName(String name) {
        this.spinner.setName(name);
    }

    public void setValue(int i) {
        this.spinner.setValue(i);
    }

    public void addTo(Container container, GridBagConstraints constraints) {
        this.addTo(container, constraints, null);
    }

    public void addTo(Container container, GridBagConstraints constraints, ButtonGroup buttonGroup) {
        constraints.anchor = 22;
        constraints.fill = 0;
        container.add((Component)this.label, constraints);
        ++constraints.gridx;
        constraints.anchor = 21;
        constraints.fill = 2;
        container.add((Component)this.spinner, constraints);
        ++constraints.gridx;
        constraints.fill = 0;
        container.add((Component)this.radioButton, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        buttonGroup.add(this.radioButton);
    }

    public int getMax() {
        return this.mode.getMax();
    }

    public int getValue() {
        return ((Number)this.spinner.getValue()).intValue();
    }

    public boolean isVisible() {
        return this.label.isVisible();
    }

    public void setRadioButtonVisible(boolean visible) {
        this.radioButton.setVisible(visible);
    }

    public void setLabelVisible(boolean visible) {
        this.label.setVisible(visible);
    }

    public void setSpinnerVisible(boolean visible) {
        this.spinner.setVisible(visible);
    }

    public void setVisible(boolean visible, boolean radioButtonsAllowed) {
        this.setRadioButtonVisible(visible && radioButtonsAllowed);
        if (this.spinner != null) {
            this.spinner.setVisible(visible);
        }
        this.label.setVisible(visible);
    }

    private JFormattedTextField getTextField() {
        return ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
    }

    public void addFocusListener(FocusListener listener) {
        this.getTextField().addFocusListener(listener);
    }

    public void update(ModeModel modeModel) {
        modeModel.setMode(this.mode);
    }

    public abstract void update(ColorModel var1);

    @Override
    public void modeChanged(ModeModel modeModel) {
        this.modeListenerWrapper.modeChanged(modeModel);
    }

    public void aboutToChangeMode() {
        this.modeListenerWrapper.aboutToChangeValue();
    }
}

