/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker.parts;

import com.bric.colorpicker.JVM;
import com.bric.colorpicker.listeners.FocusArrowListener;
import com.bric.colorpicker.parts.ClickAction;
import com.bric.colorpicker.parts.DelegateFocusTraversalPolicy;
import com.bric.colorpicker.parts.EscapeKeyBehavior;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class DialogFooter
extends JPanel {
    private static final String PROPERTY_META_SHORTCUT = "Dialog.meta.shortcut";
    private static final String PROPERTY_UNSAFE = "Dialog.Unsafe.Action";
    private static final KeyStroke escapeKey = KeyStroke.getKeyStroke(27, 0);
    private static final KeyStroke commandPeriodKey = KeyStroke.getKeyStroke(46, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static final ResourceBundle strings = ResourceBundle.getBundle("com.bric.colorpicker.resources.DialogFooter");
    private static final String PROPERTY_OPTION = "DialogFooter.propertyOption";
    private static int uniqueCtr;
    private static final int CANCEL_OPTION;
    public static final int OK_OPTION;
    private static final int NO_OPTION;
    private static final int YES_OPTION;
    private static final int YES_NO_OPTION;
    private static final int YES_NO_CANCEL_OPTION;
    public static final int OK_CANCEL_OPTION;
    private static final int SAVE_DONT_SAVE_CANCEL_OPTION;
    private static final int DONT_SAVE_SAVE_OPTION;
    private static final int SAVE_OPTION;
    private static final int DONT_SAVE_OPTION;
    private static final AncestorListener escapeTriggerListener;
    private static final boolean reverseButtonOrder;
    private static final ActionListener closeDialogAndDisposeAction;
    private final ActionListener innerActionListener = new InnerActionListener();
    private final JComponent[] leftControls;
    private final JComponent[] dismissControls;
    private final boolean autoClose;
    private final JButton defaultButton;
    private final HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            this.processRootPane();
            this.processWindow();
        }

        private void processRootPane() {
            JRootPane root = SwingUtilities.getRootPane(DialogFooter.this);
            if (root == null) {
                return;
            }
            root.setDefaultButton(DialogFooter.this.defaultButton);
            for (JComponent dismissControl : DialogFooter.this.dismissControls) {
                Character ch;
                if (!(dismissControl instanceof JButton) || (ch = (Character)dismissControl.getClientProperty(DialogFooter.PROPERTY_META_SHORTCUT)) == null) continue;
                KeyStroke keyStroke = KeyStroke.getKeyStroke((int)ch.charValue(), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
                root.getInputMap(1).put(keyStroke, keyStroke);
                root.getActionMap().put(keyStroke, new ClickAction((JButton)dismissControl));
            }
        }

        private void processWindow() {
            Window window = SwingUtilities.getWindowAncestor(DialogFooter.this);
            if (window == null) {
                return;
            }
            window.setFocusTraversalPolicy(new DelegateFocusTraversalPolicy(window.getFocusTraversalPolicy()){

                @Override
                public Component getDefaultComponent(Container focusCycleRoot) {
                    JButton button;
                    Component defaultComponent = super.getDefaultComponent(focusCycleRoot);
                    if (DialogFooter.this.isAncestorOf(defaultComponent) && (button = DialogFooter.this.defaultButton) != null && button.isShowing() && button.isEnabled() && button.isFocusable()) {
                        return button;
                    }
                    return defaultComponent;
                }
            });
        }
    };
    private int buttonGap;
    private int unsafeButtonGap;

    private DialogFooter(JComponent[] leftControls, JComponent[] dismissControls, boolean autoClose, JButton defaultButton) {
        super(new GridBagLayout());
        this.autoClose = autoClose;
        if (leftControls == null) {
            leftControls = new JComponent[]{};
        }
        if (dismissControls == null) {
            dismissControls = new JComponent[]{};
        }
        this.leftControls = DialogFooter.copy(leftControls);
        this.dismissControls = DialogFooter.copy(dismissControls);
        this.defaultButton = defaultButton;
        for (int a = 0; a < dismissControls.length; ++a) {
            dismissControls[a].putClientProperty("dialog.footer.index", a);
            if (dismissControls[a] instanceof JButton) {
                ((AbstractButton)dismissControls[a]).addActionListener(this.innerActionListener);
                continue;
            }
            try {
                Class<?> cl = dismissControls[a].getClass();
                Method m = cl.getMethod("addRadioActionListener", ActionListener.class);
                m.invoke((Object)dismissControls[a], this.innerActionListener);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.addHierarchyListener(this.hierarchyListener);
        for (JComponent leftControl : leftControls) {
            DialogFooter.addFocusArrowListener(leftControl);
        }
        for (JComponent dismissControl : dismissControls) {
            DialogFooter.addFocusArrowListener(dismissControl);
        }
        if (JVM.IS_MAC) {
            this.setButtonGap(12);
        } else {
            this.setButtonGap(6);
        }
        this.setUnsafeButtonGap(24);
        this.installGUI();
    }

    private static JButton createCancelButton(boolean escapeKeyIsTrigger) {
        JButton button = new JButton(strings.getString("dialogCancelButton"));
        button.setMnemonic(strings.getString("dialogCancelMnemonic").charAt(0));
        button.putClientProperty(PROPERTY_OPTION, CANCEL_OPTION);
        if (escapeKeyIsTrigger) {
            DialogFooter.makeEscapeKeyActivate(button);
        }
        return button;
    }

    private static void makeEscapeKeyActivate(AbstractButton button) {
        button.addAncestorListener(escapeTriggerListener);
    }

    private static JButton createOKButton(boolean escapeKeyIsTrigger) {
        JButton button = new JButton(strings.getString("dialogOKButton"));
        button.setMnemonic(strings.getString("dialogOKMnemonic").charAt(0));
        button.putClientProperty(PROPERTY_OPTION, OK_OPTION);
        if (escapeKeyIsTrigger) {
            DialogFooter.makeEscapeKeyActivate(button);
        }
        return button;
    }

    private static JButton createYesButton(boolean escapeKeyIsTrigger) {
        JButton button = new JButton(strings.getString("dialogYesButton"));
        button.setMnemonic(strings.getString("dialogYesMnemonic").charAt(0));
        button.putClientProperty(PROPERTY_OPTION, YES_OPTION);
        if (escapeKeyIsTrigger) {
            DialogFooter.makeEscapeKeyActivate(button);
        }
        return button;
    }

    private static JButton createNoButton(boolean escapeKeyIsTrigger) {
        JButton button = new JButton(strings.getString("dialogNoButton"));
        button.setMnemonic(strings.getString("dialogNoMnemonic").charAt(0));
        button.putClientProperty(PROPERTY_OPTION, NO_OPTION);
        if (escapeKeyIsTrigger) {
            DialogFooter.makeEscapeKeyActivate(button);
        }
        return button;
    }

    private static JButton createSaveButton(boolean escapeKeyIsTrigger) {
        JButton button = new JButton(strings.getString("dialogSaveButton"));
        button.setMnemonic(strings.getString("dialogSaveMnemonic").charAt(0));
        button.putClientProperty(PROPERTY_OPTION, SAVE_OPTION);
        if (escapeKeyIsTrigger) {
            DialogFooter.makeEscapeKeyActivate(button);
        }
        return button;
    }

    private static JButton createDontSaveButton(boolean escapeKeyIsTrigger) {
        String text = strings.getString("dialogDontSaveButton");
        JButton button = new JButton(text);
        button.setMnemonic(strings.getString("dialogDontSaveMnemonic").charAt(0));
        button.putClientProperty(PROPERTY_OPTION, DONT_SAVE_OPTION);
        button.putClientProperty(PROPERTY_META_SHORTCUT, Character.valueOf(text.charAt(0)));
        if (escapeKeyIsTrigger) {
            DialogFooter.makeEscapeKeyActivate(button);
        }
        return button;
    }

    public static DialogFooter createDialogFooter(JComponent[] leftComponents, int options, int defaultButton, EscapeKeyBehavior escapeKeyBehavior) {
        JComponent[] dismissControls;
        if (escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT) {
            int buttonCount = 1;
            if (options == OK_CANCEL_OPTION || options == YES_NO_OPTION || options == DONT_SAVE_SAVE_OPTION) {
                buttonCount = 2;
            } else if (options == SAVE_DONT_SAVE_CANCEL_OPTION || options == YES_NO_CANCEL_OPTION) {
                buttonCount = 3;
            }
            if (defaultButton != -1) {
                --buttonCount;
            }
            if (buttonCount > 1) {
                throw new IllegalArgumentException("request for escape key to map to " + buttonCount + " buttons.");
            }
        }
        JButton cancelButton = null;
        if (options == CANCEL_OPTION || options == OK_CANCEL_OPTION || options == SAVE_DONT_SAVE_CANCEL_OPTION || options == YES_NO_CANCEL_OPTION) {
            cancelButton = DialogFooter.createCancelButton(escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_CANCEL || escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT && defaultButton != CANCEL_OPTION || defaultButton == CANCEL_OPTION && escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_DEFAULT);
        }
        JButton dontSaveButton = null;
        if (options == DONT_SAVE_OPTION || options == SAVE_DONT_SAVE_CANCEL_OPTION || options == DONT_SAVE_SAVE_OPTION) {
            dontSaveButton = DialogFooter.createDontSaveButton(escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT && defaultButton != DONT_SAVE_OPTION || escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_DEFAULT && defaultButton == DONT_SAVE_OPTION);
        }
        JButton noButton = null;
        if (options == NO_OPTION || options == YES_NO_OPTION || options == YES_NO_CANCEL_OPTION) {
            noButton = DialogFooter.createNoButton(escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT && defaultButton != NO_OPTION || escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_DEFAULT && defaultButton == NO_OPTION);
        }
        JButton okButton = null;
        if (options == OK_OPTION || options == OK_CANCEL_OPTION) {
            okButton = DialogFooter.createOKButton(escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT && defaultButton != OK_OPTION || escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_DEFAULT && defaultButton == OK_OPTION);
        }
        JButton saveButton = null;
        if (options == SAVE_OPTION || options == SAVE_DONT_SAVE_CANCEL_OPTION || options == DONT_SAVE_SAVE_OPTION) {
            saveButton = DialogFooter.createSaveButton(escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT && defaultButton != SAVE_OPTION || escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_DEFAULT && defaultButton == SAVE_OPTION);
        }
        JButton yesButton = null;
        if (options == YES_OPTION || options == YES_NO_OPTION || options == YES_NO_CANCEL_OPTION) {
            yesButton = DialogFooter.createYesButton(escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT && defaultButton != YES_OPTION || escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_DEFAULT && defaultButton == YES_OPTION);
        }
        if (options == CANCEL_OPTION) {
            dismissControls = new JButton[]{cancelButton};
        } else if (options == DONT_SAVE_OPTION) {
            dismissControls = new JButton[]{dontSaveButton};
        } else if (options == NO_OPTION) {
            dismissControls = new JButton[]{noButton};
        } else if (options == OK_CANCEL_OPTION) {
            dismissControls = new JButton[]{okButton, cancelButton};
        } else if (options == OK_OPTION) {
            dismissControls = new JButton[]{okButton};
        } else if (options == DONT_SAVE_SAVE_OPTION) {
            dismissControls = new JButton[]{dontSaveButton, saveButton};
        } else if (options == SAVE_DONT_SAVE_CANCEL_OPTION) {
            DialogFooter.setUnsafe(dontSaveButton, true);
            dismissControls = new JButton[]{saveButton, dontSaveButton, cancelButton};
        } else if (options == SAVE_OPTION) {
            dismissControls = new JButton[]{saveButton};
        } else if (options == YES_NO_CANCEL_OPTION) {
            dismissControls = new JButton[]{yesButton, noButton, cancelButton};
        } else if (options == YES_NO_OPTION) {
            dismissControls = new JButton[]{yesButton, noButton};
        } else if (options == YES_OPTION) {
            dismissControls = new JButton[]{yesButton};
        } else {
            throw new IllegalArgumentException("Unrecognized dialog type.");
        }
        JButton theDefaultButton = null;
        for (JButton jButton : dismissControls) {
            int i = (Integer)jButton.getClientProperty(PROPERTY_OPTION);
            if (i != defaultButton) continue;
            theDefaultButton = jButton;
        }
        return new DialogFooter(leftComponents, dismissControls, true, theDefaultButton);
    }

    private static JComponent[] copy(JComponent ... c) {
        JComponent[] newArray = new JComponent[c.length];
        System.arraycopy(c, 0, newArray, 0, c.length);
        return newArray;
    }

    private static void addFocusArrowListener(JComponent jc) {
        KeyListener[] listeners;
        for (KeyListener listener : listeners = jc.getKeyListeners()) {
            if (!(listener instanceof FocusArrowListener)) continue;
            return;
        }
        jc.addKeyListener(new FocusArrowListener());
    }

    private static void normalizeButtons(JButton ... buttons) {
        int maxWidth = 0;
        int maxHeight = 0;
        for (int a = 0; a < buttons.length; ++a) {
            buttons[a].setPreferredSize(null);
            Dimension d = buttons[a].getPreferredSize();
            Number n = (Number)buttons[a].getClientProperty(PROPERTY_OPTION);
            if (n != null && n.intValue() == DONT_SAVE_OPTION || d.width > 80) {
                buttons[a] = null;
            }
            if (buttons[a] == null) continue;
            maxWidth = Math.max(d.width, maxWidth);
            maxHeight = Math.max(d.height, maxHeight);
        }
        for (JButton button : buttons) {
            if (button == null) continue;
            button.setPreferredSize(new Dimension(maxWidth, maxHeight));
        }
    }

    private static boolean isUnsafe(JComponent c) {
        Boolean b = (Boolean)c.getClientProperty(PROPERTY_UNSAFE);
        if (b == null) {
            return Boolean.FALSE;
        }
        return b;
    }

    private static void setUnsafe(JComponent c, boolean b) {
        c.putClientProperty(PROPERTY_UNSAFE, b);
    }

    private void setButtonGap(int gap) {
        if (this.buttonGap == gap) {
            return;
        }
        this.buttonGap = gap;
        this.installGUI();
    }

    private void setUnsafeButtonGap(int unsafeGap) {
        if (this.unsafeButtonGap == unsafeGap) {
            return;
        }
        this.unsafeButtonGap = unsafeGap;
        this.installGUI();
    }

    private void installGUI() {
        int a;
        this.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 10;
        for (JComponent jComponent : this.leftControls) {
            this.add((Component)jComponent, c);
            ++c.gridx;
            c.insets = new Insets(0, 0, 0, this.buttonGap);
        }
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel fluff = new JPanel();
        fluff.setOpaque(false);
        if (this.leftControls.length > 0) {
            this.add((Component)fluff, c);
            ++c.gridx;
        }
        c.weightx = 0.0;
        int unsafeCtr = 0;
        int safeCtr = 0;
        for (JComponent dismissControl1 : this.dismissControls) {
            if (JVM.IS_MAC && DialogFooter.isUnsafe(dismissControl1)) {
                ++unsafeCtr;
                continue;
            }
            ++safeCtr;
        }
        JButton[] jButtonArray = new JButton[unsafeCtr];
        JButton[] safeButtons = new JButton[safeCtr];
        unsafeCtr = 0;
        safeCtr = 0;
        for (JComponent dismissControl : this.dismissControls) {
            if (!(dismissControl instanceof JButton)) continue;
            if (JVM.IS_MAC && DialogFooter.isUnsafe(dismissControl)) {
                jButtonArray[unsafeCtr++] = (JButton)dismissControl;
                continue;
            }
            safeButtons[safeCtr++] = (JButton)dismissControl;
        }
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = new Insets(0, 0, 0, 0);
        for (a = 0; a < jButtonArray.length; ++a) {
            JButton comp = reverseButtonOrder ? jButtonArray[jButtonArray.length - 1 - a] : jButtonArray[a];
            this.add((Component)comp, c);
            ++c.gridx;
            c.insets.left = this.buttonGap;
        }
        if (jButtonArray.length > 0) {
            c.insets.left = this.unsafeButtonGap;
        } else if (this.leftControls.length == 0) {
            c.weightx = 1.0;
            this.add((Component)fluff, c);
            c.weightx = 0.0;
            ++c.gridx;
        }
        for (a = 0; a < safeButtons.length; ++a) {
            JButton comp = reverseButtonOrder ? safeButtons[safeButtons.length - 1 - a] : safeButtons[a];
            this.add((Component)comp, c);
            ++c.gridx;
            c.insets.left = this.buttonGap;
        }
        DialogFooter.normalizeButtons(jButtonArray);
        DialogFooter.normalizeButtons(safeButtons);
    }

    public JButton getButton(int buttonType) {
        for (int a = 0; a < this.getComponentCount(); ++a) {
            if (!(this.getComponent(a) instanceof JButton)) continue;
            JButton button = (JButton)this.getComponent(a);
            Object value = button.getClientProperty(PROPERTY_OPTION);
            int intValue = -1;
            if (value instanceof Number) {
                intValue = ((Number)value).intValue();
            }
            if (intValue != buttonType) continue;
            return button;
        }
        return null;
    }

    public void addOkButtonActionListener(ActionListener okListener) {
        this.getButton(OK_OPTION).addActionListener(okListener);
    }

    static {
        CANCEL_OPTION = uniqueCtr++;
        OK_OPTION = uniqueCtr++;
        NO_OPTION = uniqueCtr++;
        YES_OPTION = uniqueCtr++;
        YES_NO_OPTION = uniqueCtr++;
        YES_NO_CANCEL_OPTION = uniqueCtr++;
        OK_CANCEL_OPTION = uniqueCtr++;
        SAVE_DONT_SAVE_CANCEL_OPTION = uniqueCtr++;
        DONT_SAVE_SAVE_OPTION = uniqueCtr++;
        SAVE_OPTION = uniqueCtr++;
        DONT_SAVE_OPTION = uniqueCtr++;
        escapeTriggerListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                JButton button = (JButton)event.getComponent();
                Window w = SwingUtilities.getWindowAncestor(button);
                if (w instanceof RootPaneContainer) {
                    this.setRootPaneContainer(button, (RootPaneContainer)((Object)w));
                } else {
                    this.setRootPaneContainer(button, null);
                }
            }

            private void setRootPaneContainer(JButton button, RootPaneContainer c) {
                RootPaneContainer lastContainer = (RootPaneContainer)button.getClientProperty("bric.footer.rpc");
                if (Objects.equals(lastContainer, c)) {
                    return;
                }
                if (lastContainer != null) {
                    lastContainer.getRootPane().getInputMap(1).remove(escapeKey);
                    lastContainer.getRootPane().getActionMap().remove(escapeKey);
                    if (JVM.IS_MAC) {
                        lastContainer.getRootPane().getInputMap(1).remove(commandPeriodKey);
                    }
                }
                if (c != null) {
                    c.getRootPane().getInputMap(1).put(escapeKey, escapeKey);
                    c.getRootPane().getActionMap().put(escapeKey, new ClickAction(button));
                    if (JVM.IS_MAC) {
                        c.getRootPane().getInputMap(1).put(commandPeriodKey, escapeKey);
                    }
                }
                button.putClientProperty("bric.footer.rpc", c);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                this.ancestorAdded(event);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                this.ancestorAdded(event);
            }
        };
        reverseButtonOrder = JVM.IS_MAC;
        closeDialogAndDisposeAction = new CloseDialogAndDisposeAction();
    }

    private class InnerActionListener
    implements ActionListener {
        private InnerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent lastSelectedComponent = (JComponent)e.getSource();
            if (DialogFooter.this.autoClose) {
                closeDialogAndDisposeAction.actionPerformed(e);
            }
        }
    }

    private static class CloseDialogAndDisposeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CloseDialogAndDisposeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component src = (Component)e.getSource();
            for (Container parent = src.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof JInternalFrame) {
                    parent.setVisible(false);
                    ((JInternalFrame)parent).dispose();
                    return;
                }
                if (!(parent instanceof Window)) continue;
                parent.setVisible(false);
                ((Window)parent).dispose();
                return;
            }
        }
    }
}

