/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.model;

import com.cburch.draw.model.CanvasObject;
import com.cburch.logisim.data.Location;

public class Handle {
    private final CanvasObject object;
    private final int x;
    private final int y;

    public Handle(CanvasObject object, int x, int y) {
        this.object = object;
        this.x = x;
        this.y = y;
    }

    public Handle(CanvasObject object, Location loc) {
        this(object, loc.getX(), loc.getY());
    }

    public boolean equals(Object other) {
        boolean bl;
        if (other instanceof Handle) {
            Handle that = (Handle)other;
            bl = this.object.equals(that.object) && this.x == that.x && this.y == that.y;
        } else {
            bl = false;
        }
        return bl;
    }

    public Location getLocation() {
        return Location.create(this.x, this.y, false);
    }

    public CanvasObject getObject() {
        return this.object;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int hashCode() {
        return (this.object.hashCode() * 31 + this.x) * 31 + this.y;
    }

    public boolean isAt(int xq, int yq) {
        return this.x == xq && this.y == yq;
    }

    public boolean isAt(Location loc) {
        return this.x == loc.getX() && this.y == loc.getY();
    }
}

