/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.hex;

import com.cburch.contracts.BaseKeyListenerContract;
import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.contracts.BaseMouseMotionListenerContract;
import com.cburch.hex.HexEditor;
import com.cburch.hex.HexModel;
import com.cburch.hex.Measures;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Caret {
    private static final Color SELECT_COLOR = new Color(192, 192, 255);
    private static final Stroke CURSOR_STROKE = new BasicStroke(2.0f);
    private final HexEditor hex;
    private final List<ChangeListener> listeners;
    private long mark;
    private long cursor;
    private Object highlight;

    Caret(HexEditor hex) {
        this.hex = hex;
        this.listeners = new ArrayList<ChangeListener>();
        this.cursor = -1L;
        Listener l = new Listener();
        hex.addMouseListener(l);
        hex.addMouseMotionListener(l);
        hex.addKeyListener(l);
        hex.addFocusListener(l);
        InputMap imap = hex.getInputMap();
        ActionMap amap = hex.getActionMap();
        AbstractAction nullAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        String nullKey = "null";
        amap.put("null", nullAction);
        imap.put(KeyStroke.getKeyStroke(40, 0), "null");
        imap.put(KeyStroke.getKeyStroke(38, 0), "null");
        imap.put(KeyStroke.getKeyStroke(37, 0), "null");
        imap.put(KeyStroke.getKeyStroke(39, 0), "null");
        imap.put(KeyStroke.getKeyStroke(34, 0), "null");
        imap.put(KeyStroke.getKeyStroke(33, 0), "null");
        imap.put(KeyStroke.getKeyStroke(36, 0), "null");
        imap.put(KeyStroke.getKeyStroke(35, 0), "null");
        imap.put(KeyStroke.getKeyStroke(10, 0), "null");
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    private void expose(long loc, boolean scrollTo) {
        if (loc >= 0L) {
            Measures measures = this.hex.getMeasures();
            int x = measures.toX(loc);
            int y = measures.toY(loc);
            int w = measures.getCellWidth();
            int h = measures.getCellHeight();
            this.hex.repaint(x - 1, y - 1, w + 2, h + 2);
            if (scrollTo) {
                this.hex.scrollRectToVisible(new Rectangle(x, y, w, h));
            }
        }
    }

    public long getDot() {
        return this.cursor;
    }

    public long getMark() {
        return this.mark;
    }

    void paintForeground(Graphics g, long start, long end) {
        if (this.cursor >= start && this.cursor < end && this.hex.isFocusOwner()) {
            Measures measures = this.hex.getMeasures();
            int x = measures.toX(this.cursor);
            int y = measures.toY(this.cursor);
            Graphics2D g2 = (Graphics2D)g;
            Stroke oldStroke = g2.getStroke();
            g2.setColor(this.hex.getForeground());
            g2.setStroke(CURSOR_STROKE);
            g2.drawRect(x, y, measures.getCellWidth() - 1, measures.getCellHeight() - 1);
            g2.setStroke(oldStroke);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public void setDot(long value, boolean keepMark) {
        HexModel model = this.hex.getModel();
        if (model == null || value < model.getFirstOffset() || value > model.getLastOffset()) {
            value = -1L;
        }
        if (this.cursor != value) {
            long oldValue = this.cursor;
            if (this.highlight != null) {
                this.hex.getHighlighter().remove(this.highlight);
                this.highlight = null;
            }
            if (!keepMark) {
                this.mark = value;
            } else if (this.mark != value) {
                this.highlight = this.hex.getHighlighter().add(this.mark, value, SELECT_COLOR);
            }
            this.cursor = value;
            this.expose(oldValue, false);
            this.expose(value, true);
            if (!this.listeners.isEmpty()) {
                ChangeEvent event = new ChangeEvent(this);
                for (ChangeListener l : this.listeners) {
                    l.stateChanged(event);
                }
            }
        }
    }

    private class Listener
    implements BaseMouseListenerContract,
    BaseMouseMotionListenerContract,
    BaseKeyListenerContract,
    FocusListener {
        private Listener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Caret.this.expose(Caret.this.cursor, false);
        }

        @Override
        public void focusLost(FocusEvent e) {
            Caret.this.expose(Caret.this.cursor, false);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int cols = Caret.this.hex.getMeasures().getColumnCount();
            boolean shift = (e.getModifiersEx() & 0x40) != 0;
            switch (e.getKeyCode()) {
                case 38: {
                    if (Caret.this.cursor < (long)cols) break;
                    Caret.this.setDot(Caret.this.cursor - (long)cols, shift);
                    break;
                }
                case 37: {
                    if (Caret.this.cursor < 1L) break;
                    Caret.this.setDot(Caret.this.cursor - 1L, shift);
                    break;
                }
                case 40: {
                    if (Caret.this.cursor < Caret.this.hex.getModel().getFirstOffset() || Caret.this.cursor > Caret.this.hex.getModel().getLastOffset() - (long)cols) break;
                    Caret.this.setDot(Caret.this.cursor + (long)cols, shift);
                    break;
                }
                case 39: {
                    if (Caret.this.cursor < Caret.this.hex.getModel().getFirstOffset() || Caret.this.cursor > Caret.this.hex.getModel().getLastOffset() - 1L) break;
                    Caret.this.setDot(Caret.this.cursor + 1L, shift);
                    break;
                }
                case 36: {
                    if (Caret.this.cursor < 0L) break;
                    int dist = (int)(Caret.this.cursor % (long)cols);
                    if (dist == 0) {
                        Caret.this.setDot(0L, shift);
                        break;
                    }
                    Caret.this.setDot(Caret.this.cursor - (long)dist, shift);
                    break;
                }
                case 35: {
                    long end;
                    if (Caret.this.cursor < 0L) break;
                    HexModel model = Caret.this.hex.getModel();
                    long dest = Caret.this.cursor / (long)cols * (long)cols + (long)cols - 1L;
                    if (model != null && (dest > (end = model.getLastOffset()) || dest == Caret.this.cursor)) {
                        dest = end;
                    }
                    Caret.this.setDot(dest, shift);
                    break;
                }
                case 34: {
                    int rows = Caret.this.hex.getVisibleRect().height / Caret.this.hex.getMeasures().getCellHeight();
                    if (rows > 2) {
                        --rows;
                    }
                    if (Caret.this.cursor < 0L) break;
                    long max = Caret.this.hex.getModel().getLastOffset();
                    if (Caret.this.cursor + (long)(rows * cols) <= max) {
                        Caret.this.setDot(Caret.this.cursor + (long)(rows * cols), shift);
                        break;
                    }
                    long n = Caret.this.cursor;
                    while (n + (long)cols < max) {
                        n += (long)cols;
                    }
                    Caret.this.setDot(n, shift);
                    break;
                }
                case 33: {
                    int rows = Caret.this.hex.getVisibleRect().height / Caret.this.hex.getMeasures().getCellHeight();
                    if (rows > 2) {
                        --rows;
                    }
                    if (Caret.this.cursor >= (long)(rows * cols)) {
                        Caret.this.setDot(Caret.this.cursor - (long)(rows * cols), shift);
                        break;
                    }
                    if (Caret.this.cursor < (long)cols) break;
                    Caret.this.setDot(Caret.this.cursor % (long)cols, shift);
                    break;
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            int mask = e.getModifiersEx();
            if ((mask & 0xFFFFFFBF) != 0) {
                return;
            }
            char c = e.getKeyChar();
            int cols = Caret.this.hex.getMeasures().getColumnCount();
            switch (c) {
                case ' ': {
                    if (Caret.this.cursor < 0L) break;
                    Caret.this.setDot(Caret.this.cursor + 1L, (mask & 0x40) != 0);
                    break;
                }
                case '\n': {
                    if (Caret.this.cursor < 0L) break;
                    Caret.this.setDot(Caret.this.cursor + (long)cols, (mask & 0x40) != 0);
                    break;
                }
                case '\b': 
                case '\u007f': {
                    Caret.this.hex.delete();
                    break;
                }
                default: {
                    HexModel model;
                    int digit = Character.digit(e.getKeyChar(), 16);
                    if (digit < 0 || (model = Caret.this.hex.getModel()) == null || Caret.this.cursor < model.getFirstOffset() || Caret.this.cursor > model.getLastOffset()) break;
                    long curValue = model.get(Caret.this.cursor);
                    long newValue = 16L * curValue + (long)digit;
                    model.set(Caret.this.cursor, newValue);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Measures measures = Caret.this.hex.getMeasures();
            long loc = measures.toAddress(e.getX(), e.getY());
            Caret.this.setDot(loc, true);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Measures measures = Caret.this.hex.getMeasures();
            long loc = measures.toAddress(e.getX(), e.getY());
            Caret.this.setDot(loc, (e.getModifiersEx() & 0x40) != 0);
            if (!Caret.this.hex.isFocusOwner()) {
                Caret.this.hex.requestFocus();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseDragged(e);
        }
    }
}

