/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim;

import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.start.Startup;
import com.cburch.logisim.prefs.AppPreferences;
import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.GraphicsEnvironment;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;

public class Main {
    public static boolean headless = false;
    public static final String DIRTY_MARKER = "\ud83d\udcbe";

    public static void main(String[] args) {
        System.setProperty("apple.awt.application.name", "Logisim-evolution");
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                FlatLightLaf.installLafInfo();
                FlatDarkLaf.installLafInfo();
                FlatDarculaLaf.installLafInfo();
                FlatIntelliJLaf.installLafInfo();
                UIManager.setLookAndFeel(AppPreferences.LookAndFeel.get());
                UIManager.put("ToolTip.font", new FontUIResource("SansSerif", 1, AppPreferences.getScaled(12)));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        Startup startup = Startup.parseArgs(args);
        if (startup == null) {
            System.exit(10);
        }
        if (startup.shallQuit()) {
            System.exit(0);
        }
        try {
            startup.run();
        }
        catch (Throwable e) {
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(strWriter);
            e.printStackTrace(printWriter);
            OptionPane.showMessageDialog(null, strWriter.toString());
            System.exit(100);
        }
    }

    public static boolean hasGui() {
        return !headless;
    }
}

