/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.file;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.data.CoverColor;
import com.cburch.logisim.analyze.data.KarnaughMapGroups;
import com.cburch.logisim.analyze.file.TruthtableFileFilter;
import com.cburch.logisim.analyze.gui.KarnaughMapPanel;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Entry;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.analyze.model.ParserException;
import com.cburch.logisim.analyze.model.TruthTable;
import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.analyze.model.VariableList;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class AnalyzerTexWriter {
    private static final String SECTION_SEP = "%===============================================================================";
    private static final String SUB_SECTION_SEP = "%-------------------------------------------------------------------------------";
    public static final int MAX_TRUTH_TABLE_ROWS = 64;
    public static final FileFilter FILE_FILTER = new TruthtableFileFilter(Strings.S.getter("tableLatexFilter"), ".tex");
    private static final String K_INTRO = "\\begin{tikzpicture}[karnaugh,";
    private static final String K_NUMBERED = "disable bars,";
    private static final String K_SETUP = "x=1\\kmunitlength,y=1\\kmunitlength,kmbar left sep=1\\kmunitlength,grp/.style n args={4}{#1,fill=#1!30,minimum width= #2\\kmunitlength,minimum height=#3\\kmunitlength,rounded corners=0.2\\kmunitlength,fill opacity=0.6,rectangle,draw}]";
    private static final double OFFSET = 0.2;

    private static int nrOfInCols(AnalyzerModel model) {
        int count = 0;
        VariableList inputs = model.getInputs();
        for (int i = 0; i < inputs.vars.size(); ++i) {
            count += inputs.vars.get((int)i).width;
        }
        return count;
    }

    private static int nrOfOutCols(AnalyzerModel model) {
        int count = 0;
        VariableList outputs = model.getOutputs();
        for (int i = 0; i < outputs.vars.size(); ++i) {
            count += outputs.vars.get((int)i).width;
        }
        return count;
    }

    private static String truthTableHeader(AnalyzerModel model) {
        int i;
        StringBuilder out = new StringBuilder();
        out.append("\\begin{center}\n");
        out.append("\\begin{tabular}{");
        int nrInCols = AnalyzerTexWriter.nrOfInCols(model);
        int nrOutCols = AnalyzerTexWriter.nrOfOutCols(model);
        out.append("c".repeat(nrInCols));
        out.append("|");
        out.append("c".repeat(nrOutCols));
        out.append("}\n");
        List<Var> inputVars = model.getInputs().vars;
        List<Var> outputVars = model.getOutputs().vars;
        for (i = 0; i < inputVars.size(); ++i) {
            Var inp = inputVars.get(i);
            if (inp.width == 1) {
                out.append("$").append(inp.name).append("$&");
                continue;
            }
            String format = i == inputVars.size() - 1 ? "c|" : "c";
            out.append("\\multicolumn{").append(inp.width).append("}{").append(format).append("}{$").append(inp.name).append("[").append(inp.width - 1).append("..0]$}&");
        }
        for (i = 0; i < outputVars.size(); ++i) {
            Var outp = outputVars.get(i);
            if (outp.width == 1) {
                out.append("$").append(outp.name).append("$");
            } else {
                out.append("\\multicolumn{").append(outp.width).append("}{c}{$").append(outp.name).append("[").append(outp.width - 1).append("..0]$}");
            }
            out.append(i < outputVars.size() - 1 ? "&" : "\\\\");
        }
        out.append("\n\\hline");
        return out.toString();
    }

    private static String getCompactTruthTable(TruthTable tt, AnalyzerModel model) {
        StringBuilder content = new StringBuilder();
        for (int row = 0; row < tt.getVisibleRowCount(); ++row) {
            Entry val;
            int col;
            for (col = 0; col < AnalyzerTexWriter.nrOfInCols(model); ++col) {
                val = tt.getVisibleInputEntry(row, col);
                content.append("$").append(val.getDescription()).append("$&");
            }
            for (col = 0; col < AnalyzerTexWriter.nrOfOutCols(model); ++col) {
                val = tt.getVisibleOutputEntry(row, col);
                content.append("$").append(val.getDescription()).append("$");
                content.append(col == AnalyzerTexWriter.nrOfOutCols(model) - 1 ? "\\\\\n" : "&");
            }
        }
        return content.toString();
    }

    private static String getCompleteTruthTable(TruthTable tt, AnalyzerModel model) {
        StringBuilder content = new StringBuilder();
        for (int row = 0; row < tt.getRowCount(); ++row) {
            Entry val;
            int col;
            for (col = 0; col < AnalyzerTexWriter.nrOfInCols(model); ++col) {
                val = tt.getInputEntry(row, col);
                content.append("$").append(val.getDescription()).append("$&");
            }
            for (col = 0; col < AnalyzerTexWriter.nrOfOutCols(model); ++col) {
                val = tt.getOutputEntry(row, col);
                content.append("$").append(val.getDescription()).append("$");
                content.append(col == AnalyzerTexWriter.nrOfOutCols(model) - 1 ? "\\\\\n" : "&");
            }
        }
        return content.toString();
    }

    private static int[] reordered(int nrOfInputs) {
        int[] nArray;
        switch (nrOfInputs) {
            case 1: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
                break;
            }
            case 2: {
                int[] nArray3 = new int[2];
                nArray3[0] = 0;
                nArray = nArray3;
                nArray3[1] = 1;
                break;
            }
            case 3: {
                int[] nArray4 = new int[3];
                nArray4[0] = 1;
                nArray4[1] = 0;
                nArray = nArray4;
                nArray4[2] = 2;
                break;
            }
            case 4: {
                int[] nArray5 = new int[4];
                nArray5[0] = 0;
                nArray5[1] = 2;
                nArray5[2] = 1;
                nArray = nArray5;
                nArray5[3] = 3;
                break;
            }
            case 5: {
                int[] nArray6 = new int[5];
                nArray6[0] = 2;
                nArray6[1] = 0;
                nArray6[2] = 3;
                nArray6[3] = 1;
                nArray = nArray6;
                nArray6[4] = 4;
                break;
            }
            case 6: {
                int[] nArray7 = new int[6];
                nArray7[0] = 0;
                nArray7[1] = 3;
                nArray7[2] = 1;
                nArray7[3] = 4;
                nArray7[4] = 2;
                nArray = nArray7;
                nArray7[5] = 5;
                break;
            }
            default: {
                nArray = new int[]{};
            }
        }
        return nArray;
    }

    private static int reorderedIndex(int nrOfInputs, int row) {
        int result = 0;
        int[] reorder = AnalyzerTexWriter.reordered(nrOfInputs);
        int[] values = new int[nrOfInputs];
        for (int i = 0; i < nrOfInputs; ++i) {
            values[i] = 1 << nrOfInputs - reorder[i] - 1;
        }
        int mask = 1 << nrOfInputs - 1;
        for (int i = 0; i < nrOfInputs; ++i) {
            if ((row & mask) == mask) {
                result |= values[i];
            }
            mask >>= 1;
        }
        return result;
    }

    private static String getKarnaughInputs(AnalyzerModel model) {
        StringBuilder content = new StringBuilder();
        int[] reorder = AnalyzerTexWriter.reordered(model.getInputs().bits.size());
        for (int i = 0; i < model.getInputs().bits.size(); ++i) {
            try {
                Var.Bit inp = Var.Bit.parse(model.getInputs().bits.get(reorder[i]));
                content.append("{$").append(inp.name);
                if (inp.bitIndex >= 0) {
                    content.append("_").append(inp.bitIndex);
                }
                content.append("$}");
                continue;
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
        return content.toString();
    }

    private static String getGrayCode(int nrVars) {
        return switch (nrVars) {
            case 2 -> "{0/00,1/01,2/11,3/10}";
            case 3 -> "{0/000,1/001,2/011,3/010,4/110,5/111,6/101,7/100}";
            default -> "{0/0,1/1}";
        };
    }

    private static String getNumberedHeader(String name, AnalyzerModel model) {
        StringBuilder content = new StringBuilder();
        TruthTable table = model.getTruthTable();
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
        int kmapRows = 1 << KarnaughMapPanel.ROW_VARS[table.getInputColumnCount()];
        content.append("\n");
        StringBuilder leftVars = new StringBuilder();
        StringBuilder topVars = new StringBuilder();
        int nrLeftVars = KarnaughMapPanel.ROW_VARS[table.getInputColumnCount()];
        int count = 0;
        for (Var variable : table.getInputVariables()) {
            if (variable.width == 1) {
                if (count++ < nrLeftVars) {
                    if (leftVars.length() != 0) {
                        leftVars.append(", ");
                    }
                    leftVars.append("$").append(variable.name).append("$");
                    continue;
                }
                if (topVars.length() != 0) {
                    topVars.append(", ");
                }
                topVars.append("$").append(variable.name).append("$");
                continue;
            }
            for (int idx = variable.width; idx >= 0; --idx) {
                if (count++ < nrLeftVars) {
                    if (leftVars.length() != 0) {
                        leftVars.append(", ");
                    }
                    leftVars.append("$").append(variable.name).append("_{").append(idx).append("}$");
                    continue;
                }
                if (topVars.length() != 0) {
                    topVars.append(", ");
                }
                topVars.append("$").append(variable.name).append("_{").append(idx).append("}$");
            }
        }
        content.append("\\draw[kmbox] (").append(df.format(-0.5)).append(",").append(df.format((double)kmapRows + 0.5)).append(")\n");
        content.append("   node[below left]{").append((CharSequence)leftVars).append("}\n");
        content.append("   node[above right]{").append((CharSequence)topVars).append("} +(-0.2,0.2)\n");
        content.append("   node[above left]{").append(name).append("};");
        content.append("\\draw (0,").append(kmapRows).append(") -- (-0.7,").append(df.format((double)kmapRows + 0.7)).append(");\n");
        content.append("\\foreach \\x/\\1 in %\n");
        content.append(AnalyzerTexWriter.getGrayCode(KarnaughMapPanel.COL_VARS[table.getInputColumnCount()])).append(" {\n");
        content.append("   \\node at (\\x+0.5,").append(df.format((double)kmapRows + 0.2)).append(") {\\1};\n}\n");
        content.append("\\foreach \\y/\\1 in %\n");
        content.append(AnalyzerTexWriter.getGrayCode(KarnaughMapPanel.ROW_VARS[table.getInputColumnCount()])).append(" {\n");
        content.append("   \\node at (-0.4,-0.5-\\y+").append(df.format(kmapRows)).append(") {\\1};\n}\n");
        return content.toString();
    }

    private static String getKarnaughEmpty(String name, boolean lined, AnalyzerModel model) {
        StringBuilder content = new StringBuilder();
        content.append("\\begin{center}\n");
        content.append(K_INTRO).append(lined ? "" : K_NUMBERED).append(K_SETUP).append("\n");
        content.append("\\karnaughmap{").append(AnalyzerTexWriter.nrOfInCols(model)).append("}{").append(name).append("}{").append(AnalyzerTexWriter.getKarnaughInputs(model)).append("}{}{");
        if (!lined) {
            content.append(AnalyzerTexWriter.getNumberedHeader(name, model));
        }
        content.append("}\n");
        content.append("\\end{tikzpicture}\n");
        content.append("\\end{center}");
        return content.toString();
    }

    private static String getKValues(int outcol, AnalyzerModel model) {
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < model.getTruthTable().getRowCount(); ++i) {
            int idx = AnalyzerTexWriter.reorderedIndex(model.getInputs().bits.size(), i);
            content.append(model.getTruthTable().getOutputEntry(idx, outcol).getDescription());
        }
        return content.toString();
    }

    private static String getKarnaugh(String name, boolean lined, int outcol, AnalyzerModel model) {
        StringBuilder content = new StringBuilder();
        content.append("\\begin{center}\n");
        content.append(K_INTRO).append(lined ? "" : K_NUMBERED).append(K_SETUP).append("\n");
        content.append("\\karnaughmap{").append(AnalyzerTexWriter.nrOfInCols(model)).append("}{").append(name).append("}{").append(AnalyzerTexWriter.getKarnaughInputs(model)).append("}\n{").append(AnalyzerTexWriter.getKValues(outcol, model)).append("}{");
        if (!lined) {
            content.append(AnalyzerTexWriter.getNumberedHeader(name, model));
        }
        content.append("}\n");
        content.append("\\end{tikzpicture}\n");
        content.append("\\end{center}");
        return content.toString();
    }

    private static String getCovers(String name, AnalyzerModel model) {
        StringBuilder content = new StringBuilder();
        TruthTable table = model.getTruthTable();
        if (table.getInputColumnCount() > 6) {
            return content.toString();
        }
        KarnaughMapGroups groups = new KarnaughMapGroups(model);
        groups.setOutput(name);
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
        int idx = 0;
        int kmapRows = 1 << KarnaughMapPanel.ROW_VARS[table.getInputColumnCount()];
        for (KarnaughMapGroups.KMapGroupInfo group : groups.getCovers()) {
            for (KarnaughMapGroups.CoverInfo thiscover : group.getAreas()) {
                content.append("   \\node[grp={").append(CoverColor.COVER_COLOR.getColorName(group.getColor())).append("}");
                double width = (double)thiscover.getWidth() - 0.2;
                double height = (double)thiscover.getHeight() - 0.2;
                content.append("{").append(df.format(width)).append("}{").append(df.format(height)).append("}]");
                content.append("(n").append(idx++).append(") at");
                double y = (double)kmapRows - (double)thiscover.getHeight() / 2.0 - (double)thiscover.getRow();
                double x = (double)thiscover.getWidth() / 2.0 + (double)thiscover.getCol();
                content.append("(").append(df.format(x)).append(",").append(df.format(y)).append(") {};\n");
            }
        }
        return content.toString();
    }

    private static String getKarnaughGroups(String output, String name, boolean lined, int outcol, AnalyzerModel model) {
        StringBuilder content = new StringBuilder();
        content.append("\\begin{center}\n");
        content.append(K_INTRO).append(lined ? "" : K_NUMBERED).append(K_SETUP).append("\n");
        content.append("\\karnaughmap{").append(AnalyzerTexWriter.nrOfInCols(model)).append("}{").append(name).append("}{").append(AnalyzerTexWriter.getKarnaughInputs(model)).append("}\n{").append(AnalyzerTexWriter.getKValues(outcol, model)).append("}{");
        if (!lined) {
            content.append(AnalyzerTexWriter.getNumberedHeader(name, model));
        } else {
            content.append("\n");
        }
        content.append(AnalyzerTexWriter.getCovers(output, model));
        content.append("}\n");
        content.append("\\end{tikzpicture}\n");
        content.append("\\end{center}");
        return content.toString();
    }

    public static void doSave(File file, AnalyzerModel model) throws IOException {
        boolean linedStyle = AppPreferences.KMAP_LINED_STYLE.getBoolean();
        boolean modelIsUpdating = model.getOutputExpressions().updatesEnabled();
        model.getOutputExpressions().enableUpdates();
        try (PrintStream out = new PrintStream(file);){
            out.println("\\documentclass [15pt,a4paper,twoside]{article}");
            out.println("\\usepackage[" + Strings.S.get("latexBabelLanguage") + ",shorthands=off]{babel}        % shorhands=off is required for babel french in combination with tikz karnaugh....");
            out.println("\\usepackage[utf8x]{inputenc}");
            out.println("\\usepackage[T1]{fontenc}");
            out.println("\\usepackage{amsmath}");
            out.println("\\usepackage{geometry}");
            out.println("\\geometry{verbose,a4paper, tmargin=3.5cm,bmargin=3.5cm,lmargin=2.5cm,rmargin=2.5cm,headsep=1cm,footskip=1.5cm}");
            out.println("\\usepackage{fancyhdr}");
            out.println("\\usepackage{colortbl}");
            out.println("\\usepackage[dvipsnames]{xcolor}");
            out.println("\\usepackage{tikz -timing}");
            out.println("\\usepackage{tikz}");
            out.println("\\usetikzlibrary{karnaugh}");
            out.println("\\pagestyle{fancy}");
            out.println();
            CoverColor cols = CoverColor.COVER_COLOR;
            for (int i = 0; i < cols.nrOfColors(); ++i) {
                Color col = cols.getColor(i);
                out.println("\\definecolor{" + cols.getColorName(col) + "}{RGB}{" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "}");
            }
            out.println();
            out.println("\\fancyhead{}");
            out.println("\\fancyhead[C] {" + Strings.S.get("latexHeader", new Date()) + "}");
            out.println("\\fancyfoot[C] {\\thepage}");
            out.println("\\renewcommand{\\headrulewidth}{0.4pt}");
            out.println("\\renewcommand{\\footrulewidth}{0.4pt}");
            out.println();
            out.println("\\makeatother");
            out.println();
            out.println("\\begin{document}");
            out.println("\\section{" + Strings.S.get("latexIntroduction") + "}");
            out.println(Strings.S.get("latexIntroductionText"));
            if (model.getInputs().vars.isEmpty() || model.getOutputs().vars.isEmpty()) {
                out.println(SECTION_SEP);
                out.println("\\section{" + Strings.S.get("latexEmpty") + "}");
                out.println(Strings.S.get("latexEmptyText"));
            } else {
                out.println(SECTION_SEP);
                out.println("\\section{" + Strings.S.get("latexTruthTable") + "}");
                out.println(Strings.S.get("latexTruthTableText"));
                TruthTable tt = model.getTruthTable();
                if (tt.getRowCount() > 64) {
                    out.println(Strings.S.get("latexTruthTableToBig", 64));
                } else {
                    tt.compactVisibleRows();
                    out.println(SUB_SECTION_SEP);
                    out.println("\\subsection{" + Strings.S.get("latexTruthTableCompact") + "}");
                    out.println(AnalyzerTexWriter.truthTableHeader(model));
                    out.println(AnalyzerTexWriter.getCompactTruthTable(tt, model));
                    out.println("\\end{tabular}");
                    out.println("\\end{center}");
                    out.println(SUB_SECTION_SEP);
                    out.println("\\subsection{" + Strings.S.get("latexTruthTableComlete") + "}");
                    out.println(AnalyzerTexWriter.truthTableHeader(model));
                    out.println(AnalyzerTexWriter.getCompleteTruthTable(tt, model));
                    out.println("\\end{tabular}");
                    out.println("\\end{center}");
                }
                out.println(SECTION_SEP);
                out.println("\\section{" + Strings.S.get("latexKarnaugh") + "}");
                if (tt.getRowCount() > 64) {
                    out.println(Strings.S.get("latexKarnaughToBig", (int)Math.ceil(Math.log(64.0) / Math.log(2.0))));
                } else {
                    String func;
                    Var outp;
                    int i;
                    out.println(Strings.S.get("latexKarnaughText"));
                    out.println(SUB_SECTION_SEP);
                    out.println("\\subsection{" + Strings.S.get("latexKarnaughEmpty") + "}");
                    for (int i2 = 0; i2 < model.getOutputs().vars.size(); ++i2) {
                        Var outp2 = model.getOutputs().vars.get(i2);
                        if (outp2.width == 1) {
                            String func2 = "$" + outp2.name + "$";
                            out.println(AnalyzerTexWriter.getKarnaughEmpty(func2, linedStyle, model));
                            continue;
                        }
                        for (int idx = outp2.width - 1; idx >= 0; --idx) {
                            String func3 = "$" + outp2.name + "_{" + idx + "}$";
                            out.println(AnalyzerTexWriter.getKarnaughEmpty(func3, linedStyle, model));
                        }
                    }
                    out.println(SUB_SECTION_SEP);
                    out.println("\\subsection{" + Strings.S.get("latexKarnaughFilledIn") + "}");
                    int outcol = 0;
                    for (i = 0; i < model.getOutputs().vars.size(); ++i) {
                        outp = model.getOutputs().vars.get(i);
                        if (outp.width == 1) {
                            String func4 = "$" + outp.name + "$";
                            out.println(AnalyzerTexWriter.getKarnaugh(func4, linedStyle, outcol++, model));
                            continue;
                        }
                        for (int idx = outp.width - 1; idx >= 0; --idx) {
                            func = "$" + outp.name + "_{" + idx + "}$";
                            out.println(AnalyzerTexWriter.getKarnaugh(func, linedStyle, outcol++, model));
                        }
                    }
                    out.println(SUB_SECTION_SEP);
                    out.println("\\subsection{" + Strings.S.get("latexKarnaughFilledInGroups") + "}");
                    outcol = 0;
                    for (i = 0; i < model.getOutputs().vars.size(); ++i) {
                        outp = model.getOutputs().vars.get(i);
                        if (outp.width == 1) {
                            String func5 = "$" + outp.name + "$";
                            out.println(AnalyzerTexWriter.getKarnaughGroups(outp.name, func5, linedStyle, outcol++, model));
                            continue;
                        }
                        for (int idx = outp.width - 1; idx >= 0; --idx) {
                            func = "$" + outp.name + "_{" + idx + "}$";
                            out.println(AnalyzerTexWriter.getKarnaughGroups(outp.name + "[" + idx + "]", func, linedStyle, outcol++, model));
                        }
                    }
                    out.println(SECTION_SEP);
                    out.println("\\section{" + Strings.S.get("latexMinimal") + "}");
                    for (int o = 0; o < model.getTruthTable().getOutputVariables().size(); ++o) {
                        outp = model.getTruthTable().getOutputVariable(o);
                        if (outp.width == 1) {
                            Expression exp = Expressions.eq(Expressions.variable(outp.name), model.getOutputExpressions().getMinimalExpression(outp.name));
                            out.println(exp.toString(Expression.Notation.LATEX) + "~\\\\");
                            continue;
                        }
                        for (int idx = outp.width - 1; idx >= 0; --idx) {
                            String name = outp.bitName(idx);
                            Expression exp = Expressions.eq(Expressions.variable(name), model.getOutputExpressions().getMinimalExpression(name));
                            out.println(exp.toString(Expression.Notation.LATEX) + "~\\\\");
                        }
                    }
                }
            }
            out.println("\\end{document}");
        }
        if (!modelIsUpdating) {
            model.getOutputExpressions().disableUpdates();
        }
    }
}

