/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.file;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.file.TruthtableFileFilter;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Entry;
import com.cburch.logisim.analyze.model.TruthTable;
import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.analyze.model.VariableList;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.gui.generic.OptionPane;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class TruthtableTextFile {
    static final Pattern NAME_FORMAT = Pattern.compile("([a-zA-Z]\\w*)\\[(-?\\d+)\\.\\.(-?\\d+)]");
    public static final FileFilter FILE_FILTER = new TruthtableFileFilter(Strings.S.getter("tableTxtFileFilter"), ".txt");

    private static void center(PrintStream out, String s, int n) {
        int pad = n - s.length();
        if (pad <= 0) {
            out.printf("%s", s);
        } else {
            String left = pad / 2 > 0 ? "%" + pad / 2 + "s" : "%s";
            String right = pad - pad / 2 > 0 ? "%" + (pad - pad / 2) + "s" : "%s";
            out.printf(left + "%s" + right, "", s, "");
        }
    }

    public static void doSave(File file, AnalyzerModel model) throws IOException {
        try (PrintStream out = new PrintStream(file);){
            out.println(Strings.S.get("tableRemark1"));
            Circuit c = model.getCurrentCircuit();
            if (c != null) {
                out.println(Strings.S.get("tableRemark2", c.getName()));
            }
            out.println(Strings.S.get("tableRemark3", new Date()));
            out.println();
            out.println(Strings.S.get("tableRemark4"));
            out.println();
            VariableList inputs = model.getInputs();
            VariableList outputs = model.getOutputs();
            int[] colwidth = new int[inputs.vars.size() + outputs.vars.size()];
            int i = 0;
            for (Var variable : inputs.vars) {
                colwidth[i++] = Math.max(variable.toString().length(), variable.width);
            }
            for (Var variable : outputs.vars) {
                colwidth[i++] = Math.max(variable.toString().length(), variable.width);
            }
            i = 0;
            for (Var variable : inputs.vars) {
                TruthtableTextFile.center(out, variable.toString(), colwidth[i++]);
                out.print(" ");
            }
            out.print("|");
            for (Var variable : outputs.vars) {
                out.print(" ");
                TruthtableTextFile.center(out, variable.toString(), colwidth[i++]);
            }
            out.println();
            for (i = 0; i < colwidth.length; ++i) {
                for (int j = 0; j < colwidth[i] + 1; ++j) {
                    out.print("~");
                }
            }
            out.println("~");
            TruthTable table = model.getTruthTable();
            int rows = table.getVisibleRowCount();
            for (int row = 0; row < rows; ++row) {
                Entry val;
                int b;
                StringBuilder s;
                i = 0;
                int col = 0;
                for (Var variable : inputs.vars) {
                    s = new StringBuilder();
                    for (b = variable.width - 1; b >= 0; --b) {
                        val = table.getVisibleInputEntry(row, col++);
                        s.append(val.toBitString());
                    }
                    TruthtableTextFile.center(out, s.toString(), colwidth[i++]);
                    out.print(" ");
                }
                out.print("|");
                col = 0;
                for (Var variable : outputs.vars) {
                    s = new StringBuilder();
                    for (b = variable.width - 1; b >= 0; --b) {
                        val = table.getVisibleOutputEntry(row, col++);
                        s.append(val.toBitString());
                    }
                    out.print(" ");
                    TruthtableTextFile.center(out, s.toString(), colwidth[i++]);
                }
                out.println();
            }
        }
    }

    static void validateHeader(String line, VariableList inputs, VariableList outputs, int lineno) throws IOException {
        String[] s = line.split("\\s+");
        VariableList cur = inputs;
        for (String value : s) {
            int b;
            int a;
            if (value.equals("|")) {
                if (cur != inputs) {
                    throw new IOException(String.format("Line %d: Separator '|' must appear only once.", lineno));
                }
                cur = outputs;
                continue;
            }
            if (value.matches("[a-zA-Z]\\w*")) {
                cur.add(new Var(value, 1));
                continue;
            }
            Matcher m = NAME_FORMAT.matcher(value);
            if (!m.matches()) {
                throw new IOException(String.format("Line %d: Invalid variable name '%s'.", lineno, value));
            }
            String n = m.group(1);
            try {
                a = Integer.parseInt(m.group(2));
                b = Integer.parseInt(m.group(3));
            }
            catch (NumberFormatException e) {
                throw new IOException(String.format("Line %d: Invalid bit range in '%s'.", lineno, value));
            }
            if (a < 1 || b != 0) {
                throw new IOException(String.format("Line %d: Invalid bit range in '%s'.", lineno, value));
            }
            try {
                cur.add(new Var(n, a - b + 1));
            }
            catch (IllegalArgumentException e) {
                throw new IOException(String.format("Line %d: Too many bits in %s for truth table (max = %d bits).", lineno, cur == inputs ? "input" : "output", cur == inputs ? 20 : 256));
            }
        }
        if (inputs.vars.isEmpty()) {
            throw new IOException(String.format("Line %d: Truth table has no inputs.", lineno));
        }
        if (outputs.vars.isEmpty()) {
            throw new IOException(String.format("Line %d: Truth table has no outputs.", lineno));
        }
    }

    static Entry parseBit(char c, String val, int lineNumber) throws IOException {
        if (c == 'x' || c == 'X' || c == '-') {
            return Entry.DONT_CARE;
        }
        if (c == '0') {
            return Entry.ZERO;
        }
        if (c == '1') {
            return Entry.ONE;
        }
        throw new IOException(String.format("Line %d: Bit value '%c' in \"%s\" must be one of '0', '1', 'x', or '-'.", lineNumber, Character.valueOf(c), val));
    }

    static Entry parseHex(char c, int bit, int nbits, String sval, Var var, int lineno) throws IOException {
        if (c == 'x' || c == 'X' || c == '-') {
            return Entry.DONT_CARE;
        }
        int d = 0;
        if ('0' <= c && c <= '9') {
            d = c - 48;
        } else if ('a' <= c && c <= 'f') {
            d = 10 + (c - 97);
        } else if ('A' <= c && c <= 'F') {
            d = 10 + (c - 65);
        } else {
            throw new IOException(String.format("Line %d: Hex digit '%c' in \"%s\" must be one of '0'-'9', 'a'-'f' or 'x'.", lineno, Character.valueOf(c), sval));
        }
        if (nbits < 4 && d >= 1 << nbits) {
            throw new IOException(String.format("Line %d: Hex value \"%s\" contains too many bits for %s.", lineno, sval, var.name));
        }
        return (d & 1 << bit) == 0 ? Entry.ZERO : Entry.ONE;
    }

    static int parseVal(Entry[] row, int col, String sval, Var var, int lineno) throws IOException {
        if (sval.length() == var.width) {
            for (int i = 0; i < var.width; ++i) {
                row[col++] = TruthtableTextFile.parseBit(sval.charAt(i), sval, lineno);
            }
        } else if (sval.length() == (var.width + 3) / 4) {
            for (int i = 0; i < var.width; ++i) {
                row[col++] = TruthtableTextFile.parseHex(sval.charAt((i + (4 - var.width % 4) % 4) / 4), (var.width - i - 1) % 4, var.width - (var.width - i - 1) / 4 * 4, sval, var, lineno);
            }
        } else {
            throw new IOException(String.format("Line %d: Expected %d bits (or %d hex digits) in column %s, but found \"%s\".", lineno, var.width, (var.width + 3) / 4, var.name, sval));
        }
        return col;
    }

    static void validateRow(String line, VariableList inputs, VariableList outputs, ArrayList<Entry[]> rows, int lineno) throws IOException {
        Entry[] row = new Entry[inputs.bits.size() + outputs.bits.size()];
        int col = 0;
        String[] s = line.split("\\s+");
        int ix = 0;
        for (Var variable : inputs.vars) {
            if (ix >= s.length || s[ix].equals("|")) {
                throw new IOException(String.format("Line %d: Not enough input columns.", lineno));
            }
            col = TruthtableTextFile.parseVal(row, col, s[ix++], variable, lineno);
        }
        if (ix >= s.length) {
            throw new IOException(String.format("Line %d: Missing '|' column separator.", lineno));
        }
        if (!s[ix].equals("|")) {
            throw new IOException(String.format("Line %d: Too many input columns.", lineno));
        }
        ++ix;
        for (Var variable : outputs.vars) {
            if (ix >= s.length) {
                throw new IOException(String.format("Line %d: Not enough output columns.", lineno));
            }
            if (s[ix].equals("|")) {
                throw new IOException(String.format("Line %d: Column separator '|' must appear only once.", lineno));
            }
            col = TruthtableTextFile.parseVal(row, col, s[ix++], variable, lineno);
        }
        if (ix != s.length) {
            throw new IOException(String.format("Line %d: Too many output columns.", lineno));
        }
        rows.add(row);
    }

    public static void doLoad(File file, AnalyzerModel model, JFrame parent) throws IOException {
        int lineno = 0;
        try (Scanner sc = new Scanner(file);){
            VariableList inputs = new VariableList(20);
            VariableList outputs = new VariableList(256);
            ArrayList<Entry[]> rows = new ArrayList<Entry[]>();
            while (sc.hasNextLine()) {
                ++lineno;
                String line = sc.nextLine();
                int ix = line.indexOf(35);
                if (ix >= 0) {
                    line = line.substring(0, ix);
                }
                if ((line = line.trim()).equals("") || line.matches("\\s*[~_=-][ ~_=-|]*")) continue;
                if (inputs.vars.isEmpty()) {
                    TruthtableTextFile.validateHeader(line, inputs, outputs, lineno);
                    continue;
                }
                TruthtableTextFile.validateRow(line, inputs, outputs, rows, lineno);
            }
            if (rows.isEmpty()) {
                throw new IOException("End of file: Truth table has no rows.");
            }
            try {
                model.setVariables(inputs.vars, outputs.vars);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage());
            }
            TruthTable table = model.getTruthTable();
            try {
                table.setVisibleRows(rows, false);
            }
            catch (IllegalArgumentException e) {
                int confirm = OptionPane.showConfirmDialog(parent, new String[]{e.getMessage(), Strings.S.get("tableParseErrorMessage")}, Strings.S.get("tableParseErrorTitle"), 0);
                if (confirm != 0) {
                    sc.close();
                    return;
                }
                try {
                    table.setVisibleRows(rows, true);
                }
                catch (IllegalArgumentException ex) {
                    throw new IOException(ex.getMessage());
                }
            }
        }
    }
}

