/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.VariableList;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.file.LogisimFileActions;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectActions;
import com.cburch.logisim.proj.Projects;
import com.cburch.logisim.std.gates.CircuitBuilder;
import com.cburch.logisim.util.SyntaxChecker;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class BuildCircuitButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private final MyListener myListener = new MyListener();
    private final JFrame parent;
    private final AnalyzerModel model;

    BuildCircuitButton(JFrame parent, AnalyzerModel model) {
        this.parent = parent;
        this.model = model;
        this.addActionListener(this.myListener);
    }

    void localeChanged() {
        this.setText(Strings.S.get("buildCircuitButton"));
    }

    private void performAction(Project dest, String name, boolean replace, boolean twoInputs, boolean useNands) {
        if (replace) {
            Circuit circuit = dest.getLogisimFile().getCircuit(name);
            if (circuit == null) {
                OptionPane.showMessageDialog(this.parent, "Internal error prevents replacing circuit.", "Internal Error", 0);
                return;
            }
            CircuitMutation xn = CircuitBuilder.build(circuit, this.model, twoInputs, useNands);
            dest.doAction(xn.toAction(Strings.S.getter("replaceCircuitAction")));
        } else {
            if (dest == null) {
                dest = ProjectActions.doNew(dest);
            }
            Circuit circuit = new Circuit(name, dest.getLogisimFile(), dest);
            CircuitMutation xn = CircuitBuilder.build(circuit, this.model, twoInputs, useNands);
            xn.execute();
            dest.doAction(LogisimFileActions.addCircuit(circuit));
            dest.setCurrentCircuit(circuit);
        }
    }

    private class MyListener
    implements ActionListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Project dest = null;
            String name = null;
            boolean twoInputs = false;
            boolean useNands = false;
            boolean replace = false;
            if (!BuildCircuitButton.this.model.getOutputExpressions().hasExpressions()) {
                OptionPane.showMessageDialog(BuildCircuitButton.this.parent, Strings.S.get("zeroOrNotOptimizedMessage"), Strings.S.get("buildDialogTitle"), 0);
                return;
            }
            boolean ok = false;
            while (!ok) {
                DialogPanel dlog = new DialogPanel();
                int action = OptionPane.showConfirmDialog(BuildCircuitButton.this.parent, dlog, Strings.S.get("buildDialogTitle"), 2, 3);
                if (action != 0) {
                    return;
                }
                ProjectItem projectItem = (ProjectItem)dlog.project.getSelectedItem();
                if (projectItem == null) {
                    OptionPane.showMessageDialog(BuildCircuitButton.this.parent, Strings.S.get("buildNeedProjectError"), Strings.S.get("buildDialogErrorTitle"), 0);
                    continue;
                }
                dest = projectItem.project;
                name = dlog.name.getText().trim();
                if (name.equals("")) {
                    OptionPane.showMessageDialog(BuildCircuitButton.this.parent, Strings.S.get("buildNeedCircuitError"), Strings.S.get("buildDialogErrorTitle"), 0);
                    continue;
                }
                if (!SyntaxChecker.isVariableNameAcceptable(name, true)) continue;
                HashSet<String> labels = new HashSet<String>();
                for (String label : BuildCircuitButton.this.model.getInputs().getNames()) {
                    labels.add(label.toUpperCase());
                }
                for (String label : BuildCircuitButton.this.model.getOutputs().getNames()) {
                    labels.add(label.toUpperCase());
                }
                if (labels.contains(name.toUpperCase())) {
                    OptionPane.showMessageDialog(BuildCircuitButton.this.parent, Strings.S.get("buildDuplicatedNameError"), Strings.S.get("buildDialogErrorTitle"), 0);
                    continue;
                }
                if (dest != null) {
                    for (Circuit circ : dest.getLogisimFile().getCircuits()) {
                        if (!circ.getName().equalsIgnoreCase(name)) continue;
                        name = circ.getName();
                    }
                }
                if (dest != null && dest.getLogisimFile().getCircuit(name) != null) {
                    int choice = OptionPane.showConfirmDialog(BuildCircuitButton.this.parent, Strings.S.get("buildConfirmReplaceMessage", name), Strings.S.get("buildConfirmReplaceTitle"), 0);
                    if (choice != 0) continue;
                    replace = true;
                }
                twoInputs = dlog.twoInputs.isSelected();
                useNands = dlog.nands.isSelected();
                ok = true;
            }
            BuildCircuitButton.this.performAction(dest, name, replace, twoInputs, useNands);
        }
    }

    private static class ProjectItem {
        final Project project;

        ProjectItem(Project project) {
            this.project = project;
        }

        public String toString() {
            if (this.project == null) {
                return "< Create New Project >";
            }
            return this.project.getLogisimFile().getDisplayName();
        }
    }

    private class DialogPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JLabel projectLabel = new JLabel();
        private final JComboBox<Object> project;
        private final JLabel nameLabel = new JLabel();
        private final JTextField name = new JTextField(10);
        private final JCheckBox twoInputs = new JCheckBox();
        private final JCheckBox nands = new JCheckBox();

        DialogPanel() {
            List<Project> projects = Projects.getOpenProjects();
            Object[] options = new Object[projects.size() + 1];
            Object initialSelection = null;
            options[0] = new ProjectItem(null);
            for (int i = 1; i < options.length; ++i) {
                Project proj = projects.get(i - 1);
                options[i] = new ProjectItem(proj);
                if (proj != BuildCircuitButton.this.model.getCurrentProject()) continue;
                initialSelection = options[i];
            }
            this.project = new JComboBox<Object>(options);
            if (options.length == 1) {
                this.project.setSelectedItem(options[0]);
                this.project.setEnabled(false);
            } else if (initialSelection != null) {
                this.project.setSelectedItem(initialSelection);
            } else {
                this.project.setSelectedItem(options[options.length - 1]);
            }
            Circuit defaultCircuit = BuildCircuitButton.this.model.getCurrentCircuit();
            if (defaultCircuit != null) {
                this.name.setText(defaultCircuit.getName());
                this.name.selectAll();
            }
            VariableList outputs = BuildCircuitButton.this.model.getOutputs();
            boolean enableNands = true;
            for (String output : outputs.bits) {
                Expression expr = BuildCircuitButton.this.model.getOutputExpressions().getExpression(output);
                if (expr == null || !expr.contains(Expression.Op.XOR) && !expr.contains(Expression.Op.EQ)) continue;
                enableNands = false;
                break;
            }
            this.nands.setEnabled(enableNands);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints gc = new GridBagConstraints();
            this.setLayout(gb);
            gc.anchor = 21;
            gc.fill = 0;
            gc.gridx = 0;
            gc.gridy = 0;
            gb.setConstraints(this.projectLabel, gc);
            this.add(this.projectLabel);
            gc.gridx = 1;
            gb.setConstraints(this.project, gc);
            this.add(this.project);
            ++gc.gridy;
            gc.gridx = 0;
            gb.setConstraints(this.nameLabel, gc);
            this.add(this.nameLabel);
            gc.gridx = 1;
            gb.setConstraints(this.name, gc);
            this.add(this.name);
            ++gc.gridy;
            gb.setConstraints(this.twoInputs, gc);
            this.add(this.twoInputs);
            ++gc.gridy;
            gb.setConstraints(this.nands, gc);
            this.add(this.nands);
            this.projectLabel.setText(Strings.S.get("buildProjectLabel"));
            this.nameLabel.setText(Strings.S.get("buildNameLabel"));
            this.twoInputs.setText(Strings.S.get("buildTwoInputsLabel"));
            this.nands.setText(Strings.S.get("buildNandsLabel"));
        }
    }
}

