/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.data.CsvInterpretor;
import com.cburch.logisim.analyze.data.CsvParameter;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class CsvReadParameterDialog
extends JDialog
implements ActionListener {
    private final JComboBox<String> quotes;
    private final JComboBox<String> seperators;
    private final JButton okButton;
    private final JLabel[] labels;
    private final File file;
    private static final long serialVersionUID = 1L;
    private final CsvParameter param;
    private final String sepSpace;
    private boolean setVisible = true;

    public CsvReadParameterDialog(CsvParameter sel, File file, JFrame parentFrame) {
        super(parentFrame);
        this.file = file;
        this.sepSpace = Strings.S.get("seperatorSpace");
        String[] possibleSeperators = new String[]{",", ";", ":", this.sepSpace, Strings.S.get("SeperatorTab")};
        String[] possibleQuotes = new String[]{"\"", "'"};
        this.okButton = new JButton(Strings.S.get("ConfirmCsvParameters"));
        this.okButton.addActionListener(this);
        this.quotes = new JComboBox<String>(possibleQuotes);
        this.quotes.addActionListener(this);
        this.seperators = new JComboBox<String>(possibleSeperators);
        this.seperators.addActionListener(this);
        this.setLocationRelativeTo(parentFrame);
        this.param = sel;
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gb);
        c.gridy = 0;
        c.gridx = 0;
        c.fill = 2;
        c.gridwidth = 3;
        this.add((Component)new JLabel(Strings.S.get("UsedQuotesInFile")), c);
        c.gridx = 3;
        c.gridwidth = 1;
        this.add(this.quotes, c);
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 3;
        this.add((Component)new JLabel(Strings.S.get("UsedSeperatorInFile")), c);
        c.gridx = 3;
        c.gridwidth = 1;
        this.add(this.seperators, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 4;
        c.fill = 10;
        this.add((Component)new JLabel(Strings.S.get("cvsFilePreview")), c);
        this.pack();
        int celwidth = AppPreferences.getScaled(200);
        int celHeight = AppPreferences.getScaled(25);
        c.gridwidth = 1;
        this.labels = new JLabel[16];
        Border border = BorderFactory.createLineBorder(Color.BLACK, AppPreferences.getScaled(1));
        Dimension dim = new Dimension(celwidth, celHeight);
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                JPanel j = new JPanel();
                this.labels[y * 4 + x] = new JLabel(x + "," + y);
                j.setBorder(border);
                j.setBackground(Color.WHITE);
                j.setPreferredSize(dim);
                j.add(this.labels[y * 4 + x]);
                c.gridx = x;
                c.gridy = 3 + y;
                this.add((Component)j, c);
            }
        }
        c.gridwidth = 4;
        c.gridy = 7;
        c.gridx = 0;
        this.add((Component)this.okButton, c);
        this.pack();
        this.updateLabels();
        this.setModal(true);
        this.setVisible(this.setVisible);
    }

    private void updateLabels() {
        block6: {
            try {
                Scanner scan = new Scanner(this.file);
                for (int y = 0; y < 4; ++y) {
                    List<String> line = null;
                    if (scan.hasNext()) {
                        line = CsvInterpretor.parseCsvLine(scan.next(), this.param.seperator(), this.param.quote());
                    }
                    for (int x = 0; x < 4; ++x) {
                        if (line == null || x >= line.size()) {
                            this.labels[y * 4 + x].setText("");
                            continue;
                        }
                        this.labels[y * 4 + x].setText(line.get(x));
                    }
                }
                scan.close();
            }
            catch (FileNotFoundException e) {
                OptionPane.showMessageDialog(this, Strings.S.get("cantReadMessage", this.file.getName()), Strings.S.get("openButton"), 0);
                this.setVisible = false;
                if (!this.isVisible()) break block6;
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String sel;
        if (this.param == null) {
            return;
        }
        if (e.getSource() == this.quotes) {
            sel = (String)this.quotes.getSelectedItem();
            this.param.setQuote(sel.charAt(0));
            this.updateLabels();
        }
        if (e.getSource() == this.seperators) {
            sel = (String)this.seperators.getSelectedItem();
            if (sel.length() == 1) {
                this.param.setSeperator(sel.charAt(0));
            } else if (sel.equals(this.sepSpace)) {
                this.param.setSeperator(' ');
            } else {
                this.param.setSeperator('\t');
            }
            this.updateLabels();
        }
        if (e.getSource() == this.okButton) {
            this.param.setValid();
            this.setVisible(false);
            this.dispose();
        }
    }
}

