/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.gui.AnalyzerTab;
import com.cburch.logisim.analyze.gui.ExpressionView;
import com.cburch.logisim.analyze.gui.MinimizedTab;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.analyze.model.OutputExpressionsEvent;
import com.cburch.logisim.analyze.model.OutputExpressionsListener;
import com.cburch.logisim.analyze.model.Parser;
import com.cburch.logisim.analyze.model.ParserException;
import com.cburch.logisim.analyze.model.VariableList;
import com.cburch.logisim.analyze.model.VariableListEvent;
import com.cburch.logisim.analyze.model.VariableListListener;
import com.cburch.logisim.gui.menu.EditHandler;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.LogisimMenuItem;
import com.cburch.logisim.gui.menu.PrintHandler;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.StringGetter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.jdesktop.swingx.prompt.BuddySupport;

class ExpressionTab
extends AnalyzerTab {
    private static final long serialVersionUID = 1L;
    private final AnalyzerModel model;
    private StringGetter errorMessage;
    private final ExpressionTableModel tableModel;
    private final JTable table = new JTable(1, 1);
    private final JLabel error = new JLabel();
    private final JComboBox notationChoice = new JComboBox(new MinimizedTab.NotationModel());
    private final JLabel notationLabel = new JLabel();
    private final JLabel infoLabel = new JLabel();
    private Expression.Notation notation = Expression.Notation.MATHEMATICAL;
    private final MyListener myListener = new MyListener();
    private final ExpressionView prettyView = new ExpressionView();
    final EditHandler editHandler = new EditHandler(){

        @Override
        public void computeEnabled() {
            boolean viewing = ExpressionTab.this.table.getSelectedRow() >= 0;
            boolean editing = ExpressionTab.this.table.isEditing();
            this.setEnabled(LogisimMenuBar.CUT, editing);
            this.setEnabled(LogisimMenuBar.COPY, viewing);
            this.setEnabled(LogisimMenuBar.PASTE, viewing);
            this.setEnabled(LogisimMenuBar.DELETE, editing);
            this.setEnabled(LogisimMenuBar.DUPLICATE, false);
            this.setEnabled(LogisimMenuBar.SELECT_ALL, editing);
            this.setEnabled(LogisimMenuBar.RAISE, false);
            this.setEnabled(LogisimMenuBar.LOWER, false);
            this.setEnabled(LogisimMenuBar.RAISE_TOP, false);
            this.setEnabled(LogisimMenuBar.LOWER_BOTTOM, false);
            this.setEnabled(LogisimMenuBar.ADD_CONTROL, false);
            this.setEnabled(LogisimMenuBar.REMOVE_CONTROL, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object action = e.getSource();
            if (ExpressionTab.this.table.getSelectedRow() < 0) {
                return;
            }
            ExpressionTab.this.table.getActionMap().get(action).actionPerformed(e);
        }
    };
    final PrintHandler printHandler = new PrintHandler(){

        @Override
        public Dimension getExportImageSize() {
            int width = ExpressionTab.this.table.getWidth();
            int height = 14;
            int n = ExpressionTab.this.table.getRowCount();
            for (int i = 0; i < n; ++i) {
                ExpressionView.NamedExpression ne = (ExpressionView.NamedExpression)ExpressionTab.this.table.getValueAt(i, 0);
                ExpressionTab.this.prettyView.setWidth(width);
                ExpressionTab.this.prettyView.setExpression(ne);
                height += ExpressionTab.this.prettyView.getExpressionHeight() + 14;
            }
            return new Dimension(width + 6, height);
        }

        @Override
        public void paintExportImage(BufferedImage img, Graphics2D g) {
            int width = img.getWidth();
            int height = img.getHeight();
            g.setClip(0, 0, width, height);
            g.translate(3, 14);
            int n = ExpressionTab.this.table.getRowCount();
            for (int i = 0; i < n; ++i) {
                ExpressionView.NamedExpression ne = (ExpressionView.NamedExpression)ExpressionTab.this.table.getValueAt(i, 0);
                ExpressionTab.this.prettyView.setForeground(Color.BLACK);
                ExpressionTab.this.prettyView.setBackground(Color.WHITE);
                ExpressionTab.this.prettyView.setWidth(width - 6);
                ExpressionTab.this.prettyView.setExpression(ne);
                int rh = ExpressionTab.this.prettyView.getExpressionHeight();
                ExpressionTab.this.prettyView.setSize(new Dimension(width - 6, rh));
                ExpressionTab.this.prettyView.paintComponent(g);
                g.translate(0, rh + 14);
            }
        }

        @Override
        public int print(Graphics2D g, PageFormat pf, int pageNum, double w, double h) {
            int width = (int)Math.ceil(w);
            g.translate(3, 7);
            int n = ExpressionTab.this.table.getRowCount();
            int y = 0;
            int pg = 0;
            for (int i = 0; i < n; ++i) {
                ExpressionView.NamedExpression ne = (ExpressionView.NamedExpression)ExpressionTab.this.table.getValueAt(i, 0);
                ExpressionTab.this.prettyView.setWidth(width - 6);
                ExpressionTab.this.prettyView.setForeground(Color.BLACK);
                ExpressionTab.this.prettyView.setBackground(Color.WHITE);
                ExpressionTab.this.prettyView.setExpression(ne);
                int rh = ExpressionTab.this.prettyView.getExpressionHeight();
                if (y > 0 && (double)(y + rh) > h) {
                    y = 0;
                    if (++pg > pageNum) {
                        return 0;
                    }
                }
                if (pg == pageNum) {
                    ExpressionTab.this.prettyView.setSize(new Dimension(width - 6, rh));
                    ExpressionTab.this.prettyView.paintComponent(g);
                    g.translate(0, rh + 14);
                }
                y += rh + 14;
            }
            return pg < pageNum ? 1 : 0;
        }
    };

    public ExpressionTab(AnalyzerModel model, LogisimMenuBar menubar) {
        this.localeChanged();
        this.model = model;
        this.tableModel = new ExpressionTableModel();
        this.table.setModel(this.tableModel);
        this.table.setShowGrid(false);
        this.table.setTableHeader(null);
        this.table.setDefaultRenderer(ExpressionView.NamedExpression.class, new ExpressionTableCellRenderer());
        this.table.setDefaultEditor(ExpressionView.NamedExpression.class, new ExpressionEditor());
        this.table.setDragEnabled(true);
        ExpressionTransferHandler ccp = new ExpressionTransferHandler();
        this.table.setTransferHandler(ccp);
        this.table.setDropMode(DropMode.ON);
        InputMap inputMap = this.table.getInputMap();
        for (LogisimMenuItem item : LogisimMenuBar.EDIT_ITEMS) {
            KeyStroke accel = menubar.getAccelerator(item);
            inputMap.put(accel, item);
        }
        ActionMap actionMap = this.table.getActionMap();
        actionMap.put(LogisimMenuBar.COPY, TransferHandler.getCopyAction());
        actionMap.put(LogisimMenuBar.PASTE, TransferHandler.getPasteAction());
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        this.setLayout(gb);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = -1;
        gc.weighty = 0.0;
        gc.fill = 1;
        JPanel control = this.control();
        gb.setConstraints(control, gc);
        this.add(control);
        gc.fill = 2;
        gb.setConstraints(this.infoLabel, gc);
        this.add(this.infoLabel);
        JScrollPane scroll = new JScrollPane(this.table, 22, 31);
        scroll.setPreferredSize(new Dimension(AppPreferences.getScaled(60), AppPreferences.getScaled(100)));
        gc.weighty = 1.0;
        gc.fill = 1;
        gb.setConstraints(scroll, gc);
        this.add(scroll);
        gc.weighty = 0.0;
        gc.fill = 2;
        gb.setConstraints(this.error, gc);
        this.add(this.error);
        FocusListener f = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                ExpressionTab.this.editHandler.computeEnabled();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                ExpressionTab.this.editHandler.computeEnabled();
            }
        };
        this.addFocusListener(f);
        this.table.addFocusListener(f);
        this.setError(null);
    }

    private JPanel control() {
        JPanel control = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        control.setLayout(gb);
        gc.weightx = 1.0;
        gc.gridwidth = 1;
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 3;
        gc.anchor = 13;
        gc.insets = new Insets(3, 10, 3, 10);
        gb.setConstraints(this.notationLabel, gc);
        control.add(this.notationLabel);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.anchor = 17;
        gb.setConstraints(this.notationChoice, gc);
        control.add(this.notationChoice);
        this.notationChoice.addItemListener(this.myListener);
        return control;
    }

    @Override
    void localeChanged() {
        if (this.errorMessage != null) {
            this.error.setText(this.errorMessage.toString());
        }
        this.infoLabel.setText(Strings.S.get("outputExpressionEdit"));
        this.notationLabel.setText(Strings.S.get("ExpressionNotation"));
    }

    private void setError(StringGetter msg) {
        if (msg == null) {
            this.errorMessage = null;
            this.error.setText(" ");
        } else {
            this.errorMessage = msg;
            this.error.setText(msg.toString());
        }
    }

    @Override
    void updateTab() {
        this.tableModel.update();
    }

    @Override
    EditHandler getEditHandler() {
        return this.editHandler;
    }

    @Override
    PrintHandler getPrintHandler() {
        return this.printHandler;
    }

    private class MyListener
    implements ItemListener {
        private MyListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            Expression.Notation not;
            if (event.getSource() == ExpressionTab.this.notationChoice && (not = Expression.Notation.values()[ExpressionTab.this.notationChoice.getSelectedIndex()]) != ExpressionTab.this.notation) {
                ExpressionTab.this.notation = not;
                ExpressionTab.this.tableModel.fireTableStructureChanged();
            }
        }
    }

    public class ExpressionTableModel
    extends AbstractTableModel
    implements VariableListListener,
    OutputExpressionsListener {
        private static final long serialVersionUID = 1L;
        ExpressionView.NamedExpression[] listCopy;

        public ExpressionTableModel() {
            this.updateCopy();
            ExpressionTab.this.model.getOutputs().addVariableListListener(this);
            ExpressionTab.this.model.getOutputExpressions().addOutputExpressionsListener(this);
        }

        @Override
        public void fireTableChanged(TableModelEvent event) {
            Object[] list = this.listenerList.getListenerList();
            for (int index = 0; index < list.length; index += 2) {
                TableModelListener listener = (TableModelListener)list[index + 1];
                listener.tableChanged(event);
            }
        }

        @Override
        public void setValueAt(Object obj, int row, int column) {
            ExpressionView.NamedExpression ne = this.listCopy[row];
            if (!(obj instanceof ExpressionView.NamedExpression)) {
                return;
            }
            ExpressionView.NamedExpression e = (ExpressionView.NamedExpression)obj;
            if (ne != e && !ne.name.equals(e.name)) {
                return;
            }
            this.listCopy[row] = e;
            if (e.expr != null) {
                ExpressionTab.this.model.getOutputExpressions().setExpression(e.name, e.expr, e.exprString);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.listCopy[row];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return ExpressionView.NamedExpression.class;
        }

        @Override
        public int getRowCount() {
            return this.listCopy.length;
        }

        @Override
        public void expressionChanged(OutputExpressionsEvent event) {
            if (event.getType() == 1) {
                String name = event.getVariable();
                int idx = -1;
                for (ExpressionView.NamedExpression e : this.listCopy) {
                    ++idx;
                    if (!e.name.equals(name)) continue;
                    try {
                        e.expr = ExpressionTab.this.model.getOutputExpressions().getExpression(name);
                        e.err = null;
                    }
                    catch (Exception ex) {
                        e.expr = null;
                        e.err = ex.getMessage();
                    }
                    this.fireTableRowsUpdated(idx, idx);
                    break;
                }
            }
        }

        @Override
        public void listChanged(VariableListEvent event) {
            this.updateCopy();
            Integer idx = event.getIndex();
            switch (event.getType()) {
                case 0: 
                case 3: {
                    this.fireTableDataChanged();
                    return;
                }
                case 1: {
                    this.fireTableRowsInserted(idx, idx);
                    return;
                }
                case 2: {
                    this.fireTableRowsDeleted(idx, idx);
                    return;
                }
                case 4: {
                    this.fireTableRowsUpdated(idx, idx);
                    return;
                }
            }
        }

        void update() {
            this.updateCopy();
            this.fireTableDataChanged();
        }

        void updateCopy() {
            VariableList outputs = ExpressionTab.this.model.getOutputs();
            int n = outputs.bits.size();
            this.listCopy = new ExpressionView.NamedExpression[n];
            int i = -1;
            for (String name : outputs.bits) {
                this.listCopy[++i] = new ExpressionView.NamedExpression(name);
                try {
                    this.listCopy[i].expr = ExpressionTab.this.model.getOutputExpressions().getExpression(name);
                    this.listCopy[i].err = null;
                }
                catch (Exception e) {
                    this.listCopy[i].err = e.getMessage();
                }
            }
        }
    }

    public class ExpressionTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color bg;
            Color fg;
            if (isSelected) {
                fg = table.getSelectionForeground();
                bg = table.getSelectionBackground();
            } else {
                fg = table.getForeground();
                bg = table.getBackground();
            }
            ExpressionTab.this.prettyView.setWidth(table.getColumnModel().getColumn(0).getWidth());
            ExpressionTab.this.prettyView.setExpression((ExpressionView.NamedExpression)value);
            ExpressionTab.this.prettyView.setForeground(fg);
            ExpressionTab.this.prettyView.setBackground(bg);
            int h = ExpressionTab.this.prettyView.getExpressionHeight();
            ExpressionTab.this.prettyView.setNotation(ExpressionTab.this.notation);
            if (table.getRowHeight(row) != h) {
                table.setRowHeight(row, h);
            }
            return ExpressionTab.this.prettyView;
        }
    }

    public class ExpressionEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        final JTextField field = new JTextField();
        final JLabel label = new JLabel();
        ExpressionView.NamedExpression oldExpr;
        ExpressionView.NamedExpression newExpr;

        public ExpressionEditor() {
            this.field.setBorder(BorderFactory.createCompoundBorder(this.field.getBorder(), BorderFactory.createEmptyBorder(1, 3, 1, 3)));
            BuddySupport.addLeft(this.label, this.field);
        }

        @Override
        public Object getCellEditorValue() {
            return this.newExpr;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.oldExpr = (ExpressionView.NamedExpression)value;
            this.label.setText(" " + Expressions.variable(this.oldExpr.name) + " = ");
            this.field.setText(this.oldExpr.expr != null ? this.oldExpr.expr.toString() : "");
            return this.field;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.ok()) {
                super.stopCellEditing();
                this.oldExpr = null;
                return true;
            }
            return false;
        }

        boolean ok() {
            String exprString = this.field.getText();
            try {
                Expression expr = Parser.parse(exprString, ExpressionTab.this.model);
                ExpressionTab.this.setError(null);
                this.newExpr = new ExpressionView.NamedExpression(this.oldExpr.name, expr, exprString);
                return true;
            }
            catch (ParserException ex) {
                ExpressionTab.this.setError(ex.getMessageGetter());
                this.field.setCaretPosition(ex.getOffset());
                this.field.moveCaretPosition(ex.getEndOffset());
                this.newExpr = null;
                return false;
            }
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                return me.getClickCount() >= 2;
            }
            if (e instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)e;
                return ke.getKeyCode() == 113 || ke.getKeyCode() == 10;
            }
            return false;
        }
    }

    private class ExpressionTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        private ExpressionTransferHandler() {
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            Expression expr;
            String s;
            try {
                s = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                ExpressionTab.this.setError(Strings.S.getter("cantImportFormatError"));
                return false;
            }
            try {
                expr = Parser.parseMaybeAssignment(s, ExpressionTab.this.model);
                ExpressionTab.this.setError(null);
            }
            catch (ParserException ex) {
                ExpressionTab.this.setError(ex.getMessageGetter());
                return false;
            }
            if (expr == null) {
                return false;
            }
            int idx = -1;
            if (ExpressionTab.this.table.getRowCount() == 0) {
                return false;
            }
            if (ExpressionTab.this.table.getRowCount() == 1) {
                idx = 0;
            } else if (info.isDrop()) {
                try {
                    JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
                    idx = dl.getRow();
                }
                catch (ClassCastException dl) {}
            } else {
                idx = ExpressionTab.this.table.getSelectedRow();
                if (idx < 0 && Expression.isAssignment(expr)) {
                    String v = Expression.getAssignmentVariable(expr);
                    for (idx = ExpressionTab.this.table.getRowCount() - 1; idx >= 0; --idx) {
                        ExpressionView.NamedExpression ne = (ExpressionView.NamedExpression)ExpressionTab.this.table.getValueAt(idx, 0);
                        if (v.equals(ne.name)) break;
                    }
                }
            }
            if (idx < 0 || idx >= ExpressionTab.this.table.getRowCount()) {
                return false;
            }
            if (Expression.isAssignment(expr)) {
                expr = Expression.getAssignmentExpression(expr);
            }
            ExpressionView.NamedExpression ne = (ExpressionView.NamedExpression)ExpressionTab.this.table.getValueAt(idx, 0);
            ne.exprString = s;
            ne.expr = expr;
            ne.err = null;
            ExpressionTab.this.table.setValueAt(ne, idx, 0);
            return true;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            int idx = ExpressionTab.this.table.getSelectedRow();
            if (idx < 0) {
                return null;
            }
            ExpressionView.NamedExpression ne = (ExpressionView.NamedExpression)ExpressionTab.this.table.getValueAt(idx, 0);
            String s = ne.expr != null ? ne.expr.toString(ExpressionTab.this.notation) : ne.err;
            return s == null ? null : new StringSelection(ne.name + " = " + s);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected void exportDone(JComponent c, Transferable tdata, int action) {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return ExpressionTab.this.table.getRowCount() > 0 && support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }
    }
}

