/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.gui.generic.OptionPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

public class MinimizeButton
extends JButton {
    private final JFrame parent;
    private final AnalyzerModel model;
    private final int format;

    public MinimizeButton(JFrame parent, AnalyzerModel model, int format) {
        this.parent = parent;
        this.model = model;
        this.format = format;
        this.addActionListener(event -> this.doOptimize());
    }

    void doOptimize() {
        int choice = OptionPane.showConfirmDialog(this.parent, Strings.S.get("OptimizeLongTimeWarning"), Strings.S.get("minimizeFunctionTitle"), 0);
        if (choice != 0) {
            return;
        }
        final JTextArea info = new JTextArea(20, 80);
        info.setEditable(false);
        info.setFont(new Font("monospaced", 0, 12));
        info.setForeground(Color.WHITE);
        info.setBackground(Color.BLACK);
        DefaultCaret caret = (DefaultCaret)info.getCaret();
        caret.setUpdatePolicy(2);
        JScrollPane pane = new JScrollPane(info);
        pane.setVerticalScrollBarPolicy(20);
        pane.setHorizontalScrollBarPolicy(30);
        final JButton doneButton = new JButton(Strings.S.get("minimizeDone"));
        final JDialog infoPanel = new JDialog(this.parent, Strings.S.get("minimizeFunctionTitle"), true);
        infoPanel.setDefaultCloseOperation(0);
        infoPanel.add((Component)pane, "Center");
        infoPanel.add((Component)doneButton, "South");
        doneButton.setVisible(false);
        infoPanel.setLocationRelativeTo(this.parent);
        infoPanel.pack();
        Thread dialogThread = new Thread(new Runnable(){

            void done() {
                infoPanel.dispose();
            }

            @Override
            public void run() {
                doneButton.addActionListener(Event2 -> this.done());
                infoPanel.setVisible(true);
            }
        });
        dialogThread.start();
        Thread optimizeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                MinimizeButton.this.model.getOutputExpressions().forcedOptimize(info, MinimizeButton.this.format);
                doneButton.setVisible(true);
            }
        });
        optimizeThread.start();
    }
}

