/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.data.ExpressionRenderData;
import com.cburch.logisim.analyze.gui.Analyzer;
import com.cburch.logisim.analyze.gui.AnalyzerTab;
import com.cburch.logisim.analyze.gui.ExpressionView;
import com.cburch.logisim.analyze.gui.KarnaughMapPanel;
import com.cburch.logisim.analyze.gui.OutputSelector;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.OutputExpressions;
import com.cburch.logisim.analyze.model.OutputExpressionsEvent;
import com.cburch.logisim.analyze.model.OutputExpressionsListener;
import com.cburch.logisim.gui.menu.EditHandler;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.LogisimMenuItem;
import com.cburch.logisim.gui.menu.PrintHandler;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;

class MinimizedTab
extends AnalyzerTab {
    private static final long serialVersionUID = 1L;
    private final OutputSelector selector;
    private final KarnaughMapPanel karnaughMap;
    private final JLabel formatLabel = new JLabel();
    private final JLabel styleLabel = new JLabel();
    private final JLabel notationLabel = new JLabel();
    private final JComboBox formatChoice = new JComboBox(new FormatModel());
    private final JComboBox formatStyle = new JComboBox(new StyleModel());
    private final JComboBox notationChoice = new JComboBox(new NotationModel());
    private final ExpressionView minimizedExpr = new ExpressionView();
    private final JButton setAsExpr = new JButton();
    private final MyListener myListener = new MyListener();
    private final AnalyzerModel model;
    private final OutputExpressions outputExprs;
    final EditHandler editHandler = new EditHandler(){

        @Override
        public void computeEnabled() {
            boolean viewing = MinimizedTab.this.minimizedExpr.isFocusOwner() || MinimizedTab.this.karnaughMap.isFocusOwner();
            this.setEnabled(LogisimMenuBar.CUT, false);
            this.setEnabled(LogisimMenuBar.COPY, viewing);
            this.setEnabled(LogisimMenuBar.PASTE, false);
            this.setEnabled(LogisimMenuBar.DELETE, false);
            this.setEnabled(LogisimMenuBar.DUPLICATE, false);
            this.setEnabled(LogisimMenuBar.SELECT_ALL, false);
            this.setEnabled(LogisimMenuBar.RAISE, false);
            this.setEnabled(LogisimMenuBar.LOWER, false);
            this.setEnabled(LogisimMenuBar.RAISE_TOP, false);
            this.setEnabled(LogisimMenuBar.LOWER_BOTTOM, false);
            this.setEnabled(LogisimMenuBar.ADD_CONTROL, false);
            this.setEnabled(LogisimMenuBar.REMOVE_CONTROL, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object action = e.getSource();
            if (MinimizedTab.this.minimizedExpr.isSelected()) {
                MinimizedTab.this.minimizedExpr.getActionMap().get(action).actionPerformed(e);
            } else if (MinimizedTab.this.karnaughMap.isSelected()) {
                MinimizedTab.this.karnaughMap.getActionMap().get(action).actionPerformed(e);
            }
        }
    };
    final PrintHandler printHandler = new PrintHandler(){

        @Override
        public Dimension getExportImageSize() {
            int kWidth = MinimizedTab.this.karnaughMap.getKMapDim().width;
            int kHeight = MinimizedTab.this.karnaughMap.getKMapDim().height;
            int eWidth = MinimizedTab.this.minimizedExpr.getRenderData().getPreferredSize().width;
            int eHeight = MinimizedTab.this.minimizedExpr.getRenderData().getPreferredSize().height;
            int width = Math.max(kWidth, eWidth);
            int height = kHeight + 30 + eHeight;
            return new Dimension(width, height);
        }

        @Override
        public void paintExportImage(BufferedImage img, Graphics2D g) {
            int width = img.getWidth();
            int height = img.getHeight();
            g.setClip(0, 0, width, height);
            this.doPrint(g, width);
        }

        @Override
        public int print(Graphics2D g, PageFormat pf, int pageNum, double width, double height) {
            if (pageNum != 0) {
                return 1;
            }
            return this.doPrint(g, width);
        }

        private int doPrint(Graphics2D g, double width) {
            AffineTransform xform = g.getTransform();
            g.translate((width - (double)MinimizedTab.this.karnaughMap.getWidth()) / 2.0, 0.0);
            g.setColor(Color.BLACK);
            MinimizedTab.this.karnaughMap.paintKmap(g, false);
            g.setTransform(xform);
            ExpressionRenderData prettyView = MinimizedTab.this.minimizedExpr.getRenderData();
            g.translate((width - (double)prettyView.getWidth()) / 2.0, (double)(MinimizedTab.this.karnaughMap.getKMapDim().height + 30));
            g.setColor(Color.BLACK);
            prettyView.paint(g, 0, 0);
            return 0;
        }
    };

    public MinimizedTab(AnalyzerModel model, LogisimMenuBar menubar) {
        this.model = model;
        this.outputExprs = model.getOutputExpressions();
        this.outputExprs.addOutputExpressionsListener(this.myListener);
        this.selector = new OutputSelector(model);
        this.selector.addItemListener(this.myListener);
        this.karnaughMap = new KarnaughMapPanel(model, this.minimizedExpr);
        this.setAsExpr.addActionListener(this.myListener);
        this.formatChoice.addItemListener(this.myListener);
        this.formatStyle.addItemListener(this.myListener);
        this.notationChoice.addItemListener(this.myListener);
        JPanel buttons = new JPanel(new GridLayout(1, 1));
        buttons.add(this.setAsExpr);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        this.setLayout(gb);
        gc.weightx = 1.0;
        gc.gridwidth = 1;
        gc.gridy = -1;
        gc.gridx = 0;
        gc.fill = 0;
        gc.anchor = 10;
        JPanel cntrl = this.control();
        gb.setConstraints(cntrl, gc);
        this.add(cntrl);
        gb.setConstraints(this.karnaughMap, gc);
        this.add(this.karnaughMap);
        Insets oldInsets = gc.insets;
        gc.insets = new Insets(20, 0, 20, 0);
        gc.fill = 1;
        gb.setConstraints(this.minimizedExpr, gc);
        this.add(this.minimizedExpr);
        gc.insets = oldInsets;
        gc.fill = 0;
        gb.setConstraints(buttons, gc);
        this.add(buttons);
        String selected = this.selector.getSelectedOutput();
        this.setAsExpr.setEnabled(selected != null && !this.outputExprs.isExpressionMinimal(selected));
        this.setTransferHandler(new MinimizedTransferHandler());
        this.karnaughMap.setTransferHandler(new KmapTransferHandler());
        this.minimizedExpr.setTransferHandler(new ExpressionTransferHandler());
        InputMap inputMap1 = this.getInputMap();
        InputMap inputMap2 = this.karnaughMap.getInputMap();
        InputMap inputMap3 = this.minimizedExpr.getInputMap();
        for (LogisimMenuItem item : LogisimMenuBar.EDIT_ITEMS) {
            KeyStroke accel = menubar.getAccelerator(item);
            inputMap1.put(accel, item);
            inputMap2.put(accel, item);
            inputMap3.put(accel, item);
        }
        this.getActionMap().put(LogisimMenuBar.COPY, TransferHandler.getCopyAction());
        this.karnaughMap.getActionMap().put(LogisimMenuBar.COPY, TransferHandler.getCopyAction());
        this.minimizedExpr.getActionMap().put(LogisimMenuBar.COPY, TransferHandler.getCopyAction());
        MouseMotionAdapter m = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, e, 1);
            }
        };
        this.karnaughMap.addMouseMotionListener(m);
        this.minimizedExpr.addMouseMotionListener(m);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MinimizedTab.this.requestFocusInWindow();
            }
        });
        FocusListener f = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                MinimizedTab.this.editHandler.computeEnabled();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                MinimizedTab.this.editHandler.computeEnabled();
            }
        };
        this.addFocusListener(f);
        this.minimizedExpr.addFocusListener(f);
        this.karnaughMap.addFocusListener(f);
    }

    private JPanel control() {
        JPanel control = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        control.setLayout(gb);
        gc.weightx = 1.0;
        gc.gridwidth = 1;
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 3;
        gc.anchor = 13;
        gc.insets = new Insets(3, 10, 3, 10);
        gb.setConstraints(this.selector.getLabel(), gc);
        control.add(this.selector.getLabel());
        ++gc.gridy;
        gb.setConstraints(this.formatLabel, gc);
        control.add(this.formatLabel);
        ++gc.gridy;
        gb.setConstraints(this.styleLabel, gc);
        control.add(this.styleLabel);
        ++gc.gridy;
        gb.setConstraints(this.notationLabel, gc);
        control.add(this.notationLabel);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.anchor = 17;
        gb.setConstraints(this.selector.getComboBox(), gc);
        control.add(this.selector.getComboBox());
        ++gc.gridy;
        gb.setConstraints(this.formatChoice, gc);
        control.add(this.formatChoice);
        ++gc.gridy;
        gb.setConstraints(this.formatStyle, gc);
        control.add(this.formatStyle);
        ++gc.gridy;
        gb.setConstraints(this.notationChoice, gc);
        control.add(this.notationChoice);
        return control;
    }

    private String getCurrentVariable() {
        return this.selector.getSelectedOutput();
    }

    @Override
    void localeChanged() {
        this.selector.localeChanged();
        this.karnaughMap.localeChanged();
        this.setAsExpr.setText(Strings.S.get("minimizedSetButton"));
        this.formatLabel.setText(Strings.S.get("minimizedFormat"));
        this.styleLabel.setText(Strings.S.get("KmapStyle"));
        this.notationLabel.setText(Strings.S.get("ExpressionNotation"));
        ((FormatModel)this.formatChoice.getModel()).localeChanged();
        ((StyleModel)this.formatStyle.getModel()).localeChanged();
        ((NotationModel)this.notationChoice.getModel()).localeChanged();
    }

    @Override
    void updateTab() {
        final String output = this.getCurrentVariable();
        if (this.model.getTruthTable().getRowCount() > 4096) {
            new Analyzer.PleaseWait<Void>(Strings.S.get("expressionCalc"), (Component)this){

                @Override
                public Void doInBackground() {
                    MinimizedTab.this.model.getOutputExpressions().getExpression(output);
                    return null;
                }
            }.get();
        }
        this.karnaughMap.setOutput(output);
        int format = this.outputExprs.getMinimizedFormat(output);
        this.formatChoice.setSelectedIndex(FormatModel.getFormatIndex(format));
        this.minimizedExpr.setExpression(this.outputExprs.getMinimalExpression(output));
        this.setAsExpr.setEnabled(output != null && !this.outputExprs.isExpressionMinimal(output));
    }

    @Override
    EditHandler getEditHandler() {
        return this.editHandler;
    }

    @Override
    PrintHandler getPrintHandler() {
        return this.printHandler;
    }

    private static class FormatModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 1L;
        private final String[] choices = new String[2];
        private int selected = 0;

        static int getFormatIndex(int choice) {
            if (choice == 1) {
                return 1;
            }
            return 0;
        }

        private FormatModel() {
            this.localeChanged();
        }

        @Override
        public Object getElementAt(int index) {
            return this.choices[index];
        }

        int getSelectedFormat() {
            if (this.selected == 1) {
                return 1;
            }
            return 0;
        }

        @Override
        public Object getSelectedItem() {
            return this.choices[this.selected];
        }

        @Override
        public int getSize() {
            return this.choices.length;
        }

        void localeChanged() {
            this.choices[0] = Strings.S.get("minimizedSumOfProducts");
            this.choices[1] = Strings.S.get("minimizedProductOfSums");
            this.fireContentsChanged(this, 0, this.choices.length);
        }

        @Override
        public void setSelectedItem(Object value) {
            for (int i = 0; i < this.choices.length; ++i) {
                if (!this.choices[i].equals(value)) continue;
                this.selected = i;
            }
        }
    }

    private static class StyleModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 1L;
        private final String[] choices;
        private int selected = AppPreferences.KMAP_LINED_STYLE.get() != false ? 1 : 0;

        private StyleModel() {
            this.choices = new String[2];
            this.localeChanged();
        }

        @Override
        public int getSize() {
            return this.choices.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.choices[index];
        }

        void localeChanged() {
            this.choices[0] = Strings.S.get("KmapNumberedStyle");
            this.choices[1] = Strings.S.get("KMapLinedStyle");
            this.fireContentsChanged(this, 0, this.choices.length);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            for (int i = 0; i < this.choices.length; ++i) {
                if (!this.choices[i].equals(anItem)) continue;
                this.selected = i;
            }
        }

        public void setStyle(KarnaughMapPanel karnaughMap) {
            if (this.selected == 0) {
                karnaughMap.setStyleNumbered();
            } else {
                karnaughMap.setStyleLined();
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.choices[this.selected];
        }
    }

    public static class NotationModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 1L;
        private final String[] choices = new String[5];
        private int selected = 0;

        public NotationModel() {
            this.localeChanged();
        }

        @Override
        public int getSize() {
            return this.choices.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.choices[index];
        }

        public void localeChanged() {
            this.choices[Expression.Notation.LOGIC.id] = Strings.S.get("expressionLogicrepresentation");
            this.choices[Expression.Notation.MATHEMATICAL.id] = Strings.S.get("expressionMathrepresentation");
            this.choices[Expression.Notation.ALTLOGIC.id] = Strings.S.get("expressionAltLogicrepresentation");
            this.choices[Expression.Notation.PROGBITS.id] = Strings.S.get("expressionProgbitsrepresentation");
            this.choices[Expression.Notation.PROGBOOLS.id] = Strings.S.get("expressionProgboolsrepresentation");
            this.fireContentsChanged(this, 0, this.choices.length);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            for (int i = 0; i < this.choices.length; ++i) {
                if (!this.choices[i].equals(anItem)) continue;
                this.selected = i;
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.choices[this.selected];
        }
    }

    private class MyListener
    implements OutputExpressionsListener,
    ActionListener,
    ItemListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String output = MinimizedTab.this.getCurrentVariable();
            int format = MinimizedTab.this.outputExprs.getMinimizedFormat(output);
            MinimizedTab.this.formatChoice.setSelectedIndex(FormatModel.getFormatIndex(format));
            MinimizedTab.this.outputExprs.setExpression(output, MinimizedTab.this.outputExprs.getMinimalExpression(output));
        }

        @Override
        public void expressionChanged(OutputExpressionsEvent event) {
            String output = MinimizedTab.this.getCurrentVariable();
            if (event.getType() == 2 && event.getVariable().equals(output)) {
                MinimizedTab.this.minimizedExpr.setExpression(MinimizedTab.this.outputExprs.getMinimalExpression(output));
                MinimizedTab.this.validate();
            }
            MinimizedTab.this.setAsExpr.setEnabled(output != null && !MinimizedTab.this.outputExprs.isExpressionMinimal(output));
            int format = MinimizedTab.this.outputExprs.getMinimizedFormat(output);
            MinimizedTab.this.formatChoice.setSelectedIndex(FormatModel.getFormatIndex(format));
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getSource() == MinimizedTab.this.formatChoice) {
                String output = MinimizedTab.this.getCurrentVariable();
                FormatModel model = (FormatModel)MinimizedTab.this.formatChoice.getModel();
                MinimizedTab.this.outputExprs.setMinimizedFormat(output, model.getSelectedFormat());
                MinimizedTab.this.karnaughMap.setFormat(model.getSelectedFormat());
            } else if (event.getSource() == MinimizedTab.this.formatStyle) {
                StyleModel model = (StyleModel)MinimizedTab.this.formatStyle.getModel();
                model.setStyle(MinimizedTab.this.karnaughMap);
            } else if (event.getSource() == MinimizedTab.this.notationChoice) {
                Expression.Notation notation = Expression.Notation.values()[MinimizedTab.this.notationChoice.getSelectedIndex()];
                MinimizedTab.this.minimizedExpr.setNotation(notation);
                MinimizedTab.this.karnaughMap.setNotation(notation);
            } else {
                MinimizedTab.this.updateTab();
            }
        }
    }

    private class MinimizedTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        private MinimizedTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (MinimizedTab.this.minimizedExpr.isFocusOwner()) {
                return new KmapSelection(MinimizedTab.this.karnaughMap);
            }
            if (MinimizedTab.this.karnaughMap.isFocusOwner()) {
                return new ExpressionSelection(MinimizedTab.this.minimizedExpr.getRenderData());
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            return false;
        }

        @Override
        protected void exportDone(JComponent c, Transferable tdata, int action) {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return false;
        }
    }

    private class KmapTransferHandler
    extends MinimizedTransferHandler {
        private static final long serialVersionUID = 1L;

        private KmapTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return new KmapSelection(MinimizedTab.this.karnaughMap);
        }
    }

    private class ExpressionTransferHandler
    extends MinimizedTransferHandler {
        private static final long serialVersionUID = 1L;

        private ExpressionTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return new ExpressionSelection(MinimizedTab.this.minimizedExpr.getRenderData());
        }
    }

    static class ExpressionSelection
    extends ImageSelection {
        public ExpressionSelection(ExpressionRenderData prettyView) {
            if (prettyView == null) {
                return;
            }
            Dimension dim = prettyView.getPreferredSize();
            int w = dim.width;
            int h = dim.height;
            BufferedImage img = new BufferedImage(w, h, 1);
            Graphics2D g = img.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, w, h);
            g.setColor(Color.BLACK);
            prettyView.paint(g, 0, 0);
            g.dispose();
            this.setImage(img);
        }
    }

    static class KmapSelection
    extends ImageSelection {
        public KmapSelection(KarnaughMapPanel kmap) {
            int w = kmap.getKMapDim().width;
            int h = kmap.getKMapDim().height;
            BufferedImage img = new BufferedImage(w, h, 1);
            Graphics2D g = img.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, w, h);
            g.setColor(Color.BLACK);
            kmap.paintKmap(g, false);
            g.dispose();
            this.setImage(img);
        }
    }

    static class ImageSelection
    implements Transferable {
        private Image image;

        public void setImage(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

