/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.gui.AnalyzerTab;
import com.cburch.logisim.analyze.gui.TableTabCaret;
import com.cburch.logisim.analyze.gui.TableTabClip;
import com.cburch.logisim.analyze.model.Entry;
import com.cburch.logisim.analyze.model.TruthTable;
import com.cburch.logisim.analyze.model.TruthTableEvent;
import com.cburch.logisim.analyze.model.TruthTableListener;
import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.menu.EditHandler;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.PrintHandler;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

class TableTab
extends AnalyzerTab
implements Entry.EntryChangedListener {
    private static final long serialVersionUID = 1L;
    private final Font headFont;
    private final Font bodyFont;
    private final int headerPadding;
    private final int headerVertSep;
    private final int headerHorizSep;
    private final int defaultCellPadding;
    private final int defaultCellWidth;
    private final int defaultCellHeight;
    private final MyListener myListener = new MyListener();
    private final TruthTable table;
    private final TableBody body;
    private final TableHeader header;
    private final JScrollPane bodyPane;
    private final JScrollPane headerPane;
    private int cellHeight;
    private int tableWidth;
    private int headerHeight;
    private int bodyHeight;
    private final ColumnGroupDimensions inDim;
    private final ColumnGroupDimensions outDim;
    private final TableTabCaret caret;
    private final TableTabClip clip;
    List<Var> inputVars;
    List<Var> outputVars;
    private final SquareButton one = new SquareButton(Entry.ONE);
    private final SquareButton zero = new SquareButton(Entry.ZERO);
    private final SquareButton dontcare = new SquareButton(Entry.DONT_CARE);
    private final TightButton expand = new TightButton(Strings.S.get("tableExpand"));
    private final TightButton compact = new TightButton(Strings.S.get("tableCompact"));
    private final JLabel count = new JLabel(Strings.S.get("tableRowsShown", 0, 0), 0);
    private static final Canvas canvas = new Canvas();
    final EditHandler editHandler = new EditHandler(){

        @Override
        public void computeEnabled() {
            boolean sel = TableTab.this.caret.hasSelection();
            this.setEnabled(LogisimMenuBar.CUT, sel);
            this.setEnabled(LogisimMenuBar.COPY, sel);
            this.setEnabled(LogisimMenuBar.PASTE, sel);
            this.setEnabled(LogisimMenuBar.DELETE, sel);
            this.setEnabled(LogisimMenuBar.DUPLICATE, false);
            this.setEnabled(LogisimMenuBar.SELECT_ALL, TableTab.this.table.getRowCount() > 0);
            this.setEnabled(LogisimMenuBar.RAISE, false);
            this.setEnabled(LogisimMenuBar.LOWER, false);
            this.setEnabled(LogisimMenuBar.RAISE_TOP, false);
            this.setEnabled(LogisimMenuBar.LOWER_BOTTOM, false);
            this.setEnabled(LogisimMenuBar.ADD_CONTROL, false);
            this.setEnabled(LogisimMenuBar.REMOVE_CONTROL, false);
        }

        @Override
        public void copy() {
            TableTab.this.requestFocus();
            TableTab.this.clip.copy();
        }

        @Override
        public void paste() {
            TableTab.this.requestFocus();
            TableTab.this.clip.paste();
        }

        @Override
        public void selectAll() {
            TableTab.this.caret.selectAll();
        }

        @Override
        public void delete() {
            TableTab.this.requestFocus();
            Rectangle s = TableTab.this.caret.getSelection();
            int inputs = TableTab.this.table.getInputColumnCount();
            for (int c = s.x; c < s.x + s.width; ++c) {
                if (c < inputs) continue;
                for (int r = s.y; r < s.y + s.height; ++r) {
                    TableTab.this.table.setVisibleOutputEntry(r, c - inputs, Entry.DONT_CARE);
                }
            }
        }
    };
    final PrintHandler printHandler = new PrintHandler(){

        @Override
        public Dimension getExportImageSize() {
            return new Dimension(TableTab.this.tableWidth, TableTab.this.headerHeight + TableTab.this.bodyHeight);
        }

        @Override
        public void paintExportImage(BufferedImage img, Graphics2D g) {
            int width = img.getWidth();
            int height = img.getHeight();
            g.setClip(0, 0, width, height);
            TableTab.this.header.paintComponent(g, true, width, TableTab.this.headerHeight);
            g.translate(0, TableTab.this.headerHeight);
            TableTab.this.body.paintComponent(g, true, width, TableTab.this.bodyHeight);
        }

        @Override
        public int print(Graphics2D g, PageFormat pf, int pageNum, double w, double h) {
            double headHeight;
            int rowsPerPage;
            int n;
            int numPages;
            FontMetrics fm = g.getFontMetrics();
            double scale = 1.0;
            if ((double)TableTab.this.tableWidth > w) {
                scale = w / (double)TableTab.this.tableWidth;
            }
            if (pageNum >= (numPages = ((n = TableTab.this.getRowCount()) + (rowsPerPage = (int)((h - (headHeight = (double)fm.getHeight() * 1.5 + (double)TableTab.this.headerHeight * scale)) / ((double)TableTab.this.cellHeight * scale))) - 1) / rowsPerPage)) {
                return 1;
            }
            GraphicsUtil.drawText(g, String.format("Combinational Analysis (page %d of %d)", pageNum + 1, numPages), (int)(w / 2.0), 0, 0, -1);
            g.translate(0.0, (double)fm.getHeight() * 1.5);
            g.scale(scale, scale);
            TableTab.this.header.paintComponent(g, true, (int)(w / scale), TableTab.this.headerHeight);
            g.translate(0, TableTab.this.headerHeight);
            int heightY = TableTab.this.cellHeight * rowsPerPage;
            int topY = pageNum * heightY;
            g.translate(0, -topY);
            g.setClip(0, topY, (int)(w / scale), heightY);
            TableTab.this.body.paintComponent(g, true, (int)(w / scale), TableTab.this.bodyHeight);
            return 0;
        }
    };

    public TableTab(TruthTable table) {
        this.table = table;
        Font myFont = new Font("Serif", 0, 14);
        this.headFont = AppPreferences.getScaledFont(myFont).deriveFont(1);
        this.bodyFont = AppPreferences.getScaledFont(myFont);
        this.headerPadding = AppPreferences.getScaled(10);
        this.headerVertSep = AppPreferences.getScaled(4);
        this.headerHorizSep = AppPreferences.getScaled(4);
        this.defaultCellPadding = AppPreferences.getScaled(12);
        this.defaultCellWidth = AppPreferences.getScaled(12);
        this.defaultCellHeight = AppPreferences.getScaled(16);
        this.header = new TableHeader();
        this.body = new TableBody();
        this.bodyPane = new JScrollPane(this.body, 22, 30);
        this.bodyPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                int width = TableTab.this.bodyPane.getViewport().getWidth();
                TableTab.this.body.setSize(new Dimension(width, TableTab.this.body.getHeight()));
            }
        });
        this.bodyPane.setVerticalScrollBar(this.getVerticalScrollBar());
        this.headerPane = new JScrollPane(this.header, 21, 31);
        this.headerPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                int width = TableTab.this.headerPane.getViewport().getWidth();
                TableTab.this.header.setSize(new Dimension(width, TableTab.this.header.getHeight()));
            }
        });
        this.headerPane.getHorizontalScrollBar().setModel(this.bodyPane.getHorizontalScrollBar().getModel());
        this.bodyPane.setBorder(null);
        this.body.setBorder(null);
        this.headerPane.setBorder(null);
        this.header.setBorder(null);
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new FlowLayout());
        Entry.DONT_CARE.addListener(this.dontcare);
        Entry.ZERO.addListener(this.zero);
        Entry.ONE.addListener(this.one);
        Entry.DONT_CARE.addListener(this);
        Entry.ZERO.addListener(this);
        Entry.ONE.addListener(this);
        toolbar.add(this.dontcare);
        toolbar.add(this.one);
        toolbar.add(this.zero);
        toolbar.add(this.compact);
        toolbar.add(this.expand);
        this.one.setActionCommand("1");
        this.zero.setActionCommand("0");
        this.dontcare.setActionCommand("x");
        this.compact.setActionCommand("compact");
        this.expand.setActionCommand("expand");
        this.expand.setEnabled(this.getRowCount() < table.getRowCount());
        this.count.setText(Strings.S.get("tableRowsShown", this.getRowCount(), table.getRowCount()));
        final GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        layout.setConstraints(toolbar, gc);
        this.add(toolbar);
        ++gc.gridy;
        layout.setConstraints(this.count, gc);
        this.add(this.count);
        ++gc.gridy;
        layout.setConstraints(this.headerPane, gc);
        this.add(this.headerPane);
        gc.fill = 1;
        ++gc.gridy;
        gc.weighty = 1.0;
        layout.setConstraints(this.bodyPane, gc);
        this.add(this.bodyPane);
        this.inDim = new ColumnGroupDimensions(table.getInputVariables());
        this.outDim = new ColumnGroupDimensions(table.getOutputVariables());
        table.addTruthTableListener(this.myListener);
        this.setToolTipText(" ");
        this.caret = new TableTabCaret(this);
        this.one.addActionListener(this.caret.getListener());
        this.zero.addActionListener(this.caret.getListener());
        this.dontcare.addActionListener(this.caret.getListener());
        this.compact.addActionListener(this.caret.getListener());
        this.expand.addActionListener(this.caret.getListener());
        this.clip = new TableTabClip(this);
        this.computePreferredSize();
        this.addComponentListener(new ComponentAdapter(){
            boolean done;

            @Override
            public void componentShown(ComponentEvent e) {
                TableTab.this.removeComponentListener(this);
                if (this.done) {
                    return;
                }
                this.done = true;
                int pad = TableTab.this.bodyPane.getVerticalScrollBar().getWidth();
                GridBagConstraints gc = layout.getConstraints(TableTab.this.headerPane);
                Insets i = gc.insets;
                gc.insets.set(i.top, i.left, i.bottom, i.right + pad);
                layout.setConstraints(TableTab.this.headerPane, gc);
                TableTab.this.invalidate();
                TableTab.this.repaint();
            }
        });
        this.editHandler.computeEnabled();
        LocaleManager.addLocaleListener(this.myListener);
    }

    public JPanel getBody() {
        return this.body;
    }

    private void computePreferredSize() {
        this.inputVars = this.table.getInputVariables();
        this.outputVars = this.table.getOutputVariables();
        if (this.inputVars.isEmpty()) {
            this.inputVars = new ArrayList<Var>();
            this.inputVars.add(new Var(Strings.S.get("tableNoInputs"), 0));
        }
        if (this.outputVars.isEmpty()) {
            this.outputVars = new ArrayList<Var>();
            this.outputVars.add(new Var(Strings.S.get("tableNoOutputs"), 0));
        }
        this.cellHeight = this.defaultCellHeight;
        this.inDim.reset(this.inputVars);
        this.outDim.reset(this.outputVars);
        Graphics gfx = this.getGraphics();
        FontMetrics fm = gfx != null ? gfx.getFontMetrics(this.headFont) : canvas.getFontMetrics(this.headFont);
        this.cellHeight = fm.getHeight();
        this.inDim.calculate(fm);
        this.outDim.calculate(fm);
        this.tableWidth = this.inDim.width + this.headerHorizSep + this.outDim.width;
        this.computePreferredHeight();
    }

    private void computePreferredHeight() {
        this.bodyHeight = this.cellHeight * this.getRowCount();
        this.headerHeight = this.headerVertSep + this.cellHeight + this.headerVertSep;
        int tableHeight = this.cellHeight + this.headerHeight;
        this.header.setPreferredSize(new Dimension(this.tableWidth, this.headerHeight));
        this.headerPane.setMinimumSize(new Dimension(this.tableWidth, this.headerHeight));
        this.headerPane.setPreferredSize(new Dimension(this.tableWidth, this.headerHeight));
        this.body.setPreferredSize(new Dimension(this.tableWidth, this.bodyHeight));
        this.bodyPane.setPreferredSize(new Dimension(this.tableWidth, 1));
        this.setPreferredSize(new Dimension(this.tableWidth + 40, tableHeight));
        this.revalidate();
        this.repaint();
    }

    TableTabCaret getCaret() {
        return this.caret;
    }

    int getCellHeight() {
        return this.cellHeight;
    }

    public int getColumn(MouseEvent event) {
        int left = (this.body.getWidth() - this.tableWidth) / 2;
        int mid = left + this.inDim.width + this.headerHorizSep;
        int x = event.getX();
        if (x < mid) {
            return this.inDim.getColumn(x - left);
        }
        int c = this.outDim.getColumn(x - mid);
        return c < 0 ? -1 : this.table.getInputColumnCount() + c;
    }

    public int getNearestColumn(MouseEvent event) {
        int outputs;
        int inputs = this.table.getInputColumnCount();
        if (inputs + (outputs = this.table.getOutputColumnCount()) == 0) {
            return -1;
        }
        int left = (this.body.getWidth() - this.tableWidth) / 2;
        int mid = left + this.inDim.width + this.headerHorizSep;
        int x = event.getX();
        if (x < left) {
            return 0;
        }
        if (x >= mid + this.outDim.width) {
            return inputs + outputs - 1;
        }
        if (x < mid - this.headerHorizSep / 2 && inputs > 0) {
            return this.inDim.getNearestColumn(x - left);
        }
        return inputs + this.outDim.getNearestColumn(x - mid);
    }

    int getColumnCount() {
        int inputs = this.table.getInputColumnCount();
        int outputs = this.table.getOutputColumnCount();
        return inputs + outputs;
    }

    public int getOutputColumn(MouseEvent event) {
        int inputs;
        int c = this.getColumn(event);
        return c < (inputs = this.table.getInputColumnCount()) ? -1 : c - inputs;
    }

    public int getRow(MouseEvent event) {
        int y = event.getY();
        if (y < 0) {
            return -1;
        }
        int ret = y / this.cellHeight;
        int rows = this.getRowCount();
        return ret >= 0 && ret < rows ? ret : -1;
    }

    public int getNearestRow(MouseEvent event) {
        int y = event.getY();
        if (y < 0) {
            return 0;
        }
        int ret = y / this.cellHeight;
        int rows = this.getRowCount();
        return ret < 0 ? 0 : (ret >= rows ? rows - 1 : ret);
    }

    public int getRowCount() {
        return this.table.getVisibleRowCount();
    }

    public int getInputColumnCount() {
        return this.table.getInputColumnCount();
    }

    public int getOutputColumnCount() {
        return this.table.getOutputColumnCount();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int row = this.getRow(event);
        if (row < 0) {
            return null;
        }
        int col = this.getOutputColumn(event);
        if (col < 0) {
            return null;
        }
        Entry entry = this.table.getVisibleOutputEntry(row, col);
        return entry.getErrorMessage();
    }

    public TruthTable getTruthTable() {
        return this.table;
    }

    JScrollBar getVerticalScrollBar() {
        return new JScrollBar(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getBlockIncrement(int direction) {
                int curY = this.getValue();
                int curHeight = this.getVisibleAmount();
                int numCells = curHeight / TableTab.this.cellHeight - 1;
                if (numCells <= 0) {
                    numCells = 1;
                }
                if (direction > 0) {
                    return curY > 0 ? numCells * TableTab.this.cellHeight : numCells * TableTab.this.cellHeight + TableTab.this.headerVertSep;
                }
                return curY > TableTab.this.cellHeight + TableTab.this.headerVertSep ? numCells * TableTab.this.cellHeight : numCells * TableTab.this.cellHeight + TableTab.this.headerVertSep;
            }

            @Override
            public int getUnitIncrement(int direction) {
                int curY = this.getValue();
                if (direction > 0) {
                    return curY > 0 ? TableTab.this.cellHeight : TableTab.this.cellHeight + TableTab.this.headerVertSep;
                }
                return curY > TableTab.this.cellHeight + TableTab.this.headerVertSep ? TableTab.this.cellHeight : TableTab.this.cellHeight + TableTab.this.headerVertSep;
            }
        };
    }

    int getXLeft(int col) {
        int left = Math.max(0, (this.body.getWidth() - this.tableWidth) / 2);
        int mid = left + this.inDim.width + this.headerHorizSep;
        int inputs = this.table.getInputColumnCount();
        if (col < inputs) {
            return left + this.inDim.getX(col);
        }
        return mid + this.outDim.getX(col - inputs);
    }

    int getXRight(int col) {
        int left = Math.max(0, (this.body.getWidth() - this.tableWidth) / 2);
        int mid = left + this.inDim.width + this.headerHorizSep;
        int inputs = this.table.getInputColumnCount();
        if (col < inputs) {
            return left + this.inDim.getX(col) + this.inDim.cellWidth;
        }
        return mid + this.outDim.getX(col - inputs) + this.outDim.cellWidth;
    }

    int getCellWidth(int col) {
        int inputs = this.table.getInputColumnCount();
        return col < inputs ? this.inDim.cellWidth : this.outDim.cellWidth;
    }

    int getY(int row) {
        return row * this.cellHeight;
    }

    @Override
    void localeChanged() {
        this.computePreferredSize();
        this.repaint();
    }

    @Override
    void updateTab() {
        this.editHandler.computeEnabled();
    }

    @Override
    EditHandler getEditHandler() {
        return this.editHandler;
    }

    @Override
    PrintHandler getPrintHandler() {
        return this.printHandler;
    }

    @Override
    public void entryDesriptionChanged() {
        this.repaint();
    }

    private class MyListener
    implements TruthTableListener,
    LocaleListener {
        private MyListener() {
        }

        @Override
        public void rowsChanged(TruthTableEvent event) {
            this.updateTable();
        }

        @Override
        public void cellsChanged(TruthTableEvent event) {
            TableTab.this.repaint();
        }

        @Override
        public void structureChanged(TruthTableEvent event) {
            this.updateTable();
        }

        void updateTable() {
            TableTab.this.computePreferredSize();
            TableTab.this.expand.setEnabled(TableTab.this.getRowCount() < TableTab.this.table.getRowCount());
            TableTab.this.count.setText(Strings.S.get("tableRowsShown", TableTab.this.getRowCount(), TableTab.this.table.getRowCount()));
            TableTab.this.body.setSize(new Dimension(TableTab.this.body.getWidth(), TableTab.this.table.getRowCount() * TableTab.this.cellHeight));
            TableTab.this.repaint();
        }

        @Override
        public void localeChanged() {
            TableTab.this.expand.setText(Strings.S.get("tableExpand"));
            TableTab.this.compact.setText(Strings.S.get("tableCompact"));
            TableTab.this.count.setText(Strings.S.get("tableRowsShown", TableTab.this.getRowCount(), TableTab.this.table.getRowCount()));
        }
    }

    private static class SquareButton
    extends TightButton
    implements Entry.EntryChangedListener {
        private static final long serialVersionUID = 1L;
        final Entry myEntry;

        SquareButton(Entry e) {
            super(e.getDescription());
            this.myEntry = e;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            int s = (int)d.getHeight();
            return new Dimension(s, s);
        }

        @Override
        public void entryDesriptionChanged() {
            this.setText(this.myEntry.getDescription());
            this.repaint();
        }
    }

    private static class TightButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        TightButton(String s) {
            super(s);
            this.setMargin(new Insets(0, 0, 0, 0));
        }
    }

    private class TableHeader
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private TableHeader() {
        }

        @Override
        public void paintComponent(Graphics g) {
            this.paintComponent(g, false, this.getWidth(), this.getHeight());
        }

        public void paintComponent(Graphics g, boolean printView, int canvasWidth, int canvasHeight) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (!printView) {
                super.paintComponent(g);
            }
            int top = canvasHeight - TableTab.this.cellHeight - TableTab.this.headerVertSep;
            int left = Math.max(0, (canvasWidth - TableTab.this.tableWidth) / 2);
            g.setColor(Color.GRAY);
            int lineX = left + TableTab.this.inDim.width + TableTab.this.headerHorizSep / 2;
            int lineY = top + TableTab.this.cellHeight + TableTab.this.headerVertSep / 2;
            g.drawLine(left, lineY, left + TableTab.this.tableWidth, lineY);
            g.drawLine(lineX, top, lineX, TableTab.this.cellHeight);
            g.setColor(Color.BLACK);
            g.setFont(TableTab.this.headFont);
            TableTab.this.inDim.paintHeaders(g, left, top);
            TableTab.this.outDim.paintHeaders(g, left + TableTab.this.inDim.width + TableTab.this.headerHorizSep, top);
        }
    }

    private class TableBody
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private TableBody() {
        }

        @Override
        public void paintComponent(Graphics g) {
            try {
                this.paintComponent(g, false, this.getWidth(), this.getHeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void paintComponent(Graphics g, boolean printView, int canvasWidth, int canvasHeight) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (!printView) {
                super.paintComponent(g);
                TableTab.this.caret.paintBackground(g);
            }
            boolean top = false;
            int left = Math.max(0, (canvasWidth - TableTab.this.tableWidth) / 2);
            int mid = left + TableTab.this.inDim.width + TableTab.this.headerHorizSep;
            g.setColor(Color.GRAY);
            int lineX = left + TableTab.this.inDim.width + TableTab.this.headerHorizSep / 2;
            g.drawLine(lineX, 0, lineX, 0 + TableTab.this.bodyHeight);
            g.setFont(TableTab.this.bodyFont);
            FontMetrics fm = g.getFontMetrics();
            int y = 0;
            Rectangle clip = g.getClipBounds();
            int firstRow = Math.max(0, (clip.y - y) / TableTab.this.cellHeight);
            int lastRow = Math.min(TableTab.this.getRowCount(), 2 + (clip.y + clip.height - y) / TableTab.this.cellHeight);
            y += firstRow * TableTab.this.cellHeight;
            for (int row = firstRow; row < lastRow; ++row) {
                TableTab.this.inDim.paintRow(g, fm, left, y, row, true);
                TableTab.this.outDim.paintRow(g, fm, mid, y, row, false);
                y += TableTab.this.cellHeight;
            }
            if (!printView) {
                TableTab.this.caret.paintForeground(g);
            }
        }
    }

    private class ColumnGroupDimensions {
        int cellWidth;
        int cellPadding;
        int leftPadding;
        int rightPadding;
        int width;
        List<Var> vars;

        ColumnGroupDimensions(List<Var> vars) {
            this.vars = vars;
        }

        void reset(List<Var> vars) {
            this.vars = vars;
            this.leftPadding = TableTab.this.defaultCellPadding / 2;
            this.rightPadding = TableTab.this.defaultCellPadding / 2;
            this.cellPadding = TableTab.this.defaultCellPadding;
            this.cellWidth = TableTab.this.defaultCellWidth;
        }

        void calculate(FontMetrics fm) {
            for (int i = 1; i < this.vars.size(); ++i) {
                int cw2;
                int cw1;
                int cw;
                int hw2;
                Var v1 = this.vars.get(i - 1);
                Var v2 = this.vars.get(i);
                int hw1 = fm.stringWidth(v1.toString());
                int hw = hw1 - hw1 / 2 + TableTab.this.headerPadding + (hw2 = fm.stringWidth(v2.toString())) / 2;
                if (hw <= (cw = (cw1 = v1.width * this.cellWidth) - cw1 / 2 + this.cellPadding + (cw2 = v2.width * this.cellWidth) / 2)) continue;
                this.cellPadding += hw - cw;
            }
            Var v = this.vars.get(0);
            int w = fm.stringWidth(v.toString());
            this.leftPadding = Math.max(TableTab.this.defaultCellPadding / 2, w / 2 - this.cellWidth * v.width / 2);
            v = this.vars.get(this.vars.size() - 1);
            w = fm.stringWidth(v.toString());
            this.rightPadding = Math.max(TableTab.this.defaultCellPadding / 2, w - w / 2 - (this.cellWidth * v.width - this.cellWidth * v.width / 2));
            this.calculateWidth();
        }

        void calculateWidth() {
            int w = -this.cellPadding;
            for (Var v : this.vars) {
                w += this.cellPadding + v.width * this.cellWidth;
            }
            this.width = this.leftPadding + w + this.rightPadding;
        }

        int getColumn(int x) {
            if (x < this.leftPadding) {
                return -1;
            }
            x -= this.leftPadding;
            int col = 0;
            for (Var v : this.vars) {
                if (x < 0) {
                    return -1;
                }
                if (x < v.width * this.cellWidth) {
                    return col + x / this.cellWidth;
                }
                col += v.width;
                x -= v.width * this.cellWidth + this.cellPadding;
            }
            return -1;
        }

        int getNearestColumn(int x) {
            if (x < this.leftPadding) {
                return 0;
            }
            x -= this.leftPadding;
            int col = 0;
            for (Var var : this.vars) {
                if (x < -(this.cellPadding / 2)) {
                    return col - 1;
                }
                if (x < 0) {
                    return col;
                }
                if (x < var.width * this.cellWidth) {
                    return col + x / this.cellWidth;
                }
                col += var.width;
                x -= var.width * this.cellWidth + this.cellPadding;
            }
            return col - 1;
        }

        int getX(int col) {
            int x = this.leftPadding;
            for (Var var : this.vars) {
                if (col < 0) {
                    return x;
                }
                if (col < var.width) {
                    return x + col * this.cellWidth;
                }
                col -= var.width;
                x += var.width * this.cellWidth + this.cellPadding;
            }
            return x;
        }

        void paintHeaders(Graphics g, int x, int y) {
            FontMetrics fm = g.getFontMetrics();
            y += fm.getAscent() + 1;
            x += this.leftPadding;
            for (Var var : this.vars) {
                String s = var.toString();
                int sx = x + var.width * this.cellWidth / 2;
                int sw = fm.stringWidth(s);
                g.drawString(s, sx - sw / 2, y);
                x += var.width * this.cellWidth + this.cellPadding;
            }
        }

        void paintRow(Graphics g, FontMetrics fm, int x, int y, int row, boolean isInput) {
            x += this.leftPadding;
            int cy = y + fm.getAscent();
            int col = 0;
            for (Var var : this.vars) {
                for (int b = var.width - 1; b >= 0; --b) {
                    Entry entry;
                    Entry entry2 = entry = isInput ? TableTab.this.table.getVisibleInputEntry(row, col++) : TableTab.this.table.getVisibleOutputEntry(row, col++);
                    if (entry.isError()) {
                        g.setColor(Value.errorColor);
                        g.fillRect(x, y, this.cellWidth, TableTab.this.cellHeight);
                        g.setColor(Color.BLACK);
                    }
                    g.setColor(entry == Entry.BUS_ERROR ? Value.errorColor : Color.BLACK);
                    String label = entry.getDescription();
                    int width = fm.stringWidth(label);
                    g.drawString(label, x + (this.cellWidth - width) / 2, cy);
                    x += this.cellWidth;
                }
                x += this.cellPadding;
            }
        }
    }
}

