/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.contracts.BaseKeyListenerContract;
import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.contracts.BaseMouseMotionListenerContract;
import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.gui.Analyzer;
import com.cburch.logisim.analyze.gui.TableTab;
import com.cburch.logisim.analyze.model.Entry;
import com.cburch.logisim.analyze.model.TruthTable;
import com.cburch.logisim.analyze.model.TruthTableEvent;
import com.cburch.logisim.analyze.model.TruthTableListener;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

class TableTabCaret {
    private static final Color SELECT_COLOR = new Color(192, 192, 255);
    private static final Color HIGHLIGHT_COLOR = new Color(255, 255, 192);
    private final Listener listener = new Listener();
    private final TableTab table;
    private Pt cursor;
    private Pt markA;
    private Pt markB;
    private Pt hover;
    private final Pt invalid;
    private final Pt home;
    private int[] hilightRows;
    private boolean cleanHilight;
    boolean hadSelection = false;

    private void clearHilight() {
        if (this.hilightRows == null) {
            return;
        }
        this.cleanHilight = true;
        this.hilightRows = null;
    }

    public ActionListener getListener() {
        return this.listener;
    }

    TableTabCaret(TableTab table) {
        this.table = table;
        this.invalid = new Pt();
        this.markA = this.cursor = (this.home = new Pt(0, 0));
        this.markB = this.invalid;
        this.hover = this.invalid;
        table.getTruthTable().addTruthTableListener(this.listener);
        table.getBody().addMouseListener(this.listener);
        table.getBody().addMouseMotionListener(this.listener);
        table.addKeyListener(this.listener);
        table.addFocusListener(this.listener);
        InputMap imap = table.getInputMap();
        ActionMap amap = table.getActionMap();
        AbstractAction nullAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        String nullKey = "null";
        amap.put("null", nullAction);
        imap.put(KeyStroke.getKeyStroke(40, 0), "null");
        imap.put(KeyStroke.getKeyStroke(38, 0), "null");
        imap.put(KeyStroke.getKeyStroke(37, 0), "null");
        imap.put(KeyStroke.getKeyStroke(39, 0), "null");
        imap.put(KeyStroke.getKeyStroke(34, 0), "null");
        imap.put(KeyStroke.getKeyStroke(33, 0), "null");
        imap.put(KeyStroke.getKeyStroke(36, 0), "null");
        imap.put(KeyStroke.getKeyStroke(35, 0), "null");
        imap.put(KeyStroke.getKeyStroke(10, 0), "null");
    }

    boolean marked() {
        return this.markA.isValid() && this.markB.isValid();
    }

    Rectangle getSelection() {
        if (this.marked()) {
            int r0 = Math.min(this.markA.row, this.markB.row);
            int c0 = Math.min(this.markA.col, this.markB.col);
            int r1 = Math.max(this.markA.row, this.markB.row);
            int c1 = Math.max(this.markA.col, this.markB.col);
            return new Rectangle(c0, r0, c1 - c0 + 1, r1 - r0 + 1);
        }
        if (this.cursor.isValid()) {
            return new Rectangle(this.cursor.col, this.cursor.row, 1, 1);
        }
        return new Rectangle(0, 0, -1, -1);
    }

    boolean hasSelection() {
        return this.marked() || this.cursor.isValid();
    }

    void updateMenus() {
        boolean sel = this.hasSelection();
        if (this.hadSelection != sel) {
            this.hadSelection = sel;
            this.table.updateTab();
        }
    }

    void paintBackground(Graphics g) {
        if (this.hilightRows != null) {
            g.setColor(HIGHLIGHT_COLOR);
            int inputs = this.table.getInputColumnCount();
            int outputs = this.table.getOutputColumnCount();
            int x0 = this.table.getXLeft(0);
            int x1 = this.table.getXRight(inputs + outputs - 1);
            for (int rowId : this.hilightRows) {
                int y = this.table.getY(rowId);
                int h = this.table.getCellHeight();
                g.fillRect(x0, y, x1 - x0, h);
            }
        }
        if (this.marked() && !this.markA.equals(this.markB)) {
            Rectangle r = this.region(this.markA, this.markB);
            g.setColor(SELECT_COLOR);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        if (this.table.isFocusOwner() && this.cursor.isValid()) {
            Rectangle r = this.region(this.cursor);
            g.setColor(Color.WHITE);
            g.fillRect(r.x, r.y + 1, r.width - 1, r.height - 3);
        }
    }

    void paintForeground(Graphics g) {
        Pt p;
        if (!this.table.isFocusOwner()) {
            return;
        }
        if (this.cursor.isValid()) {
            p = this.cursor;
            g.setColor(Color.BLACK);
        } else if (this.hover.isValid()) {
            p = this.hover;
            g.setColor(Color.GRAY);
        } else {
            return;
        }
        int x = this.table.getXLeft(p.col);
        int y = this.table.getY(p.row);
        int w = this.table.getCellWidth(p.row);
        int h = this.table.getCellHeight();
        GraphicsUtil.switchToWidth(g, 2);
        g.drawRect(x - 1, y, w + 1, h - 2);
        GraphicsUtil.switchToWidth(g, 1);
    }

    void selectAll() {
        this.table.requestFocus();
        this.clearHilight();
        this.cursor = this.invalid;
        this.markA = new Pt(0, 0);
        this.markB = new Pt(this.table.getRowCount() - 1, this.table.getColumnCount() - 1);
        this.repaint(this.markA, this.markB);
    }

    private Pt pointNear(int row, int col) {
        int inputs = this.table.getInputColumnCount();
        int outputs = this.table.getOutputColumnCount();
        int rows = this.table.getRowCount();
        int cols = inputs + outputs;
        int n = row < 0 ? 0 : (row = row >= rows ? rows - 1 : row);
        col = col < 0 ? 0 : (col >= cols ? cols - 1 : col);
        return new Pt(row, col);
    }

    private void move(int row, int col, boolean shift) {
        Pt p = this.pointNear(row, col);
        if (shift) {
            Pt oldMarkB = this.markB;
            this.markB = p;
            this.repaint(oldMarkB, this.cursor, this.markA, this.markB);
            this.scrollTo(this.markB);
        } else {
            this.setCursor(p, p);
        }
    }

    private void setCursor(Pt p, Pt m) {
        Pt oldCursor = this.cursor;
        Pt oldMarkA = this.markA;
        Pt oldMarkB = this.markB;
        this.clearHilight();
        this.cursor = p;
        this.markA = m;
        this.markB = this.invalid;
        this.repaint(oldCursor, oldMarkA, oldMarkB, this.cursor, this.markA, this.markB);
        if (this.cursor.isValid()) {
            this.scrollTo(this.cursor);
        }
    }

    private void scrollTo(Pt p) {
        if (!p.isValid()) {
            return;
        }
        int cx = this.table.getXLeft(p.col);
        int cy = this.table.getY(p.row);
        int cw = this.table.getCellWidth(p.col);
        int ch = this.table.getCellHeight();
        this.table.getBody().scrollRectToVisible(new Rectangle(cx, cy, cw, ch));
    }

    private void repaint(Pt ... pts) {
        this.updateMenus();
        if (this.cleanHilight) {
            this.cleanHilight = false;
            this.table.repaint();
            return;
        }
        Rectangle r = this.region(pts);
        if (r.isEmpty()) {
            return;
        }
        r.grow(2, 2);
        this.table.getBody().repaint(r);
    }

    private Rectangle region(Pt ... pts) {
        int r0 = -1;
        int r1 = -1;
        int c0 = -1;
        int c1 = -1;
        for (Pt p : pts) {
            if (p == null || !p.isValid()) continue;
            if (r0 == -1) {
                r0 = p.row;
                c0 = p.col;
                r1 = r0;
                c1 = c0;
                continue;
            }
            r0 = Math.min(r0, p.row);
            c0 = Math.min(c0, p.col);
            r1 = Math.max(r1, p.row);
            c1 = Math.max(c1, p.col);
        }
        if (r0 < 0) {
            return new Rectangle(0, 0, -1, -1);
        }
        int x0 = this.table.getXLeft(c0);
        int x1 = this.table.getXRight(c1);
        int y0 = this.table.getY(r0);
        int y1 = this.table.getY(r1) + this.table.getCellHeight();
        return new Rectangle(x0 - 2, y0 - 2, x1 - x0 + 4, y1 - y0 + 4);
    }

    private boolean isContiguous(int[] rows) {
        if (rows.length <= 1) {
            return true;
        }
        for (int i = 1; i < rows.length; ++i) {
            if (Math.abs(rows[i] - rows[i]) <= 1) continue;
            return false;
        }
        return true;
    }

    private class Listener
    implements BaseMouseListenerContract,
    BaseMouseMotionListenerContract,
    BaseKeyListenerContract,
    FocusListener,
    TruthTableListener,
    ActionListener {
        private Listener() {
        }

        @Override
        public void cellsChanged(TruthTableEvent event) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            TableTabCaret.this.repaint(TableTabCaret.this.cursor);
        }

        @Override
        public void focusLost(FocusEvent e) {
            TableTabCaret.this.repaint(TableTabCaret.this.cursor);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String action;
            switch (action = event.getActionCommand()) {
                case "1": {
                    this.doKey('1');
                    break;
                }
                case "0": {
                    this.doKey('0');
                    break;
                }
                case "x": {
                    this.doKey('-');
                    break;
                }
                case "compact": {
                    final TruthTable tt = TableTabCaret.this.table.getTruthTable();
                    if (tt.getRowCount() > 4096) {
                        new Analyzer.PleaseWait<Void>(Strings.S.get("tabcaretCompactRows"), (Component)TableTabCaret.this.table){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public Void doInBackground() {
                                tt.compactVisibleRows();
                                return null;
                            }
                        }.get();
                        break;
                    }
                    tt.compactVisibleRows();
                    break;
                }
                case "expand": {
                    TruthTable model = TableTabCaret.this.table.getTruthTable();
                    model.expandVisibleRows();
                    break;
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            boolean shift;
            int rows = TableTabCaret.this.table.getRowCount();
            int inputs = TableTabCaret.this.table.getInputColumnCount();
            int outputs = TableTabCaret.this.table.getOutputColumnCount();
            int cols = inputs + outputs;
            boolean bl = shift = (e.getModifiersEx() & 0x40) != 0;
            Pt p = shift ? (TableTabCaret.this.markB.isValid() ? TableTabCaret.this.markB : TableTabCaret.this.markA) : TableTabCaret.this.cursor;
            switch (e.getKeyCode()) {
                case 38: {
                    TableTabCaret.this.move(p.row - 1, p.col, shift);
                    break;
                }
                case 37: {
                    TableTabCaret.this.move(p.row, p.col - 1, shift);
                    break;
                }
                case 40: {
                    TableTabCaret.this.move(p.row + 1, p.col, shift);
                    break;
                }
                case 39: {
                    TableTabCaret.this.move(p.row, p.col + 1, shift);
                    break;
                }
                case 36: {
                    if (p.col == 0) {
                        TableTabCaret.this.move(0, 0, shift);
                        break;
                    }
                    TableTabCaret.this.move(p.row, 0, shift);
                    break;
                }
                case 35: {
                    if (p.col == cols - 1) {
                        TableTabCaret.this.move(rows - 1, cols - 1, shift);
                        break;
                    }
                    TableTabCaret.this.move(p.row, cols - 1, shift);
                    break;
                }
                case 34: {
                    rows = TableTabCaret.this.table.getBody().getVisibleRect().height / TableTabCaret.this.table.getCellHeight();
                    if (rows > 2) {
                        --rows;
                    }
                    TableTabCaret.this.move(p.row + rows, p.col, shift);
                    break;
                }
                case 33: {
                    rows = TableTabCaret.this.table.getBody().getVisibleRect().height / TableTabCaret.this.table.getCellHeight();
                    if (rows > 2) {
                        --rows;
                    }
                    TableTabCaret.this.move(TableTabCaret.this.cursor.row - rows, TableTabCaret.this.cursor.col, shift);
                    break;
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            int mask = e.getModifiersEx();
            if ((mask & 0xFFFFFFBF) != 0) {
                return;
            }
            this.doKey(e.getKeyChar());
        }

        private int[] allRowsContaining(List<Integer> indexes) {
            int n;
            TruthTable model = TableTabCaret.this.table.getTruthTable();
            int n2 = n = indexes == null ? 0 : indexes.size();
            if (n == 0) {
                return null;
            }
            int[] rows = new int[n];
            for (int i = 0; i < n; ++i) {
                rows[i] = model.findVisibleRowContaining(indexes.get(i));
            }
            Arrays.sort(rows);
            return rows;
        }

        private List<Integer> allIndexesForRowRange(int r1, int r2) {
            TruthTable model = TableTabCaret.this.table.getTruthTable();
            if (r1 < 0 || r2 < 0) {
                return null;
            }
            if (r1 > r2) {
                int t = r1;
                r1 = r2;
                r2 = t;
            }
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (int r = r1; r <= r2; ++r) {
                for (Integer idx : model.getVisibleRowIndexes(r)) {
                    indexes.add(idx);
                }
            }
            Collections.sort(indexes);
            return indexes;
        }

        void doKey(char c) {
            TableTabCaret.this.clearHilight();
            TableTabCaret.this.table.requestFocus();
            if (!TableTabCaret.this.cursor.isValid()) {
                if (!TableTabCaret.this.marked()) {
                    return;
                }
                Rectangle s = TableTabCaret.this.getSelection();
                TableTabCaret.this.cursor = new Pt(s.y, s.x);
                TableTabCaret.this.repaint(TableTabCaret.this.cursor);
                TableTabCaret.this.scrollTo(TableTabCaret.this.cursor);
            }
            TruthTable model = TableTabCaret.this.table.getTruthTable();
            int inputs = TableTabCaret.this.table.getInputColumnCount();
            Entry newEntry = null;
            int dx = 1;
            int dy = 0;
            switch (c) {
                case ' ': {
                    Entry cur;
                    if (TableTabCaret.this.cursor.col < inputs) {
                        cur = model.getVisibleInputEntry(TableTabCaret.this.cursor.row, TableTabCaret.this.cursor.col);
                        newEntry = cur == Entry.DONT_CARE ? Entry.ZERO : Entry.ONE;
                        break;
                    }
                    cur = model.getVisibleOutputEntry(TableTabCaret.this.cursor.row, TableTabCaret.this.cursor.col - inputs);
                    if (cur == Entry.ZERO) {
                        newEntry = Entry.ONE;
                        break;
                    }
                    if (cur == Entry.ONE) {
                        newEntry = Entry.DONT_CARE;
                        break;
                    }
                    newEntry = Entry.ZERO;
                    break;
                }
                case '0': 
                case 'F': 
                case 'f': {
                    newEntry = Entry.ZERO;
                    break;
                }
                case '1': 
                case 'T': 
                case 't': {
                    newEntry = Entry.ONE;
                    break;
                }
                case '-': 
                case 'X': 
                case 'x': {
                    newEntry = Entry.DONT_CARE;
                    break;
                }
                case '\n': {
                    dy = 1;
                    break;
                }
                case '\b': {
                    newEntry = Entry.DONT_CARE;
                    dx = -1;
                    break;
                }
                default: {
                    return;
                }
            }
            if (newEntry != null && TableTabCaret.this.cursor.col < inputs) {
                Pt oldCursor = TableTabCaret.this.cursor;
                Pt oldMarkA = TableTabCaret.this.markA;
                Pt oldMarkB = TableTabCaret.this.markB;
                List<Integer> oldCursorIdx = this.allIndexesForRowRange(TableTabCaret.this.cursor.row, TableTabCaret.this.cursor.row);
                List<Integer> oldMarkIdx = this.allIndexesForRowRange(TableTabCaret.this.markA.row, TableTabCaret.this.markB.row);
                boolean updated = model.setVisibleInputEntry(TableTabCaret.this.cursor.row, TableTabCaret.this.cursor.col, newEntry, true);
                if (updated) {
                    TableTabCaret.this.cursor = TableTabCaret.this.invalid;
                    int[] rows = this.allRowsContaining(oldCursorIdx);
                    if (rows != null) {
                        TableTabCaret.this.cursor = newEntry != Entry.ONE ? new Pt(rows[0], oldCursor.col) : new Pt(rows[rows.length - 1], oldCursor.col);
                        TableTabCaret.this.hilightRows = rows;
                    }
                    TableTabCaret.this.markA = TableTabCaret.this.cursor;
                    TableTabCaret.this.markB = TableTabCaret.this.invalid;
                    int[] marks = this.allRowsContaining(oldMarkIdx);
                    if (marks != null) {
                        int n = marks.length;
                        if (TableTabCaret.this.isContiguous(marks)) {
                            boolean fwd = oldMarkA.row <= oldMarkB.row;
                            TableTabCaret.this.markA = new Pt(marks[fwd ? 0 : n - 1], oldMarkA.col);
                            TableTabCaret.this.markB = new Pt(marks[fwd ? n - 1 : 0], oldMarkB.col);
                        }
                        TableTabCaret.this.hilightRows = marks;
                    }
                    TableTabCaret.this.table.repaint();
                }
            } else if (newEntry != null) {
                model.setVisibleOutputEntry(TableTabCaret.this.cursor.row, TableTabCaret.this.cursor.col - inputs, newEntry);
            }
            if (!TableTabCaret.this.markA.isValid() || !TableTabCaret.this.markB.isValid()) {
                return;
            }
            Rectangle selection = TableTabCaret.this.getSelection();
            int row = TableTabCaret.this.cursor.row;
            int col = TableTabCaret.this.cursor.col;
            if (dy > 0) {
                col = selection.x;
                if (++row >= selection.y + selection.height) {
                    row = selection.y;
                }
            } else if (dx > 0) {
                if (++col >= selection.x + selection.width) {
                    col = selection.x;
                    if (++row >= selection.y + selection.height) {
                        row = selection.y;
                    }
                }
            } else if (dx < 0 && --col < selection.x) {
                col = selection.x + selection.width - 1;
                if (--row < selection.y) {
                    row = selection.y + selection.height - 1;
                }
            }
            Pt oldCursor = TableTabCaret.this.cursor;
            TableTabCaret.this.cursor = new Pt(row, col);
            TableTabCaret.this.repaint(oldCursor, TableTabCaret.this.cursor, TableTabCaret.this.markA, TableTabCaret.this.markB);
            TableTabCaret.this.scrollTo(TableTabCaret.this.cursor);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (TableTabCaret.this.cursor.isValid() && TableTabCaret.this.cursor.col >= TableTabCaret.this.table.getInputColumnCount()) {
                TableTabCaret.this.markB = new Pt(TableTabCaret.this.table.getRowCount() - 1, TableTabCaret.this.markA.col);
                TableTabCaret.this.repaint(TableTabCaret.this.markA, TableTabCaret.this.markB);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Pt oldMarkB = TableTabCaret.this.markB;
            TableTabCaret.this.markB = this.pointNear(e);
            TableTabCaret.this.repaint(oldMarkB, TableTabCaret.this.cursor, TableTabCaret.this.markA, TableTabCaret.this.markB);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Pt oldHover = TableTabCaret.this.hover;
            TableTabCaret.this.hover = this.pointAt(e);
            TableTabCaret.this.repaint(oldHover, TableTabCaret.this.hover);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Pt oldHover = TableTabCaret.this.hover;
            TableTabCaret.this.hover = this.pointAt(e);
            TableTabCaret.this.repaint(oldHover, TableTabCaret.this.hover);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Pt oldHover = TableTabCaret.this.hover;
            TableTabCaret.this.hover = TableTabCaret.this.invalid;
            TableTabCaret.this.repaint(oldHover, TableTabCaret.this.hover);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TableTabCaret.this.table.requestFocus();
            if ((e.getModifiersEx() & 0x40) != 0) {
                this.mouseDragged(e);
            } else {
                TableTabCaret.this.setCursor(this.pointAt(e), this.pointNear(e));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseDragged(e);
        }

        @Override
        public void rowsChanged(TruthTableEvent event) {
            this.structureChanged(event);
        }

        @Override
        public void structureChanged(TruthTableEvent event) {
            TableTabCaret.this.cursor = TableTabCaret.this.invalid;
            TableTabCaret.this.markA = TableTabCaret.this.invalid;
            TableTabCaret.this.markB = TableTabCaret.this.invalid;
            TableTabCaret.this.hover = TableTabCaret.this.invalid;
            TableTabCaret.this.clearHilight();
            TableTabCaret.this.repaint(new Pt[0]);
        }

        Pt pointAt(MouseEvent e) {
            return new Pt(TableTabCaret.this.table.getRow(e), TableTabCaret.this.table.getColumn(e));
        }

        Pt pointNear(MouseEvent e) {
            return new Pt(TableTabCaret.this.table.getNearestRow(e), TableTabCaret.this.table.getNearestColumn(e));
        }
    }

    private class Pt
    implements Comparable<Pt> {
        final int row;
        final int col;

        Pt() {
            this.row = -1;
            this.col = -1;
        }

        Pt(int r, int c) {
            this.row = r;
            this.col = c;
        }

        boolean isValid() {
            return this.row >= 0 && this.col >= 0 && this.row < TableTabCaret.this.table.getRowCount() && this.col < TableTabCaret.this.table.getColumnCount();
        }

        public boolean equals(Object o) {
            boolean bl;
            if (o instanceof Pt) {
                Pt other = (Pt)o;
                bl = other.row == this.row && other.col == this.col || !other.isValid() && !this.isValid();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public int compareTo(Pt other) {
            if (!other.isValid()) {
                return !this.isValid() ? 0 : 1;
            }
            if (!this.isValid()) {
                return -1;
            }
            if (other.row != this.row) {
                return this.row - other.row;
            }
            return this.col - other.col;
        }

        public String toString() {
            return this.isValid() ? "Pt(" + this.row + ", " + this.col + ")" : "Pt(?, ?)";
        }
    }
}

