/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.model;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Entry;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.analyze.model.TruthTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JTextArea;

public class Implicant
implements Comparable<Implicant> {
    static final Implicant MINIMAL_IMPLICANT = new Implicant(0, -1);
    static final List<Implicant> MINIMAL_LIST = Collections.singletonList(MINIMAL_IMPLICANT);
    public static final int MAXIMAL_NR_OF_INPUTS_FOR_AUTO_MINIMAL_FORM = 6;
    final int unknowns;
    final int values;
    final boolean isDontCare;
    boolean isPrime = true;
    private static final CompareGenerality sortByGenerality = new CompareGenerality();

    private static int getNrOfOnes(int value, int nrOfBits) {
        int nrOfOnes = 0;
        int mask = 1;
        for (int bitIndex = 0; bitIndex < nrOfBits; ++bitIndex) {
            if ((value & mask) != 0) {
                ++nrOfOnes;
            }
            mask <<= 1;
        }
        return nrOfOnes;
    }

    private static void report(JTextArea out, String info) {
        if (out != null) {
            out.append(info);
        }
    }

    private static String getGroupRepresentation(int value, int dontCares, int nrOfBits) {
        StringBuffer result = new StringBuffer();
        for (int mask = 1 << nrOfBits - 1; mask > 0; mask >>= 1) {
            if ((dontCares & mask) != 0) {
                result.append("-");
                continue;
            }
            result.append((value & mask) != 0 ? "1" : "0");
        }
        return result.toString();
    }

    static List<Implicant> computeMinimal(int format, AnalyzerModel model, String variable, JTextArea outputArea) {
        ArrayList<Implicant> termsToRemove;
        TruthTable table = model.getTruthTable();
        int outputVariableIndex = model.getOutputs().bits.indexOf(variable);
        if (outputVariableIndex < 0) {
            return Collections.emptyList();
        }
        Entry desiredTerm = format == 0 ? Entry.ONE : Entry.ZERO;
        Entry skippedTerm = desiredTerm == Entry.ONE ? Entry.ZERO : Entry.ONE;
        int nrOfInputs = table.getInputColumnCount();
        HashSet<Integer> oneHotTable = new HashSet<Integer>();
        int mask = 1;
        for (int bitIndex = 0; bitIndex < nrOfInputs; ++bitIndex) {
            oneHotTable.add(mask);
            mask <<= 1;
        }
        HashMap<Implicant, HashSet> primes = new HashMap<Implicant, HashSet>();
        ArrayList<Implicant> essentialPrimes = new ArrayList<Implicant>();
        HashMap currentTable = new HashMap();
        HashMap newTable = new HashMap();
        HashMap termsToCover = new HashMap();
        boolean allDontCare = true;
        for (int inputCombination = 0; inputCombination < table.getRowCount(); ++inputCombination) {
            Entry term = table.getOutputEntry(inputCombination, outputVariableIndex);
            if (term == skippedTerm) {
                allDontCare = false;
                continue;
            }
            int nrOfOnes = Implicant.getNrOfOnes(inputCombination, nrOfInputs);
            boolean isDontCare = term != desiredTerm;
            Implicant implicant = new Implicant(inputCombination, isDontCare);
            HashSet<Implicant> implicantsSet = new HashSet<Implicant>();
            if (!isDontCare) {
                termsToCover.put(implicant, new ArrayList());
                implicantsSet.add(implicant);
                allDontCare = false;
            }
            if (!newTable.containsKey(nrOfOnes)) {
                newTable.put(nrOfOnes, new HashMap());
            }
            ((HashMap)newTable.get(nrOfOnes)).put(implicant, implicantsSet);
        }
        if (allDontCare) {
            return Collections.emptyList();
        }
        if (nrOfInputs > 6 && outputArea == null) {
            return Collections.emptyList();
        }
        Implicant.report(outputArea, String.format("\n%s\n", Strings.S.fmt("implicantOutputName", variable)));
        boolean couldMerge = false;
        int groupSize = 2;
        do {
            Implicant.report(outputArea, String.format("\n%s", Strings.S.fmt("implicantGroupSize", groupSize)));
            long nrOfPrimes = 0L;
            couldMerge = false;
            currentTable.clear();
            currentTable.putAll(newTable);
            newTable.clear();
            int minimalKey = Integer.MAX_VALUE;
            int maximalKey = 0;
            for (Object key2 : currentTable.keySet()) {
                if ((Integer)key2 < minimalKey) {
                    minimalKey = (Integer)key2;
                }
                if ((Integer)key2 <= maximalKey) continue;
                maximalKey = (Integer)key2;
            }
            for (int key = minimalKey; key < maximalKey; ++key) {
                Object key2;
                if (!currentTable.containsKey(key) || !currentTable.containsKey(key + 1)) continue;
                key2 = ((HashMap)currentTable.get(key)).keySet().iterator();
                while (key2.hasNext()) {
                    Implicant termGroup1 = (Implicant)key2.next();
                    for (Implicant termGroup2 : ((HashMap)currentTable.get(key + 1)).keySet()) {
                        int n;
                        if (termGroup1.unknowns != termGroup2.unknowns || !oneHotTable.contains(n = termGroup1.values ^ termGroup2.values)) continue;
                        int dontCareMask = termGroup1.unknowns | n;
                        int newValue = (termGroup1.values & n) == 0 ? termGroup1.values : termGroup2.values;
                        boolean isDontCareGroup = termGroup1.isDontCare && termGroup2.isDontCare;
                        Implicant newImplicant = new Implicant(dontCareMask, newValue, isDontCareGroup);
                        HashSet newImplicantTerms = new HashSet();
                        couldMerge = true;
                        termGroup2.isPrime = false;
                        termGroup1.isPrime = false;
                        newImplicantTerms.addAll((Collection)((HashMap)currentTable.get(key)).get(termGroup1));
                        newImplicantTerms.addAll((Collection)((HashMap)currentTable.get(key + 1)).get(termGroup2));
                        boolean found = false;
                        if (newTable.containsKey(key)) {
                            for (Implicant implicant : ((HashMap)newTable.get(key)).keySet()) {
                                found |= implicant.values == newValue && implicant.unknowns == dontCareMask;
                            }
                            if (found) continue;
                            ((HashMap)newTable.get(key)).put(newImplicant, newImplicantTerms);
                            continue;
                        }
                        newTable.put(key, new HashMap());
                        ((HashMap)newTable.get(key)).put(newImplicant, newImplicantTerms);
                    }
                }
            }
            for (Iterator key : currentTable.keySet()) {
                for (Implicant implicant : ((HashMap)currentTable.get(key)).keySet()) {
                    if (!implicant.isPrime || implicant.isDontCare) continue;
                    primes.put(implicant, (HashSet)((HashMap)currentTable.get(key)).get(implicant));
                    if (nrOfPrimes % 16L == 0L) {
                        Implicant.report(outputArea, "\n");
                    }
                    Implicant.report(outputArea, String.format("%s ", Implicant.getGroupRepresentation(implicant.values, implicant.unknowns, nrOfInputs)));
                    ++nrOfPrimes;
                }
            }
            if (nrOfPrimes == 0L) {
                Implicant.report(outputArea, String.format("\n%s", Strings.S.get("implicantNoneFound")));
            }
            groupSize <<= 1;
        } while (couldMerge);
        for (Implicant prime : primes.keySet()) {
            for (Implicant term : termsToCover.keySet()) {
                if (!((HashSet)primes.get(prime)).contains(term)) continue;
                ((ArrayList)termsToCover.get(term)).add(prime);
            }
        }
        boolean couldDoRowReduction = false;
        boolean couldDoColumnReduction = false;
        Implicant.report(outputArea, String.format("\n%s", Strings.S.get("implicantColumRowReduction")));
        long nrEssentialPrimes = 0L;
        do {
            Object prime;
            couldDoRowReduction = false;
            couldDoColumnReduction = false;
            termsToRemove = new ArrayList<Implicant>();
            for (Implicant term : termsToCover.keySet()) {
                ArrayList termInfo = (ArrayList)termsToCover.get(term);
                if (termInfo.size() != 1 || !primes.containsKey(prime = (Implicant)termInfo.get(0))) continue;
                for (Implicant terms : (HashSet)primes.get(prime)) {
                    for (Implicant currentPrime : primes.keySet()) {
                        if (currentPrime.equals(prime)) continue;
                        couldDoColumnReduction |= ((HashSet)primes.get(currentPrime)).contains(terms);
                        ((HashSet)primes.get(currentPrime)).remove(terms);
                    }
                    termsToRemove.add(terms);
                }
                essentialPrimes.add((Implicant)prime);
                primes.remove(prime);
                if (nrEssentialPrimes++ % 16L == 0L) {
                    Implicant.report(outputArea, "\n");
                }
                Implicant.report(outputArea, String.format(" %s", Implicant.getGroupRepresentation(((Implicant)prime).values, ((Implicant)prime).unknowns, nrOfInputs)));
            }
            for (Implicant term : termsToRemove) {
                termsToCover.remove(term);
            }
            HashSet<Implicant> primesToRemove = new HashSet<Implicant>();
            HashMap primeHierarchy = new HashMap();
            ArrayList<Integer> nrOfElementGroups = new ArrayList<Integer>();
            prime = primes.keySet().iterator();
            while (prime.hasNext()) {
                Implicant implicant = (Implicant)prime.next();
                HashSet primeElements = (HashSet)primes.get(implicant);
                if (primeElements.isEmpty()) {
                    primesToRemove.add(implicant);
                    couldDoRowReduction = true;
                    continue;
                }
                int nrOfElements = primeElements.size();
                if (!primeHierarchy.containsKey(nrOfElements)) {
                    primeHierarchy.put(nrOfElements, new HashSet());
                }
                ((HashSet)primeHierarchy.get(nrOfElements)).add(implicant);
                if (nrOfElementGroups.contains(nrOfElements)) continue;
                nrOfElementGroups.add(nrOfElements);
            }
            Collections.sort(nrOfElementGroups);
            if (!nrOfElementGroups.isEmpty()) {
                for (int mergeGroupId = nrOfElementGroups.size() - 1; mergeGroupId > 0; --mergeGroupId) {
                    for (Implicant bigPrime : (HashSet)primeHierarchy.get(nrOfElementGroups.get(mergeGroupId))) {
                        if (primesToRemove.contains(bigPrime)) continue;
                        for (int checkGroupId = mergeGroupId - 1; checkGroupId >= 0; --checkGroupId) {
                            for (Implicant smallPrime : (HashSet)primeHierarchy.get(nrOfElementGroups.get(checkGroupId))) {
                                if (primesToRemove.contains(smallPrime) || !((HashSet)primes.get(bigPrime)).containsAll((Collection)primes.get(smallPrime))) continue;
                                couldDoRowReduction = true;
                                primesToRemove.add(smallPrime);
                            }
                        }
                    }
                }
            }
            for (Implicant implicant : primesToRemove) {
                primes.remove(implicant);
                for (Implicant element : termsToCover.keySet()) {
                    ((ArrayList)termsToCover.get(element)).remove(implicant);
                }
            }
        } while (couldDoRowReduction || couldDoColumnReduction);
        if (!termsToCover.isEmpty()) {
            Implicant.report(outputArea, String.format("\n\n ", Strings.S.get("implicantGreedy")));
        }
        nrEssentialPrimes = 0L;
        while (!termsToCover.isEmpty()) {
            termsToRemove = new ArrayList();
            for (Implicant term : termsToCover.keySet()) {
                if (termsToRemove.contains(term)) continue;
                Implicant group = (Implicant)((ArrayList)termsToCover.get(term)).get(0);
                essentialPrimes.add(group);
                if (nrEssentialPrimes++ % 16L == 0L) {
                    Implicant.report(outputArea, "\n");
                }
                Implicant.report(outputArea, String.format(" %s", Implicant.getGroupRepresentation(group.values, group.unknowns, nrOfInputs)));
                termsToRemove.addAll((Collection)primes.get(group));
            }
            for (Implicant term : termsToRemove) {
                termsToCover.remove(term);
            }
        }
        return essentialPrimes;
    }

    public static Expression toExpression(int format, AnalyzerModel model, List<Implicant> implicants) {
        if (implicants == null) {
            return null;
        }
        TruthTable table = model.getTruthTable();
        if (format == 1) {
            Expression product = null;
            for (Implicant implicant : implicants) {
                product = Expressions.and(product, implicant.toSum(table));
            }
            return product == null ? Expressions.constant(1) : product;
        }
        Expression sum = null;
        for (Implicant implicant : implicants) {
            sum = Expressions.or(sum, implicant.toProduct(table));
        }
        return sum == null ? Expressions.constant(0) : sum;
    }

    private Implicant(int unknowns, int values) {
        this.unknowns = unknowns;
        this.values = values;
        this.isDontCare = false;
    }

    private Implicant(int unknowns, int values, boolean dontCareTerm) {
        this.unknowns = unknowns;
        this.values = values;
        this.isDontCare = dontCareTerm;
    }

    private Implicant(int values, boolean dontCareTerm) {
        this.unknowns = 0;
        this.values = values;
        this.isDontCare = dontCareTerm;
    }

    @Override
    public int compareTo(Implicant o) {
        if (this.values < o.values) {
            return -1;
        }
        if (this.values > o.values) {
            return 1;
        }
        return Integer.compare(this.unknowns, o.unknowns);
    }

    public boolean equals(Object other) {
        boolean bl;
        if (other instanceof Implicant) {
            Implicant o = (Implicant)other;
            bl = this.unknowns == o.unknowns && this.values == o.values;
        } else {
            bl = false;
        }
        return bl;
    }

    public int getRow() {
        return this.unknowns != 0 ? -1 : this.values;
    }

    public Iterable<Implicant> getTerms() {
        return new TermIterator(this);
    }

    public int getUnknownCount() {
        int ret = 0;
        int n = this.unknowns;
        while (n != 0) {
            n &= n - 1;
            ++ret;
        }
        return ret;
    }

    public int hashCode() {
        return this.unknowns << 16 | this.values;
    }

    public Expression toProduct(TruthTable source) {
        Expression term = null;
        int cols = source.getInputColumnCount();
        for (int i = cols - 1; i >= 0; --i) {
            if ((this.unknowns & 1 << i) != 0) continue;
            Expression literal = Expressions.variable(source.getInputHeader(cols - 1 - i));
            if ((this.values & 1 << i) == 0) {
                literal = Expressions.not(literal);
            }
            term = Expressions.and(term, literal);
        }
        return term == null ? Expressions.constant(1) : term;
    }

    public Expression toSum(TruthTable source) {
        Expression term = null;
        int cols = source.getInputColumnCount();
        for (int i = cols - 1; i >= 0; --i) {
            if ((this.unknowns & 1 << i) != 0) continue;
            Expression literal = Expressions.variable(source.getInputHeader(cols - 1 - i));
            if ((this.values & 1 << i) != 0) {
                literal = Expressions.not(literal);
            }
            term = Expressions.or(term, literal);
        }
        return term == null ? Expressions.constant(1) : term;
    }

    static SortedMap<Implicant, String> computePartition(AnalyzerModel model) {
        TruthTable table = model.getTruthTable();
        int maxval = (1 << table.getInputColumnCount()) - 1;
        HashMap<String, HashSet> regions = new HashMap<String, HashSet>();
        for (int i = 0; i < table.getVisibleRowCount(); ++i) {
            String val = table.getVisibleOutputs(i);
            int idx = table.getVisibleRowIndex(i);
            int dc = table.getVisibleRowDcMask(i);
            Implicant imp = new Implicant(dc, idx);
            HashSet region = regions.computeIfAbsent(val, k -> new HashSet());
            region.add(imp);
        }
        TreeMap<Implicant, String> ret = new TreeMap<Implicant, String>();
        for (Map.Entry it : regions.entrySet()) {
            String val = (String)it.getKey();
            HashSet<Implicant> base = (HashSet<Implicant>)it.getValue();
            HashSet<Implicant> all = new HashSet<Implicant>();
            HashSet<Implicant> current = base;
            while (!current.isEmpty()) {
                HashSet<Implicant> next = new HashSet<Implicant>();
                for (Implicant implicant : current) {
                    all.add(implicant);
                    for (int j = 1; j <= maxval; j *= 2) {
                        Implicant opp;
                        if ((implicant.unknowns & j) != 0 || !all.contains(opp = new Implicant(implicant.unknowns, implicant.values ^ j))) continue;
                        Implicant i = new Implicant(opp.unknowns | j, opp.values);
                        next.add(i);
                    }
                }
                current = next;
            }
            ArrayList<Implicant> sorted = new ArrayList<Implicant>(all);
            sorted.sort(sortByGenerality);
            ArrayList<Implicant> chosen = new ArrayList<Implicant>();
            for (Implicant implicant : sorted) {
                if (!Implicant.disjoint(implicant, chosen)) continue;
                chosen.add(implicant);
                ret.put(implicant, val);
            }
        }
        return ret;
    }

    private static boolean disjoint(Implicant imp, ArrayList<Implicant> chosen) {
        for (Implicant other : chosen) {
            int dc = imp.unknowns | other.unknowns;
            if ((imp.values & ~dc) != (other.values & ~dc)) continue;
            return false;
        }
        return true;
    }

    private static class TermIterator
    implements Iterable<Implicant>,
    Iterator<Implicant> {
        final Implicant source;
        int currentMask = 0;

        TermIterator(Implicant source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.currentMask >= 0;
        }

        @Override
        public Iterator<Implicant> iterator() {
            return this;
        }

        @Override
        public Implicant next() {
            int ret = this.currentMask | this.source.values;
            int diffs = this.currentMask ^ this.source.unknowns;
            int diff = diffs ^ diffs - 1 & diffs;
            this.currentMask = diff == 0 ? -1 : this.currentMask & -diff | diff;
            return new Implicant(0, ret);
        }

        @Override
        public void remove() {
        }
    }

    private static class CompareGenerality
    implements Comparator<Implicant> {
        private CompareGenerality() {
        }

        @Override
        public int compare(Implicant i1, Implicant i2) {
            int diff = i2.getUnknownCount() - i1.getUnknownCount();
            if (diff != 0) {
                return diff;
            }
            return (i1.values & ~i1.unknowns) - (i2.values & ~i2.unknowns);
        }
    }
}

