/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.model;

import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Entry;
import com.cburch.logisim.analyze.model.Implicant;
import com.cburch.logisim.analyze.model.TruthTableEvent;
import com.cburch.logisim.analyze.model.TruthTableListener;
import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.analyze.model.VariableListEvent;
import com.cburch.logisim.analyze.model.VariableListListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public class TruthTable {
    private static final Entry DEFAULT_ENTRY = Entry.DONT_CARE;
    private final MyListener myListener = new MyListener();
    private final List<TruthTableListener> listeners = new ArrayList<TruthTableListener>();
    private final AnalyzerModel model;
    private ArrayList<Row> rows = new ArrayList();
    private final ArrayList<Entry[]> columns = new ArrayList();
    private static final CompareInputs sortByInputs = new CompareInputs();

    private void initRows() {
        int inputs = this.getInputColumnCount();
        int n = this.getRowCount();
        this.rows.clear();
        this.rows.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            this.rows.add(new Row(i, inputs, 0));
        }
    }

    private void initColumns() {
        int outputs = this.getOutputColumnCount();
        this.columns.clear();
        this.columns.ensureCapacity(outputs);
        for (int i = 0; i < outputs; ++i) {
            this.columns.add(null);
        }
    }

    public TruthTable(AnalyzerModel model) {
        this.model = model;
        this.initRows();
        this.initColumns();
        model.getInputs().addVariableListListener(this.myListener);
        model.getOutputs().addVariableListListener(this.myListener);
    }

    public void expandVisibleRows() {
        if (this.getVisibleRowCount() == this.getRowCount()) {
            return;
        }
        this.initRows();
        this.fireRowsChanged();
    }

    public void compactVisibleRows() {
        SortedMap<Implicant, String> partition = Implicant.computePartition(this.model);
        this.rows.clear();
        this.initColumns();
        int ni = this.getInputColumnCount();
        int no = this.getOutputColumnCount();
        for (Map.Entry<Implicant, String> it : partition.entrySet()) {
            Implicant imp = it.getKey();
            String val = it.getValue();
            Row r = new Row(imp.values, ni, imp.unknowns);
            this.rows.add(r);
            for (int col = 0; col < no; ++col) {
                Entry value = Entry.parse("" + val.charAt(col));
                Entry[] column = this.columns.get(col);
                if (column == null && value == DEFAULT_ENTRY) continue;
                if (column == null) {
                    column = this.getOutputColumn(col);
                }
                for (Integer idx : r) {
                    column[idx.intValue()] = value;
                }
            }
        }
        this.fireRowsChanged();
        for (int col = 0; col < no; ++col) {
            if (this.columns.get(col) == null) continue;
            this.fireCellsChanged(col);
        }
    }

    public void setOutputColumn(int col, Entry[] values) {
        if (values.length != this.getRowCount()) {
            throw new IllegalArgumentException("bad column length");
        }
        Entry[] oldValues = this.columns.set(col, values);
        if (oldValues == values) {
            return;
        }
        boolean rowsChanged = false;
        for (int i = this.rows.size() - 1; i >= 0; --i) {
            Row r = this.rows.get(i);
            int base = r.baseIndex();
            Entry v = values[base];
            boolean split = true;
            block1: while (split) {
                split = false;
                for (Integer idx : r) {
                    if (v == values[idx]) continue;
                    this.splitRow(r, idx);
                    rowsChanged = true;
                    split = true;
                    continue block1;
                }
            }
        }
        if (rowsChanged) {
            this.fireRowsChanged();
        }
        this.fireCellsChanged(col);
    }

    void splitRow(Row r, int idx) {
        int base = r.baseIndex();
        if (idx == base || !r.contains(idx)) {
            throw new IllegalArgumentException("bad row split");
        }
        int diff = idx ^ base;
        int n = r.duplicity();
        if (n <= 1) {
            throw new IllegalStateException("row duplicity should be at least 2");
        }
        Row splits = new Row(base, r.inputs.length, diff);
        int m = 0;
        this.rows.remove(r);
        for (Integer other : splits) {
            Row s = new Row(other, r.inputs.length, r.dcMask() & ~diff);
            m += s.duplicity();
            int pos = Collections.binarySearch(this.rows, s, sortByInputs);
            if (pos < 0) {
                this.rows.add(-pos - 1, s);
                continue;
            }
            throw new IllegalStateException("unexpected row split");
        }
        if (m != n) {
            throw new IllegalStateException("assertion failed in row split");
        }
    }

    public Entry getVisibleOutputEntry(int row, int col) {
        Row r = this.rows.get(row);
        int idx = r.baseIndex();
        return this.getOutputEntry(idx, col);
    }

    public Entry getOutputEntry(int idx, int col) {
        if (idx < 0 || col < 0) {
            return DEFAULT_ENTRY;
        }
        Entry[] column = this.columns.get(col);
        return column == null ? DEFAULT_ENTRY : (idx < column.length ? column[idx] : DEFAULT_ENTRY);
    }

    public String getVisibleOutputs(int row) {
        Row r = this.rows.get(row);
        int idx = r.baseIndex();
        StringBuilder s = new StringBuilder();
        for (Entry[] column : this.columns) {
            s.append((column == null ? DEFAULT_ENTRY : column[idx]).getDescription());
        }
        return s.toString();
    }

    public Entry getVisibleInputEntry(int row, int col) {
        Row r = this.rows.get(row);
        return r.inputs[col];
    }

    public int getVisibleRowDcMask(int row) {
        Row r = this.rows.get(row);
        return r.dcMask();
    }

    public int getVisibleRowIndex(int row) {
        Row r = this.rows.get(row);
        return r.baseIndex();
    }

    public Iterable<Integer> getVisibleRowIndexes(int row) {
        return this.rows.get(row);
    }

    public Entry getInputEntry(int idx, int col) {
        if (idx < 0 || idx >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("bad row index");
        }
        int inputs = this.getInputColumnCount();
        if (col < 0 || col >= inputs) {
            throw new IndexOutOfBoundsException("bad input column index");
        }
        return TruthTable.isInputSet(idx, col, inputs) ? Entry.ONE : Entry.ZERO;
    }

    public static boolean isInputSet(int idx, int col, int inputs) {
        return (idx & 1 << inputs - col - 1) != 0;
    }

    public Entry[] getOutputColumn(int col) {
        Object[] column = this.columns.get(col);
        if (column == null) {
            if (col < 0 || col >= this.getOutputColumnCount()) {
                throw new IndexOutOfBoundsException("bad output column index");
            }
            column = new Entry[this.getRowCount()];
            Arrays.fill(column, DEFAULT_ENTRY);
            this.columns.set(col, (Entry[])column);
        }
        return column;
    }

    private boolean identicalOutputs(int idx1, int idx2) {
        if (idx1 == idx2) {
            return true;
        }
        for (Entry[] column : this.columns) {
            if (column == null || column[idx1] == column[idx2]) continue;
            return false;
        }
        return true;
    }

    private void mergeOutputs(int idx1, int idx2, boolean[] changed) {
        if (idx1 == idx2) {
            return;
        }
        for (int col = 0; col < this.columns.size(); ++col) {
            Entry[] column = this.columns.get(col);
            if (column == null || column[idx1] == column[idx2]) continue;
            column[idx2] = column[idx1];
            changed[col] = true;
        }
    }

    private boolean setDontCare(Row r, int dc, boolean force, boolean[] changed) {
        Row newRow = new Row(r.baseIndex(), r.inputs.length, r.dcMask() | dc);
        int base = newRow.baseIndex();
        if (!force) {
            for (Integer idx : newRow) {
                if (this.identicalOutputs(base, idx)) continue;
                return false;
            }
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = this.rows.get(i);
            if (!newRow.intersects(row)) continue;
            if (newRow.contains(row)) {
                for (Integer idx : row) {
                    this.mergeOutputs(base, idx, changed);
                }
                this.rows.remove(i);
            } else {
                int pos;
                for (pos = row.inputs.length - 1; pos >= 0 && (row.inputs[pos] != Entry.DONT_CARE || newRow.inputs[pos] == Entry.DONT_CARE); --pos) {
                }
                if (pos < 0) {
                    throw new IllegalStateException("failed row merge");
                }
                int bit = 1 << row.inputs.length - 1 - pos;
                this.splitRow(row, row.baseIndex() ^ bit);
            }
            --i;
        }
        int pos = Collections.binarySearch(this.rows, newRow, sortByInputs);
        if (pos >= 0) {
            throw new IllegalStateException("failed row merge");
        }
        this.rows.add(-pos - 1, newRow);
        return true;
    }

    public boolean setVisibleInputEntry(int row, int col, Entry value, boolean force) {
        Row r = this.rows.get(row);
        if (r.inputs[col] == value) {
            return false;
        }
        int dc = 1 << r.inputs.length - 1 - col;
        if (value == Entry.DONT_CARE) {
            boolean[] changed = new boolean[this.columns.size()];
            if (!this.setDontCare(r, dc, force, changed)) {
                return false;
            }
            this.fireRowsChanged();
            for (int ocol = 0; ocol < this.columns.size(); ++ocol) {
                if (!changed[ocol]) continue;
                this.fireCellsChanged(ocol);
            }
            return true;
        }
        if (value == Entry.ONE || value == Entry.ZERO) {
            if (r.inputs[col] != Entry.DONT_CARE) {
                return false;
            }
            this.splitRow(r, r.baseIndex() | dc);
            this.fireRowsChanged();
            return true;
        }
        throw new IllegalArgumentException("invalid input entry");
    }

    public void setVisibleOutputEntry(int row, int col, Entry value) {
        Row r = this.rows.get(row);
        Entry[] column = this.columns.get(col);
        if (column == null && value == DEFAULT_ENTRY) {
            return;
        }
        if (column == null) {
            column = this.getOutputColumn(col);
        }
        boolean changed = false;
        for (Integer idx : r) {
            if (column[idx] == value) continue;
            changed = true;
            column[idx.intValue()] = value;
        }
        if (changed) {
            this.fireCellsChanged(col);
        }
    }

    Row findRow(int idx) {
        for (int i = this.rows.size() - 1; i >= 0; --i) {
            Row r = this.rows.get(i);
            if (!r.contains(idx)) continue;
            return r;
        }
        throw new IllegalStateException("missing row");
    }

    public int findVisibleRowContaining(int idx) {
        for (int i = this.rows.size() - 1; i >= 0; --i) {
            Row r = this.rows.get(i);
            if (!r.contains(idx)) continue;
            return i;
        }
        throw new IllegalStateException("missing row");
    }

    public void setVisibleRows(List<Entry[]> newEntries, boolean force) {
        int i;
        int ni = this.getInputColumnCount();
        int no = this.getOutputColumnCount();
        ArrayList<Row> newRows = new ArrayList<Row>(newEntries.size());
        for (Entry[] values : newEntries) {
            if (values.length != ni + no) {
                throw new IllegalArgumentException("wrong column count");
            }
            newRows.add(new Row(values, ni));
        }
        List<Var> ivars = this.getInputVariables();
        int[] taken = new int[this.getRowCount()];
        for (i = 0; i < newRows.size(); ++i) {
            Row r = (Row)newRows.get(i);
            for (Integer idx : r) {
                if (taken[idx] != 0 && !force) {
                    throw new IllegalArgumentException(String.format("Some inputs are repeated. For example, rows %d and %d have overlapping input values %s and %s.", taken[idx], i + 1, ((Row)newRows.get(taken[idx] - 1)).toBitString(ivars), r.toBitString(ivars)));
                }
                if (taken[idx] != 0) {
                    throw new IllegalArgumentException("Sorry, this error can't yet be fixed. Eliminate duplicate rows then try again.");
                }
                taken[idx.intValue()] = i + 1;
            }
        }
        for (i = 0; i < this.getRowCount(); ++i) {
            if (taken[i] == 0 && !force) {
                throw new IllegalArgumentException(String.format("Some inputs are missing. For example, there is no row for input %s.", new Row(i, ni, 0).toBitString(ivars)));
            }
            if (taken[i] != 0) continue;
            newRows.add(new Row(i, ni, 0));
        }
        newRows.sort(sortByInputs);
        this.rows.clear();
        this.rows = newRows;
        this.initColumns();
        for (Entry[] values : newEntries) {
            Row r = new Row(values, ni);
            for (int col = 0; col < no; ++col) {
                Entry value = values[ni + col];
                Entry[] column = this.columns.get(col);
                if (column == null && value == DEFAULT_ENTRY) continue;
                if (column == null) {
                    column = this.getOutputColumn(col);
                }
                for (Integer idx : r) {
                    column[idx.intValue()] = value;
                }
            }
        }
        this.fireRowsChanged();
        for (int col = 0; col < no; ++col) {
            if (this.columns.get(col) == null) continue;
            this.fireCellsChanged(col);
        }
    }

    public void setOutputEntry(int idx, int col, Entry value) {
        Entry[] column = this.columns.get(col);
        if (column == null && value == DEFAULT_ENTRY) {
            return;
        }
        if (column == null) {
            column = this.getOutputColumn(col);
        }
        if (column[idx] == value) {
            return;
        }
        column[idx] = value;
        Row r = this.findRow(idx);
        if (r.duplicity() > 1) {
            this.splitRow(r, idx);
            this.fireRowsChanged();
        }
        this.fireCellsChanged(col);
    }

    public void addTruthTableListener(TruthTableListener l) {
        this.listeners.add(l);
    }

    public void removeTruthTableListener(TruthTableListener l) {
        this.listeners.remove(l);
    }

    private void fireRowsChanged() {
        TruthTableEvent event = new TruthTableEvent(this, null);
        for (TruthTableListener l : this.listeners) {
            l.rowsChanged(event);
        }
    }

    private void fireCellsChanged(int col) {
        TruthTableEvent event = new TruthTableEvent(this, col);
        for (TruthTableListener l : this.listeners) {
            l.cellsChanged(event);
        }
    }

    private void fireStructureChanged(VariableListEvent cause) {
        TruthTableEvent event = new TruthTableEvent(this, cause);
        for (TruthTableListener l : this.listeners) {
            l.structureChanged(event);
        }
    }

    public String getInputHeader(int col) {
        return this.model.getInputs().bits.get(col);
    }

    public String getOutputHeader(int col) {
        return this.model.getOutputs().bits.get(col);
    }

    public int getInputIndex(String input) {
        return this.model.getInputs().bits.indexOf(input);
    }

    public int getOutputIndex(String output) {
        return this.model.getOutputs().bits.indexOf(output);
    }

    public List<Var> getInputVariables() {
        return this.model.getInputs().vars;
    }

    public List<Var> getOutputVariables() {
        return this.model.getOutputs().vars;
    }

    public Var getInputVariable(int index) {
        return this.model.getInputs().vars.get(index);
    }

    public Var getOutputVariable(int index) {
        return this.model.getOutputs().vars.get(index);
    }

    public int getInputColumnCount() {
        return this.model.getInputs().bits.size();
    }

    public int getOutputColumnCount() {
        return this.model.getOutputs().bits.size();
    }

    public int getRowCount() {
        return 1 << this.model.getInputs().bits.size();
    }

    public int getVisibleRowCount() {
        return this.rows.size();
    }

    private static class Row
    implements Iterable<Integer> {
        final Entry[] inputs;

        Row(int idx, int numInputs, int mask) {
            this.inputs = new Entry[numInputs];
            for (int i = numInputs - 1; i >= 0; --i) {
                this.inputs[i] = (mask & 1) == 0 ? ((idx & 1) == 0 ? Entry.ZERO : Entry.ONE) : Entry.DONT_CARE;
                idx >>= 1;
                mask >>= 1;
            }
        }

        Row(Entry[] entries, int numInputs) {
            this.inputs = new Entry[numInputs];
            System.arraycopy(entries, 0, this.inputs, 0, numInputs);
        }

        public int baseIndex() {
            int idx = 0;
            for (Entry input : this.inputs) {
                idx = idx << 1 | (input == Entry.ONE ? 1 : 0);
            }
            return idx;
        }

        public int dcMask() {
            int mask = 0;
            for (Entry input : this.inputs) {
                mask = mask << 1 | (input == Entry.DONT_CARE ? 1 : 0);
            }
            return mask;
        }

        public int duplicity() {
            int count = 1;
            for (Entry input : this.inputs) {
                count *= input == Entry.DONT_CARE ? 2 : 1;
            }
            return count;
        }

        public String toString() {
            StringBuilder s = new StringBuilder("row[");
            for (int i = 0; i < this.inputs.length; ++i) {
                if (i != 0) {
                    s.append(" ");
                }
                s.append(this.inputs[i].getDescription());
            }
            s.append("]");
            s.append(" dup=").append(this.duplicity());
            s.append(String.format(" base=%x dcmask=%x", this.baseIndex(), this.dcMask()));
            return s.toString();
        }

        public String toBitString(List<Var> vars) {
            StringBuilder s = new StringBuilder();
            int i = 0;
            for (Var variable : vars) {
                s.append(" ");
                for (int j = 0; j < variable.width; ++j) {
                    s.append(this.inputs[i++].toBitString());
                }
            }
            return s.toString();
        }

        public boolean contains(int idx) {
            return (idx & ~this.dcMask()) == this.baseIndex();
        }

        public boolean contains(Row other) {
            return this.contains(other.baseIndex()) && (other.dcMask() & ~this.dcMask()) == 0;
        }

        public boolean intersects(Row other) {
            int dc = this.dcMask() | other.dcMask();
            return (other.baseIndex() & ~dc) == (this.baseIndex() & ~dc);
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                final int base;
                final int mask;
                final int nbits;
                final int count;
                int iter;
                {
                    this.base = this.baseIndex();
                    this.mask = this.dcMask();
                    this.nbits = inputs.length;
                    this.count = this.duplicity();
                    this.iter = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.iter < this.count;
                }

                @Override
                public Integer next() {
                    int add = this.iter;
                    int keep = 0;
                    for (int b = 0; b < this.nbits; ++b) {
                        if ((this.mask & 1 << b) == 0) {
                            add = (add & ~keep) << 1 | add & keep;
                        }
                        keep |= 1 << b;
                    }
                    ++this.iter;
                    return this.base | add;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class MyListener
    implements VariableListListener {
        private MyListener() {
        }

        @Override
        public void listChanged(VariableListEvent event) {
            if (event.getSource() == TruthTable.this.model.getInputs()) {
                this.inputsChanged(event);
                for (int col = 0; col < TruthTable.this.columns.size(); ++col) {
                    Entry[] column = TruthTable.this.columns.get(col);
                    if (column == null) continue;
                    column = this.inputsChangedForOutput(column, event);
                    TruthTable.this.columns.set(col, column);
                }
                TruthTable.this.fireRowsChanged();
            } else {
                this.outputsChanged(event);
            }
            TruthTable.this.fireStructureChanged(event);
        }

        private void outputsChanged(VariableListEvent event) {
            block13: {
                int action;
                Var v;
                block15: {
                    int newIndex;
                    Integer delta;
                    block16: {
                        block14: {
                            block12: {
                                v = event.getVariable();
                                action = event.getType();
                                if (action != 0) break block12;
                                TruthTable.this.initColumns();
                                break block13;
                            }
                            if (action != 1) break block14;
                            Integer bitIndex = event.getBitIndex();
                            for (int b = v.width - 1; b >= 0; --b) {
                                TruthTable.this.columns.add(bitIndex - b, null);
                            }
                            break block13;
                        }
                        if (action != 3) break block15;
                        delta = event.getBitIndex();
                        newIndex = TruthTable.this.getOutputIndex(v.bitName(0));
                        if (delta <= 0) break block16;
                        for (int b = 0; b < v.width; ++b) {
                            Entry[] column = TruthTable.this.columns.remove(newIndex - delta - b);
                            TruthTable.this.columns.add(newIndex - b, column);
                        }
                        break block13;
                    }
                    if (delta >= 0) break block13;
                    for (int b = v.width - 1; b >= 0; --b) {
                        Entry[] column = TruthTable.this.columns.remove(newIndex - delta - b);
                        TruthTable.this.columns.add(newIndex - b, column);
                    }
                    break block13;
                }
                if (action == 2) {
                    Integer bitIndex = event.getBitIndex();
                    for (int b = 0; b < v.width; ++b) {
                        TruthTable.this.columns.remove(bitIndex - b);
                    }
                } else if (action == 4) {
                    Integer bitIndex = event.getBitIndex();
                    Var newVar = TruthTable.this.getOutputVariable(event.getIndex());
                    int lost = v.width - newVar.width;
                    int pos = bitIndex + 1 - v.width;
                    if (lost > 0) {
                        while (lost-- != 0) {
                            TruthTable.this.columns.remove(pos);
                        }
                    } else if (lost < 0) {
                        while (lost++ != 0) {
                            TruthTable.this.columns.add(pos, null);
                        }
                    }
                }
            }
        }

        private void inputsChanged(VariableListEvent event) {
            Var v = event.getVariable();
            int action = event.getType();
            if (action == 1) {
                Integer bitIndex = event.getBitIndex();
                int oldCount = TruthTable.this.getInputColumnCount() - v.width;
                for (int b = v.width - 1; b >= 0; --b) {
                    this.addInput(bitIndex - b, oldCount++);
                }
            } else if (action == 2) {
                Integer bitIndex = event.getBitIndex();
                int oldCount = TruthTable.this.getInputColumnCount() + v.width;
                for (int b = 0; b < v.width; ++b) {
                    this.removeInput(bitIndex - b, oldCount--);
                }
            } else if (action == 3) {
                Integer delta = event.getBitIndex();
                int newIndex = TruthTable.this.getInputIndex(v.bitName(0));
                if (delta > 0) {
                    for (int b = 0; b < v.width; ++b) {
                        this.moveInput(newIndex - delta - b, newIndex - b);
                    }
                } else if (delta < 0) {
                    for (int b = v.width - 1; b >= 0; --b) {
                        this.moveInput(newIndex - delta - b, newIndex - b);
                    }
                }
            } else if (action == 4) {
                Integer bitIndex = event.getBitIndex();
                Var newVar = TruthTable.this.getInputVariable(event.getIndex());
                int lost = v.width - newVar.width;
                int oldCount = TruthTable.this.getInputColumnCount() + lost;
                int pos = bitIndex + 1 - v.width;
                if (lost > 0) {
                    while (lost-- != 0) {
                        this.removeInput(pos, oldCount--);
                    }
                } else if (lost < 0) {
                    while (lost++ != 0) {
                        this.addInput(pos, oldCount++);
                    }
                }
            } else if (action == 0) {
                TruthTable.this.initRows();
            }
        }

        private void moveInput(int oldIndex, int newIndex) {
            int inputs = TruthTable.this.getInputColumnCount();
            oldIndex = inputs - 1 - oldIndex;
            newIndex = inputs - 1 - newIndex;
            int allMask = (1 << inputs) - 1;
            int sameMask = allMask ^ (1 << 1 + Math.max(oldIndex, newIndex)) - 1 ^ (1 << Math.min(oldIndex, newIndex)) - 1;
            int moveMask = 1 << oldIndex;
            int moveDist = Math.abs(newIndex - oldIndex);
            boolean moveLeft = newIndex > oldIndex;
            int blockMask = allMask ^ sameMask ^ moveMask;
            ArrayList<Row> ret = new ArrayList<Row>(2 * TruthTable.this.rows.size());
            for (Row row : TruthTable.this.rows) {
                int dc0;
                int idx0;
                int i = row.baseIndex();
                int dc = row.dcMask();
                if (moveLeft) {
                    idx0 = i & sameMask | (i & moveMask) << moveDist | (i & blockMask) >> 1;
                    dc0 = dc & sameMask | (dc & moveMask) << moveDist | (dc & blockMask) >> 1;
                } else {
                    idx0 = i & sameMask | (i & moveMask) >> moveDist | (i & blockMask) << 1;
                    dc0 = dc & sameMask | (dc & moveMask) >> moveDist | (dc & blockMask) << 1;
                }
                ret.add(new Row(idx0, inputs, dc0));
            }
            ret.sort(sortByInputs);
            TruthTable.this.rows = ret;
        }

        private void addInput(int index, int oldCount) {
            ArrayList<Row> ret = new ArrayList<Row>(2 * TruthTable.this.rows.size());
            for (Row row : TruthTable.this.rows) {
                int i = row.baseIndex();
                int dc = row.dcMask();
                int b = 1 << oldCount - index;
                int mask = b - 1;
                int idx0 = (i & ~mask) << 1 | 0 | i & mask;
                int dc0 = (dc & ~mask) << 1 | 0 | dc & mask;
                ret.add(new Row(idx0 | 0, oldCount + 1, dc0));
                ret.add(new Row(idx0 | b, oldCount + 1, dc0));
            }
            ret.sort(sortByInputs);
            TruthTable.this.rows = ret;
        }

        private void removeInput(int index, int oldCount) {
            int b = 1 << oldCount - 1 - index;
            boolean[] changed = new boolean[TruthTable.this.columns.size()];
            for (int i = 0; i < TruthTable.this.rows.size(); ++i) {
                Row r = TruthTable.this.rows.get(i);
                if (r.inputs[index] == Entry.DONT_CARE) continue;
                TruthTable.this.setDontCare(r, b, true, changed);
            }
            int mask = b - 1;
            ArrayList<Row> ret = new ArrayList<Row>(TruthTable.this.rows.size());
            for (Row r : TruthTable.this.rows) {
                int i = r.baseIndex();
                int dc = r.dcMask();
                int idx0 = i >> 1 & ~mask | i & mask;
                int dc0 = dc >> 1 & ~mask | dc & mask;
                ret.add(new Row(idx0, oldCount - 1, dc0));
            }
            ret.sort(sortByInputs);
            TruthTable.this.rows = ret;
        }

        private Entry[] inputsChangedForOutput(Entry[] column, VariableListEvent event) {
            block11: {
                int action;
                Var v;
                block13: {
                    int newIndex;
                    Integer delta;
                    block14: {
                        block12: {
                            block10: {
                                v = event.getVariable();
                                action = event.getType();
                                if (action != 1) break block10;
                                Integer bitIndex = event.getBitIndex();
                                int oldCount = TruthTable.this.getInputColumnCount() - v.width;
                                for (int b = v.width - 1; b >= 0; --b) {
                                    column = this.addInputForOutput(column, bitIndex - b, oldCount++);
                                }
                                break block11;
                            }
                            if (action != 2) break block12;
                            Integer bitIndex = event.getBitIndex();
                            int oldCount = TruthTable.this.getInputColumnCount() + v.width;
                            for (int b = 0; b < v.width; ++b) {
                                column = this.removeInputForOutput(column, bitIndex - b, oldCount--);
                            }
                            break block11;
                        }
                        if (action != 3) break block13;
                        delta = event.getBitIndex();
                        newIndex = TruthTable.this.getInputIndex(v.bitName(0));
                        if (delta <= 0) break block14;
                        for (int b = 0; b < v.width; ++b) {
                            column = this.moveInputForOutput(column, newIndex - delta - b, newIndex - b);
                        }
                        break block11;
                    }
                    if (delta >= 0) break block11;
                    for (int b = v.width - 1; b >= 0; --b) {
                        column = this.moveInputForOutput(column, newIndex - delta - b, newIndex - b);
                    }
                    break block11;
                }
                if (action == 4) {
                    Integer bitIndex = event.getBitIndex();
                    Var newVar = TruthTable.this.getInputVariable(event.getIndex());
                    int lost = v.width - newVar.width;
                    int oldCount = TruthTable.this.getInputColumnCount() + lost;
                    int pos = bitIndex + 1 - v.width;
                    if (lost > 0) {
                        while (lost-- != 0) {
                            column = this.removeInputForOutput(column, pos, oldCount--);
                        }
                    } else if (lost < 0) {
                        while (lost++ != 0) {
                            column = this.addInputForOutput(column, pos, oldCount++);
                        }
                    }
                }
            }
            return column;
        }

        private Entry[] moveInputForOutput(Entry[] old, int oldIndex, int newIndex) {
            int inputs = TruthTable.this.getInputColumnCount();
            oldIndex = inputs - 1 - oldIndex;
            newIndex = inputs - 1 - newIndex;
            Entry[] ret = new Entry[old.length];
            int sameMask = old.length - 1 ^ (1 << 1 + Math.max(oldIndex, newIndex)) - 1 ^ (1 << Math.min(oldIndex, newIndex)) - 1;
            int moveMask = 1 << oldIndex;
            int moveDist = Math.abs(newIndex - oldIndex);
            boolean moveLeft = newIndex > oldIndex;
            int blockMask = old.length - 1 ^ sameMask ^ moveMask;
            for (int i = 0; i < old.length; ++i) {
                int j = moveLeft ? i & sameMask | (i & moveMask) << moveDist | (i & blockMask) >> 1 : i & sameMask | (i & moveMask) >> moveDist | (i & blockMask) << 1;
                ret[j] = old[i];
            }
            return ret;
        }

        private Entry[] removeInputForOutput(Entry[] old, int index, int oldCount) {
            Entry[] ret = new Entry[old.length / 2];
            int j = 0;
            int mask = 1 << oldCount - 1 - index;
            for (int i = 0; i < old.length; ++i) {
                if ((i & mask) != 0) continue;
                Entry e0 = old[i];
                Entry e1 = old[i | mask];
                ret[j++] = e0 == e1 ? e0 : Entry.DONT_CARE;
            }
            return ret;
        }

        private Entry[] addInputForOutput(Entry[] old, int index, int oldCount) {
            Entry[] ret = new Entry[2 * old.length];
            int b = 1 << oldCount - index;
            int mask = b - 1;
            for (int i = 0; i < old.length; ++i) {
                ret[(i & (mask ^ 0xFFFFFFFF)) << 1 | 0 | i & mask] = old[i];
                ret[(i & (mask ^ 0xFFFFFFFF)) << 1 | b | i & mask] = old[i];
            }
            return ret;
        }
    }

    public static class CompareInputs
    implements Comparator<Row> {
        @Override
        public int compare(Row r1, Row r2) {
            return r1.baseIndex() - r2.baseIndex();
        }
    }
}

