/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.model;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.model.ParserException;
import java.util.Iterator;

public class Var
implements Iterable<String> {
    public final int width;
    public final String name;

    public Var(String n, int w) {
        this.name = n;
        this.width = w;
    }

    public boolean equals(Object obj) {
        boolean bl;
        if (obj instanceof Var) {
            Var other = (Var)obj;
            bl = other.name.equals(this.name) && other.width == this.width;
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.name.hashCode() + this.width;
    }

    public String toString() {
        return this.width > 1 ? this.name + "[" + (this.width - 1) + "..0]" : this.name;
    }

    public static Var parse(String s) throws ParserException {
        s = s.trim();
        int i = s.indexOf(91);
        int j = s.lastIndexOf(93);
        int w = 1;
        if (0 < i && i < j && j == s.length() - 1) {
            String braces = s.substring(i + 1, j);
            if (!braces.endsWith("..0")) {
                throw new ParserException(Strings.S.getter("variableFormat"), i);
            }
            try {
                w = 1 + Integer.parseInt(braces.substring(0, braces.length() - 3));
            }
            catch (NumberFormatException e) {
                throw new ParserException(Strings.S.getter("variableFormat"), i);
            }
            if (w < 1) {
                throw new ParserException(Strings.S.getter("variableFormat"), i);
            }
            if (w > 32) {
                throw new ParserException(Strings.S.getter("variableTooMuchBits"), i);
            }
            s = s.substring(0, i).trim();
        } else {
            if (i >= 0 || j >= 0) {
                throw new ParserException(Strings.S.getter("variableFormat"), i >= 0 ? i : j);
            }
            s = s.trim();
        }
        return new Var(s, w);
    }

    public String bitName(int b) {
        if (b >= this.width) {
            throw new IllegalArgumentException("Can't access bit " + b + " of " + this.width);
        }
        return this.width > 1 ? this.name + "[" + b + "]" : this.name;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int bitIndex;
            {
                this.bitIndex = Var.this.width - 1;
            }

            @Override
            public boolean hasNext() {
                return this.bitIndex >= 0;
            }

            @Override
            public String next() {
                return Var.this.bitName(this.bitIndex--);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class Bit {
        public final String name;
        public final int bitIndex;

        public Bit(String name, int b) {
            this.name = name;
            this.bitIndex = b;
        }

        public String toString() {
            return this.bitIndex == -1 ? this.name : this.name + "[" + this.bitIndex + "]";
        }

        public static Bit parse(String s) throws ParserException {
            int i = (s = s.trim()).indexOf(58);
            if (i > 0) {
                try {
                    String name = s.substring(0, i);
                    int sub = Integer.parseInt(s.substring(i + 1));
                    return new Bit(name, sub);
                }
                catch (NumberFormatException e) {
                    throw new ParserException(Strings.S.getter("badVariableIndexError"), i);
                }
            }
            if (i == 0) {
                throw new ParserException(Strings.S.getter("badVariableColonError"), i);
            }
            i = s.indexOf(91);
            int j = s.lastIndexOf(93);
            if (0 < i && i < j && j == s.length() - 1) {
                try {
                    String name = s.substring(0, i).trim();
                    int sub = Integer.parseInt(s.substring(i + 1, j));
                    return new Bit(name, sub);
                }
                catch (NumberFormatException e) {
                    throw new ParserException(Strings.S.getter("badVariableIndexError"), i);
                }
            }
            if (i >= 0 || j >= 0) {
                throw new ParserException(Strings.S.getter("badVariableBitFormError"), i >= 0 ? i : j);
            }
            return new Bit(s, -1);
        }
    }
}

