/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.model;

import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.analyze.model.VariableListEvent;
import com.cburch.logisim.analyze.model.VariableListListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

public class VariableList {
    private final List<VariableListListener> listeners = new ArrayList<VariableListListener>();
    private final int maxSize;
    private final List<Var> data;
    private final List<String> names;
    public final List<Var> vars;
    public final List<String> bits;
    private final List<VariableList> others;

    public VariableList(int maxSize) {
        this.maxSize = maxSize;
        this.data = maxSize > 16 ? new ArrayList<Var>() : new ArrayList(maxSize);
        this.names = maxSize > 16 ? new ArrayList<String>() : new ArrayList(maxSize);
        this.vars = Collections.unmodifiableList(this.data);
        this.bits = Collections.unmodifiableList(this.names);
        this.others = new ArrayList<VariableList>();
    }

    public void addCompanion(VariableList varList) {
        this.others.add(varList);
    }

    public List<String> getNames() {
        return this.names;
    }

    public boolean containsDuplicate(VariableList data, Var oldVar, String name) {
        int i;
        boolean found = false;
        int n = this.vars.size();
        for (i = 0; i < n && !found; ++i) {
            Var other = this.vars.get(i);
            if (other == oldVar || !name.equals(other.name)) continue;
            found = true;
            break;
        }
        for (i = 0; i < this.others.size() && !found; ++i) {
            VariableList l = this.others.get(i);
            if (l.equals(data)) continue;
            found |= l.containsDuplicate(data, oldVar, name);
        }
        return found;
    }

    public void add(Var variable) {
        if (this.data.size() + variable.width > this.maxSize) {
            throw new IllegalArgumentException("maximum size is " + this.maxSize);
        }
        int index = this.data.size();
        this.data.add(variable);
        for (String bit : variable) {
            this.names.add(bit);
        }
        int bitIndex = this.names.size() - 1;
        this.fireEvent(1, variable, index, bitIndex);
    }

    public void addVariableListListener(VariableListListener l) {
        this.listeners.add(l);
    }

    private void fireEvent(int type) {
        this.fireEvent(type, null, null, null);
    }

    private void fireEvent(int type, Var variable, Integer index, Integer bitIndex) {
        if (this.listeners.isEmpty()) {
            return;
        }
        VariableListEvent event = new VariableListEvent(this, type, variable, index, bitIndex);
        for (VariableListListener l : this.listeners) {
            l.listChanged(event);
        }
    }

    public int getMaximumSize() {
        return this.maxSize;
    }

    public void move(Var variable, int delta) {
        int index = this.data.indexOf(variable);
        if (index < 0) {
            throw new NoSuchElementException(variable.toString());
        }
        int bitIndex = this.names.indexOf(variable.bitName(0));
        if (bitIndex < 0) {
            throw new NoSuchElementException(variable.toString());
        }
        int newIndex = index + delta;
        if (newIndex < 0) {
            throw new IllegalArgumentException("cannot move index " + index + " by " + delta);
        }
        if (newIndex > this.data.size() - 1) {
            throw new IllegalArgumentException("Cannot move index " + index + " by " + delta + ": size " + this.data.size());
        }
        if (index == newIndex) {
            return;
        }
        this.data.remove(index);
        this.data.add(newIndex, variable);
        this.names.subList(bitIndex + 1 - variable.width, bitIndex + 1).clear();
        int i = newIndex == 0 ? 0 : 1 + this.names.indexOf(this.data.get(newIndex - 1).bitName(0));
        for (String bit : variable) {
            this.names.add(i++, bit);
        }
        int bitDelta = this.names.indexOf(variable.bitName(0)) - bitIndex;
        this.fireEvent(3, variable, delta, bitDelta);
    }

    public void remove(Var variable) {
        int index = this.data.indexOf(variable);
        if (index < 0) {
            throw new NoSuchElementException(variable.toString());
        }
        int bitIndex = this.names.indexOf(variable.bitName(0));
        if (bitIndex < 0) {
            throw new NoSuchElementException(variable.toString());
        }
        this.data.remove(index);
        this.names.subList(bitIndex + 1 - variable.width, bitIndex + 1).clear();
        this.fireEvent(2, variable, index, bitIndex);
    }

    public void removeVariableListListener(VariableListListener l) {
        this.listeners.remove(l);
    }

    public void replace(Var oldVar, Var newVar) {
        int index = this.data.indexOf(oldVar);
        if (index < 0) {
            throw new NoSuchElementException(oldVar.toString());
        }
        int bitIndex = this.names.indexOf(oldVar.bitName(0));
        if (bitIndex < 0) {
            throw new NoSuchElementException(oldVar.toString());
        }
        if (oldVar.equals(newVar)) {
            return;
        }
        this.data.set(index, newVar);
        this.names.subList(bitIndex + 1 - oldVar.width, bitIndex + 1).clear();
        int i = bitIndex + 1 - oldVar.width;
        for (String bit : newVar) {
            this.names.add(i++, bit);
        }
        this.fireEvent(4, oldVar, index, bitIndex);
    }

    public void setAll(List<Var> values) {
        int total = 0;
        for (Var v : values) {
            total += v.width;
        }
        if (total > this.maxSize) {
            throw new IllegalArgumentException("maximum size is " + this.maxSize);
        }
        this.data.clear();
        this.data.addAll(values);
        this.names.clear();
        for (Var variable : values) {
            for (String bit : variable) {
                this.names.add(bit);
            }
        }
        this.fireEvent(0);
    }
}

