/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Entry;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.analyze.model.TruthTable;
import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.circuit.AnalyzeException;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.CircuitWires;
import com.cburch.logisim.circuit.ExpressionComputer;
import com.cburch.logisim.circuit.Propagator;
import com.cburch.logisim.circuit.SplitterFactory;
import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.circuit.WireBundle;
import com.cburch.logisim.circuit.WireThread;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.wiring.Pin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class Analyze {
    private static Expression checkForCircularExpressions(ExpressionMap expressionMap) {
        for (LocationBit point : expressionMap.dirtyPoints) {
            Expression expr = (Expression)expressionMap.get(point);
            if (!expr.isCircular()) continue;
            return expr;
        }
        return null;
    }

    public static void computeExpression(AnalyzerModel model, Circuit circuit, Map<Instance, String> pinNames) throws AnalyzeException {
        int b;
        int width;
        String label;
        ExpressionMap expressionMap = new ExpressionMap(circuit);
        ArrayList<Var> inputVars = new ArrayList<Var>();
        ArrayList<Var> outputVars = new ArrayList<Var>();
        ArrayList<Instance> outputPins = new ArrayList<Instance>();
        for (Map.Entry<Instance, String> entry : pinNames.entrySet()) {
            Instance pin = entry.getKey();
            label = entry.getValue();
            width = pin.getAttributeValue(StdAttr.WIDTH).getWidth();
            if (Pin.FACTORY.isInputPin(pin)) {
                expressionMap.currentCause = Instance.getComponentFor(pin);
                for (b = 0; b < width; ++b) {
                    Expression e = Expressions.variable((String)(width > 1 ? label + "[" + b + "]" : label));
                    expressionMap.put(new LocationBit(pin.getLocation(), b), e);
                }
                inputVars.add(new Var(label, width));
                continue;
            }
            outputPins.add(pin);
            outputVars.add(new Var(label, width));
        }
        Analyze.propagateComponents(expressionMap, circuit.getNonWires());
        int maxIterations = 100;
        int iterations = 0;
        while (!expressionMap.dirtyPoints.isEmpty()) {
            if (iterations > 100) {
                throw new AnalyzeException.Circular();
            }
            Analyze.propagateWires(expressionMap, new HashSet<LocationBit>(expressionMap.dirtyPoints));
            HashSet<Component> dirtyComponents = Analyze.getDirtyComponents(circuit, expressionMap.dirtyPoints);
            expressionMap.dirtyPoints.clear();
            Analyze.propagateComponents(expressionMap, dirtyComponents);
            Expression expr = Analyze.checkForCircularExpressions(expressionMap);
            if (expr != null) {
                throw new AnalyzeException.Circular();
            }
            ++iterations;
        }
        model.setVariables(inputVars, outputVars);
        for (Instance pin : outputPins) {
            label = pinNames.get(pin);
            width = pin.getAttributeValue(StdAttr.WIDTH).getWidth();
            for (b = 0; b < width; ++b) {
                LocationBit loc = new LocationBit(pin.getLocation(), b);
                String name = width > 1 ? label + "[" + b + "]" : label;
                model.getOutputExpressions().setExpression(name, (Expression)expressionMap.get(loc));
            }
        }
    }

    public static void computeTable(AnalyzerModel model, Project proj, Circuit circuit, Map<Instance, String> pinLabels) {
        int i;
        ArrayList<Instance> inputPins = new ArrayList<Instance>();
        ArrayList<Var> inputVars = new ArrayList<Var>();
        ArrayList<Object> inputNames = new ArrayList<Object>();
        ArrayList<Instance> outputPins = new ArrayList<Instance>();
        ArrayList<Var> outputVars = new ArrayList<Var>();
        ArrayList<Object> outputNames = new ArrayList<Object>();
        for (Map.Entry<Instance, String> entry : pinLabels.entrySet()) {
            Instance pin = entry.getKey();
            int width = pin.getAttributeValue(StdAttr.WIDTH).getWidth();
            Var variable = new Var(entry.getValue(), width);
            if (Pin.FACTORY.isInputPin(pin)) {
                inputPins.add(pin);
                for (Object name : variable) {
                    inputNames.add(name);
                }
                inputVars.add(variable);
                continue;
            }
            outputPins.add(pin);
            for (Object name : variable) {
                outputNames.add(name);
            }
            outputVars.add(variable);
        }
        int inputCount = inputNames.size();
        int rowCount = 1 << inputCount;
        Entry[][] columns = new Entry[outputNames.size()][rowCount];
        for (i = 0; i < rowCount; ++i) {
            CircuitState circuitState = new CircuitState(proj, circuit);
            int incol = 0;
            for (Instance pin : inputPins) {
                int width = pin.getAttributeValue(StdAttr.WIDTH).getWidth();
                Value[] v = new Value[width];
                for (int b = width - 1; b >= 0; --b) {
                    boolean value;
                    v[b] = (value = TruthTable.isInputSet(i, incol++, inputCount)) ? Value.TRUE : Value.FALSE;
                }
                InstanceState pinState = circuitState.getInstanceState(pin);
                Pin.FACTORY.setValue(pinState, Value.create(v));
            }
            Propagator prop = circuitState.getPropagator();
            prop.propagate();
            if (prop.isOscillating()) {
                for (int j = 0; j < columns.length; ++j) {
                    columns[j][i] = Entry.OSCILLATE_ERROR;
                }
                continue;
            }
            int outcol = 0;
            for (Instance pin : outputPins) {
                int width = pin.getAttributeValue(StdAttr.WIDTH).getWidth();
                InstanceState pinState = circuitState.getInstanceState(pin);
                for (int b = width - 1; b >= 0; --b) {
                    Value outValue = Pin.FACTORY.getValue(pinState).get(b);
                    Entry out = outValue == Value.TRUE ? Entry.ONE : (outValue == Value.FALSE ? Entry.ZERO : (outValue == Value.ERROR ? Entry.BUS_ERROR : Entry.DONT_CARE));
                    columns[outcol++][i] = out;
                }
            }
        }
        model.setVariables(inputVars, outputVars);
        for (i = 0; i < columns.length; ++i) {
            model.getTruthTable().setOutputColumn(i, columns[i]);
        }
    }

    private static HashSet<Component> getDirtyComponents(Circuit circuit, Set<LocationBit> pointsToProcess) {
        HashSet<Component> dirtyComponents = new HashSet<Component>();
        for (LocationBit point : pointsToProcess) {
            dirtyComponents.addAll(circuit.getNonWires(point.loc));
        }
        return dirtyComponents;
    }

    public static SortedMap<Instance, String> getPinLabels(Circuit circuit) {
        TreeMap<Location.At, Object> ret = new TreeMap<Location.At, Object>(Location.CompareVertical);
        for (Instance pin : circuit.getAppearance().getPortOffsets(Direction.EAST).values()) {
            ret.put(pin, null);
        }
        ArrayList<Location.At> pinList = new ArrayList<Location.At>(ret.keySet());
        HashSet<Object> labelsTaken = new HashSet<Object>();
        for (Instance instance : pinList) {
            Object label = instance.getAttributeSet().getValue(StdAttr.LABEL);
            if ((label = Analyze.toValidLabel((String)label)) == null) continue;
            if (labelsTaken.contains(label)) {
                int i = 2;
                while (labelsTaken.contains((String)label + i)) {
                    ++i;
                }
                label = (String)label + i;
            }
            ret.put(instance, label);
            labelsTaken.add(label);
        }
        for (Instance instance : pinList) {
            int i;
            String defaultList;
            if (ret.get(instance) != null) continue;
            if (Pin.FACTORY.isInputPin(instance)) {
                defaultList = Strings.S.get("defaultInputLabels");
                if (!defaultList.contains(",")) {
                    defaultList = "a,b,c,d,e,f,g,h";
                }
            } else {
                defaultList = Strings.S.get("defaultOutputLabels");
                if (!defaultList.contains(",")) {
                    defaultList = "x,y,z,u,v,w,s,t";
                }
            }
            String[] options = defaultList.split(",");
            Object label = null;
            for (i = 0; label == null && i < options.length; ++i) {
                if (labelsTaken.contains(options[i])) continue;
                label = options[i];
            }
            if (label == null) {
                i = 1;
                while (labelsTaken.contains(label = "x" + ++i)) {
                }
            }
            labelsTaken.add(label);
            ret.put(instance, label);
        }
        return ret;
    }

    private static void propagateComponents(ExpressionMap expressionMap, Collection<Component> components) throws AnalyzeException {
        for (Component comp : components) {
            ExpressionComputer computer = (ExpressionComputer)comp.getFeature(ExpressionComputer.class);
            if (computer != null) {
                try {
                    expressionMap.currentCause = comp;
                    computer.computeExpression(expressionMap);
                    continue;
                }
                catch (UnsupportedOperationException e) {
                    throw new AnalyzeException.CannotHandle(comp.getFactory().getDisplayName());
                }
            }
            if (comp.getFactory() instanceof Pin || comp.getFactory() instanceof SplitterFactory) continue;
            throw new AnalyzeException.CannotHandle(comp.getFactory().getDisplayName());
        }
    }

    private static void propagateWires(ExpressionMap expressionMap, HashSet<LocationBit> pointsToProcess) throws AnalyzeException {
        expressionMap.currentCause = null;
        for (LocationBit locationBit : pointsToProcess) {
            Expression e = (Expression)expressionMap.get(locationBit);
            expressionMap.currentCause = expressionMap.causes.get(locationBit);
            WireBundle bundle = expressionMap.circuit.wires.getWireBundle(locationBit.loc);
            if (e == null || bundle == null || !bundle.isValid() || bundle.threads == null) continue;
            if (bundle.threads.length <= locationBit.bit) {
                throw new AnalyzeException.CannotHandle("incompatible widths");
            }
            WireThread t = bundle.threads[locationBit.bit];
            for (CircuitWires.ThreadBundle tb : t.getBundles()) {
                for (Location p2 : tb.b.points) {
                    Component oldCause;
                    Component eCause;
                    if (p2.equals(locationBit.loc)) continue;
                    LocationBit p2b = new LocationBit(p2, tb.loc);
                    Expression old = (Expression)expressionMap.get(p2b);
                    if (old != null && (eCause = expressionMap.currentCause) != (oldCause = expressionMap.causes.get(p2b)) && !old.equals(e)) {
                        throw new AnalyzeException.Conflict();
                    }
                    expressionMap.put(p2b, e);
                }
            }
        }
    }

    private static String toValidLabel(String label) {
        if (label == null) {
            return null;
        }
        StringBuilder end = null;
        StringBuilder ret = new StringBuilder();
        boolean afterWhitespace = false;
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (Character.isJavaIdentifierStart(c)) {
                if (afterWhitespace) {
                    c = Character.toTitleCase(c);
                    afterWhitespace = false;
                }
                ret.append(c);
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                if (ret.length() > 0) {
                    ret.append(c);
                } else {
                    if (end == null) {
                        end = new StringBuilder();
                    }
                    end.append(c);
                }
                afterWhitespace = false;
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            afterWhitespace = true;
        }
        if (end != null && ret.length() > 0) {
            ret.append((CharSequence)end);
        }
        if (ret.length() == 0) {
            return null;
        }
        return ret.toString();
    }

    private Analyze() {
    }

    private static class ExpressionMap
    extends HashMap<LocationBit, Expression>
    implements ExpressionComputer.Map {
        private static final long serialVersionUID = 1L;
        private final Circuit circuit;
        private final Set<LocationBit> dirtyPoints = new HashSet<LocationBit>();
        private final Map<LocationBit, Component> causes = new HashMap<LocationBit, Component>();
        private Component currentCause = null;

        ExpressionMap(Circuit circuit) {
            this.circuit = circuit;
        }

        @Override
        public Expression put(LocationBit point, Expression expression) {
            Expression ret = super.put(point, expression);
            if (this.currentCause != null) {
                this.causes.put(point, this.currentCause);
            }
            if (!Objects.equals(ret, expression)) {
                this.dirtyPoints.add(point);
            }
            return ret;
        }

        @Override
        public Expression put(Location point, int bit, Expression expression) {
            return this.put(new LocationBit(point, bit), expression);
        }

        @Override
        public Expression get(Location point, int bit) {
            return (Expression)this.get(new LocationBit(point, bit));
        }
    }

    public static class LocationBit {
        final Location loc;
        final int bit;

        public LocationBit(Location l, int b) {
            this.loc = l;
            this.bit = b;
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof LocationBit) {
                LocationBit that = (LocationBit)other;
                bl = that.loc.equals(this.loc) && that.bit == this.bit;
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return this.loc.hashCode() + this.bit;
        }
    }
}

