/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.circuit.appear.CircuitAppearanceEvent;
import com.cburch.logisim.circuit.appear.CircuitAppearanceListener;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeDefaultProvider;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.util.SyntaxChecker;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;

public class CircuitAttributes
extends AbstractAttributeSet {
    public static final Attribute<String> NAME_ATTR = Attributes.forString("circuit", Strings.S.getter("circuitName"));
    public static final Attribute<Direction> LABEL_LOCATION_ATTR = Attributes.forDirection("labelloc", Strings.S.getter("circuitLabelLocAttr"));
    public static final Attribute<String> CIRCUIT_LABEL_ATTR = Attributes.forString("clabel", Strings.S.getter("circuitLabelAttr"));
    public static final Attribute<Direction> CIRCUIT_LABEL_FACING_ATTR = Attributes.forDirection("clabelup", Strings.S.getter("circuitLabelDirAttr"));
    public static final Attribute<Font> CIRCUIT_LABEL_FONT_ATTR = Attributes.forFont("clabelfont", Strings.S.getter("circuitLabelFontAttr"));
    public static final Attribute<Boolean> CIRCUIT_IS_VHDL_BOX = Attributes.forBoolean("circuitvhdl", Strings.S.getter("circuitIsVhdl"));
    public static final Attribute<Boolean> NAMED_CIRCUIT_BOX_FIXED_SIZE = Attributes.forBoolean("circuitnamedboxfixedsize", Strings.S.getter("circuitNamedBoxFixedSize"));
    public static final AttributeOption APPEAR_CLASSIC = StdAttr.APPEAR_CLASSIC;
    public static final AttributeOption APPEAR_FPGA = StdAttr.APPEAR_FPGA;
    public static final AttributeOption APPEAR_EVOLUTION = StdAttr.APPEAR_EVOLUTION;
    public static final AttributeOption APPEAR_CUSTOM = new AttributeOption("custom", Strings.S.getter("circuitCustomAppearance"));
    public static final Attribute<AttributeOption> APPEARANCE_ATTR = Attributes.forOption("appearance", Strings.S.getter("circuitAppearanceAttr"), new AttributeOption[]{APPEAR_CLASSIC, APPEAR_FPGA, APPEAR_EVOLUTION, APPEAR_CUSTOM});
    public static final Attribute<Double> SIMULATION_FREQUENCY = Attributes.forDouble("simulationFrequency");
    public static final Attribute<Double> DOWNLOAD_FREQUENCY = Attributes.forDouble("downloadFrequency");
    public static final Attribute<String> DOWNLOAD_BOARD = Attributes.forString("downloadBoard");
    public static final defaultStaticAttributeProvider DEFAULT_STATIC_ATTRIBUTES = new defaultStaticAttributeProvider();
    private static final Attribute<?>[] STATIC_ATTRS = new Attribute[]{NAME_ATTR, CIRCUIT_LABEL_ATTR, CIRCUIT_LABEL_FACING_ATTR, CIRCUIT_LABEL_FONT_ATTR, APPEARANCE_ATTR, NAMED_CIRCUIT_BOX_FIXED_SIZE, SIMULATION_FREQUENCY, DOWNLOAD_FREQUENCY, DOWNLOAD_BOARD};
    private static final Object[] STATIC_DEFAULTS = new Object[]{"", "", Direction.EAST, StdAttr.DEFAULT_LABEL_FONT, APPEAR_CLASSIC, false, -1.0, -1.0, ""};
    private static final List<Attribute<?>> INSTANCE_ATTRS = Arrays.asList(StdAttr.FACING, StdAttr.LABEL, LABEL_LOCATION_ATTR, StdAttr.LABEL_FONT, StdAttr.LABEL_VISIBILITY, NAME_ATTR, CIRCUIT_LABEL_ATTR, CIRCUIT_LABEL_FACING_ATTR, CIRCUIT_LABEL_FONT_ATTR, APPEARANCE_ATTR);
    private final Circuit source;
    private Instance subcircInstance;
    private Direction facing;
    private String label;
    private Direction labelLocation;
    private Font labelFont;
    private Boolean labelVisible;
    private MyListener listener;
    private Instance[] pinInstances;
    private boolean nameReadOnly;

    public static void copyStaticAttributes(AttributeSet destination, AttributeSet source) {
        destination.setValue(CIRCUIT_LABEL_ATTR, source.getValue(CIRCUIT_LABEL_ATTR));
        destination.setValue(CIRCUIT_LABEL_FACING_ATTR, source.getValue(CIRCUIT_LABEL_FACING_ATTR));
        destination.setValue(CIRCUIT_LABEL_FONT_ATTR, source.getValue(CIRCUIT_LABEL_FONT_ATTR));
        destination.setValue(APPEARANCE_ATTR, source.getValue(APPEARANCE_ATTR));
        destination.setValue(NAMED_CIRCUIT_BOX_FIXED_SIZE, source.getValue(NAMED_CIRCUIT_BOX_FIXED_SIZE));
        destination.setValue(SIMULATION_FREQUENCY, source.getValue(SIMULATION_FREQUENCY));
        destination.setValue(DOWNLOAD_FREQUENCY, source.getValue(DOWNLOAD_FREQUENCY));
        destination.setValue(DOWNLOAD_BOARD, source.getValue(DOWNLOAD_BOARD));
    }

    static AttributeSet createBaseAttrs(Circuit source, String name) {
        AttributeSet ret = AttributeSets.fixedSet(STATIC_ATTRS, STATIC_DEFAULTS);
        ret.setValue(APPEARANCE_ATTR, AppPreferences.getDefaultCircuitAppearance());
        ret.setValue(NAME_ATTR, name);
        ret.addAttributeListener(new StaticListener(source));
        return ret;
    }

    public CircuitAttributes(Circuit source) {
        this.source = source;
        this.subcircInstance = null;
        this.facing = source.getAppearance().getFacing();
        this.label = "";
        this.labelLocation = Direction.NORTH;
        this.labelFont = StdAttr.DEFAULT_LABEL_FONT;
        this.labelVisible = true;
        this.pinInstances = new Instance[0];
        this.nameReadOnly = false;
        DOWNLOAD_FREQUENCY.setHidden(true);
        SIMULATION_FREQUENCY.setHidden(true);
        DOWNLOAD_BOARD.setHidden(true);
    }

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        CircuitAttributes other = (CircuitAttributes)dest;
        other.subcircInstance = null;
        other.listener = null;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return INSTANCE_ATTRS;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public Instance[] getPinInstances() {
        return this.pinInstances;
    }

    public <E> E getValue(Attribute<E> attr) {
        if (attr == StdAttr.FACING) {
            return (E)this.facing;
        }
        if (attr == StdAttr.LABEL) {
            return (E)this.label;
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (E)this.labelFont;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            return (E)this.labelVisible;
        }
        if (attr == LABEL_LOCATION_ATTR) {
            return (E)this.labelLocation;
        }
        return this.source.getStaticAttributes().getValue(attr);
    }

    public static void copyInto(AttributeSet source, AttributeSet destination) {
        destination.setValue(StdAttr.FACING, source.getValue(StdAttr.FACING));
        destination.setValue(StdAttr.LABEL, source.getValue(StdAttr.LABEL));
        destination.setValue(StdAttr.LABEL_FONT, source.getValue(StdAttr.LABEL_FONT));
        destination.setValue(StdAttr.LABEL_VISIBILITY, source.getValue(StdAttr.LABEL_VISIBILITY));
        destination.setValue(LABEL_LOCATION_ATTR, source.getValue(LABEL_LOCATION_ATTR));
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        for (Attribute<?> aStatic : STATIC_ATTRS) {
            if (aStatic != attr) continue;
            return false;
        }
        return attr.isToSave();
    }

    void setPinInstances(Instance[] value) {
        this.pinInstances = value;
    }

    void setSubcircuit(Instance value) {
        this.subcircInstance = value;
        if (this.subcircInstance != null && this.listener == null) {
            this.listener = new MyListener(this.source);
            this.source.getStaticAttributes().addAttributeListener(this.listener);
            this.source.getAppearance().addCircuitAppearanceListener(this.listener);
        }
    }

    @Override
    public void setReadOnly(Attribute<?> attr, boolean value) {
        if (attr == NAME_ATTR) {
            this.nameReadOnly = value;
        }
    }

    @Override
    public boolean isReadOnly(Attribute<?> attr) {
        if (attr == NAME_ATTR) {
            return this.nameReadOnly;
        }
        return false;
    }

    public <E> void setValue(Attribute<E> attr, E value) {
        if (attr == StdAttr.FACING) {
            Direction val = (Direction)value;
            if (this.facing.equals(val)) {
                return;
            }
            this.facing = val;
            this.fireAttributeValueChanged(StdAttr.FACING, val, null);
            if (this.subcircInstance != null) {
                this.subcircInstance.recomputeBounds();
            }
        } else if (attr == StdAttr.LABEL) {
            String val = (String)value;
            String oldval = this.label;
            if (this.label.equals(val)) {
                return;
            }
            this.label = val;
            this.fireAttributeValueChanged(StdAttr.LABEL, val, oldval);
        } else if (attr == StdAttr.LABEL_FONT) {
            Font val = (Font)value;
            if (this.labelFont.equals(val)) {
                return;
            }
            this.labelFont = val;
            this.fireAttributeValueChanged(StdAttr.LABEL_FONT, val, null);
        } else if (attr == StdAttr.LABEL_VISIBILITY) {
            Boolean val = (Boolean)value;
            if (this.labelVisible == value) {
                return;
            }
            this.labelVisible = val;
            this.fireAttributeValueChanged(StdAttr.LABEL_VISIBILITY, val, null);
        } else if (attr == LABEL_LOCATION_ATTR) {
            Direction val = (Direction)value;
            if (this.labelLocation.equals(val)) {
                return;
            }
            this.labelLocation = val;
            this.fireAttributeValueChanged(LABEL_LOCATION_ATTR, val, null);
        } else {
            this.source.getStaticAttributes().setValue(attr, value);
            if (attr == NAME_ATTR) {
                this.source.fireEvent(0, value);
            }
        }
    }

    private static class StaticListener
    implements AttributeListener {
        private final Circuit source;

        private StaticListener(Circuit s) {
            this.source = s;
        }

        @Override
        public void attributeListChanged(AttributeEvent e) {
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            if (e.getAttribute() == NAME_ATTR) {
                String OldName;
                String NewName = (String)e.getValue();
                String string = OldName = e.getOldValue() == null ? "ThisShouldNotHappen" : (String)e.getOldValue();
                if (!NewName.equals(OldName)) {
                    if (NewName.isEmpty()) {
                        OptionPane.showMessageDialog(null, Strings.S.get("EmptyNameError"), "", 0);
                        e.getSource().setValue(NAME_ATTR, OldName);
                        this.source.fireEvent(0, OldName);
                        return;
                    }
                    if (!SyntaxChecker.isVariableNameAcceptable(NewName, true)) {
                        e.getSource().setValue(NAME_ATTR, OldName);
                        this.source.fireEvent(0, OldName);
                        return;
                    }
                    for (Component component : this.source.getNonWires()) {
                        String label;
                        if (!(component.getFactory() instanceof Pin) || (label = component.getAttributeSet().getValue(StdAttr.LABEL).toUpperCase()).isEmpty() || !label.equals(NewName.toUpperCase())) continue;
                        String msg = Strings.S.get("CircuitSameInputOutputLabel");
                        OptionPane.showMessageDialog(null, "\"" + NewName + "\" : " + msg);
                        e.getSource().setValue(NAME_ATTR, OldName);
                        this.source.fireEvent(0, OldName);
                        return;
                    }
                    this.source.fireEvent(8, OldName);
                    this.source.fireEvent(0, NewName);
                }
            }
        }
    }

    private class MyListener
    implements AttributeListener,
    CircuitAppearanceListener {
        private final Circuit source;

        private MyListener(Circuit s) {
            this.source = s;
        }

        @Override
        public void attributeListChanged(AttributeEvent e) {
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            Attribute<?> a = e.getAttribute();
            CircuitAttributes.this.fireAttributeValueChanged(a, e.getValue(), e.getOldValue());
        }

        @Override
        public void circuitAppearanceChanged(CircuitAppearanceEvent e) {
            SubcircuitFactory factory = (SubcircuitFactory)CircuitAttributes.this.subcircInstance.getFactory();
            if (e.isConcerning(4)) {
                factory.computePorts(CircuitAttributes.this.subcircInstance);
            }
            if (e.isConcerning(2)) {
                CircuitAttributes.this.subcircInstance.recomputeBounds();
            }
            CircuitAttributes.this.subcircInstance.fireInvalidated();
            if (this.source != null && !this.source.getAppearance().isDefaultAppearance()) {
                this.source.getStaticAttributes().setValue(APPEARANCE_ATTR, APPEAR_CUSTOM);
            }
        }
    }

    private static class defaultStaticAttributeProvider
    implements AttributeDefaultProvider {
        private defaultStaticAttributeProvider() {
        }

        @Override
        public Object getDefaultAttributeValue(Attribute<?> attr, LogisimVersion ver) {
            AttributeSet ret = AttributeSets.fixedSet(STATIC_ATTRS, STATIC_DEFAULTS);
            ret.setValue(APPEARANCE_ATTR, StdAttr.APPEAR_CLASSIC);
            return ret.getValue(attr);
        }

        @Override
        public boolean isAllDefaultValues(AttributeSet attrs, LogisimVersion ver) {
            return false;
        }
    }
}

