/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitAction;
import com.cburch.logisim.circuit.CircuitChange;
import com.cburch.logisim.circuit.CircuitMutator;
import com.cburch.logisim.circuit.CircuitTransaction;
import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class CircuitMutation
extends CircuitTransaction {
    private final Circuit primary;
    private final List<CircuitChange> changes;

    CircuitMutation() {
        this(null);
    }

    public CircuitMutation(Circuit circuit) {
        this.primary = circuit;
        this.changes = new ArrayList<CircuitChange>();
    }

    public void add(Component comp) {
        this.changes.add(CircuitChange.add(this.primary, comp));
    }

    public void addAll(Collection<? extends Component> comps) {
        this.changes.add(CircuitChange.addAll(this.primary, new ArrayList<Component>(comps)));
    }

    public void change(CircuitChange change) {
        this.changes.add(change);
    }

    public void clear() {
        this.changes.add(CircuitChange.clear(this.primary, null));
    }

    @Override
    protected Map<Circuit, Integer> getAccessedCircuits() {
        HashMap<Circuit, Integer> accessMap = new HashMap<Circuit, Integer>();
        HashSet<Circuit> supercircsDone = new HashSet<Circuit>();
        HashSet<VhdlEntity> vhdlDone = new HashSet<VhdlEntity>();
        HashSet<ComponentFactory> siblingsDone = new HashSet<ComponentFactory>();
        for (CircuitChange change : this.changes) {
            VhdlEntity sibling;
            boolean isFirstForVhdl;
            ComponentFactory factory;
            boolean isFirstForSibling;
            boolean isFirstForCirc;
            Circuit circ = change.getCircuit();
            accessMap.put(circ, READ_WRITE);
            if (change.concernsSupercircuit() && (isFirstForCirc = supercircsDone.add(circ))) {
                for (Circuit supercirc : circ.getCircuitsUsingThis()) {
                    accessMap.put(supercirc, READ_WRITE);
                }
            }
            if (!change.concernsSiblingComponents() || !(isFirstForSibling = siblingsDone.add(factory = change.getComponent().getFactory()))) continue;
            if (factory instanceof SubcircuitFactory) {
                SubcircuitFactory sub = (SubcircuitFactory)factory;
                Circuit sibling2 = sub.getSubcircuit();
                boolean isFirstForCirc2 = supercircsDone.add(sibling2);
                if (!isFirstForCirc2) continue;
                for (Circuit supercirc : sibling2.getCircuitsUsingThis()) {
                    accessMap.put(supercirc, READ_WRITE);
                }
                continue;
            }
            if (!(factory instanceof VhdlEntity) || !(isFirstForVhdl = vhdlDone.add(sibling = (VhdlEntity)factory))) continue;
            for (Circuit supercirc : sibling.getCircuitsUsingThis()) {
                accessMap.put(supercirc, READ_WRITE);
            }
        }
        return accessMap;
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public void remove(Component comp) {
        this.changes.add(CircuitChange.remove(this.primary, comp));
    }

    public void removeAll(Collection<? extends Component> comps) {
        this.changes.add(CircuitChange.removeAll(this.primary, new ArrayList<Component>(comps)));
    }

    public void replace(Component oldComp, Component newComp) {
        ReplacementMap repl = new ReplacementMap(oldComp, newComp);
        this.changes.add(CircuitChange.replace(this.primary, repl));
    }

    public void replace(ReplacementMap replacements) {
        if (!replacements.isEmpty()) {
            replacements.freeze();
            this.changes.add(CircuitChange.replace(this.primary, replacements));
        }
    }

    @Override
    protected void run(CircuitMutator mutator) {
        Circuit curCircuit = null;
        ReplacementMap curReplacements = null;
        for (CircuitChange change : this.changes) {
            Circuit circ = change.getCircuit();
            if (circ != curCircuit) {
                if (curCircuit != null) {
                    mutator.replace(curCircuit, curReplacements);
                }
                curCircuit = circ;
                curReplacements = new ReplacementMap();
            }
            change.execute(mutator, curReplacements);
        }
        if (curCircuit != null) {
            mutator.replace(curCircuit, curReplacements);
        }
    }

    public void set(Component comp, Attribute<?> attr, Object value) {
        this.changes.add(CircuitChange.set(this.primary, comp, attr, value));
    }

    public void setForCircuit(Attribute<?> attr, Object value) {
        this.changes.add(CircuitChange.setForCircuit(this.primary, attr, value));
    }

    public Action toAction(StringGetter name) {
        if (name == null) {
            name = Strings.S.getter("unknownChangeAction");
        }
        return new CircuitAction(name, this);
    }
}

