/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitWires;
import com.cburch.logisim.circuit.ComponentDataGuiProvider;
import com.cburch.logisim.circuit.Propagator;
import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.Splitter;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentState;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.io.extra.Buzzer;
import com.cburch.logisim.std.memory.Ram;
import com.cburch.logisim.std.memory.RamState;
import com.cburch.logisim.std.wiring.Clock;
import com.cburch.logisim.std.wiring.Pin;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class CircuitState
implements InstanceData {
    private final MyCircuitListener myCircuitListener = new MyCircuitListener();
    private Propagator base = null;
    private final Project proj;
    private final Circuit circuit;
    private CircuitState parentState = null;
    private Component parentComp = null;
    private HashSet<CircuitState> subStates = new HashSet();
    private CircuitWires.State wireData = null;
    private final HashMap<Component, Object> componentData = new HashMap();
    private final Map<Location, Value> values = new HashMap<Location, Value>();
    private CopyOnWriteArraySet<Component> dirtyComponents = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<Location> dirtyPoints = new CopyOnWriteArraySet();
    final HashMap<Location, Propagator.SetData> causes = new HashMap();
    private static int lastId = 0;
    private final int id = lastId++;
    private boolean knownClocks;
    private Component temporaryClock;

    public CircuitState(Project proj, Circuit circuit) {
        this.proj = proj;
        this.circuit = circuit;
        circuit.addCircuitListener(this.myCircuitListener);
    }

    @Override
    public CircuitState clone() {
        return this.cloneState();
    }

    public CircuitState cloneState() {
        CircuitState ret = new CircuitState(this.proj, this.circuit);
        ret.copyFrom(this, new Propagator(ret));
        ret.parentComp = null;
        ret.parentState = null;
        return ret;
    }

    public boolean containsKey(Location pt) {
        return this.values.containsKey(pt);
    }

    private void copyFrom(CircuitState src, Propagator base) {
        Object newValue;
        Object oldValue;
        this.base = base;
        this.parentComp = src.parentComp;
        this.parentState = src.parentState;
        HashMap<CircuitState, CircuitState> substateData = new HashMap<CircuitState, CircuitState>();
        this.subStates = new HashSet();
        for (CircuitState circuitState : src.subStates) {
            CircuitState newSub = new CircuitState(src.proj, circuitState.circuit);
            newSub.copyFrom(circuitState, base);
            newSub.parentState = this;
            this.subStates.add(newSub);
            substateData.put(circuitState, newSub);
        }
        for (Component component : src.componentData.keySet()) {
            Object object;
            oldValue = src.componentData.get(component);
            if (oldValue instanceof CircuitState) {
                newValue = (CircuitState)substateData.get(oldValue);
                if (newValue != null) {
                    this.componentData.put(component, newValue);
                    continue;
                }
                this.componentData.remove(component);
                continue;
            }
            if (oldValue instanceof ComponentState) {
                ComponentState state = (ComponentState)oldValue;
                object = state.clone();
            } else {
                object = oldValue;
            }
            newValue = object;
            this.componentData.put(component, newValue);
        }
        for (Location location : src.causes.keySet()) {
            oldValue = src.causes.get(location);
            newValue = ((Propagator.SetData)oldValue).cloneFor(this);
            this.causes.put(location, (Propagator.SetData)newValue);
        }
        if (src.wireData != null) {
            this.wireData = (CircuitWires.State)src.wireData.clone();
        }
        this.values.putAll(src.values);
        this.dirtyComponents.addAll(src.dirtyComponents);
        this.dirtyPoints.addAll(src.dirtyPoints);
    }

    public void drawOscillatingPoints(ComponentDrawContext context) {
        if (this.base != null) {
            this.base.drawOscillatingPoints(context);
        }
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    Value getComponentOutputAt(Location p) {
        Propagator.SetData causeList = this.causes.get(p);
        return Propagator.computeValue(causeList);
    }

    public Object getData(Component comp) {
        return this.componentData.get(comp);
    }

    public InstanceState getInstanceState(Component comp) {
        ComponentFactory factory = comp.getFactory();
        if (factory instanceof InstanceFactory) {
            InstanceFactory instanceFactory = (InstanceFactory)factory;
            return instanceFactory.createInstanceState(this, comp);
        }
        throw new RuntimeException("getInstanceState requires instance component");
    }

    public InstanceState getInstanceState(Instance instance) {
        InstanceFactory factory = instance.getFactory();
        if (factory instanceof InstanceFactory) {
            return factory.createInstanceState(this, instance);
        }
        throw new RuntimeException("getInstanceState() requires instance component");
    }

    public CircuitState getParentState() {
        return this.parentState;
    }

    public Project getProject() {
        return this.proj;
    }

    public Propagator getPropagator() {
        if (this.base == null) {
            this.base = new Propagator(this);
            this.markAllComponentsDirty();
        }
        return this.base;
    }

    Component getSubcircuit() {
        return this.parentComp;
    }

    public Set<CircuitState> getSubStates() {
        return this.subStates;
    }

    public Value getValue(Location pt) {
        Value ret = this.values.get(pt);
        if (ret != null) {
            return ret;
        }
        BitWidth wid = this.circuit.getWidth(pt);
        return Value.createUnknown(wid);
    }

    Value getValueByWire(Location p) {
        return this.values.get(p);
    }

    CircuitWires.State getWireData() {
        return this.wireData;
    }

    public boolean isSubstate() {
        return this.parentState != null;
    }

    private void markAllComponentsDirty() {
        this.dirtyComponents.addAll(this.circuit.getNonWires());
    }

    public void markComponentAsDirty(Component comp) {
        try {
            this.dirtyComponents.add(comp);
        }
        catch (RuntimeException e) {
            CopyOnWriteArraySet<Component> set = new CopyOnWriteArraySet<Component>();
            set.add(comp);
            this.dirtyComponents = set;
        }
    }

    public void markComponentsDirty(Collection<Component> comps) {
        this.dirtyComponents.addAll(comps);
    }

    public void markPointAsDirty(Location pt) {
        this.dirtyPoints.add(pt);
    }

    void processDirtyComponents() {
        if (!this.dirtyComponents.isEmpty()) {
            Object[] toProcess;
            RuntimeException firstException = null;
            int tries = 4;
            while (true) {
                try {
                    toProcess = this.dirtyComponents.toArray();
                }
                catch (RuntimeException e) {
                    if (firstException == null) {
                        firstException = e;
                    }
                    if (tries == 0) {
                        Object[] toProcess2 = new Object[]{};
                        this.dirtyComponents = new CopyOnWriteArraySet();
                        throw firstException;
                    }
                    --tries;
                    continue;
                }
                break;
            }
            this.dirtyComponents.clear();
            Object[] objectArray = toProcess;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object compObj = objectArray[i];
                if (!(compObj instanceof Component)) continue;
                Component comp = (Component)compObj;
                comp.propagate(this);
                if (!(comp.getFactory() instanceof Pin) || this.parentState == null) continue;
                this.parentComp.propagate(this.parentState);
            }
        }
        CircuitState[] subs = new CircuitState[this.subStates.size()];
        for (CircuitState substate : this.subStates.toArray(subs)) {
            substate.processDirtyComponents();
        }
    }

    void processDirtyPoints() {
        HashSet<Location> dirty = new HashSet<Location>(this.dirtyPoints);
        this.dirtyPoints.clear();
        if (this.circuit.wires.isMapVoided()) {
            for (int i = 3; i >= 0; --i) {
                try {
                    dirty.addAll(this.circuit.wires.points.getSplitLocations());
                    break;
                }
                catch (ConcurrentModificationException e) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (i != 0) continue;
                    e.printStackTrace();
                    continue;
                }
            }
        }
        if (!dirty.isEmpty()) {
            this.circuit.wires.propagate(this, dirty);
        }
        CircuitState[] subs = new CircuitState[this.subStates.size()];
        for (CircuitState substate : this.subStates.toArray(subs)) {
            if (substate == null) continue;
            substate.processDirtyPoints();
        }
    }

    void reset() {
        this.temporaryClock = null;
        this.wireData = null;
        for (Component comp : this.componentData.keySet()) {
            ComponentFactory componentFactory = comp.getFactory();
            if (componentFactory instanceof Ram) {
                Ram ram = (Ram)componentFactory;
                boolean remove = ram.reset(this, Instance.getInstanceFor(comp));
                if (!remove) continue;
                this.componentData.put(comp, null);
                continue;
            }
            if (comp.getFactory() instanceof Buzzer) {
                Buzzer.stopBuzzerSound(comp, this);
                continue;
            }
            if (comp.getFactory() instanceof SubcircuitFactory) continue;
            Object object = this.componentData.get(comp);
            if (object instanceof ComponentDataGuiProvider) {
                ComponentDataGuiProvider guiProvider = (ComponentDataGuiProvider)object;
                guiProvider.destroy();
            }
            this.componentData.put(comp, null);
        }
        this.values.clear();
        this.dirtyComponents.clear();
        this.dirtyPoints.clear();
        this.causes.clear();
        this.markAllComponentsDirty();
        for (CircuitState sub : this.subStates) {
            sub.reset();
        }
    }

    public void setData(Component comp, Object data) {
        if (data instanceof CircuitState) {
            CircuitState newState = (CircuitState)data;
            CircuitState oldState = (CircuitState)this.componentData.get(comp);
            if (oldState != newState) {
                if (oldState != null && oldState.parentComp == comp) {
                    this.subStates.remove(oldState);
                    oldState.parentState = null;
                    oldState.parentComp = null;
                    oldState.reset();
                }
                if (newState != null && newState.parentState != this) {
                    this.subStates.add(newState);
                    newState.base = this.base;
                    newState.parentState = this;
                    newState.parentComp = comp;
                    newState.markAllComponentsDirty();
                }
            }
        } else if (this.componentData.get(comp) instanceof ComponentDataGuiProvider) {
            ((ComponentDataGuiProvider)this.componentData.get(comp)).destroy();
        }
        this.componentData.put(comp, data);
    }

    public void setValue(Location pt, Value val, Component cause, int delay) {
        if (this.base != null) {
            this.base.setValue(this, pt, val, cause, delay);
        }
    }

    void setValueByWire(Location p, Value v) {
        boolean changed;
        if (v == Value.NIL) {
            old = this.values.remove(p);
            changed = old != null && old != Value.NIL;
        } else {
            old = this.values.put(p, v);
            boolean bl = changed = !v.equals(old);
        }
        if (changed) {
            boolean found = false;
            for (Component component : this.circuit.getComponents(p)) {
                if (component instanceof Wire || component instanceof Splitter) continue;
                found = true;
                this.markComponentAsDirty(component);
            }
            if (found && this.base != null) {
                this.base.locationTouched(this, p);
            }
        }
    }

    void setWireData(CircuitWires.State data) {
        this.wireData = data;
    }

    boolean toggleClocks(int ticks) {
        boolean ret = false;
        if (this.temporaryClock != null) {
            ret |= this.temporaryClockValidateOrTick(ticks);
        }
        for (Component clock : this.circuit.getClocks()) {
            ret |= Clock.tick(this, ticks, clock);
        }
        CircuitState[] subs = new CircuitState[this.subStates.size()];
        for (CircuitState substate : this.subStates.toArray(subs)) {
            ret |= substate.toggleClocks(ticks);
        }
        return ret;
    }

    private boolean temporaryClockValidateOrTick(int ticks) {
        try {
            Pin pin = (Pin)this.temporaryClock.getFactory();
            Instance instance = Instance.getInstanceFor(this.temporaryClock);
            if (instance == null || !pin.isInputPin(instance) || pin.getWidth(instance).getWidth() != 1) {
                this.temporaryClock = null;
                return false;
            }
            if (ticks >= 0) {
                InstanceState state = this.getInstanceState(instance);
                pin.setValue(state, ticks % 2 == 0 ? Value.FALSE : Value.TRUE);
                state.fireInvalidated();
            }
            return true;
        }
        catch (ClassCastException e) {
            this.temporaryClock = null;
            return false;
        }
    }

    public boolean hasKnownClocks() {
        return this.knownClocks || this.temporaryClock != null;
    }

    public void markKnownClocks() {
        this.knownClocks = true;
    }

    public boolean setTemporaryClock(Component clk) {
        this.temporaryClock = clk;
        return clk == null || this.temporaryClockValidateOrTick(-1);
    }

    public Component getTemporaryClock() {
        return this.temporaryClock;
    }

    public String toString() {
        return "State" + this.id + "[" + this.circuit.getName() + "]";
    }

    private class MyCircuitListener
    implements CircuitListener {
        private MyCircuitListener() {
        }

        @Override
        public void circuitChanged(CircuitEvent event) {
            int action = event.getAction();
            if (action == 1) {
                Component comp = (Component)event.getData();
                if (comp instanceof Wire) {
                    Wire wire = (Wire)comp;
                    CircuitState.this.markPointAsDirty(wire.getEnd0());
                    CircuitState.this.markPointAsDirty(wire.getEnd1());
                } else {
                    CircuitState.this.markComponentAsDirty(comp);
                }
            } else if (action == 2) {
                Component comp = (Component)event.getData();
                if (comp == CircuitState.this.temporaryClock) {
                    CircuitState.this.temporaryClock = null;
                }
                if (comp.getFactory() instanceof Clock) {
                    CircuitState.this.knownClocks = false;
                }
                if (comp.getFactory() instanceof SubcircuitFactory) {
                    CircuitState.this.knownClocks = false;
                    CircuitState circuitState = (CircuitState)CircuitState.this.getData(comp);
                    if (circuitState != null && circuitState.parentComp == comp) {
                        CircuitState.this.subStates.remove(circuitState);
                        circuitState.parentState = null;
                        circuitState.parentComp = null;
                        circuitState.reset();
                    }
                } else {
                    Object object = CircuitState.this.getData(comp);
                    if (object instanceof ComponentDataGuiProvider) {
                        ComponentDataGuiProvider guiProvider = (ComponentDataGuiProvider)object;
                        guiProvider.destroy();
                    }
                }
                if (comp instanceof Wire) {
                    Wire w = (Wire)comp;
                    CircuitState.this.markPointAsDirty(w.getEnd0());
                    CircuitState.this.markPointAsDirty(w.getEnd1());
                } else {
                    if (CircuitState.this.base != null) {
                        CircuitState.this.base.checkComponentEnds(CircuitState.this, comp);
                    }
                    CircuitState.this.dirtyComponents.remove(comp);
                }
            } else if (action == 5) {
                CircuitState.this.temporaryClock = null;
                CircuitState.this.knownClocks = false;
                CircuitState.this.subStates.clear();
                CircuitState.this.wireData = null;
                for (Component comp : CircuitState.this.componentData.keySet()) {
                    Object object = CircuitState.this.componentData.get(comp);
                    if (object instanceof ComponentDataGuiProvider) {
                        ComponentDataGuiProvider componentDataGuiProvider = (ComponentDataGuiProvider)object;
                        componentDataGuiProvider.destroy();
                        continue;
                    }
                    object = CircuitState.this.componentData.get(comp);
                    if (!(object instanceof CircuitState)) continue;
                    CircuitState circuitState = (CircuitState)object;
                    circuitState.reset();
                }
                CircuitState.this.componentData.clear();
                CircuitState.this.values.clear();
                CircuitState.this.dirtyComponents.clear();
                CircuitState.this.dirtyPoints.clear();
                CircuitState.this.causes.clear();
            } else if (action == 4) {
                Component comp = (Component)event.getData();
                CircuitState.this.markComponentAsDirty(comp);
                CircuitState.this.proj.getSimulator().addPendingInput(CircuitState.this, comp);
            } else if (action == 6) {
                ReplacementMap map = event.getResult().getReplacementMap(CircuitState.this.circuit);
                if (map == null) {
                    return;
                }
                for (Component component : map.getRemovals()) {
                    Object compState = CircuitState.this.componentData.remove(component);
                    if (compState != null) continue;
                    Class<?> compFactory = component.getFactory().getClass();
                    boolean found = false;
                    for (Component repl : map.getReplacementsFor(component)) {
                        if (repl.getFactory().getClass() != compFactory) continue;
                        found = true;
                        CircuitState.this.setData(repl, compState);
                        break;
                    }
                    if (!found && compState instanceof RamState) {
                        RamState state = (RamState)compState;
                        Ram.closeHexFrame(state);
                    }
                    if (found || !(compState instanceof CircuitState)) continue;
                    CircuitState sub = (CircuitState)compState;
                    sub.parentState = null;
                    CircuitState.this.subStates.remove(sub);
                }
            }
        }
    }
}

