/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.CircuitPoints;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Splitter;
import com.cburch.logisim.circuit.SplitterAttributes;
import com.cburch.logisim.circuit.WidthIncompatibilityData;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.circuit.WireBundle;
import com.cburch.logisim.circuit.WireSet;
import com.cburch.logisim.circuit.WireThread;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.PullResistor;
import com.cburch.logisim.std.wiring.Tunnel;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.IteratorUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CircuitWires {
    static final Logger logger = LoggerFactory.getLogger(CircuitWires.class);
    private final HashSet<Wire> wires = new HashSet();
    private final HashSet<Splitter> splitters = new HashSet();
    private final HashSet<Component> tunnels = new HashSet();
    private final TunnelListener tunnelListener = new TunnelListener();
    private final HashSet<Component> pulls = new HashSet();
    final CircuitPoints points = new CircuitPoints();
    private Bounds bounds = Bounds.EMPTY_BOUNDS;
    private BundleMap masterBundleMap = null;

    private static Value pullValue(Value base, Value pullTo) {
        if (base.isFullyDefined()) {
            return base;
        }
        if (base.getWidth() == 1) {
            if (base == Value.UNKNOWN) {
                return pullTo;
            }
            return base;
        }
        Value[] ret = base.getAll();
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i] != Value.UNKNOWN) continue;
            ret[i] = pullTo;
        }
        return Value.create(ret);
    }

    CircuitWires() {
    }

    boolean add(Component comp) {
        boolean added = true;
        if (comp instanceof Wire) {
            Wire wire = (Wire)comp;
            added = this.addWire(wire);
        } else if (comp instanceof Splitter) {
            Splitter splitter = (Splitter)comp;
            this.splitters.add(splitter);
        } else {
            ComponentFactory factory = comp.getFactory();
            if (factory instanceof Tunnel) {
                this.tunnels.add(comp);
                comp.getAttributeSet().addAttributeListener(this.tunnelListener);
            } else if (factory instanceof PullResistor) {
                this.pulls.add(comp);
                comp.getAttributeSet().addAttributeListener(this.tunnelListener);
            }
        }
        if (added) {
            this.points.add(comp);
            this.voidBundleMap();
        }
        return added;
    }

    void add(Component comp, EndData end) {
        this.points.add(comp, end);
        this.voidBundleMap();
    }

    private boolean addWire(Wire w) {
        boolean added = this.wires.add(w);
        if (!added) {
            return false;
        }
        if (this.bounds != Bounds.EMPTY_BOUNDS) {
            this.bounds = this.bounds.add(w.e0).add(w.e1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeBundleMap(BundleMap ret) {
        Object end;
        Object ends;
        this.connectWires(ret);
        this.connectTunnels(ret);
        this.connectPullResistors(ret);
        Iterator<Object> it = ret.getBundles().iterator();
        while (it.hasNext()) {
            WireBundle b = it.next();
            WireBundle bpar = b.find();
            if (bpar == b) continue;
            for (Location pt : b.points) {
                ret.setBundleAt(pt, bpar);
                bpar.points.add(pt);
            }
            bpar.addPullValue(b.getPullValue());
            it.remove();
        }
        for (Splitter spl : this.splitters) {
            ends = new ArrayList<EndData>(spl.getEnds());
            Iterator<Object> iterator = ((ArrayList)ends).iterator();
            while (iterator.hasNext()) {
                end = (EndData)iterator.next();
                Location p = ((EndData)end).getLocation();
                WireBundle pb = ret.createBundleAt(p);
                pb.setWidth(((EndData)end).getWidth(), p);
            }
        }
        for (Location p : ret.getBundlePoints()) {
            WireBundle pb = ret.getBundleAt(p);
            BitWidth width = this.points.getWidth(p);
            if (width == BitWidth.UNKNOWN) continue;
            pb.setWidth(width, p);
        }
        for (Splitter spl : this.splitters) {
            ends = new ArrayList<EndData>(spl.getEnds());
            int index = -1;
            end = ((ArrayList)ends).iterator();
            while (end.hasNext()) {
                EndData end2 = (EndData)end.next();
                ++index;
                Location p = end2.getLocation();
                WireBundle pb = ret.getBundleAt(p);
                if (pb == null) continue;
                pb.setWidth(end2.getWidth(), p);
                spl.wireData.endBundle[index] = pb;
            }
        }
        for (Splitter spl : this.splitters) {
            ends = spl;
            synchronized (ends) {
                SplitterAttributes splAttrs = (SplitterAttributes)spl.getAttributeSet();
                byte[] bitEnd = splAttrs.bitEnd;
                SplitterData splData = spl.wireData;
                WireBundle fromBundle = splData.endBundle[0];
                if (fromBundle == null || !fromBundle.isValid()) {
                    continue;
                }
                for (int i = 0; i < bitEnd.length; ++i) {
                    byte j = bitEnd[i];
                    if (j <= 0) continue;
                    byte thr = spl.bitThread[i];
                    WireBundle toBundle = splData.endBundle[j];
                    WireThread[] toThreads = toBundle.threads;
                    if (toThreads == null || !toBundle.isValid()) continue;
                    WireThread[] fromThreads = fromBundle.threads;
                    if (i >= fromThreads.length) {
                        throw new ArrayIndexOutOfBoundsException("from " + i + " of " + fromThreads.length);
                    }
                    if (thr >= toThreads.length) {
                        throw new ArrayIndexOutOfBoundsException("to " + thr + " of " + toThreads.length);
                    }
                    fromThreads[i].unite(toThreads[thr]);
                }
            }
        }
        for (WireBundle wireBundle : ret.getBundles()) {
            if (!wireBundle.isValid() || wireBundle.threads == null) continue;
            for (int i = 0; i < wireBundle.threads.length; ++i) {
                WireThread thr;
                wireBundle.threads[i] = thr = wireBundle.threads[i].find();
                thr.getBundles().add(new ThreadBundle(i, wireBundle));
            }
        }
        Collection<WidthIncompatibilityData> exceptions = this.points.getWidthIncompatibilityData();
        if (CollectionUtil.isNotEmpty(exceptions)) {
            for (WidthIncompatibilityData wid : exceptions) {
                ret.addWidthIncompatibilityData(wid);
            }
        }
        for (WireBundle wireBundle : ret.getBundles()) {
            WidthIncompatibilityData e = wireBundle.getWidthIncompatibilityData();
            if (e == null) continue;
            ret.addWidthIncompatibilityData(e);
        }
    }

    private void connectPullResistors(BundleMap ret) {
        for (Component comp : this.pulls) {
            Location loc = comp.getEnd(0).getLocation();
            WireBundle b = ret.getBundleAt(loc);
            if (b == null) {
                b = ret.createBundleAt(loc);
                b.points.add(loc);
                ret.setBundleAt(loc, b);
            }
            Instance instance = Instance.getInstanceFor(comp);
            b.addPullValue(PullResistor.getPullValue(instance));
        }
    }

    private void connectTunnels(BundleMap ret) {
        HashMap<String, ArrayList> tunnelSets = new HashMap<String, ArrayList>();
        for (Component comp : this.tunnels) {
            String label = comp.getAttributeSet().getValue(StdAttr.LABEL).trim();
            if (label.equals("")) continue;
            ArrayList tunnelSet = tunnelSets.computeIfAbsent(label, k -> new ArrayList(3));
            tunnelSet.add(comp.getLocation());
        }
        for (ArrayList tunnelSet : tunnelSets.values()) {
            WireBundle bundle;
            WireBundle foundBundle = null;
            Location foundLocation = null;
            for (Location loc : tunnelSet) {
                bundle = ret.getBundleAt(loc);
                if (bundle == null) continue;
                foundBundle = bundle;
                foundLocation = loc;
                break;
            }
            if (foundBundle == null) {
                foundLocation = (Location)tunnelSet.get(0);
                foundBundle = ret.createBundleAt(foundLocation);
            }
            for (Location loc : tunnelSet) {
                if (loc == foundLocation) continue;
                bundle = ret.getBundleAt(loc);
                if (bundle == null) {
                    foundBundle.points.add(loc);
                    ret.setBundleAt(loc, foundBundle);
                    continue;
                }
                bundle.unite(foundBundle);
            }
        }
    }

    private void connectWires(BundleMap ret) {
        for (Wire wire : this.wires) {
            WireBundle bundleB;
            WireBundle bundleA = ret.getBundleAt(wire.e0);
            if (bundleA == null) {
                bundleB = ret.createBundleAt(wire.e1);
                bundleB.points.add(wire.e0);
                ret.setBundleAt(wire.e0, bundleB);
                continue;
            }
            bundleB = ret.getBundleAt(wire.e1);
            if (bundleB == null) {
                bundleA.points.add(wire.e1);
                ret.setBundleAt(wire.e1, bundleA);
                continue;
            }
            bundleB.unite(bundleA);
        }
    }

    void draw(ComponentDrawContext context, Collection<Component> hidden) {
        boolean showState = context.getShowState();
        CircuitState state = context.getCircuitState();
        Graphics2D g = (Graphics2D)context.getGraphics();
        g.setColor(Color.BLACK);
        GraphicsUtil.switchToWidth(g, 3);
        WireSet highlighted = context.getHighlightedWires();
        BundleMap bmap = this.getBundleMap();
        boolean isValid = bmap.isValid();
        if (CollectionUtil.isNullOrEmpty(hidden)) {
            for (Wire wire : this.wires) {
                Location s = wire.e0;
                Location t = wire.e1;
                WireBundle wireBundle = bmap.getBundleAt(s);
                int width = 5;
                if (!wireBundle.isValid()) {
                    g.setColor(Value.widthErrorColor);
                } else if (showState) {
                    g.setColor(!isValid ? Value.nilColor : state.getValue(s).getColor());
                } else {
                    g.setColor(Color.BLACK);
                }
                if (highlighted.containsWire(wire)) {
                    width = wireBundle.isBus() ? 5 : 4;
                    GraphicsUtil.switchToWidth(g, width);
                    g.drawLine(s.getX(), s.getY(), t.getX(), t.getY());
                    Stroke oldStroke = g.getStroke();
                    g.setStroke(Wire.HIGHLIGHTED_STROKE);
                    g.setColor(Value.strokeColor);
                    g.drawLine(s.getX(), s.getY(), t.getX(), t.getY());
                    g.setStroke(oldStroke);
                } else {
                    width = wireBundle.isBus() ? 4 : 3;
                    GraphicsUtil.switchToWidth(g, width);
                    g.drawLine(s.getX(), s.getY(), t.getX(), t.getY());
                }
                if (!wire.isDrcHighlighted()) continue;
                width += 2;
                g.setColor(wire.getDrcHighlightColor());
                GraphicsUtil.switchToWidth(g, 2);
                if (wire.isVertical()) {
                    g.drawLine(s.getX() - width, s.getY(), t.getX() - width, t.getY());
                    g.drawLine(s.getX() + width, s.getY(), t.getX() + width, t.getY());
                    continue;
                }
                g.drawLine(s.getX(), s.getY() - width, t.getX(), t.getY() - width);
                g.drawLine(s.getX(), s.getY() + width, t.getX(), t.getY() + width);
            }
            for (Location loc : this.points.getSplitLocations()) {
                WireBundle wb;
                if (this.points.getComponentCount(loc) <= 2 || (wb = bmap.getBundleAt(loc)) == null) continue;
                Color color = Color.BLACK;
                if (!wb.isValid()) {
                    color = Value.widthErrorColor;
                } else if (showState) {
                    color = !isValid ? Value.nilColor : state.getValue(loc).getColor();
                }
                g.setColor(color);
                int n = highlighted.containsLocation(loc) ? (wb.isBus() ? 6 : 5) : (wb.isBus() ? 5 : 4);
                n = (int)((double)n * 1.35);
                g.fillOval(loc.getX() - n, loc.getY() - n, n * 2, n * 2);
            }
        } else {
            for (Wire wire : this.wires) {
                if (hidden.contains(wire)) continue;
                Location s = wire.e0;
                Location t = wire.e1;
                WireBundle wireBundle = bmap.getBundleAt(s);
                if (!wireBundle.isValid()) {
                    g.setColor(Value.widthErrorColor);
                } else if (showState) {
                    g.setColor(!isValid ? Value.nilColor : state.getValue(s).getColor());
                } else {
                    g.setColor(Color.BLACK);
                }
                if (highlighted.containsWire(wire)) {
                    GraphicsUtil.switchToWidth(g, 5);
                    g.drawLine(s.getX(), s.getY(), t.getX(), t.getY());
                    GraphicsUtil.switchToWidth(g, 3);
                    continue;
                }
                GraphicsUtil.switchToWidth(g, wireBundle.isBus() ? 4 : 3);
                g.drawLine(s.getX(), s.getY(), t.getX(), t.getY());
            }
            for (Location loc : this.points.getSplitLocations()) {
                WireBundle wireBundle;
                if (this.points.getComponentCount(loc) <= 2) continue;
                int icount = 0;
                for (Component component : this.points.getComponents(loc)) {
                    if (hidden.contains(component)) continue;
                    ++icount;
                }
                if (icount <= 2 || (wireBundle = bmap.getBundleAt(loc)) == null) continue;
                if (!wireBundle.isValid()) {
                    g.setColor(Value.widthErrorColor);
                } else if (showState) {
                    g.setColor(!isValid ? Value.nilColor : state.getValue(loc).getColor());
                } else {
                    g.setColor(Color.BLACK);
                }
                int n2 = highlighted.containsLocation(loc) ? (wireBundle.isBus() ? 5 : 4) : (wireBundle.isBus() ? 4 : 3);
                n2 = (int)((double)n2 * 1.35);
                g.fillOval(loc.getX() - n2, loc.getY() - n2, n2 * 2, n2 * 2);
            }
        }
    }

    private BundleMap getBundleMap() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.masterBundleMap != null) {
                return this.masterBundleMap;
            }
            BundleMap ret = new BundleMap();
            try {
                this.computeBundleMap(ret);
                this.masterBundleMap = ret;
            }
            catch (Exception t) {
                ret.invalidate();
                logger.error(t.getLocalizedMessage());
            }
            return ret;
        }
        try {
            BundleMap[] ret = new BundleMap[1];
            SwingUtilities.invokeAndWait(() -> {
                ret[0] = this.getBundleMap();
            });
            return ret[0];
        }
        catch (Exception e) {
            BundleMap ret = new BundleMap();
            ret.invalidate();
            return ret;
        }
    }

    Iterator<? extends Component> getComponents() {
        return IteratorUtil.createJoinedIterator(this.splitters.iterator(), this.wires.iterator());
    }

    private Value getThreadValue(CircuitState state, WireThread t) {
        Value ret = Value.UNKNOWN;
        Value pull = Value.UNKNOWN;
        for (ThreadBundle tb : t.getBundles()) {
            for (Location p : tb.b.points) {
                Value val = state.getComponentOutputAt(p);
                if (val == null || val == Value.NIL) continue;
                ret = ret.combine(val.get(tb.loc));
            }
            Value pullHere = tb.b.getPullValue();
            if (pullHere == Value.UNKNOWN) continue;
            pull = pull.combine(pullHere);
        }
        if (pull != Value.UNKNOWN) {
            ret = CircuitWires.pullValue(ret, pull);
        }
        return ret;
    }

    BitWidth getWidth(Location q) {
        BitWidth det = this.points.getWidth(q);
        if (det != BitWidth.UNKNOWN) {
            return det;
        }
        BundleMap bmap = this.getBundleMap();
        if (!bmap.isValid()) {
            return BitWidth.UNKNOWN;
        }
        WireBundle qb = bmap.getBundleAt(q);
        if (qb != null && qb.isValid()) {
            return qb.getWidth();
        }
        return BitWidth.UNKNOWN;
    }

    Location getWidthDeterminant(Location q) {
        BitWidth det = this.points.getWidth(q);
        if (det != BitWidth.UNKNOWN) {
            return q;
        }
        WireBundle qb = this.getBundleMap().getBundleAt(q);
        if (qb != null && qb.isValid()) {
            return qb.getWidthDeterminant();
        }
        return q;
    }

    Set<WidthIncompatibilityData> getWidthIncompatibilityData() {
        return this.getBundleMap().getWidthIncompatibilityData();
    }

    Bounds getWireBounds() {
        Bounds bds = this.bounds;
        if (bds == Bounds.EMPTY_BOUNDS) {
            bds = this.recomputeBounds();
        }
        return bds;
    }

    WireBundle getWireBundle(Location query) {
        BundleMap bundleMap = this.getBundleMap();
        return bundleMap.getBundleAt(query);
    }

    Set<Wire> getWires() {
        return this.wires;
    }

    WireSet getWireSet(Wire start) {
        WireBundle wireBundle = this.getWireBundle(start.e0);
        if (wireBundle == null) {
            return WireSet.EMPTY;
        }
        HashSet<Wire> wires = new HashSet<Wire>();
        for (Location loc : wireBundle.points) {
            wires.addAll(this.points.getWires(loc));
        }
        return new WireSet(wires);
    }

    boolean isMapVoided() {
        return this.masterBundleMap == null;
    }

    void propagate(CircuitState circState, Set<Location> points) {
        BundleMap map = this.getBundleMap();
        CopyOnWriteArraySet<WireThread> dirtyThreads = new CopyOnWriteArraySet<WireThread>();
        State state = circState.getWireData();
        if (state == null || state.bundleMap != map) {
            state = new State(map);
            for (WireBundle bundle : map.getBundles()) {
                WireThread[] wireThreads = bundle.threads;
                if (!bundle.isValid() || wireThreads == null) continue;
                dirtyThreads.addAll(Arrays.asList(wireThreads));
            }
            circState.setWireData(state);
        }
        for (Location point : points) {
            WireBundle wireBundle = map.getBundleAt(point);
            if (wireBundle == null) {
                circState.setValueByWire(point, circState.getComponentOutputAt(point));
                continue;
            }
            WireThread[] th = wireBundle.threads;
            if (!wireBundle.isValid() || th == null) {
                CopyOnWriteArraySet<Location> pbPoints = wireBundle.points;
                if (pbPoints == null) {
                    circState.setValueByWire(point, Value.NIL);
                    continue;
                }
                for (Location loc2 : pbPoints) {
                    circState.setValueByWire(loc2, Value.NIL);
                }
                continue;
            }
            dirtyThreads.addAll(Arrays.asList(th));
        }
        if (dirtyThreads.isEmpty()) {
            return;
        }
        HashSet<ThreadBundle> bundles = new HashSet<ThreadBundle>();
        for (WireThread t : dirtyThreads) {
            Value v = this.getThreadValue(circState, t);
            state.thrValues.put(t, v);
            bundles.addAll(t.getBundles());
        }
        for (ThreadBundle tb : bundles) {
            WireBundle b = tb.b;
            Value bv = null;
            if (b.isValid() && b.threads != null) {
                if (b.threads.length == 1) {
                    bv = state.thrValues.get(b.threads[0]);
                } else {
                    Value[] tvs = new Value[b.threads.length];
                    boolean tvsValid = true;
                    for (int i = 0; i < tvs.length; ++i) {
                        Value tv = state.thrValues.get(b.threads[i]);
                        if (tv == null) {
                            tvsValid = false;
                            break;
                        }
                        tvs[i] = tv;
                    }
                    if (tvsValid) {
                        bv = Value.create(tvs);
                    }
                }
            }
            if (bv == null) continue;
            for (Location p : b.points) {
                circState.setValueByWire(p, bv);
            }
        }
    }

    private Bounds recomputeBounds() {
        Iterator<Wire> it = this.wires.iterator();
        if (!it.hasNext()) {
            this.bounds = Bounds.EMPTY_BOUNDS;
            return Bounds.EMPTY_BOUNDS;
        }
        Wire w = it.next();
        int xmin = w.e0.getX();
        int ymin = w.e0.getY();
        int xmax = w.e1.getX();
        int ymax = w.e1.getY();
        while (it.hasNext()) {
            int y1;
            int y0;
            int x1;
            w = it.next();
            int x0 = w.e0.getX();
            if (x0 < xmin) {
                xmin = x0;
            }
            if ((x1 = w.e1.getX()) > xmax) {
                xmax = x1;
            }
            if ((y0 = w.e0.getY()) < ymin) {
                ymin = y0;
            }
            if ((y1 = w.e1.getY()) <= ymax) continue;
            ymax = y1;
        }
        this.bounds = Bounds.create(xmin, ymin, xmax - xmin + 1, ymax - ymin + 1);
        return this.bounds;
    }

    void remove(Component comp) {
        if (comp instanceof Wire) {
            Wire wire = (Wire)comp;
            this.removeWire(wire);
        } else if (comp instanceof Splitter) {
            this.splitters.remove(comp);
        } else {
            ComponentFactory factory = comp.getFactory();
            if (factory instanceof Tunnel) {
                this.tunnels.remove(comp);
                comp.getAttributeSet().removeAttributeListener(this.tunnelListener);
            } else if (factory instanceof PullResistor) {
                this.pulls.remove(comp);
                comp.getAttributeSet().removeAttributeListener(this.tunnelListener);
            }
        }
        this.points.remove(comp);
        this.voidBundleMap();
    }

    void remove(Component comp, EndData end) {
        this.points.remove(comp, end);
        this.voidBundleMap();
    }

    private void removeWire(Wire w) {
        Bounds smaller;
        if (!this.wires.remove(w)) {
            return;
        }
        if (!(this.bounds == Bounds.EMPTY_BOUNDS || (smaller = this.bounds.expand(-2)).contains(w.e0) && smaller.contains(w.e1))) {
            this.bounds = Bounds.EMPTY_BOUNDS;
        }
    }

    void replace(Component comp, EndData oldEnd, EndData newEnd) {
        this.points.remove(comp, oldEnd);
        this.points.add(comp, newEnd);
        this.voidBundleMap();
    }

    private void voidBundleMap() {
        this.masterBundleMap = null;
    }

    private class TunnelListener
    implements AttributeListener {
        private TunnelListener() {
        }

        @Override
        public void attributeListChanged(AttributeEvent e) {
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            Attribute<?> attr = e.getAttribute();
            if (attr == StdAttr.LABEL || attr == PullResistor.ATTR_PULL_TYPE) {
                CircuitWires.this.voidBundleMap();
            }
        }
    }

    static class BundleMap {
        final HashMap<Location, WireBundle> pointBundles = new HashMap();
        final HashSet<WireBundle> bundles = new HashSet();
        boolean isValid = true;
        HashSet<WidthIncompatibilityData> incompatibilityData = null;

        BundleMap() {
        }

        void addWidthIncompatibilityData(WidthIncompatibilityData e) {
            if (this.incompatibilityData == null) {
                this.incompatibilityData = new HashSet();
            }
            this.incompatibilityData.add(e);
        }

        WireBundle createBundleAt(Location p) {
            WireBundle ret = this.pointBundles.get(p);
            if (ret == null) {
                ret = new WireBundle();
                this.pointBundles.put(p, ret);
                ret.points.add(p);
                this.bundles.add(ret);
            }
            return ret;
        }

        WireBundle getBundleAt(Location p) {
            return this.pointBundles.get(p);
        }

        Set<Location> getBundlePoints() {
            return this.pointBundles.keySet();
        }

        Set<WireBundle> getBundles() {
            return this.bundles;
        }

        HashSet<WidthIncompatibilityData> getWidthIncompatibilityData() {
            return this.incompatibilityData;
        }

        void invalidate() {
            this.isValid = false;
        }

        boolean isValid() {
            return this.isValid;
        }

        void setBundleAt(Location p, WireBundle b) {
            this.pointBundles.put(p, b);
        }
    }

    static class SplitterData {
        final WireBundle[] endBundle;

        SplitterData(int fanOut) {
            this.endBundle = new WireBundle[fanOut + 1];
        }
    }

    static class ThreadBundle {
        final int loc;
        final WireBundle b;

        ThreadBundle(int loc, WireBundle b) {
            this.loc = loc;
            this.b = b;
        }
    }

    static class State {
        final BundleMap bundleMap;
        final HashMap<WireThread, Value> thrValues = new HashMap();

        State(BundleMap bundleMap) {
            this.bundleMap = bundleMap;
        }

        public Object clone() {
            State ret = new State(this.bundleMap);
            ret.thrValues.putAll(this.thrValues);
            return ret;
        }
    }
}

