/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.util.StringGetter;

public abstract class RadixOption
extends AttributeOption {
    public static final RadixOption RADIX_2 = new Radix2();
    public static final RadixOption RADIX_8 = new Radix8();
    public static final RadixOption RADIX_10_UNSIGNED = new Radix10Unsigned();
    public static final RadixOption RADIX_10_SIGNED = new Radix10Signed();
    public static final RadixOption RADIX_16 = new Radix16();
    public static final RadixOption RADIX_FLOAT = new RadixFloat();
    public static final RadixOption[] OPTIONS = new RadixOption[]{RADIX_2, RADIX_8, RADIX_10_SIGNED, RADIX_10_UNSIGNED, RADIX_16, RADIX_FLOAT};
    public static final Attribute<RadixOption> ATTRIBUTE = Attributes.forOption("radix", Strings.S.getter("radixAttr"), OPTIONS);
    private final String saveName;
    private final StringGetter displayGetter;

    public static RadixOption decode(String value) {
        for (RadixOption opt : OPTIONS) {
            if (!value.equals(opt.saveName)) continue;
            return opt;
        }
        return RADIX_2;
    }

    private RadixOption(String saveName, StringGetter displayGetter) {
        super(saveName, displayGetter);
        this.saveName = saveName;
        this.displayGetter = displayGetter;
    }

    @Override
    public StringGetter getDisplayGetter() {
        return this.displayGetter;
    }

    public abstract int getMaxLength(BitWidth var1);

    public int getMaxLength(Value value) {
        return this.getMaxLength(value.getBitWidth());
    }

    public String getSaveString() {
        return this.saveName;
    }

    @Override
    public String toDisplayString() {
        return this.displayGetter.toString();
    }

    public String getIndexChar() {
        return "";
    }

    @Override
    public String toString() {
        return this.saveName;
    }

    public abstract String toString(Value var1);

    private static class Radix2
    extends RadixOption {
        private Radix2() {
            super("2", Strings.S.getter("radix2"));
        }

        @Override
        public int getMaxLength(BitWidth width) {
            int bits = width.getWidth();
            return bits <= 1 ? 1 : bits + (bits - 1) / 4;
        }

        @Override
        public int getMaxLength(Value value) {
            return value.toDisplayString(2).length();
        }

        @Override
        public String toString(Value value) {
            return value.toDisplayString(2);
        }

        @Override
        public String getIndexChar() {
            return "b";
        }
    }

    private static class Radix8
    extends RadixOption {
        private Radix8() {
            super("8", Strings.S.getter("radix8"));
        }

        @Override
        public int getMaxLength(BitWidth width) {
            return Math.max(1, (width.getWidth() + 2) / 3);
        }

        @Override
        public int getMaxLength(Value value) {
            return value.toDisplayString(8).length();
        }

        @Override
        public String toString(Value value) {
            return value.toDisplayString(8);
        }

        @Override
        public String getIndexChar() {
            return "o";
        }
    }

    private static class Radix10Unsigned
    extends RadixOption {
        private Radix10Unsigned() {
            super("10unsigned", Strings.S.getter("radix10Unsigned"));
        }

        @Override
        public int getMaxLength(BitWidth width) {
            return switch (width.getWidth()) {
                case 0, 1, 2, 3 -> 1;
                case 4, 5, 6 -> 2;
                case 7, 8, 9 -> 3;
                case 10, 11, 12, 13 -> 4;
                case 14, 15, 16 -> 5;
                case 17, 18, 19 -> 6;
                case 20, 21, 22, 23 -> 7;
                case 24, 25, 26 -> 8;
                case 27, 28, 29 -> 9;
                case 30, 31, 32, 33 -> 10;
                case 34, 35, 36 -> 11;
                case 37, 38, 39 -> 12;
                case 40, 41, 42, 43 -> 13;
                case 44, 45, 46 -> 14;
                case 47, 48, 49 -> 15;
                case 50, 51, 52, 53 -> 16;
                case 54, 55, 56 -> 17;
                case 57, 58, 59 -> 18;
                case 60, 61, 62, 63 -> 19;
                case 64 -> 20;
                default -> throw new AssertionError((Object)("unexpected bit width: " + width));
            };
        }

        @Override
        public String toString(Value value) {
            return value.toDecimalString(false);
        }

        @Override
        public String getIndexChar() {
            return "u";
        }
    }

    private static class Radix10Signed
    extends RadixOption {
        private Radix10Signed() {
            super("10signed", Strings.S.getter("radix10Signed"));
        }

        @Override
        public int getMaxLength(BitWidth width) {
            return switch (width.getWidth()) {
                case 0 -> 1;
                case 1, 2, 3, 4 -> 2;
                case 5, 6, 7 -> 3;
                case 8, 9, 10 -> 4;
                case 11, 12, 13, 14 -> 5;
                case 15, 16, 17 -> 6;
                case 18, 19, 20 -> 7;
                case 21, 22, 23, 24 -> 8;
                case 25, 26, 27 -> 9;
                case 28, 29, 30 -> 10;
                case 31, 32, 33, 34 -> 11;
                case 35, 36, 37 -> 12;
                case 38, 39, 40 -> 13;
                case 41, 42, 43, 44 -> 14;
                case 45, 46, 47 -> 15;
                case 48, 49, 50 -> 16;
                case 51, 52, 53, 54 -> 17;
                case 55, 56, 57 -> 18;
                case 58, 59, 60 -> 19;
                case 61, 62, 63, 64 -> 20;
                default -> throw new AssertionError((Object)("unexpected bit width: " + width));
            };
        }

        @Override
        public String toString(Value value) {
            return value.toDecimalString(true);
        }

        @Override
        public String getIndexChar() {
            return "s";
        }
    }

    private static class Radix16
    extends RadixOption {
        private Radix16() {
            super("16", Strings.S.getter("radix16"));
        }

        @Override
        public int getMaxLength(BitWidth width) {
            return Math.max(1, (width.getWidth() + 3) / 4);
        }

        @Override
        public String toString(Value value) {
            return value.toDisplayString(16);
        }

        @Override
        public String getIndexChar() {
            return "h";
        }
    }

    private static class RadixFloat
    extends RadixOption {
        private RadixFloat() {
            super("float", Strings.S.getter("radixFloat"));
        }

        @Override
        public int getMaxLength(BitWidth width) {
            return width.getWidth() == 64 ? 24 : 12;
        }

        @Override
        public String toString(Value value) {
            return value.getWidth() == 64 ? Double.toString(value.toDoubleValue()) : Float.toString(value.toFloatValue());
        }

        @Override
        public String getIndexChar() {
            return "f";
        }
    }
}

