/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.PropagationPoints;
import com.cburch.logisim.circuit.Propagator;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.log.ClockSource;
import com.cburch.logisim.gui.log.ComponentSelector;
import com.cburch.logisim.gui.log.SignalInfo;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.UniquelyNamedThread;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class Simulator {
    private final SimThread simThread;
    private final ArrayList<Listener> listeners = new ArrayList();
    private final Object lock = new Object();

    public Simulator() {
        this.simThread = new SimThread(this);
        try {
            this.simThread.setPriority(this.simThread.getPriority() - 1);
        }
        catch (IllegalArgumentException | SecurityException runtimeException) {
            // empty catch block
        }
        this.simThread.start();
        this.setTickFrequency(AppPreferences.TICK_FREQUENCY.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSimulatorListener(Listener l) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSimulatorListener(Listener l) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(l);
        }
    }

    public void drawStepPoints(ComponentDrawContext context) {
        this.simThread.drawStepPoints(context);
    }

    public void drawPendingInputs(ComponentDrawContext context) {
        this.simThread.drawPendingInputs(context);
    }

    public String getSingleStepMessage() {
        return this.simThread.getSingleStepMessage();
    }

    public void addPendingInput(CircuitState state, Component comp) {
        this.simThread.addPendingInput(state, comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Listener> copyListeners() {
        ArrayList<Listener> copy;
        Object object = this.lock;
        synchronized (object) {
            copy = new ArrayList<Listener>(this.listeners);
        }
        return copy;
    }

    private void fireSimulatorReset() {
        Event event = new Event(this, false, false, false);
        for (Listener listener : this.copyListeners()) {
            listener.simulatorReset(event);
        }
    }

    private void firePropagationStarted(boolean t) {
        Event e = new Event(this, t, false, false);
        for (Listener l : this.copyListeners()) {
            l.propagationStarted(e);
        }
    }

    private void firePropagationCompleted(boolean t, boolean s, boolean p) {
        Event event = new Event(this, t, s, p);
        for (Listener listener : this.copyListeners()) {
            listener.propagationCompleted(event);
        }
    }

    private Listener getPropagationListener() {
        Listener propagationListener = null;
        for (Listener listener : this.copyListeners()) {
            if (!listener.wantProgressEvents()) continue;
            if (propagationListener != null) {
                throw new IllegalStateException("Only one chronogram listener supported");
            }
            propagationListener = listener;
        }
        return propagationListener;
    }

    private void fireSimulatorStateChanged() {
        Event e = new Event(this, false, false, false);
        for (Listener l : this.copyListeners()) {
            l.simulatorStateChanged(e);
        }
    }

    public double getTickFrequency() {
        return this.simThread.getTickFrequency();
    }

    public boolean isExceptionEncountered() {
        return this.simThread.isExceptionEncountered();
    }

    public boolean isOscillating() {
        Propagator prop = this.simThread.getPropagator();
        return prop != null && prop.isOscillating();
    }

    public CircuitState getCircuitState() {
        Propagator prop = this.simThread.getPropagator();
        return prop == null ? null : prop.getRootState();
    }

    public boolean isAutoPropagating() {
        return this.simThread.isAutoPropagating();
    }

    public boolean isAutoTicking() {
        return this.simThread.isAutoTicking();
    }

    public void setCircuitState(CircuitState state) {
        if (this.simThread.setPropagator(state == null ? null : state.getPropagator())) {
            this.fireSimulatorStateChanged();
        }
    }

    public void setAutoPropagation(boolean value) {
        if (this.simThread.setAutoPropagation(value)) {
            this.fireSimulatorStateChanged();
        }
    }

    public void setAutoTicking(boolean value) {
        if (value && !this.ensureClocks()) {
            return;
        }
        if (this.simThread.setAutoTicking(value)) {
            this.fireSimulatorStateChanged();
        }
    }

    public void setTickFrequency(double freq) {
        CircuitState circuitState = this.getCircuitState();
        if (circuitState != null) {
            circuitState.getCircuit().setTickFrequency(freq);
        }
        if (this.simThread.setTickFrequency(freq)) {
            this.fireSimulatorStateChanged();
        }
    }

    public void step() {
        this.simThread.requestStep();
    }

    public void tick(int count) {
        if (!this.ensureClocks()) {
            return;
        }
        this.simThread.requestTick(count);
    }

    public void reset() {
        this.simThread.requestReset();
    }

    public boolean nudge() {
        return this.simThread.requestNudge();
    }

    public void shutDown() {
        this.simThread.requestShutDown();
    }

    private boolean ensureClocks() {
        CircuitState cs = this.getCircuitState();
        if (cs == null || cs.hasKnownClocks()) {
            return true;
        }
        Circuit circ = cs.getCircuit();
        ArrayList<SignalInfo> clocks = ComponentSelector.findClocks(circ);
        if (CollectionUtil.isNotEmpty(clocks)) {
            cs.markKnownClocks();
            return true;
        }
        Component clk = ClockSource.doClockDriverDialog(circ);
        if (clk == null || !cs.setTemporaryClock(clk)) {
            return false;
        }
        this.fireSimulatorStateChanged();
        return true;
    }

    private static class SimThread
    extends UniquelyNamedThread {
        private final Simulator sim;
        private long lastTick = System.nanoTime();
        private Propagator propagator = null;
        private boolean autoPropagating = true;
        private boolean autoTicking = false;
        private double autoTickFreq = 1.0;
        private long autoTickNanos = Math.round(1.0E9 / this.autoTickFreq);
        private int manualTicksRequested = 0;
        private int manualStepsRequested = 0;
        private boolean nudgeRequested = false;
        private boolean resetRequested = false;
        private boolean complete = false;
        private boolean oops = false;
        private final PropagationPoints stepPoints = new PropagationPoints();

        SimThread(Simulator s) {
            super("SimThread");
            this.sim = s;
        }

        synchronized Propagator getPropagator() {
            return this.propagator;
        }

        synchronized boolean isExceptionEncountered() {
            return this.oops;
        }

        synchronized boolean isAutoTicking() {
            return this.autoTicking;
        }

        synchronized boolean isAutoPropagating() {
            return this.autoPropagating;
        }

        synchronized double getTickFrequency() {
            return this.autoTickFreq;
        }

        synchronized void drawStepPoints(ComponentDrawContext context) {
            if (!this.autoPropagating) {
                this.stepPoints.draw(context);
            }
        }

        synchronized void drawPendingInputs(ComponentDrawContext context) {
            if (!this.autoPropagating) {
                this.stepPoints.drawPendingInputs(context);
            }
        }

        synchronized void addPendingInput(CircuitState state, Component comp) {
            this.stepPoints.addPendingInput(state, comp);
        }

        synchronized String getSingleStepMessage() {
            return this.autoPropagating ? "" : this.stepPoints.getSingleStepMessage();
        }

        synchronized boolean setPropagator(Propagator value) {
            if (this.propagator == value) {
                return false;
            }
            this.propagator = value;
            this.manualTicksRequested = 0;
            this.manualStepsRequested = 0;
            this.notifyAll();
            return true;
        }

        synchronized boolean setAutoPropagation(boolean value) {
            if (this.autoPropagating == value) {
                return false;
            }
            this.autoPropagating = value;
            if (this.autoPropagating) {
                this.manualStepsRequested = 0;
            } else {
                this.nudgeRequested = false;
            }
            this.notifyAll();
            return true;
        }

        synchronized boolean setAutoTicking(boolean value) {
            if (this.autoTicking == value) {
                return false;
            }
            this.autoTicking = value;
            this.notifyAll();
            return true;
        }

        synchronized boolean setTickFrequency(double freq) {
            if (this.autoTickFreq == freq) {
                return false;
            }
            this.autoTickFreq = freq;
            this.autoTickNanos = freq <= 0.0 ? 0L : Math.round(1.0E9 / this.autoTickFreq);
            this.notifyAll();
            return true;
        }

        synchronized void requestStep() {
            ++this.manualStepsRequested;
            this.autoPropagating = false;
            this.notifyAll();
        }

        synchronized void requestTick(int count) {
            this.manualTicksRequested += count;
            this.notifyAll();
        }

        synchronized void requestReset() {
            this.resetRequested = true;
            this.manualTicksRequested = 0;
            this.manualStepsRequested = 0;
            this.notifyAll();
        }

        synchronized boolean requestNudge() {
            if (!this.autoPropagating) {
                return false;
            }
            this.nudgeRequested = true;
            this.notifyAll();
            return true;
        }

        synchronized void requestShutDown() {
            this.complete = true;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loop() {
            Propagator prop = null;
            boolean doReset = false;
            boolean doNudge = false;
            boolean doTick = false;
            boolean doTickIfStable = false;
            boolean doStep = false;
            boolean doProp = false;
            long now = 0L;
            SimThread simThread = this;
            synchronized (simThread) {
                boolean ready = false;
                do {
                    long deadline2;
                    if (this.complete) {
                        return false;
                    }
                    prop = this.propagator;
                    now = System.nanoTime();
                    if (this.resetRequested) {
                        this.resetRequested = false;
                        doReset = true;
                        doProp = this.autoPropagating;
                        ready = true;
                    }
                    if (this.nudgeRequested) {
                        this.nudgeRequested = false;
                        doNudge = true;
                        ready = true;
                    }
                    if (this.manualStepsRequested > 0) {
                        --this.manualStepsRequested;
                        doTickIfStable = this.autoTicking;
                        doStep = true;
                        ready = true;
                    }
                    if (this.manualTicksRequested > 0) {
                        doTick = true;
                        doProp = this.autoPropagating;
                        doStep = !this.autoPropagating;
                        ready = true;
                    }
                    long delta = 0L;
                    if (this.autoTicking && this.autoPropagating && this.autoTickNanos > 0L && (delta = (deadline2 = this.lastTick + this.autoTickNanos) - now) <= 0L) {
                        doTick = true;
                        doProp = true;
                        ready = true;
                    }
                    if (ready) continue;
                    try {
                        if (delta > 0L) {
                            this.wait(delta / 1000000L, (int)(delta % 1000000L));
                            continue;
                        }
                        this.wait();
                    }
                    catch (InterruptedException deadline2) {
                        // empty catch block
                    }
                } while (!ready);
                this.oops = false;
            }
            boolean oops = false;
            boolean osc = false;
            boolean ticked = false;
            boolean stepped = false;
            boolean propagated = false;
            boolean hasClocks = true;
            if (doReset) {
                try {
                    this.stepPoints.clear();
                    if (prop != null) {
                        prop.reset();
                    }
                    this.sim.fireSimulatorReset();
                }
                catch (Exception err) {
                    oops = true;
                    err.printStackTrace();
                }
            }
            if (doTick || doTickIfStable && prop != null && !prop.isPending()) {
                this.lastTick = now;
                ticked = true;
                if (prop != null) {
                    hasClocks = prop.toggleClocks();
                }
            }
            if (doProp || doNudge) {
                try {
                    this.sim.firePropagationStarted(ticked);
                    propagated = doProp;
                    Listener p = this.sim.getPropagationListener();
                    Event evt = p == null ? null : new Event(this.sim, false, false, false);
                    this.stepPoints.clear();
                    if (prop != null) {
                        propagated |= prop.propagate(p, evt);
                    }
                }
                catch (Exception err) {
                    oops = true;
                    err.printStackTrace();
                }
            }
            if (doStep) {
                try {
                    stepped = true;
                    this.stepPoints.clear();
                    if (prop != null) {
                        prop.step(this.stepPoints);
                    }
                    if (prop == null || !prop.isPending()) {
                        propagated = true;
                    }
                }
                catch (Exception err) {
                    oops = true;
                    err.printStackTrace();
                }
            }
            osc = prop != null && prop.isOscillating();
            boolean clockDied = false;
            SimThread simThread2 = this;
            synchronized (simThread2) {
                this.oops = oops;
                if (osc) {
                    this.autoPropagating = false;
                    this.nudgeRequested = false;
                }
                if (ticked && this.manualTicksRequested > 0) {
                    --this.manualTicksRequested;
                }
                if (this.autoTicking && !hasClocks) {
                    this.autoTicking = false;
                    clockDied = true;
                }
            }
            if (ticked || stepped || propagated || doNudge) {
                this.sim.firePropagationCompleted(ticked, stepped && !propagated, propagated);
            }
            if (clockDied) {
                this.sim.fireSimulatorStateChanged();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (this.loop()) {
                    }
                    return;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    SimThread simThread = this;
                    synchronized (simThread) {
                        this.oops = true;
                        this.autoPropagating = false;
                        this.autoTicking = false;
                        this.manualTicksRequested = 0;
                        this.manualStepsRequested = 0;
                        this.nudgeRequested = false;
                    }
                    SwingUtilities.invokeLater(() -> OptionPane.showMessageDialog(null, "The simulator has crashed. Save your work and restart Logisim."));
                    continue;
                }
                break;
            }
        }
    }

    public static class Event {
        private final Simulator source;
        private final boolean didTick;
        private final boolean didSingleStep;
        private final boolean didPropagate;

        public Event(Simulator src, boolean t, boolean s, boolean p) {
            this.source = src;
            this.didTick = t;
            this.didSingleStep = s;
            this.didPropagate = p;
        }

        public Simulator getSource() {
            return this.source;
        }

        public boolean didTick() {
            return this.didTick;
        }

        public boolean didSingleStep() {
            return this.didSingleStep;
        }

        public boolean didPropagate() {
            return this.didPropagate;
        }
    }

    public static interface Listener {
        public void simulatorReset(Event var1);

        default public boolean wantProgressEvents() {
            return false;
        }

        default public void propagationStarted(Event e) {
        }

        default public void propagationInProgress(Event e) {
        }

        default public void propagationCompleted(Event e) {
        }

        public void simulatorStateChanged(Event var1);
    }
}

