/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitHdlGeneratorFactory;
import com.cburch.logisim.circuit.CircuitMutator;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.CircuitTransaction;
import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.circuit.SubcircuitPoker;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.tools.CircuitStateHolder;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class SubcircuitFactory
extends InstanceFactory {
    private Circuit source;

    public SubcircuitFactory(Circuit source) {
        super("", null, new CircuitHdlGeneratorFactory(source), true);
        this.source = source;
        this.setFacingAttribute(StdAttr.FACING);
        this.setDefaultToolTip(new CircuitFeature(null));
        this.setInstancePoker(SubcircuitPoker.class);
    }

    void computePorts(Instance instance) {
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        SortedMap<Location, Instance> portLocs = this.source.getAppearance().getPortOffsets(facing);
        Port[] ports = new Port[portLocs.size()];
        Instance[] pins = new Instance[portLocs.size()];
        int i = -1;
        for (Map.Entry<Location, Instance> portLoc : portLocs.entrySet()) {
            Location loc = portLoc.getKey();
            Instance pin = portLoc.getValue();
            String type = Pin.FACTORY.isInputPin(pin) ? "input" : "output";
            BitWidth width = pin.getAttributeValue(StdAttr.WIDTH);
            ports[++i] = new Port(loc.getX(), loc.getY(), type, width);
            pins[i] = pin;
            String label = pin.getAttributeValue(StdAttr.LABEL);
            if (label == null || label.length() <= 0) continue;
            ports[i].setToolTip(StringUtil.constantGetter(label));
        }
        CircuitAttributes attrs = (CircuitAttributes)instance.getAttributeSet();
        attrs.setPinInstances(pins);
        instance.setPorts(ports);
        instance.recomputeBounds();
        this.configureLabel(instance);
    }

    private void configureLabel(Instance instance) {
        Bounds bds = instance.getBounds();
        Direction loc = instance.getAttributeValue(CircuitAttributes.LABEL_LOCATION_ATTR);
        int x = bds.getX() + bds.getWidth() / 2;
        int y = bds.getY() + bds.getHeight() / 2;
        int ha = 0;
        int va = 0;
        if (loc == Direction.EAST) {
            x = bds.getX() + bds.getWidth() + 2;
            ha = -1;
        } else if (loc == Direction.WEST) {
            x = bds.getX() - 2;
            ha = 1;
        } else if (loc == Direction.SOUTH) {
            y = bds.getY() + bds.getHeight() + 2;
            va = -1;
        } else {
            y = bds.getY() - 2;
            va = 1;
        }
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, x, y, ha, va);
    }

    @Override
    public void configureNewInstance(Instance instance) {
        CircuitAttributes attrs = (CircuitAttributes)instance.getAttributeSet();
        attrs.setSubcircuit(instance);
        instance.addAttributeListener();
        this.computePorts(instance);
    }

    @Override
    public boolean contains(Location loc, AttributeSet attrs) {
        if (super.contains(loc, attrs)) {
            Direction defaultFacing;
            Direction facing = attrs.getValue(StdAttr.FACING);
            Location query = facing.equals(defaultFacing = this.source.getAppearance().getFacing()) ? loc : loc.rotate(facing, defaultFacing, 0, 0);
            return this.source.getAppearance().contains(query);
        }
        return false;
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new CircuitAttributes(this.source);
    }

    private void drawCircuitLabel(InstancePainter painter, Bounds bds, Direction facing, Direction defaultFacing) {
        AttributeSet staticAttrs = this.source.getStaticAttributes();
        Object label = staticAttrs.getValue(CircuitAttributes.CIRCUIT_LABEL_ATTR);
        if (label != null && !((String)label).equals("")) {
            Direction up = staticAttrs.getValue(CircuitAttributes.CIRCUIT_LABEL_FACING_ATTR);
            Font font = staticAttrs.getValue(CircuitAttributes.CIRCUIT_LABEL_FONT_ATTR);
            int back = ((String)label).indexOf(92);
            int lines = 1;
            boolean backs = false;
            while (back >= 0 && back <= ((String)label).length() - 2) {
                char c = ((String)label).charAt(back + 1);
                if (c == 'n') {
                    ++lines;
                } else if (c == '\\') {
                    backs = true;
                }
                back = ((String)label).indexOf(92, back + 2);
            }
            int x = bds.getX() + bds.getWidth() / 2;
            int y = bds.getY() + bds.getHeight() / 2;
            Graphics g = painter.getGraphics().create();
            double angle = 1.5707963267948966 - (up.toRadians() - defaultFacing.toRadians()) - facing.toRadians();
            if (g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                if (Math.abs(angle) > 0.01) {
                    g2.rotate(angle, x, y);
                }
            }
            g.setFont(font);
            if (lines == 1 && !backs) {
                GraphicsUtil.drawCenteredText(g, (String)label, x, y);
            } else {
                FontMetrics fm = g.getFontMetrics();
                int height = fm.getHeight();
                y = y - (height * lines - fm.getLeading()) / 2 + fm.getAscent();
                back = ((String)label).indexOf(92);
                while (back >= 0 && back <= ((String)label).length() - 2) {
                    char c = ((String)label).charAt(back + 1);
                    if (c == 'n') {
                        String line = ((String)label).substring(0, back);
                        GraphicsUtil.drawText(g, line, x, y, 0, 1);
                        y += height;
                        label = ((String)label).substring(back + 2);
                        back = ((String)label).indexOf(92);
                        continue;
                    }
                    if (c == '\\') {
                        label = ((String)label).substring(0, back) + ((String)label).substring(back + 1);
                        back = ((String)label).indexOf(92, back + 1);
                        continue;
                    }
                    back = ((String)label).indexOf(92, back + 2);
                }
                GraphicsUtil.drawText(g, (String)label, x, y, 0, 1);
            }
            g.dispose();
        }
    }

    @Override
    public StringGetter getDisplayGetter() {
        return StringUtil.constantGetter(this.source.getName());
    }

    @Override
    public Object getInstanceFeature(Instance instance, Object key) {
        if (key == MenuExtender.class) {
            return new CircuitFeature(instance);
        }
        return super.getInstanceFeature(instance, key);
    }

    @Override
    public String getName() {
        return this.source.getName();
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        Direction defaultFacing = this.source.getAppearance().getFacing();
        Bounds bds = this.source.getAppearance().getOffsetBounds();
        return bds.rotate(defaultFacing, facing, 0, 0);
    }

    public Circuit getSubcircuit() {
        return this.source;
    }

    public void setSubcircuit(Circuit sub) {
        this.source = sub;
    }

    public CircuitState getSubstate(CircuitState superState, Component comp) {
        return this.getSubstate(this.createInstanceState(superState, comp));
    }

    public CircuitState getSubstate(CircuitState superState, Instance instance) {
        return this.getSubstate(this.createInstanceState(superState, instance));
    }

    private CircuitState getSubstate(InstanceState instanceState) {
        CircuitState subState = (CircuitState)instanceState.getData();
        if (subState == null) {
            subState = new CircuitState(instanceState.getProject(), this.source);
            instanceState.setData(subState);
            instanceState.fireInvalidated();
        }
        return subState;
    }

    @Override
    public void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            this.computePorts(instance);
        } else if (attr == CircuitAttributes.LABEL_LOCATION_ATTR) {
            this.configureLabel(instance);
        } else if (attr == CircuitAttributes.APPEARANCE_ATTR) {
            ChangeAppearanceTransaction xn = new ChangeAppearanceTransaction();
            this.source.getLocker().execute(xn);
            this.computePorts(instance);
        }
    }

    private void paintBase(InstancePainter painter, Graphics g) {
        CircuitAttributes attrs = (CircuitAttributes)painter.getAttributeSet();
        Direction facing = attrs.getFacing();
        Direction defaultFacing = this.source.getAppearance().getFacing();
        Location loc = painter.getLocation();
        g.translate(loc.getX(), loc.getY());
        this.source.getAppearance().paintSubcircuit(painter, g, facing);
        this.drawCircuitLabel(painter, this.getOffsetBounds(attrs), facing, defaultFacing);
        g.translate(-loc.getX(), -loc.getY());
        painter.drawLabel();
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Color fg = g.getColor();
        int v = fg.getRed() + fg.getGreen() + fg.getBlue();
        Composite oldComposite = null;
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            if (v > 50) {
                oldComposite = g2d.getComposite();
                AlphaComposite c = AlphaComposite.getInstance(3, 0.5f);
                ((Graphics2D)g).setComposite(c);
            }
        }
        this.paintBase(painter, g);
        if (oldComposite != null) {
            ((Graphics2D)g).setComposite(oldComposite);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        this.paintBase(painter, painter.getGraphics());
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState superState) {
        CircuitState subState = this.getSubstate(superState);
        CircuitAttributes attrs = (CircuitAttributes)superState.getAttributeSet();
        Instance[] pins = attrs.getPinInstances();
        for (int i = 0; i < pins.length; ++i) {
            Instance pin = pins[i];
            InstanceState pinState = subState.getInstanceState(pin);
            if (Pin.FACTORY.isInputPin(pin)) {
                Value oldVal;
                Value newVal = superState.getPortValue(i);
                if (newVal.equals(oldVal = Pin.FACTORY.getValue(pinState))) continue;
                Pin.FACTORY.setValue(pinState, newVal);
                Pin.FACTORY.propagate(pinState);
                continue;
            }
            Value val = pinState.getPortValue(0);
            superState.setPort(i, val, 1);
        }
    }

    @Override
    public void paintIcon(InstancePainter painter) {
        Graphics2D g2 = (Graphics2D)painter.getGraphics().create();
        CircuitAttributes attrs = (CircuitAttributes)painter.getAttributeSet();
        if (attrs.getValue(CircuitAttributes.APPEARANCE_ATTR).equals(CircuitAttributes.APPEAR_CLASSIC)) {
            SubcircuitFactory.paintClasicIcon(g2);
        } else if (attrs.getValue(CircuitAttributes.APPEARANCE_ATTR).equals(CircuitAttributes.APPEAR_FPGA)) {
            SubcircuitFactory.paintHCIcon(g2);
        } else {
            SubcircuitFactory.paintEvolutionIcon(g2);
        }
        g2.dispose();
    }

    public static void paintClasicIcon(Graphics2D g2) {
        g2.setStroke(new BasicStroke(AppPreferences.getScaled(2)));
        g2.setColor(Color.GRAY);
        g2.drawArc(AppPreferences.getScaled(6), AppPreferences.getScaled(-2), AppPreferences.getScaled(4), AppPreferences.getScaled(6), 180, 180);
        g2.setColor(Color.BLACK);
        g2.drawRect(AppPreferences.getScaled(2), AppPreferences.getScaled(1), AppPreferences.getScaled(12), AppPreferences.getScaled(14));
        int wh = AppPreferences.getScaled(3);
        for (int y = 0; y < 3; ++y) {
            if (y == 1) {
                g2.setColor(Value.trueColor);
            } else {
                g2.setColor(Value.falseColor);
            }
            g2.fillOval(AppPreferences.getScaled(1), AppPreferences.getScaled(y * 4 + 3), wh, wh);
            if (y >= 2) continue;
            g2.setColor(Value.unknownColor);
            g2.fillOval(AppPreferences.getScaled(12), AppPreferences.getScaled(y * 4 + 3), wh, wh);
        }
    }

    public static void paintHCIcon(Graphics2D g2) {
        g2.setStroke(new BasicStroke(AppPreferences.getScaled(2)));
        g2.setColor(Color.BLACK);
        g2.drawRect(AppPreferences.getScaled(1), AppPreferences.getScaled(1), AppPreferences.getScaled(14), AppPreferences.getScaled(14));
        Font f = g2.getFont().deriveFont((float)AppPreferences.getIconSize() / 4.0f);
        TextLayout l = new TextLayout("main", f, g2.getFontRenderContext());
        l.draw(g2, (float)((double)(AppPreferences.getIconSize() / 2) - l.getBounds().getCenterX()), (float)((double)(AppPreferences.getIconSize() / 4) - l.getBounds().getCenterY()));
        int wh = AppPreferences.getScaled(3);
        for (int y = 1; y < 3; ++y) {
            if (y == 1) {
                g2.setColor(Value.trueColor);
            } else {
                g2.setColor(Value.falseColor);
            }
            g2.fillOval(AppPreferences.getScaled(0), AppPreferences.getScaled(y * 4 + 3), wh, wh);
            if (y >= 2) continue;
            g2.setColor(Value.unknownColor);
            g2.fillOval(AppPreferences.getScaled(13), AppPreferences.getScaled(y * 4 + 3), wh, wh);
        }
    }

    public static void paintEvolutionIcon(Graphics2D g2) {
        g2.setStroke(new BasicStroke(AppPreferences.getScaled(2)));
        g2.setColor(Color.BLACK);
        g2.drawRect(AppPreferences.getScaled(2), 0, AppPreferences.getScaled(12), AppPreferences.getScaled(16));
        g2.fillRect(AppPreferences.getScaled(2), 3 * AppPreferences.getIconSize() / 4, AppPreferences.getScaled(12), AppPreferences.getIconSize() / 4);
        for (int y = 0; y < 3; ++y) {
            g2.drawLine(0, AppPreferences.getScaled(y * 4 + 2), AppPreferences.getScaled(2), AppPreferences.getScaled(y * 4 + 2));
            if (y >= 2) continue;
            g2.drawLine(AppPreferences.getScaled(13), AppPreferences.getScaled(y * 4 + 2), AppPreferences.getScaled(15), AppPreferences.getScaled(y * 4 + 2));
        }
        g2.setColor(Color.WHITE);
        Font f = g2.getFont().deriveFont((float)AppPreferences.getIconSize() / 4.0f);
        TextLayout l = new TextLayout("main", f, g2.getFontRenderContext());
        l.draw(g2, (float)((double)(AppPreferences.getIconSize() / 2) - l.getBounds().getCenterX()), (float)((double)(7 * AppPreferences.getIconSize() / 8) - l.getBounds().getCenterY()));
    }

    @Override
    public void removeComponent(Circuit circ, Component c, CircuitState state) {
        this.getSubcircuit().removeComponent(c);
    }

    private class CircuitFeature
    implements StringGetter,
    MenuExtender,
    ActionListener {
        private final Instance instance;
        private Project proj;

        public CircuitFeature(Instance instance) {
            this.instance = instance;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CircuitState superState = this.proj.getCircuitState();
            if (superState == null) {
                return;
            }
            CircuitState subState = SubcircuitFactory.this.getSubstate(superState, this.instance);
            if (subState == null) {
                return;
            }
            this.proj.setCircuitState(subState);
        }

        @Override
        public void configureMenu(JPopupMenu menu, Project proj) {
            this.proj = proj;
            String name = this.instance.getFactory().getDisplayName();
            String text = Strings.S.get("subcircuitViewItem", name);
            JMenuItem item = new JMenuItem(text);
            item.addActionListener(this);
            menu.add(item);
            CircuitStateHolder.HierarchyInfo hi = new CircuitStateHolder.HierarchyInfo(proj.getCurrentCircuit());
            hi.addComponent(this.instance.getComponent());
            this.getSubMenuItems(menu, proj, (CircuitState)this.instance.getData(proj.getCircuitState()), hi);
        }

        public void getSubMenuItems(JPopupMenu menu, Project proj, CircuitState state, CircuitStateHolder.HierarchyInfo hi) {
            for (Component comp : SubcircuitFactory.this.source.getNonWires()) {
                MenuExtender m;
                if (!(comp instanceof InstanceComponent)) continue;
                InstanceComponent c = (InstanceComponent)comp;
                if (c.getFactory() instanceof SubcircuitFactory) {
                    m = (CircuitFeature)c.getFeature(MenuExtender.class);
                    CircuitStateHolder.HierarchyInfo newhi = hi.getCopy();
                    newhi.addComponent(c);
                    ((CircuitFeature)m).getSubMenuItems(menu, proj, (CircuitState)c.getInstance().getData(state), newhi);
                    continue;
                }
                if (!c.getInstance().getFactory().providesSubCircuitMenu()) continue;
                m = (MenuExtender)c.getFeature(MenuExtender.class);
                if (m instanceof CircuitStateHolder) {
                    CircuitStateHolder csh = (CircuitStateHolder)((Object)m);
                    csh.setCircuitState(state);
                    csh.setHierarchyName(hi);
                }
                m.configureMenu(menu, proj);
            }
        }

        @Override
        public String toString() {
            return SubcircuitFactory.this.source.getName();
        }
    }

    private class ChangeAppearanceTransaction
    extends CircuitTransaction {
        private ChangeAppearanceTransaction() {
        }

        @Override
        protected Map<Circuit, Integer> getAccessedCircuits() {
            HashMap<Circuit, Integer> accessMap = new HashMap<Circuit, Integer>();
            for (Circuit supercirc : SubcircuitFactory.this.source.getCircuitsUsingThis()) {
                accessMap.put(supercirc, READ_WRITE);
            }
            return accessMap;
        }

        @Override
        protected void run(CircuitMutator mutator) {
        }
    }
}

