/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.WidthIncompatibilityData;
import com.cburch.logisim.circuit.WireThread;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import java.util.concurrent.CopyOnWriteArraySet;

class WireBundle {
    private BitWidth width = BitWidth.UNKNOWN;
    private Value pullValue = Value.UNKNOWN;
    private WireBundle parent;
    private Location widthDeterminant = null;
    private boolean isBus_ = false;
    WireThread[] threads = null;
    final CopyOnWriteArraySet<Location> points = new CopyOnWriteArraySet();
    private WidthIncompatibilityData incompatibilityData = null;

    WireBundle() {
        this.parent = this;
    }

    void addPullValue(Value val) {
        this.pullValue = this.pullValue.combine(val);
    }

    WireBundle find() {
        WireBundle ret = this;
        if (ret.parent != ret) {
            while (ret.parent != (ret = ret.parent)) {
            }
            this.parent = ret;
        }
        return ret;
    }

    Value getPullValue() {
        return this.pullValue;
    }

    BitWidth getWidth() {
        if (this.incompatibilityData != null) {
            return BitWidth.UNKNOWN;
        }
        return this.width;
    }

    Location getWidthDeterminant() {
        if (this.incompatibilityData != null) {
            return null;
        }
        return this.widthDeterminant;
    }

    WidthIncompatibilityData getWidthIncompatibilityData() {
        return this.incompatibilityData;
    }

    boolean isBus() {
        return this.isBus_;
    }

    void isolate() {
        this.parent = this;
    }

    boolean isValid() {
        return this.incompatibilityData == null;
    }

    void setWidth(BitWidth width, Location det) {
        if (width == BitWidth.UNKNOWN) {
            return;
        }
        if (this.incompatibilityData != null) {
            this.incompatibilityData.add(det, width);
            return;
        }
        if (this.width != BitWidth.UNKNOWN) {
            if (width.equals(this.width)) {
                this.isBus_ = width.getWidth() > 1;
            } else {
                this.incompatibilityData = new WidthIncompatibilityData();
                this.incompatibilityData.add(this.widthDeterminant, this.width);
                this.incompatibilityData.add(det, width);
            }
            return;
        }
        this.width = width;
        this.widthDeterminant = det;
        this.threads = new WireThread[width.getWidth()];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new WireThread();
        }
    }

    void unite(WireBundle other) {
        WireBundle group2;
        WireBundle group = this.find();
        if (group != (group2 = other.find())) {
            group.parent = group2;
        }
    }
}

