/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.Rectangle;
import com.cburch.draw.shapes.Text;
import com.cburch.logisim.circuit.appear.AppearanceAnchor;
import com.cburch.logisim.circuit.appear.AppearancePort;
import com.cburch.logisim.circuit.appear.DefaultAppearance;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Pin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultCustomAppearance {
    private static final int OFFS = 50;

    public static List<CanvasObject> build(Collection<Instance> pins) {
        HashMap edge = new HashMap();
        edge.put(Direction.EAST, new ArrayList());
        edge.put(Direction.WEST, new ArrayList());
        int maxLeftLabelLength = 0;
        int maxRightLabelLength = 0;
        if (!pins.isEmpty()) {
            for (Instance instance : pins) {
                Direction pinEdge;
                Text label = new Text(0, 0, instance.getAttributeValue(StdAttr.LABEL));
                int labelWidth = label.getText().length() * 8;
                if (instance.getAttributeValue(Pin.ATTR_TYPE).booleanValue()) {
                    pinEdge = Direction.EAST;
                    if (labelWidth > maxRightLabelLength) {
                        maxRightLabelLength = labelWidth;
                    }
                } else {
                    pinEdge = Direction.WEST;
                    if (labelWidth > maxLeftLabelLength) {
                        maxLeftLabelLength = labelWidth;
                    }
                }
                List e = (List)edge.get(pinEdge);
                e.add(instance);
            }
        }
        for (Map.Entry entry : edge.entrySet()) {
            DefaultAppearance.sortPinList((List)entry.getValue(), (Direction)entry.getKey());
        }
        int numEast = ((List)edge.get(Direction.EAST)).size();
        int n = ((List)edge.get(Direction.WEST)).size();
        int maxVert = Math.max(numEast, n);
        int textWidth = 200;
        int width = 220;
        int height = maxVert > 0 ? maxVert * 10 + 10 : 10;
        int ax = 0;
        int ay = 0;
        if (numEast > 0) {
            ax = 220;
            ay = 10;
        } else if (n > 0) {
            ax = 0;
            ay = 10;
        }
        int rx = 50 + (9 - (ax + 9) % 10);
        int ry = 50 + (9 - (ay + 9) % 10);
        ArrayList<CanvasObject> ret = new ArrayList<CanvasObject>();
        DefaultCustomAppearance.placePins(ret, (List)edge.get(Direction.WEST), rx, ry + 10, 0, 10);
        DefaultCustomAppearance.placePins(ret, (List)edge.get(Direction.EAST), rx + 220, ry + 10, 0, 10);
        Rectangle rect = new Rectangle(rx, ry, 220, height);
        rect.setValue(DrawAttr.STROKE_WIDTH, 1);
        ret.add(rect);
        ret.add(new AppearanceAnchor(Location.create(rx + ax, ry + ay, true)));
        return ret;
    }

    private static void placePins(List<CanvasObject> dest, List<Instance> pins, int x, int y, int dX, int dY) {
        for (Instance pin : pins) {
            dest.add(new AppearancePort(Location.create(x, y, true), pin));
            x += dX;
            y += dY;
        }
    }
}

