/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.Rectangle;
import com.cburch.draw.shapes.Text;
import com.cburch.logisim.circuit.appear.AppearanceAnchor;
import com.cburch.logisim.circuit.appear.AppearancePort;
import com.cburch.logisim.circuit.appear.DefaultAppearance;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Pin;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultEvolutionAppearance {
    private static final int OFFS = 50;

    public static List<CanvasObject> build(Collection<Instance> pins, String circuitName, boolean fixedSize) {
        int ay;
        int ax;
        int TitleWidth;
        HashMap edge = new HashMap();
        edge.put(Direction.EAST, new ArrayList());
        edge.put(Direction.WEST, new ArrayList());
        int maxLeftLabelLength = 0;
        int maxRightLabelLength = 0;
        int n = TitleWidth = circuitName == null ? 112 : circuitName.length() * 8;
        if (!pins.isEmpty()) {
            for (Instance instance : pins) {
                Direction pinEdge;
                Text label = new Text(0, 0, instance.getAttributeValue(StdAttr.LABEL));
                int labelWidth = label.getText().length() * 8;
                if (instance.getAttributeValue(Pin.ATTR_TYPE).booleanValue()) {
                    pinEdge = Direction.EAST;
                    if (labelWidth > maxRightLabelLength) {
                        maxRightLabelLength = labelWidth;
                    }
                } else {
                    pinEdge = Direction.WEST;
                    if (labelWidth > maxLeftLabelLength) {
                        maxLeftLabelLength = labelWidth;
                    }
                }
                List e = (List)edge.get(pinEdge);
                e.add(instance);
            }
        }
        for (Map.Entry entry : edge.entrySet()) {
            DefaultAppearance.sortPinList((List)entry.getValue(), (Direction)entry.getKey());
        }
        int numEast = ((List)edge.get(Direction.EAST)).size();
        int n2 = ((List)edge.get(Direction.WEST)).size();
        int maxVert = Math.max(numEast, n2);
        int dy = 20;
        int textWidth = fixedSize ? 200 : Math.max(maxLeftLabelLength + maxRightLabelLength + 35, TitleWidth + 15);
        int thight = 20;
        int width = textWidth / 10 * 10 + 20;
        int height = maxVert > 0 ? maxVert * 20 + 20 : 30;
        int sdy = 4;
        if (numEast > 0) {
            ax = width;
            ay = 10;
        } else if (n2 > 0) {
            ax = 0;
            ay = 10;
        } else {
            ax = 0;
            ay = 0;
        }
        int rx = 50 + (9 - (ax + 9) % 10);
        int ry = 50 + (9 - (ay + 9) % 10);
        ArrayList<CanvasObject> ret = new ArrayList<CanvasObject>();
        DefaultEvolutionAppearance.placePins(ret, (List)edge.get(Direction.WEST), rx, ry + 10, 0, 20, true, 4, fixedSize);
        DefaultEvolutionAppearance.placePins(ret, (List)edge.get(Direction.EAST), rx + width, ry + 10, 0, 20, false, 4, fixedSize);
        Rectangle rect = new Rectangle(rx + 10, ry + height - 20, width - 20, 20);
        rect.setValue(DrawAttr.STROKE_WIDTH, 1);
        rect.setValue(DrawAttr.PAINT_TYPE, DrawAttr.PAINT_FILL);
        rect.setValue(DrawAttr.FILL_COLOR, Color.BLACK);
        ret.add(rect);
        rect = new Rectangle(rx + 10, ry, width - 20, height);
        rect.setValue(DrawAttr.STROKE_WIDTH, 2);
        ret.add(rect);
        String label = circuitName == null ? "VHDL Component" : circuitName;
        int maxLength = 23;
        String ellipsis = "...";
        if (fixedSize && label.length() > 23) {
            label = label.substring(0, 23 - "...".length()).concat("...");
        }
        Text textLabel = new Text(rx + (width >> 1), ry + (height - 1 - 5), label);
        textLabel.getLabel().setHorizontalAlignment(0);
        textLabel.getLabel().setColor(Color.WHITE);
        textLabel.getLabel().setFont(DrawAttr.DEFAULT_NAME_FONT);
        ret.add(textLabel);
        ret.add(new AppearanceAnchor(Location.create(rx + ax, ry + ay, true)));
        return ret;
    }

    private static void placePins(List<CanvasObject> dest, List<Instance> pins, int x, int y, int dX, int dY, boolean isLeftSide, int ldy, boolean isFixedSize) {
        Color color = Color.DARK_GRAY;
        for (Instance pin : pins) {
            Rectangle rect;
            int hAlign;
            int ldX;
            int height;
            int offset = pin.getAttributeValue(StdAttr.WIDTH).getWidth() > 1 ? 2 : 1;
            int n = height = pin.getAttributeValue(StdAttr.WIDTH).getWidth() > 1 ? 4 : 3;
            if (isLeftSide) {
                ldX = 15;
                hAlign = 2;
                rect = new Rectangle(x, y - offset, 10, height);
            } else {
                ldX = -15;
                hAlign = 4;
                rect = new Rectangle(x - 10, y - offset, 10, height);
            }
            rect.setValue(DrawAttr.STROKE_WIDTH, 1);
            rect.setValue(DrawAttr.PAINT_TYPE, DrawAttr.PAINT_FILL);
            rect.setValue(DrawAttr.FILL_COLOR, Color.BLACK);
            dest.add(rect);
            dest.add(new AppearancePort(Location.create(x, y, true), pin));
            if (pin.getAttributeSet().containsAttribute(StdAttr.LABEL)) {
                String label = pin.getAttributeValue(StdAttr.LABEL);
                int maxLength = 12;
                String ellipsis = "...";
                if (isFixedSize && label.length() > 12) {
                    label = label.substring(0, 12 - "...".length()).concat("...");
                }
                Text textLabel = new Text(x + ldX, y + ldy, label);
                textLabel.getLabel().setHorizontalAlignment(hAlign);
                textLabel.getLabel().setColor(color);
                textLabel.getLabel().setFont(DrawAttr.DEFAULT_FIXED_PICH_FONT);
                dest.add(textLabel);
            }
            x += dX;
            y += dY;
        }
    }
}

