/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FileStatistics {
    private final List<Count> counts;
    private final Count totalWithout;
    private final Count totalWith;

    private FileStatistics(List<Count> counts, Count totalWithout, Count totalWith) {
        this.counts = Collections.unmodifiableList(counts);
        this.totalWithout = totalWithout;
        this.totalWith = totalWith;
    }

    public static FileStatistics compute(LogisimFile file, Circuit circuit) {
        HashSet<Circuit> include = new HashSet<Circuit>(file.getCircuits());
        HashMap<Circuit, Map<ComponentFactory, Count>> countMap = new HashMap<Circuit, Map<ComponentFactory, Count>>();
        FileStatistics.doRecursiveCount(circuit, include, countMap);
        FileStatistics.doUniqueCounts(countMap.get(circuit), countMap);
        List<Count> countList = FileStatistics.sortCounts(countMap.get(circuit), file);
        return new FileStatistics(countList, FileStatistics.getTotal(countList, include), FileStatistics.getTotal(countList, null));
    }

    private static Map<ComponentFactory, Count> doRecursiveCount(Circuit circuit, Set<Circuit> include, Map<Circuit, Map<ComponentFactory, Count>> countMap) {
        if (countMap.containsKey(circuit)) {
            return countMap.get(circuit);
        }
        Map<ComponentFactory, Count> counts = FileStatistics.doSimpleCount(circuit);
        countMap.put(circuit, counts);
        for (Count count : counts.values()) {
            count.uniqueCount = count.simpleCount;
            count.recursiveCount = count.simpleCount;
        }
        for (Circuit sub : include) {
            SubcircuitFactory subFactory = sub.getSubcircuitFactory();
            if (!counts.containsKey(subFactory)) continue;
            int multiplier = counts.get((Object)subFactory).simpleCount;
            Map<ComponentFactory, Count> subCountRecursive = FileStatistics.doRecursiveCount(sub, include, countMap);
            for (Count subCount : subCountRecursive.values()) {
                ComponentFactory subfactory = subCount.factory;
                Count superCount = counts.get(subfactory);
                if (superCount == null) {
                    superCount = new Count(subfactory);
                    counts.put(subfactory, superCount);
                }
                superCount.recursiveCount += multiplier * subCount.recursiveCount;
            }
        }
        return counts;
    }

    private static Map<ComponentFactory, Count> doSimpleCount(Circuit circuit) {
        HashMap<ComponentFactory, Count> counts = new HashMap<ComponentFactory, Count>();
        for (Component comp : circuit.getNonWires()) {
            ComponentFactory factory = comp.getFactory();
            Count count = counts.get(factory);
            if (count == null) {
                count = new Count(factory);
                counts.put(factory, count);
            }
            ++count.simpleCount;
        }
        return counts;
    }

    private static void doUniqueCounts(Map<ComponentFactory, Count> counts, Map<Circuit, Map<ComponentFactory, Count>> circuitCounts) {
        for (Count count : counts.values()) {
            ComponentFactory factory = count.getFactory();
            int unique = 0;
            for (Circuit circ : circuitCounts.keySet()) {
                Count subcount = circuitCounts.get(circ).get(factory);
                if (subcount == null) continue;
                unique += subcount.simpleCount;
            }
            count.uniqueCount = unique;
        }
    }

    private static Count getTotal(List<Count> counts, Set<Circuit> exclude) {
        Count ret = new Count(null);
        for (Count count : counts) {
            ComponentFactory factory = count.getFactory();
            Circuit factoryCirc = null;
            if (factory instanceof SubcircuitFactory) {
                SubcircuitFactory sub = (SubcircuitFactory)factory;
                factoryCirc = sub.getSubcircuit();
            }
            if (exclude != null && exclude.contains(factoryCirc)) continue;
            ret.simpleCount += count.simpleCount;
            ret.uniqueCount += count.uniqueCount;
            ret.recursiveCount += count.recursiveCount;
        }
        return ret;
    }

    private static List<Count> sortCounts(Map<ComponentFactory, Count> counts, LogisimFile file) {
        ArrayList<Count> ret = new ArrayList<Count>();
        for (AddTool tool : file.getTools()) {
            ComponentFactory factory = tool.getFactory();
            Count count = counts.get(factory);
            if (count == null) continue;
            count.library = file;
            ret.add(count);
        }
        for (Library lib : file.getLibraries()) {
            for (Tool tool : lib.getTools()) {
                AddTool addTool;
                ComponentFactory factory;
                Count count;
                if (!(tool instanceof AddTool) || (count = counts.get(factory = (addTool = (AddTool)tool).getFactory())) == null) continue;
                count.library = lib;
                ret.add(count);
            }
        }
        return ret;
    }

    public List<Count> getCounts() {
        return this.counts;
    }

    public Count getTotalWithoutSubcircuits() {
        return this.totalWithout;
    }

    public Count getTotalWithSubcircuits() {
        return this.totalWith;
    }

    public static final class Count {
        private Library library = null;
        private final ComponentFactory factory;
        private int simpleCount;
        private int uniqueCount;
        private int recursiveCount;

        private Count(ComponentFactory factory) {
            this.factory = factory;
            this.simpleCount = 0;
            this.uniqueCount = 0;
            this.recursiveCount = 0;
        }

        public ComponentFactory getFactory() {
            return this.factory;
        }

        public Library getLibrary() {
            return this.library;
        }

        public int getRecursiveCount() {
            return this.recursiveCount;
        }

        public int getSimpleCount() {
            return this.simpleCount;
        }

        public int getUniqueCount() {
            return this.uniqueCount;
        }
    }
}

