/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.file.LoadFailedException;
import com.cburch.logisim.file.LoadedLibrary;
import com.cburch.logisim.file.Loader;
import com.cburch.logisim.file.LoaderException;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.ProjectsDirty;
import com.cburch.logisim.file.Strings;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.util.LineBuffer;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;

public final class LibraryManager {
    public static final LibraryManager instance = new LibraryManager();
    public static final char DESC_SEP = '#';
    private final HashMap<LibraryDescriptor, WeakReference<LoadedLibrary>> fileMap = new HashMap();
    private final WeakHashMap<LoadedLibrary, LibraryDescriptor> invMap = new WeakHashMap();

    private LibraryManager() {
        ProjectsDirty.initialize();
    }

    private static String toRelative(Loader loader, File file) {
        File currentDirectory = loader.getCurrentDirectory();
        String fileName = file.toString();
        try {
            fileName = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (currentDirectory != null) {
            int nrOfPartsEqual;
            String[] currentParts = currentDirectory.toString().split(Pattern.quote(File.separator));
            String[] newParts = fileName.split(Pattern.quote(File.separator));
            int nrOfNewParts = newParts.length;
            for (nrOfPartsEqual = 0; nrOfPartsEqual < currentParts.length && nrOfPartsEqual < nrOfNewParts - 1 && currentParts[nrOfPartsEqual].equals(newParts[nrOfPartsEqual]); ++nrOfPartsEqual) {
            }
            int nrOfLevelsToGoDown = currentParts.length - nrOfPartsEqual;
            StringBuilder relativeFile = new StringBuilder();
            relativeFile.append(String.format("..%s", File.separator).repeat(nrOfLevelsToGoDown));
            for (int restingPartId = nrOfPartsEqual; restingPartId < nrOfNewParts; ++restingPartId) {
                relativeFile.append(newParts[restingPartId]);
                if (restingPartId >= nrOfNewParts - 1) continue;
                relativeFile.append(File.separator);
            }
            return relativeFile.toString();
        }
        return fileName;
    }

    public void fileSaved(Loader loader, File dest, File oldFile, LogisimFile file) {
        LoadedLibrary lib;
        LoadedLibrary old = this.findKnown(oldFile);
        if (old != null) {
            old.setDirty(false);
        }
        if ((lib = this.findKnown(dest)) != null) {
            LogisimFile clone = file.cloneLogisimFile(loader);
            clone.setName(file.getName());
            clone.setDirty(false);
            lib.setBase(clone);
        }
    }

    private LoadedLibrary findKnown(Object key) {
        WeakReference<LoadedLibrary> retLibRef = this.fileMap.get(key);
        if (retLibRef == null) {
            return null;
        }
        LoadedLibrary retLib = (LoadedLibrary)retLibRef.get();
        if (retLib == null) {
            this.fileMap.remove(key);
            return null;
        }
        return retLib;
    }

    public Library findReference(LogisimFile file, File query) {
        for (Library lib : file.getLibraries()) {
            LogisimFile loadedProj;
            Library ret;
            LoadedLibrary loadedLib;
            Library library;
            LibraryDescriptor desc = this.invMap.get(lib);
            if (desc != null && desc.concernsFile(query)) {
                return lib;
            }
            if (!(lib instanceof LoadedLibrary) || !((library = (loadedLib = (LoadedLibrary)lib).getBase()) instanceof LogisimFile) || (ret = this.findReference(loadedProj = (LogisimFile)library, query)) == null) continue;
            return lib;
        }
        return null;
    }

    public String getDescriptor(Loader loader, Library lib) {
        if (loader.getBuiltin().getLibraries().contains(lib)) {
            return "#" + lib.getName();
        }
        LibraryDescriptor desc = this.invMap.get(lib);
        if (desc != null) {
            return desc.toDescriptor(loader);
        }
        throw new LoaderException(Strings.S.get("fileDescriptorUnknownError", lib.getDisplayName()));
    }

    Collection<LogisimFile> getLogisimLibraries() {
        ArrayList<LogisimFile> ret = new ArrayList<LogisimFile>();
        for (LoadedLibrary lib : this.invMap.keySet()) {
            Library library = lib.getBase();
            if (!(library instanceof LogisimFile)) continue;
            LogisimFile lsFile = (LogisimFile)library;
            ret.add(lsFile);
        }
        return ret;
    }

    public LoadedLibrary loadJarLibrary(Loader loader, File toRead, String className) {
        JarDescriptor jarDescriptor = new JarDescriptor(toRead, className);
        LoadedLibrary ret = this.findKnown(jarDescriptor);
        if (ret != null) {
            return ret;
        }
        try {
            ret = new LoadedLibrary(loader.loadJarFile(toRead, className));
        }
        catch (LoadFailedException e) {
            loader.showError(e.getMessage());
            return null;
        }
        this.fileMap.put(jarDescriptor, new WeakReference<LoadedLibrary>(ret));
        this.invMap.put(ret, jarDescriptor);
        return ret;
    }

    public static Set<String> getBuildinNames(Loader loader) {
        HashSet<String> buildinNames = new HashSet<String>();
        for (Library lib : loader.getBuiltin().getLibraries()) {
            buildinNames.add(lib.getName());
        }
        return buildinNames;
    }

    public Library loadLibrary(Loader loader, String desc) {
        int sep = desc.indexOf(35);
        if (sep < 0) {
            loader.showError(Strings.S.get("fileDescriptorError", desc));
            return null;
        }
        String type = desc.substring(0, sep);
        String name = desc.substring(sep + 1);
        switch (type) {
            case "": {
                Library ret = loader.getBuiltin().getLibrary(name);
                if (ret == null) {
                    loader.showError(Strings.S.get("fileBuiltinMissingError", name));
                    return null;
                }
                return ret;
            }
            case "file": {
                File toRead = loader.getFileFor(name, Loader.LOGISIM_FILTER);
                return this.loadLogisimLibrary(loader, toRead);
            }
            case "jar": {
                int sepLoc = name.lastIndexOf(35);
                String fileName = name.substring(0, sepLoc);
                String className = name.substring(sepLoc + 1);
                File toRead = loader.getFileFor(fileName, Loader.JAR_FILTER);
                return this.loadJarLibrary(loader, toRead, className);
            }
        }
        loader.showError(Strings.S.get("fileTypeError", type, desc));
        return null;
    }

    public static String getLibraryFilePath(Loader loader, String desc) {
        int sep = desc.indexOf(35);
        if (sep < 0) {
            loader.showError(Strings.S.get("fileDescriptorError", desc));
            return null;
        }
        String type = desc.substring(0, sep);
        String name = desc.substring(sep + 1);
        return switch (type) {
            case "file" -> loader.getFileFor(name, Loader.LOGISIM_FILTER).getAbsolutePath();
            case "jar" -> loader.getFileFor(name.substring(0, name.lastIndexOf(35)), Loader.JAR_FILTER).getAbsolutePath();
            default -> null;
        };
    }

    public static String getReplacementDescriptor(Loader loader, String desc, String fileName) {
        int sep = desc.indexOf(35);
        if (sep < 0) {
            loader.showError(Strings.S.get("fileDescriptorError", desc));
            return null;
        }
        String type = desc.substring(0, sep);
        String name = desc.substring(sep + 1);
        return switch (type) {
            case "file" -> String.format("file#%s", fileName);
            case "jar" -> LineBuffer.format("jar#{{1}}#{{2}}", fileName, name.substring(name.lastIndexOf(35) + 1));
            default -> null;
        };
    }

    public LoadedLibrary loadLogisimLibrary(Loader loader, File toRead) {
        LoadedLibrary ret = this.findKnown(toRead);
        if (ret != null) {
            return ret;
        }
        try {
            ret = new LoadedLibrary(loader.loadLogisimFile(toRead));
        }
        catch (LoadFailedException e) {
            loader.showError(e.getMessage());
            return null;
        }
        LogisimProjectDescriptor desc = new LogisimProjectDescriptor(toRead);
        this.fileMap.put(desc, new WeakReference<LoadedLibrary>(ret));
        this.invMap.put(ret, desc);
        return ret;
    }

    public void reload(Loader loader, LoadedLibrary lib) {
        LibraryDescriptor descriptor = this.invMap.get(lib);
        if (descriptor == null) {
            loader.showError(Strings.S.get("unknownLibraryFileError", lib.getDisplayName()));
        } else {
            try {
                descriptor.setBase(loader, lib);
            }
            catch (LoadFailedException e) {
                loader.showError(e.getMessage());
            }
        }
    }

    void setDirty(File file, boolean dirty) {
        LoadedLibrary lib = this.findKnown(file);
        if (lib != null) {
            lib.setDirty(dirty);
        }
    }

    public static void removeUnusedLibraries(Library lib) {
        LogisimFile logiLib = null;
        if (lib instanceof LoadedLibrary) {
            LoadedLibrary lib1 = (LoadedLibrary)lib;
            Library library = lib1.getBase();
            if (library instanceof LogisimFile) {
                LogisimFile logi;
                logiLib = logi = (LogisimFile)library;
            }
        } else if (lib instanceof LogisimFile) {
            LogisimFile logi;
            logiLib = logi = (LogisimFile)lib;
        }
        if (logiLib == null) {
            return;
        }
        HashSet<String> toBeRemoved = new HashSet<String>();
        for (Library library : logiLib.getLibraries()) {
            boolean isUsed = false;
            for (Circuit circ : logiLib.getCircuits()) {
                for (Component tool : circ.getNonWires()) {
                    isUsed |= library.contains(tool.getFactory());
                }
            }
            if (!isUsed) {
                toBeRemoved.add(library.getName());
                continue;
            }
            LibraryManager.removeUnusedLibraries(library);
        }
        for (String remove : toBeRemoved) {
            lib.removeLibrary(remove);
        }
    }

    public static Set<String> getUsedBaseLibraries(Library library) {
        HashSet<String> result = new HashSet<String>();
        for (Library lib : library.getLibraries()) {
            result.addAll(LibraryManager.getUsedBaseLibraries(lib));
            if (lib instanceof LoadedLibrary || lib instanceof LogisimFile) continue;
            result.add(lib.getName());
        }
        return result;
    }

    public static void removeBaseLibraries(Library library, Set<String> baseLibs) {
        Iterator<Library> libIterator = library.getLibraries().iterator();
        while (libIterator.hasNext()) {
            Library lib = libIterator.next();
            if (baseLibs.contains(lib.getName())) {
                libIterator.remove();
                continue;
            }
            LibraryManager.removeBaseLibraries(lib, baseLibs);
        }
    }

    private static interface LibraryDescriptor {
        public boolean concernsFile(File var1);

        public void setBase(Loader var1, LoadedLibrary var2) throws LoadFailedException;

        public String toDescriptor(Loader var1);
    }

    private static class JarDescriptor
    implements LibraryDescriptor {
        private final File file;
        private final String className;

        JarDescriptor(File file, String className) {
            this.file = file;
            this.className = className;
        }

        @Override
        public boolean concernsFile(File query) {
            return this.file.equals(query);
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof JarDescriptor) {
                JarDescriptor o = (JarDescriptor)other;
                bl = this.file.equals(o.file) && this.className.equals(o.className);
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return this.file.hashCode() * 31 + this.className.hashCode();
        }

        @Override
        public void setBase(Loader loader, LoadedLibrary lib) throws LoadFailedException {
            lib.setBase(loader.loadJarFile(this.file, this.className));
        }

        @Override
        public String toDescriptor(Loader loader) {
            return "jar#" + LibraryManager.toRelative(loader, this.file) + "#" + this.className;
        }
    }

    private static class LogisimProjectDescriptor
    implements LibraryDescriptor {
        private final File file;

        public LogisimProjectDescriptor(File file) {
            this.file = file;
        }

        @Override
        public boolean concernsFile(File query) {
            return this.file.equals(query);
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof LogisimProjectDescriptor) {
                LogisimProjectDescriptor o = (LogisimProjectDescriptor)other;
                bl = this.file.equals(o.file);
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        @Override
        public void setBase(Loader loader, LoadedLibrary lib) throws LoadFailedException {
            lib.setBase(loader.loadLogisimFile(this.file));
        }

        @Override
        public String toDescriptor(Loader loader) {
            return "file#" + LibraryManager.toRelative(loader, this.file);
        }
    }
}

