/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.draw.model.AbstractCanvasObject;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitMutator;
import com.cburch.logisim.circuit.CircuitTransaction;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.circuit.appear.AppearanceSvgReader;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.file.Strings;
import com.cburch.logisim.file.XmlIterator;
import com.cburch.logisim.file.XmlReader;
import com.cburch.logisim.file.XmlReaderException;
import com.cburch.logisim.std.base.Text;
import com.cburch.logisim.std.memory.Mem;
import com.cburch.logisim.std.memory.Ram;
import com.cburch.logisim.std.memory.RamAttributes;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class XmlCircuitReader
extends CircuitTransaction {
    private static final String contextFmt = "%s.%s";
    private final XmlReader.ReadContext reader;
    private final List<XmlReader.CircuitData> circuitsData;
    private boolean isHolyCross = false;
    private boolean isEvolution = false;

    public XmlCircuitReader(XmlReader.ReadContext reader, List<XmlReader.CircuitData> circDatas, boolean isThisHolyCrossFile, boolean isThisEvolutionFile) {
        this.reader = reader;
        this.circuitsData = circDatas;
        this.isHolyCross = isThisHolyCrossFile;
        this.isEvolution = isThisEvolutionFile;
    }

    static Component getComponent(Element elt, XmlReader.ReadContext reader, boolean isHolyCross, boolean isEvolution) throws XmlReaderException {
        String name = elt.getAttribute("name");
        if (StringUtil.isNullOrEmpty(name)) {
            throw new XmlReaderException(Strings.S.get("compNameMissingError"));
        }
        String libName = elt.getAttribute("lib");
        Library lib = reader.findLibrary(libName);
        if (lib == null) {
            throw new XmlReaderException(Strings.S.get("compUnknownError", "no-lib"));
        }
        Tool tool = lib.getTool(name);
        if (!(tool instanceof AddTool)) {
            String msg = StringUtil.isNullOrEmpty(libName) ? Strings.S.get("compUnknownError", name) : Strings.S.get("compAbsentError", name, libName);
            throw new XmlReaderException(msg);
        }
        ComponentFactory source = ((AddTool)tool).getFactory();
        String locStr = elt.getAttribute("loc");
        AttributeSet attrs = source.createAttributeSet();
        ComponentFactory defaults = source;
        if (isHolyCross && source instanceof Ram) {
            RamAttributes ramAttrs = (RamAttributes)attrs;
            ramAttrs.setValue(Mem.ENABLES_ATTR, Mem.USELINEENABLES);
            ramAttrs.updateAttributes();
            defaults = null;
        }
        reader.initAttributeSet(elt, attrs, defaults, isHolyCross, isEvolution);
        if (StringUtil.isNullOrEmpty(locStr)) {
            throw new XmlReaderException(Strings.S.get("compLocMissingError", source.getName()));
        }
        try {
            return source.createComponent(Location.parse(locStr), attrs);
        }
        catch (NumberFormatException e) {
            throw new XmlReaderException(Strings.S.get("compLocInvalidError", source.getName(), locStr));
        }
    }

    void addWire(Circuit dest, CircuitMutator mutator, Element elt) throws XmlReaderException {
        Location pt1;
        Location pt0;
        try {
            String str = elt.getAttribute("from");
            if (str == null || "".equals(str)) {
                throw new XmlReaderException(Strings.S.get("wireStartMissingError"));
            }
            pt0 = Location.parse(str);
        }
        catch (NumberFormatException e) {
            throw new XmlReaderException(Strings.S.get("wireStartInvalidError"));
        }
        try {
            String str = elt.getAttribute("to");
            if (str == null || "".equals(str)) {
                throw new XmlReaderException(Strings.S.get("wireEndMissingError"));
            }
            pt1 = Location.parse(str);
        }
        catch (NumberFormatException e) {
            throw new XmlReaderException(Strings.S.get("wireEndInvalidError"));
        }
        if (!pt0.equals(pt1)) {
            mutator.add(dest, Wire.create(pt0, pt1));
        }
    }

    private void buildCircuit(XmlReader.CircuitData circData, CircuitMutator mutator) {
        Element element = circData.circuitElement;
        Circuit dest = circData.circuit;
        Map<Element, Component> knownComponents = circData.knownComponents;
        if (knownComponents == null) {
            knownComponents = Collections.emptyMap();
        }
        try {
            boolean hasNamedBox = false;
            boolean hasNamedBoxFixedSize = false;
            boolean hasAppearAttr = false;
            for (Element attrElt : XmlIterator.forChildElements(circData.circuitElement, "a")) {
                if (!attrElt.hasAttribute("name")) continue;
                String name = attrElt.getAttribute("name");
                hasNamedBox |= "circuitnamedbox".equals(name);
                hasAppearAttr |= "appearance".equals(name);
                hasNamedBoxFixedSize |= "circuitnamedboxfixedsize".equals(name);
            }
            this.reader.initAttributeSet(circData.circuitElement, dest.getStaticAttributes(), null, this.isHolyCross, this.isEvolution);
            if (circData.circuitElement.hasChildNodes()) {
                if (hasNamedBox) {
                    appear = CollectionUtil.isNotEmpty(circData.appearance) ? CircuitAttributes.APPEAR_CUSTOM : CircuitAttributes.APPEAR_EVOLUTION;
                    dest.getStaticAttributes().setValue(CircuitAttributes.APPEARANCE_ATTR, appear);
                } else if (!hasAppearAttr) {
                    appear = CircuitAttributes.APPEAR_CLASSIC;
                    if (CollectionUtil.isNotEmpty(circData.appearance)) {
                        appear = CircuitAttributes.APPEAR_CUSTOM;
                    } else if (this.isHolyCross) {
                        appear = CircuitAttributes.APPEAR_FPGA;
                    }
                    dest.getStaticAttributes().setValue(CircuitAttributes.APPEARANCE_ATTR, appear);
                }
                if (!hasNamedBoxFixedSize) {
                    dest.getStaticAttributes().setValue(CircuitAttributes.NAMED_CIRCUIT_BOX_FIXED_SIZE, false);
                }
            }
        }
        catch (XmlReaderException e) {
            this.reader.addErrors(e, circData.circuit.getName() + ".static");
        }
        HashMap<Bounds, Component> componentsAt = new HashMap<Bounds, Component>();
        ArrayList<Component> overlapComponents = new ArrayList<Component>();
        for (Element subElement : XmlIterator.forChildElements(element)) {
            String context;
            String subEltName = subElement.getTagName();
            if ("comp".equals(subEltName)) {
                try {
                    Component comp = knownComponents.get(subElement);
                    if (comp == null) {
                        comp = XmlCircuitReader.getComponent(subElement, this.reader, this.isHolyCross, this.isEvolution);
                    }
                    if (comp == null || comp.getFactory() instanceof Text && comp.getAttributeSet().getValue(Text.ATTR_TEXT).isEmpty()) continue;
                    Bounds bds = comp.getBounds();
                    Component conflict = (Component)componentsAt.get(bds);
                    if (conflict != null) {
                        String msg = Strings.S.get("fileComponentOverlapError", conflict.getFactory().getName() + conflict.getLocation(), comp.getFactory().getName() + conflict.getLocation());
                        this.reader.addError(msg, circData.circuit.getName());
                        overlapComponents.add(comp);
                        continue;
                    }
                    mutator.add(dest, comp);
                    componentsAt.put(bds, comp);
                }
                catch (XmlReaderException e) {
                    context = String.format(contextFmt, circData.circuit.getName(), this.toComponentString(subElement));
                    this.reader.addErrors(e, context);
                }
                continue;
            }
            if (!"wire".equals(subEltName)) continue;
            try {
                this.addWire(dest, mutator, subElement);
            }
            catch (XmlReaderException e) {
                context = String.format(contextFmt, circData.circuit.getName(), this.toWireString(subElement));
                this.reader.addErrors(e, context);
            }
        }
        for (Component comp : overlapComponents) {
            Bounds bds = comp.getBounds();
            if (bds.getHeight() == 0 || bds.getWidth() == 0) continue;
            int d = 0;
            while (componentsAt.get(bds.translate(d += 10, d)) != null && d < 100000) {
            }
            Location loc = comp.getLocation().translate(d, d);
            AttributeSet attrs = (AttributeSet)comp.getAttributeSet().clone();
            comp = comp.getFactory().createComponent(loc, attrs);
            componentsAt.put(comp.getBounds(), comp);
            mutator.add(dest, comp);
        }
    }

    private void buildDynamicAppearance(XmlReader.CircuitData circData) {
        Circuit dest = circData.circuit;
        ArrayList<AbstractCanvasObject> shapes = new ArrayList<AbstractCanvasObject>();
        for (Element appearElt : XmlIterator.forChildElements(circData.circuitElement, "appear")) {
            for (Element sub : XmlIterator.forChildElements(appearElt)) {
                String context;
                if (!sub.getTagName().startsWith("visible-")) continue;
                try {
                    AbstractCanvasObject m = AppearanceSvgReader.createShape(sub, null, dest);
                    if (m == null) {
                        context = String.format(contextFmt, circData.circuit.getName(), sub.getTagName());
                        this.reader.addError(Strings.S.get("fileAppearanceNotFound", sub.getTagName()), context);
                        continue;
                    }
                    shapes.add(m);
                }
                catch (RuntimeException e) {
                    context = String.format(contextFmt, circData.circuit.getName(), sub.getTagName());
                    this.reader.addError(Strings.S.get("fileAppearanceError", sub.getTagName()), context);
                }
            }
        }
        if (!shapes.isEmpty()) {
            if (circData.appearance == null) {
                circData.appearance = shapes;
            } else {
                circData.appearance.addAll(shapes);
            }
        }
        if (CollectionUtil.isNotEmpty(circData.appearance)) {
            dest.getAppearance().setObjectsForce(circData.appearance);
        }
    }

    @Override
    protected Map<Circuit, Integer> getAccessedCircuits() {
        HashMap<Circuit, Integer> access = new HashMap<Circuit, Integer>();
        for (XmlReader.CircuitData data : this.circuitsData) {
            access.put(data.circuit, READ_WRITE);
        }
        return access;
    }

    @Override
    protected void run(CircuitMutator mutator) {
        for (XmlReader.CircuitData circuitData : this.circuitsData) {
            this.buildCircuit(circuitData, mutator);
        }
        for (XmlReader.CircuitData circuitData : this.circuitsData) {
            this.buildDynamicAppearance(circuitData);
        }
    }

    private String toComponentString(Element elt) {
        String name = elt.getAttribute("name");
        String loc = elt.getAttribute("loc");
        return String.format("%s(%s)", name, loc);
    }

    private String toWireString(Element elt) {
        String from = elt.getAttribute("from");
        String to = elt.getAttribute("to");
        return String.format("w%s-%s", from, to);
    }
}

