/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.draw.model.AbstractCanvasObject;
import com.cburch.draw.model.CanvasObject;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitMapInfo;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeDefaultProvider;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.file.LibraryLoader;
import com.cburch.logisim.file.LibraryManager;
import com.cburch.logisim.file.LoadedLibrary;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.MouseMappings;
import com.cburch.logisim.file.ToolbarData;
import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.MapComponent;
import com.cburch.logisim.generated.BuildInfo;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.base.Text;
import com.cburch.logisim.std.wiring.ProbeAttributes;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.InputEventUtil;
import com.cburch.logisim.util.LineBuffer;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.util.XmlUtil;
import com.cburch.logisim.vhdl.base.VhdlContent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class XmlWriter {
    private final LogisimFile file;
    private final Document doc;
    private final String outFilePath;
    private final String librariesPath;
    private final boolean isProjectExport;
    private final LibraryLoader loader;
    private final HashMap<Library, String> libs = new HashMap();
    private static final Comparator<Node> nodeComparator = (nodeA, nodeB) -> {
        int compareResult = XmlWriter.stringCompare(nodeA.getNodeName(), nodeB.getNodeName());
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = XmlWriter.stringCompare(XmlWriter.attrsToString(nodeA.getAttributes()), XmlWriter.attrsToString(nodeB.getAttributes()));
        if (compareResult != 0) {
            return compareResult;
        }
        return XmlWriter.stringCompare(nodeA.getNodeValue(), nodeB.getNodeValue());
    };

    private XmlWriter(LogisimFile file, Document doc, LibraryLoader loader) {
        this(file, doc, loader, null, null);
    }

    private XmlWriter(LogisimFile file, Document doc, LibraryLoader loader, String outFilePath) {
        this(file, doc, loader, outFilePath, null);
    }

    private XmlWriter(LogisimFile file, Document doc, LibraryLoader loader, String outFilePath, String librariesPath) {
        this.file = file;
        this.doc = doc;
        this.loader = loader;
        this.outFilePath = outFilePath;
        this.librariesPath = librariesPath;
        this.isProjectExport = StringUtil.isNotEmpty(librariesPath);
    }

    static String attrToString(Attr a) {
        String n = a.getName();
        String v = a.getValue().replaceAll("&", "&amp;").replaceAll("\"", "&quot;");
        return n + "=\"" + v + "\"";
    }

    static String attrsToString(NamedNodeMap a) {
        int n = a.getLength();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return XmlWriter.attrToString((Attr)a.item(0));
        }
        ArrayList<String> lst = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            lst.add(XmlWriter.attrToString((Attr)a.item(i)));
        }
        Collections.sort(lst);
        return String.join((CharSequence)" ", lst);
    }

    private static int stringCompare(String stringA, String stringB) {
        if (stringA == null) {
            return -1;
        }
        if (stringB == null) {
            return 1;
        }
        return stringA.compareTo(stringB);
    }

    static void sort(Node top) {
        NodeList children = top.getChildNodes();
        int childrenCount = children.getLength();
        String name = top.getNodeName();
        if ("appear".equals(name)) {
            int portIndex;
            ArrayList<Integer> circuitPortIndexes = new ArrayList<Integer>();
            for (int nodeIndex = 0; nodeIndex < childrenCount; ++nodeIndex) {
                if (!"circ-port".equals(children.item(nodeIndex).getNodeName())) continue;
                circuitPortIndexes.add(nodeIndex);
            }
            if (circuitPortIndexes.isEmpty()) {
                return;
            }
            int numberOfPorts = circuitPortIndexes.size();
            Node[] nodeSet = new Node[numberOfPorts];
            for (portIndex = 0; portIndex < numberOfPorts; ++portIndex) {
                nodeSet[portIndex] = children.item((Integer)circuitPortIndexes.get(portIndex));
            }
            Arrays.sort(nodeSet, nodeComparator);
            for (portIndex = 0; portIndex < numberOfPorts; ++portIndex) {
                top.insertBefore(nodeSet[portIndex], null);
            }
            return;
        }
        if (!(childrenCount <= 1 || name.equals("project") || name.equals("lib") || name.equals("toolbar"))) {
            int nodeIndex;
            Node[] nodeSet = new Node[childrenCount];
            for (nodeIndex = 0; nodeIndex < childrenCount; ++nodeIndex) {
                nodeSet[nodeIndex] = children.item(nodeIndex);
            }
            Arrays.sort(nodeSet, nodeComparator);
            for (nodeIndex = 0; nodeIndex < childrenCount; ++nodeIndex) {
                top.insertBefore(nodeSet[nodeIndex], null);
            }
        }
        for (int childId = 0; childId < childrenCount; ++childId) {
            XmlWriter.sort(children.item(childId));
        }
    }

    static void write(LogisimFile file, OutputStream out, LibraryLoader loader, File destFile, String libraryHome) throws ParserConfigurationException, TransformerException {
        XmlWriter context;
        DocumentBuilderFactory docFactory = XmlUtil.getHardenedBuilderFactory();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        if (destFile != null) {
            String dstFilePath = destFile.getAbsolutePath();
            dstFilePath = dstFilePath.substring(0, dstFilePath.lastIndexOf(File.separator));
            context = new XmlWriter(file, doc, loader, dstFilePath);
        } else {
            context = libraryHome != null ? new XmlWriter(file, doc, loader, null, libraryHome) : new XmlWriter(file, doc, loader);
        }
        context.fromLogisimFile();
        TransformerFactory tfFactory = TransformerFactory.newInstance();
        try {
            tfFactory.setAttribute("indent-number", 2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer tf = tfFactory.newTransformer();
        tf.setOutputProperty("encoding", "UTF-8");
        tf.setOutputProperty("indent", "yes");
        try {
            tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        doc.normalize();
        XmlWriter.sort(doc);
        DOMSource src = new DOMSource(doc);
        StreamResult dest = new StreamResult(out);
        tf.transform(src, dest);
    }

    void addAttributeSetContent(Element elt, AttributeSet attrs, AttributeDefaultProvider source, boolean userModifiedOnly) {
        if (attrs == null) {
            return;
        }
        if (source != null && source.isAllDefaultValues(attrs, BuildInfo.version)) {
            return;
        }
        Iterator<Attribute<?>> iterator = attrs.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute<?> attrBase;
            Attribute<?> attr = attrBase = iterator.next();
            Object val = attrs.getValue(attr);
            if (userModifiedOnly && (attrs.isReadOnly(attr) || attr.isHidden()) || !attrs.isToSave(attr) || val == null) continue;
            Object dflt = source == null ? null : source.getDefaultAttributeValue(attr, BuildInfo.version);
            String defaultValue = dflt == null ? "" : attr.toStandardString(dflt);
            String newValue = attr.toStandardString(val);
            if (!(dflt == null || !dflt.equals(val) && !defaultValue.equals(newValue) || attr.equals(StdAttr.APPEARANCE) && !userModifiedOnly) && (!attr.equals(ProbeAttributes.PROBEAPPEARANCE) || userModifiedOnly || !val.equals(ProbeAttributes.APPEAR_EVOLUTION_NEW))) continue;
            Element a = this.doc.createElement("a");
            a.setAttribute("name", attr.getName());
            if ("filePath".equals(attr.getName()) && this.outFilePath != null) {
                Path outFP = Paths.get(this.outFilePath, new String[0]);
                Path attrValP = Paths.get(newValue, new String[0]);
                newValue = outFP.relativize(attrValP).toString();
                a.setAttribute("val", newValue);
            } else if (newValue.contains("\n")) {
                a.appendChild(this.doc.createTextNode(newValue));
            } else {
                a.setAttribute("val", attr.toStandardString(val));
            }
            elt.appendChild(a);
        }
    }

    Library findLibrary(ComponentFactory source) {
        if (this.file.contains(source)) {
            return this.file;
        }
        for (Library lib : this.file.getLibraries()) {
            if (!lib.contains(source)) continue;
            return lib;
        }
        return null;
    }

    Library findLibrary(Tool tool) {
        if (this.libraryContains(this.file, tool)) {
            return this.file;
        }
        for (Library lib : this.file.getLibraries()) {
            if (!this.libraryContains(lib, tool)) continue;
            return lib;
        }
        return null;
    }

    Element fromCircuit(Circuit circuit) {
        Element elt;
        Element ret = this.doc.createElement("circuit");
        ret.setAttribute("name", circuit.getName());
        this.addAttributeSetContent(ret, circuit.getStaticAttributes(), CircuitAttributes.DEFAULT_STATIC_ATTRIBUTES, false);
        if (circuit.getAppearance().hasCustomAppearance()) {
            Element appear = this.doc.createElement("appear");
            for (CanvasObject obj : circuit.getAppearance().getCustomObjectsFromBottom()) {
                AbstractCanvasObject canvasObject;
                Element elt2;
                if (!(obj instanceof AbstractCanvasObject) || (elt2 = (canvasObject = (AbstractCanvasObject)obj).toSvgElement(this.doc)) == null) continue;
                appear.appendChild(elt2);
            }
            ret.appendChild(appear);
        }
        for (Wire wire : circuit.getWires()) {
            ret.appendChild(this.fromWire(wire));
        }
        for (Component comp : circuit.getNonWires()) {
            elt = this.fromComponent(comp);
            if (elt == null) continue;
            ret.appendChild(elt);
        }
        for (String board : circuit.getBoardMapNamestoSave()) {
            elt = this.fromMap(circuit, board);
            if (elt == null) continue;
            ret.appendChild(elt);
        }
        return ret;
    }

    Element fromVhdl(VhdlContent vhdl) {
        vhdl.aboutToSave();
        Element ret = this.doc.createElement("vhdl");
        ret.setAttribute("name", vhdl.getName());
        ret.setTextContent(vhdl.getContent());
        return ret;
    }

    Element fromMap(Circuit circ, String boardName) {
        Element ret = this.doc.createElement("boardmap");
        ret.setAttribute("boardname", boardName);
        for (String key : circ.getMapInfo(boardName).keySet()) {
            Element map = this.doc.createElement("mc");
            CircuitMapInfo mapInfo = circ.getMapInfo(boardName).get(key);
            if (mapInfo.isOldFormat()) {
                map.setAttribute("key", key);
                if (mapInfo.isOpen()) {
                    map.setAttribute("open", "open");
                } else if (mapInfo.isConst()) {
                    map.setAttribute("vconst", Long.toString(mapInfo.getConstValue()));
                } else {
                    BoardRectangle rect = mapInfo.getRectangle();
                    map.setAttribute("valx", Integer.toString(rect.getXpos()));
                    map.setAttribute("valy", Integer.toString(rect.getYpos()));
                    map.setAttribute("valw", Integer.toString(rect.getWidth()));
                    map.setAttribute("valh", Integer.toString(rect.getHeight()));
                }
            } else {
                MapComponent nmap = mapInfo.getMap();
                if (nmap != null) {
                    nmap.getMapElement(map);
                } else {
                    map.setAttribute("key", key);
                    MapComponent.getComplexMap(map, mapInfo);
                }
            }
            ret.appendChild(map);
        }
        return ret;
    }

    Element fromComponent(Component comp) {
        String value;
        String libName;
        ComponentFactory source = comp.getFactory();
        Library lib = this.findLibrary(source);
        if (lib == null) {
            this.loader.showError(source.getName() + " component not found");
            return null;
        }
        if (lib == this.file) {
            libName = null;
        } else {
            libName = this.libs.get(lib);
            if (libName == null) {
                this.loader.showError("unknown library within file");
                return null;
            }
        }
        if ("Text".equals(source.getName()) && (value = comp.getAttributeSet().getValue(Text.ATTR_TEXT)).isEmpty()) {
            return null;
        }
        Element ret = this.doc.createElement("comp");
        if (libName != null) {
            ret.setAttribute("lib", libName);
        }
        ret.setAttribute("name", source.getName());
        ret.setAttribute("loc", comp.getLocation().toString());
        this.addAttributeSetContent(ret, comp.getAttributeSet(), comp.getFactory(), false);
        return ret;
    }

    Element fromLibrary(Library lib) {
        String origFile;
        Element ret = this.doc.createElement("lib");
        if (this.libs.containsKey(lib)) {
            return null;
        }
        String name = Integer.toString(this.libs.size());
        String desc = this.loader.getDescriptor(lib);
        if (desc == null) {
            this.loader.showError("library location unknown: " + lib.getName());
            return null;
        }
        this.libs.put(lib, name);
        if (this.isProjectExport || AppPreferences.REMOVE_UNUSED_LIBRARIES.getBoolean()) {
            boolean isUsed = false;
            List<? extends Tool> list = lib.getTools();
            for (Circuit circuit : this.file.getCircuits()) {
                for (Component tool : circuit.getNonWires()) {
                    isUsed |= lib.contains(tool.getFactory());
                }
            }
            for (Tool tool : this.file.getOptions().getToolbarData().getContents()) {
                isUsed |= list.contains(tool);
            }
            for (Map.Entry entry : this.file.getOptions().getMouseMappings().getMappings().entrySet()) {
                isUsed |= list.contains(entry.getValue());
            }
            if (!isUsed && !"#Base".equals(desc)) {
                return null;
            }
        }
        if (this.isProjectExport && lib instanceof LoadedLibrary && (origFile = LibraryManager.getLibraryFilePath(this.file.getLoader(), desc)) != null) {
            String[] stringArray = origFile.split(Pattern.quote(File.separator));
            String filename = stringArray[stringArray.length - 1];
            String string = String.format("%s%s%s", this.librariesPath, File.separator, filename);
            try {
                Files.copy(Paths.get(origFile, new String[0]), Paths.get(string, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                return null;
            }
            String newFilePath = LineBuffer.format("..{{1}}{{2}}{{1}}{{3}}", File.separator, "library", filename);
            desc = LibraryManager.getReplacementDescriptor(this.file.getLoader(), desc, newFilePath);
        }
        ret.setAttribute("name", name);
        ret.setAttribute("desc", desc);
        for (Tool tool : lib.getTools()) {
            AttributeSet attrs = tool.getAttributeSet();
            if (attrs == null) continue;
            Element element = this.doc.createElement("tool");
            element.setAttribute("name", tool.getName());
            this.addAttributeSetContent(element, attrs, tool, true);
            if (element.getChildNodes().getLength() <= 0) continue;
            ret.appendChild(element);
        }
        return ret;
    }

    Element fromLogisimFile() {
        Element ret = this.doc.createElement("project");
        this.doc.appendChild(ret);
        ret.appendChild(this.doc.createTextNode("\nThis file is intended to be loaded by Logisim-evolution v3.8.0(https://github.com/logisim-evolution/).\n"));
        ret.setAttribute("version", "1.0");
        ret.setAttribute("source", BuildInfo.version.toString());
        for (Library lib : this.file.getLibraries()) {
            Element elt = this.fromLibrary(lib);
            if (elt == null) continue;
            ret.appendChild(elt);
        }
        if (this.file.getMainCircuit() != null) {
            Element mainElt = this.doc.createElement("main");
            mainElt.setAttribute("name", this.file.getMainCircuit().getName());
            ret.appendChild(mainElt);
        }
        ret.appendChild(this.fromOptions());
        ret.appendChild(this.fromMouseMappings());
        ret.appendChild(this.fromToolbarData());
        for (Circuit circ : this.file.getCircuits()) {
            ret.appendChild(this.fromCircuit(circ));
        }
        for (VhdlContent vhdl : this.file.getVhdlContents()) {
            ret.appendChild(this.fromVhdl(vhdl));
        }
        return ret;
    }

    Element fromMouseMappings() {
        Element elt = this.doc.createElement("mappings");
        MouseMappings map = this.file.getOptions().getMouseMappings();
        for (Map.Entry<Integer, Tool> entry : map.getMappings().entrySet()) {
            Integer mods = entry.getKey();
            Tool tool = entry.getValue();
            Element toolElt = this.fromTool(tool);
            String mapValue = InputEventUtil.toString(mods);
            toolElt.setAttribute("map", mapValue);
            elt.appendChild(toolElt);
        }
        return elt;
    }

    Element fromOptions() {
        Element elt = this.doc.createElement("options");
        this.addAttributeSetContent(elt, this.file.getOptions().getAttributeSet(), null, false);
        return elt;
    }

    Element fromTool(Tool tool) {
        String libName;
        Library lib = this.findLibrary(tool);
        if (lib == null) {
            this.loader.showError(String.format("tool `%s' not found", tool.getDisplayName()));
            return null;
        }
        if (lib == this.file) {
            libName = null;
        } else {
            libName = this.libs.get(lib);
            if (libName == null) {
                this.loader.showError("unknown library within file");
                return null;
            }
        }
        Element elt = this.doc.createElement("tool");
        if (libName != null) {
            elt.setAttribute("lib", libName);
        }
        elt.setAttribute("name", tool.getName());
        this.addAttributeSetContent(elt, tool.getAttributeSet(), tool, true);
        return elt;
    }

    Element fromToolbarData() {
        Element elt = this.doc.createElement("toolbar");
        ToolbarData toolbar = this.file.getOptions().getToolbarData();
        for (Tool tool : toolbar.getContents()) {
            if (tool == null) {
                elt.appendChild(this.doc.createElement("sep"));
                continue;
            }
            elt.appendChild(this.fromTool(tool));
        }
        return elt;
    }

    Element fromWire(Wire w) {
        Element ret = this.doc.createElement("wire");
        ret.setAttribute("from", w.getEnd0().toString());
        ret.setAttribute("to", w.getEnd1().toString());
        return ret;
    }

    boolean libraryContains(Library lib, Tool query) {
        for (Tool tool : lib.getTools()) {
            if (!tool.sharesSource(query)) continue;
            return true;
        }
        return false;
    }
}

