/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DriveStrength {
    public static final String DRIVE_ATTRIBUTE_STRING = "FPGAPinDriveStrength";
    public static final char DEFAULT_STENGTH = '\u0000';
    public static final char DRIVE_2 = '\u0001';
    public static final char DRIVE_4 = '\u0002';
    public static final char DRIVE_8 = '\u0003';
    public static final char DRIVE_16 = '\u0004';
    public static final char DRIVE_24 = '\u0005';
    public static final char UNKNOWN = '\u00ff';
    public static final String[] BEHAVIOR_STRINGS = new String[]{"Default", "2 mA", "4 mA", "8 mA", "16 mA", "24 mA"};

    public static String getConstrainedDriveStrength(char id) {
        if (id > '\u0000' && id <= '\u0005') {
            return BEHAVIOR_STRINGS[id].replace(" mA", " ");
        }
        return "";
    }

    public static char getId(String identifier) {
        char result = '\u0000';
        List<String> theList = DriveStrength.getStrings();
        Iterator<String> iter = theList.iterator();
        result = '\u0000';
        while (iter.hasNext()) {
            if (iter.next().equals(identifier)) {
                return result;
            }
            result = (char)(result + '\u0001');
        }
        return '\u00ff';
    }

    public static List<String> getStrings() {
        LinkedList<String> result = new LinkedList<String>();
        result.add(BEHAVIOR_STRINGS[0]);
        result.add(BEHAVIOR_STRINGS[1]);
        result.add(BEHAVIOR_STRINGS[2]);
        result.add(BEHAVIOR_STRINGS[3]);
        result.add(BEHAVIOR_STRINGS[4]);
        result.add(BEHAVIOR_STRINGS[5]);
        return result;
    }
}

